/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableInferredTarget;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropContainer_skikoKt;
import androidx.compose.ui.viewinterop.InteropViewHolder;
import androidx.compose.ui.viewinterop.ScheduledUpdatesSwapchain;
import androidx.compose.ui.viewinterop.SwingInteropContainer;
import androidx.compose.ui.viewinterop.TrackInteropPlacementModifierNode;
import java.awt.Component;
import java.awt.Container;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.ClipRectangle;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSwingInteropContainer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n+ 2 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain\n*L\n1#1,260:1\n60#2,16:261\n*S KotlinDebug\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n*L\n228#1:261,16\n*E\n"})
public final class SwingInteropContainer
implements InteropContainer {
    private final Container root;
    private final boolean placeInteropAbove;
    private Map<Container, InteropViewHolder> interopComponents;
    private TrackInteropPlacementModifierNode rootModifier;
    private final SnapshotStateObserver snapshotObserver;
    private final ScheduledUpdatesSwapchain scheduledUpdatesSwapchain;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SwingInteropContainer(Container root, boolean placeInteropAbove, Function0<Unit> requestRedraw) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(requestRedraw, (String)"requestRedraw");
        this.root = var1_1;
        this.placeInteropAbove = var2_2;
        this.interopComponents = new LinkedHashMap();
        this.snapshotObserver = new SnapshotStateObserver((Function1)snapshotObserver.1.INSTANCE);
        this.scheduledUpdatesSwapchain = new ScheduledUpdatesSwapchain((Function0<Unit>)var3_3);
    }

    public final Container getRoot() {
        return this.root;
    }

    @Override
    public final TrackInteropPlacementModifierNode getRootModifier() {
        return this.rootModifier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setRootModifier(TrackInteropPlacementModifierNode trackInteropPlacementModifierNode) {
        void var1_1;
        this.rootModifier = var1_1;
    }

    @Override
    public final SnapshotStateObserver getSnapshotObserver() {
        return this.snapshotObserver;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(InteropViewHolder holder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return this.interopComponents.containsKey(var1_1.getGroup());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void place(InteropViewHolder holder) {
        void var2_3;
        void var1_1;
        void var3_5;
        boolean alreadyAdded;
        SwingInteropContainer swingInteropContainer;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Container group = holder.getGroup();
        if (this.interopComponents.isEmpty()) {
            swingInteropContainer = this;
            swingInteropContainer.snapshotObserver.start();
        }
        if (!(alreadyAdded = this.interopComponents.containsKey(group))) {
            this.interopComponents.put(group, holder);
        }
        int countBelow = InteropContainer_skikoKt.countInteropComponentsBelow(this, holder);
        SwingInteropContainer swingInteropContainer2 = this;
        int n = swingInteropContainer2.interopComponents.size() - 1;
        if (!swingInteropContainer2.placeInteropAbove) {
            swingInteropContainer = swingInteropContainer2;
            int n2 = swingInteropContainer.root.getComponentCount() - swingInteropContainer2.interopComponents.size();
            n += n2;
        }
        int awtIndex = n - countBelow;
        this.scheduleUpdate((Function0<Unit>)((Function0)new Function0<Unit>((boolean)var3_5, (InteropViewHolder)var1_1, this, (int)var2_3){
            final /* synthetic */ boolean $alreadyAdded;
            final /* synthetic */ InteropViewHolder $holder;
            final /* synthetic */ SwingInteropContainer this$0;
            final /* synthetic */ int $awtIndex;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$alreadyAdded = var1_1;
                this.$holder = var2_2;
                this.this$0 = var3_3;
                this.$awtIndex = $awtIndex;
                super(0);
            }

            public final void invoke() {
                if (this.$alreadyAdded) {
                    InteropViewHolder.changeInteropViewIndex$17a3dcbe(this.this$0.getRoot());
                    return;
                }
                this.$holder.insertInteropView$17a3dcbe(this.this$0.getRoot());
            }
        }));
    }

    @Override
    public final void unplace(InteropViewHolder holder) {
        SwingInteropContainer swingInteropContainer;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.scheduleUpdate((Function0<Unit>)((Function0)new Function0<Unit>(holder, this){
            final /* synthetic */ InteropViewHolder $holder;
            final /* synthetic */ SwingInteropContainer this$0;
            {
                void var2_2;
                void var1_1;
                this.$holder = var1_1;
                this.this$0 = var2_2;
                super(0);
            }

            public final void invoke() {
                this.$holder.removeInteropView(this.this$0.getRoot());
            }
        }));
        this.interopComponents.remove(((InteropViewHolder)((Object)swingInteropContainer)).getGroup());
        if (this.interopComponents.isEmpty()) {
            swingInteropContainer = this;
            swingInteropContainer.snapshotObserver.stop();
        }
    }

    private final void executeScheduledUpdates() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        boolean bl = this.scheduledUpdatesSwapchain.execute();
        if (bl) {
            SwingInteropContainer swingInteropContainer = this;
            swingInteropContainer.root.validate();
            swingInteropContainer = this;
            swingInteropContainer.root.repaint();
        }
    }

    public final void dispose() {
        this.executeScheduledUpdates();
    }

    /*
     * WARNING - void declaration
     */
    public final void postponingExecutingScheduledUpdates(Function0<Unit> body) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ScheduledUpdatesSwapchain this_$iv = this.scheduledUpdatesSwapchain;
        try {
            object2 = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object2) {
                if (!ScheduledUpdatesSwapchain.access$getNeedsRequestRedrawOnUpdateScheduled$p(this_$iv)) {
                    String string = "Reentry into ignoringRedrawRequests is not allowed";
                    throw new IllegalStateException(string.toString());
                }
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, false);
            }
            object.invoke();
        }
        catch (Throwable throwable) {
            object = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object) {
                void var2_4;
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p((ScheduledUpdatesSwapchain)var2_4, true);
            }
            throw throwable;
        }
        object2 = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
        synchronized (object2) {
            ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, true);
        }
        this.executeScheduledUpdates();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void scheduleUpdate(Function0<Unit> action) {
        void var1_1;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.scheduledUpdatesSwapchain.scheduleUpdate((Function0<Unit>)var1_1);
    }

    public final ClipRectangle getClipRectForComponent(Component component) {
        String string;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        InteropViewHolder interopViewHolder = this.interopComponents.get(string);
        if (interopViewHolder == null) {
            string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)interopViewHolder, (String)"null cannot be cast to non-null type org.jetbrains.skiko.ClipRectangle");
        return (ClipRectangle)interopViewHolder;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @ComposableInferredTarget(scheme="[androidx.compose.ui.UiComposable[androidx.compose.ui.UiComposable]]")
    public final void invoke(Function2<? super Composer, ? super Integer, Unit> content, Composer $composer, int $changed) {
        void var2_2;
        Intrinsics.checkNotNullParameter(content, (String)"content");
        $composer = $composer.startRestartGroup(-1630984403);
        int $dirty = $changed;
        if (($changed & 6) == 0) {
            $dirty |= $composer.changedInstance(content) ? 4 : 2;
        }
        if (($changed & 0x30) == 0) {
            $dirty |= $composer.changedInstance((Object)this) ? 32 : 16;
        }
        if (($dirty & 0x13) != 18 || !$composer.getSkipping()) {
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart((int)-1630984403, (int)$dirty, (int)-1, (String)"androidx.compose.ui.viewinterop.SwingInteropContainer.invoke (SwingInteropContainer.desktop.kt:249)");
            }
            CompositionLocalKt.CompositionLocalProvider((ProvidedValue)InteropContainer_skikoKt.getLocalInteropContainer().provides((Object)this), (Function2)((Function2)ComposableLambdaKt.rememberComposableLambda((int)891259885, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this, content){
                final /* synthetic */ SwingInteropContainer this$0;
                final /* synthetic */ Function2<Composer, Integer, Unit> $content;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$content = var2_2;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Composable
                @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                public final void invoke(Composer $composer, int $changed) {
                    if (($changed & 3) != 2 || !$composer.getSkipping()) {
                        if (ComposerKt.isTraceInProgress()) {
                            void var2_2;
                            ComposerKt.traceEventStart((int)891259885, (int)var2_2, (int)-1, (String)"androidx.compose.ui.viewinterop.SwingInteropContainer.invoke.<anonymous> (SwingInteropContainer.desktop.kt:253)");
                        }
                        InteropContainer_skikoKt.TrackInteropPlacementContainer(this.this$0, this.$content, $composer, 0);
                        if (ComposerKt.isTraceInProgress()) {
                            return;
                        }
                    } else {
                        void var1_1;
                        var1_1.skipToGroupEnd();
                    }
                }
            }, (Composer)$composer, (int)54)), (Composer)$composer, (int)(0x30 | ProvidedValue.$stable));
            if (ComposerKt.isTraceInProgress()) {
                // empty if block
            }
        } else {
            $composer.skipToGroupEnd();
        }
        ScopeUpdateScope scopeUpdateScope = var2_2.endRestartGroup();
        if (scopeUpdateScope != null) {
            void var3_3;
            void var1_1;
            scopeUpdateScope.updateScope((Function2)new Function2<Composer, Integer, Unit>(this, (Function2<? super Composer, ? super Integer, Unit>)var1_1, (int)var3_3){
                final /* synthetic */ SwingInteropContainer $tmp0_rcvr;
                final /* synthetic */ Function2<Composer, Integer, Unit> $content;
                final /* synthetic */ int $$changed;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.$tmp0_rcvr = var1_1;
                    this.$content = var2_2;
                    this.$$changed = var3_3;
                    super(2);
                }
            });
            return;
        }
    }
}

