/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.DepthSortedSet;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.SortedSet;
import java.util.Comparator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDepthSortedSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,191:1\n102#1:227\n42#2,7:192\n42#2,7:199\n42#2,7:206\n42#2,7:213\n42#2,7:220\n*S KotlinDebug\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n*L\n93#1:227\n54#1:192,7\n62#1:199,7\n68#1:206,7\n75#1:213,7\n79#1:220,7\n*E\n"})
public final class DepthSortedSet {
    private final boolean extraAssertions;
    private final Lazy mapOfOriginalDepth$delegate;
    private final Comparator<LayoutNode> DepthComparator;
    private final SortedSet<LayoutNode> set;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public DepthSortedSet(boolean extraAssertions) {
        void var1_1;
        this.extraAssertions = var1_1;
        this.mapOfOriginalDepth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)mapOfOriginalDepth.2.INSTANCE);
        this.DepthComparator = new Comparator<LayoutNode>(){};
        this.set = new SortedSet<LayoutNode>(this.DepthComparator);
    }

    private final Map<LayoutNode, Integer> getMapOfOriginalDepth() {
        Lazy lazy = this.mapOfOriginalDepth$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(LayoutNode node) {
        void var2_3;
        void var1_1;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean contains = this.set.contains(node);
        if (this.extraAssertions && !(bl = contains == this.getMapOfOriginalDepth().containsKey(var1_1))) {
            InlineClassHelperKt.throwIllegalStateException("inconsistency in TreeSet");
        }
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(LayoutNode node) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl = node.isAttached();
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.add called on an unattached node");
        }
        if (this.extraAssertions) {
            Integer usedDepth = this.getMapOfOriginalDepth().get(node);
            if (usedDepth == null) {
                LayoutNode layoutNode = node;
                this.getMapOfOriginalDepth().put(layoutNode, layoutNode.getDepth$ui());
            } else {
                void var2_3;
                int n = node.getDepth$ui();
                n = var2_3.intValue() == n ? 1 : 0;
                if (n == 0) {
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        this.set.add((LayoutNode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(LayoutNode node) {
        void var1_1;
        Integer n;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl2 = node.isAttached();
        if (!bl2) {
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.remove called on an unattached node");
        }
        boolean contains = this.set.remove(node);
        if (this.extraAssertions && !(bl = Intrinsics.areEqual((Object)(n = this.getMapOfOriginalDepth().remove(node)), contains ? Integer.valueOf(var1_1.getDepth$ui()) : null))) {
            InlineClassHelperKt.throwIllegalStateException("invalid node depth");
        }
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    public final LayoutNode pop() {
        void var1_1;
        LayoutNode node = (LayoutNode)this.set.first();
        Intrinsics.checkNotNull((Object)node);
        this.remove(node);
        return var1_1;
    }

    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    public final String toString() {
        String string = this.set.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

