/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.DraggableAnchors;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nAnchoredDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/material3/internal/MapDraggableAnchors\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,864:1\n1#2:865\n*E\n"})
final class MapDraggableAnchors<T>
implements DraggableAnchors<T> {
    private final Map<T, Float> anchors;

    /*
     * WARNING - void declaration
     */
    public MapDraggableAnchors(Map<T, Float> anchors) {
        void var1_1;
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        this.anchors = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float positionOf(T value) {
        void var1_1;
        Float f = this.anchors.get(var1_1);
        if (f != null) {
            return f.floatValue();
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasAnchorFor(T value) {
        void var1_1;
        return this.anchors.containsKey(var1_1);
    }

    @Override
    public final T closestAnchor(float position) {
        Object v0;
        Object object = this.anchors.entrySet();
        if (!(object = object.iterator()).hasNext()) {
            v0 = null;
        } else {
            Object e = object.next();
            if (!object.hasNext()) {
                v0 = e;
            } else {
                Map.Entry it = (Map.Entry)e;
                float f = Math.abs(position - ((Number)it.getValue()).floatValue());
                do {
                    Object e2;
                    Map.Entry it2;
                    float f2;
                    if (Float.compare(f, f2 = Math.abs(position - ((Number)(it2 = (Map.Entry)(e2 = object.next())).getValue()).floatValue())) <= 0) continue;
                    e = e2;
                    f = f2;
                } while (object.hasNext());
                v0 = e;
            }
        }
        Map.Entry entry = v0;
        if (entry != null) {
            return (T)entry.getKey();
        }
        return null;
    }

    @Override
    public final T closestAnchor(float position, boolean searchUpwards) {
        Object v0;
        Object object = this.anchors.entrySet();
        if (!(object = object.iterator()).hasNext()) {
            v0 = null;
        } else {
            Object e = object.next();
            if (!object.hasNext()) {
                v0 = e;
            } else {
                Map.Entry entry = (Map.Entry)e;
                float anchor22 = ((Number)entry.getValue()).floatValue();
                float delta = searchUpwards ? anchor22 - position : position - anchor22;
                float f = delta < 0.0f ? Float.POSITIVE_INFINITY : delta;
                do {
                    float f2;
                    Object e2 = object.next();
                    Map.Entry anchor22 = (Map.Entry)e2;
                    anchor22 = ((Number)anchor22.getValue()).floatValue();
                    float delta2 = searchUpwards ? anchor22 - position : position - anchor22;
                    float f3 = f2 = delta2 < 0.0f ? Float.POSITIVE_INFINITY : delta2;
                    if (Float.compare(f, f2) <= 0) continue;
                    e = e2;
                    f = f2;
                } while (object.hasNext());
                v0 = e;
            }
        }
        Map.Entry entry = v0;
        if (entry != null) {
            return (T)entry.getKey();
        }
        return null;
    }

    @Override
    public final float minAnchor() {
        Float f = CollectionsKt.minOrNull((Iterable)this.anchors.values());
        if (f != null) {
            return f.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public final float maxAnchor() {
        Float f = CollectionsKt.maxOrNull((Iterable)this.anchors.values());
        if (f != null) {
            return f.floatValue();
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapDraggableAnchors)) {
            return false;
        }
        return Intrinsics.areEqual(this.anchors, ((MapDraggableAnchors)var1_1).anchors);
    }

    public final int hashCode() {
        return 31 * ((Object)this.anchors).hashCode();
    }

    public final String toString() {
        return "MapDraggableAnchors(" + this.anchors + ')';
    }
}

