/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket.internals;

import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.core.BytePacketBuilderExtensions_jvmKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketKt;
import io.ktor.utils.io.pool.ObjectPool;
import io.ktor.websocket.internals.BytePacketUtilsKt;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u001a\u001b\u0010\u0003\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0006\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a+\u0010\u000f\u001a\u00020\u000e*\u00020\b2\u0006\u0010\t\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\"\u0014\u0010\u0011\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012"}, d2={"Ljava/util/zip/Deflater;", "", "data", "deflateFully", "(Ljava/util/zip/Deflater;[B)[B", "Ljava/util/zip/Inflater;", "inflateFully", "(Ljava/util/zip/Inflater;[B)[B", "Lkotlinx/io/Sink;", "deflater", "Ljava/nio/ByteBuffer;", "buffer", "", "flush", "", "deflateTo", "(Lkotlinx/io/Sink;Ljava/util/zip/Deflater;Ljava/nio/ByteBuffer;Z)I", "PADDED_EMPTY_CHUNK", "[B", "EMPTY_CHUNK"})
@SourceDebugExtension(value={"SMAP\nDeflaterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeflaterUtils.kt\nio/ktor/websocket/internals/DeflaterUtilsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Pool.kt\nio/ktor/utils/io/pool/PoolKt\n*L\n1#1,86:1\n19#2,2:87\n21#2:94\n19#2,3:95\n19#2,2:98\n21#2:105\n160#3,5:89\n160#3,5:100\n*S KotlinDebug\n*F\n+ 1 DeflaterUtils.kt\nio/ktor/websocket/internals/DeflaterUtilsKt\n*L\n20#1:87,2\n20#1:94\n36#1:95,3\n46#1:98,2\n46#1:105\n21#1:89,5\n47#1:100,5\n*E\n"})
public final class DeflaterUtilsKt {
    private static final byte[] PADDED_EMPTY_CHUNK;
    private static final byte[] EMPTY_CHUNK;

    /*
     * WARNING - void declaration
     */
    public static final byte[] deflateFully(Deflater $this$deflateFully, byte[] data) {
        void var1_1;
        void var2_2;
        Deflater deflater;
        Intrinsics.checkNotNullParameter((Object)$this$deflateFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        $this$deflateFully.setInput(data);
        Object builder$iv = new Buffer();
        Sink $this$deflateFully_u24lambda_u241 = (Sink)builder$iv;
        ObjectPool $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
        Object instance$iv = $this$useInstance$iv.borrow();
        try {
            ByteBuffer buffer = (ByteBuffer)instance$iv;
            while (!$this$deflateFully.needsInput()) {
                DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u241, $this$deflateFully, buffer, false);
            }
            while (DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u241, $this$deflateFully, buffer, true) != 0) {
            }
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.recycle(instance$iv);
            throw throwable;
        }
        $this$useInstance$iv.recycle(instance$iv);
        Deflater deflatedBytes = (Source)builder$iv;
        if (BytePacketUtilsKt.endsWith((Source)deflatedBytes, PADDED_EMPTY_CHUNK)) {
            Deflater deflater2 = deflatedBytes;
            builder$iv = SourcesKt.readByteArray((Source)deflater2, (int)((int)ByteReadPacketKt.getRemaining((Source)deflater2) - EMPTY_CHUNK.length));
            deflatedBytes.close();
            return builder$iv;
        }
        builder$iv = new Buffer();
        Sink $this$deflateFully_u24lambda_u243 = (Sink)builder$iv;
        BytePacketBuilderKt.writePacket((Sink)$this$deflateFully_u24lambda_u243, (Source)deflater);
        var2_2.writeByte((byte)0);
        return SourcesKt.readByteArray((Source)((Source)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] inflateFully(Inflater $this$inflateFully, byte[] data) {
        void var2_4;
        Intrinsics.checkNotNullParameter((Object)$this$inflateFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] dataToInflate = ArraysKt.plus((byte[])data, (byte[])EMPTY_CHUNK);
        $this$inflateFully.setInput(dataToInflate);
        Buffer builder$iv = new Buffer();
        Sink $this$inflateFully_u24lambda_u245 = (Sink)builder$iv;
        ObjectPool $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
        Object instance$iv = $this$useInstance$iv.borrow();
        try {
            ByteBuffer buffer = (ByteBuffer)instance$iv;
            long limit = (long)dataToInflate.length + $this$inflateFully.getBytesRead();
            while ($this$inflateFully.getBytesRead() < limit) {
                void var1_3;
                buffer.clear();
                int inflated = $this$inflateFully.inflate(buffer.array(), buffer.position(), buffer.limit());
                ByteBuffer byteBuffer = buffer;
                byteBuffer.position(byteBuffer.position() + var1_3);
                buffer.flip();
                BytePacketBuilderExtensions_jvmKt.writeFully((Sink)$this$inflateFully_u24lambda_u245, (ByteBuffer)buffer);
            }
        }
        finally {
            $this$useInstance$iv.recycle(instance$iv);
        }
        Inflater inflater = (Source)var2_4;
        return SourcesKt.readByteArray((Source)inflater);
    }

    /*
     * WARNING - void declaration
     */
    private static final int deflateTo(Sink $this$deflateTo, Deflater deflater, ByteBuffer buffer, boolean flush2) {
        void var1_2;
        void var2_3;
        Sink sink;
        void var3_4;
        buffer.clear();
        int deflated = var3_4 != false ? deflater.deflate(buffer.array(), buffer.position(), buffer.limit(), 2) : deflater.deflate(buffer.array(), buffer.position(), buffer.limit());
        if (deflated == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = buffer;
        byteBuffer.position(byteBuffer.position() + deflated);
        buffer.flip();
        BytePacketBuilderExtensions_jvmKt.writeFully((Sink)sink, (ByteBuffer)var2_3);
        return (int)var1_2;
    }

    static {
        byte[] byArray = new byte[5];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = -1;
        byArray2[4] = -1;
        PADDED_EMPTY_CHUNK = byArray2;
        byte[] byArray3 = new byte[4];
        byArray2 = byArray3;
        byArray3[0] = 0;
        byArray2[1] = 0;
        byArray2[2] = -1;
        byArray2[3] = -1;
        EMPTY_CHUNK = byArray2;
    }
}

