/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.ws.MessageInflater;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

@SourceDebugExtension(value={"SMAP\nWebSocketReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketReader.kt\nokhttp3/internal/ws/WebSocketReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
public final class WebSocketReader
implements Closeable {
    private final boolean isClient;
    private final BufferedSource source;
    private final FrameCallback frameCallback;
    private final boolean perMessageDeflate;
    private final boolean noContextTakeover;
    private boolean closed;
    private int opcode;
    private long frameLength;
    private boolean isFinalFrame;
    private boolean isControlFrame;
    private boolean readingCompressedMessage;
    private final Buffer controlFrameBuffer;
    private final Buffer messageFrameBuffer;
    private MessageInflater messageInflater;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    /*
     * WARNING - void declaration
     */
    public WebSocketReader(boolean isClient, BufferedSource source, FrameCallback frameCallback, boolean perMessageDeflate, boolean noContextTakeover) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)frameCallback, (String)"frameCallback");
        this.isClient = var1_1;
        this.source = var2_2;
        this.frameCallback = var3_3;
        this.perMessageDeflate = perMessageDeflate;
        this.noContextTakeover = noContextTakeover;
        this.controlFrameBuffer = new Buffer();
        this.messageFrameBuffer = new Buffer();
        this.maskKey = this.isClient ? null : new byte[4];
        this.maskCursor = this.isClient ? null : new Buffer.UnsafeCursor();
    }

    public final void processNextFrame() throws IOException {
        Closeable closeable;
        Closeable closeable2;
        int n;
        WebSocketReader webSocketReader;
        block10: {
            this.readHeader();
            if (this.isControlFrame) {
                this.readControlFrame();
                return;
            }
            webSocketReader = this;
            n = webSocketReader.opcode;
            if (n != 1 && n != 2) {
                throw new ProtocolException("Unknown opcode: " + Util.toHexString(n));
            }
            closeable2 = webSocketReader;
            block0: do {
                if (closeable2.closed) {
                    throw new IOException("closed");
                }
                if (closeable2.frameLength > 0L) {
                    closeable2.source.readFully(closeable2.messageFrameBuffer, closeable2.frameLength);
                    if (!closeable2.isClient) {
                        Buffer buffer = closeable2.messageFrameBuffer;
                        Buffer.UnsafeCursor unsafeCursor = closeable2.maskCursor;
                        Intrinsics.checkNotNull((Object)unsafeCursor);
                        buffer.readAndWriteUnsafe(unsafeCursor);
                        closeable2.maskCursor.seek(closeable2.messageFrameBuffer.size() - closeable2.frameLength);
                        Buffer.UnsafeCursor unsafeCursor2 = closeable2.maskCursor;
                        Intrinsics.checkNotNull((Object)closeable2.maskKey);
                        WebSocketProtocol.toggleMask(unsafeCursor2, closeable2.maskKey);
                        closeable2.maskCursor.close();
                    }
                }
                if (closeable2.isFinalFrame) break block10;
                closeable = closeable2;
                while (!closeable.closed) {
                    closeable.readHeader();
                    if (!closeable.isControlFrame) continue block0;
                    closeable.readControlFrame();
                }
            } while (closeable2.opcode == 0);
            throw new ProtocolException("Expected continuation opcode. Got: " + Util.toHexString(closeable2.opcode));
        }
        if (webSocketReader.readingCompressedMessage) {
            Closeable closeable3 = webSocketReader.messageInflater;
            if (closeable3 == null) {
                closeable = closeable2 = new MessageInflater(webSocketReader.noContextTakeover);
                webSocketReader.messageInflater = closeable;
                closeable3 = closeable2;
            }
            closeable2 = closeable3;
            closeable3.inflate(webSocketReader.messageFrameBuffer);
        }
        if (n == 1) {
            webSocketReader.frameCallback.onReadMessage(webSocketReader.messageFrameBuffer.readUtf8());
            return;
        }
        webSocketReader.frameCallback.onReadMessage(webSocketReader.messageFrameBuffer.readByteString());
    }

    /*
     * WARNING - void declaration
     */
    private final void readHeader() throws IOException, ProtocolException {
        void var2_2;
        void var1_3;
        int b0;
        if (this.closed) {
            throw new IOException("closed");
        }
        long timeoutBefore = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            b0 = Util.and(this.source.readByte(), 255);
        }
        finally {
            this.source.timeout().timeout(timeoutBefore, TimeUnit.NANOSECONDS);
        }
        this.opcode = b0 & 0xF;
        this.isFinalFrame = (b0 & 0x80) != 0;
        boolean bl = this.isControlFrame = (b0 & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean reservedFlag1 = (b0 & 0x40) != 0;
        switch (this.opcode) {
            case 1: 
            case 2: {
                boolean bl2;
                if (reservedFlag1) {
                    if (!this.perMessageDeflate) {
                        throw new ProtocolException("Unexpected rsv1 flag");
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                this.readingCompressedMessage = bl2;
                break;
            }
            default: {
                if (!reservedFlag1) break;
                throw new ProtocolException("Unexpected rsv1 flag");
            }
        }
        if (timeoutBefore = (b0 & 0x20) != 0) {
            throw new ProtocolException("Unexpected rsv2 flag");
        }
        if ((b0 = (b0 & 0x10) != 0 ? 1 : 0) != 0) {
            throw new ProtocolException("Unexpected rsv3 flag");
        }
        int b1 = Util.and(this.source.readByte(), 255);
        boolean isMasked = (b1 & 0x80) != 0;
        if (isMasked == this.isClient) {
            throw new ProtocolException(this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.frameLength = var1_3 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = Util.and(this.source.readShort(), 65535);
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException("Frame length 0x" + Util.toHexString(this.frameLength) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (var2_2 != false) {
            Intrinsics.checkNotNull((Object)this.maskKey);
            this.source.readFully(this.maskKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readControlFrame() throws IOException {
        if (this.frameLength > 0L) {
            this.source.readFully(this.controlFrameBuffer, this.frameLength);
            if (!this.isClient) {
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull((Object)unsafeCursor);
                this.controlFrameBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(0L);
                Intrinsics.checkNotNull((Object)this.maskKey);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                return;
            }
            case 10: {
                this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                return;
            }
            case 8: {
                void var2_2;
                void var1_1;
                int code = 1005;
                String reason = "";
                long bufferSize = this.controlFrameBuffer.size();
                if (bufferSize == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (bufferSize != 0L) {
                    code = this.controlFrameBuffer.readShort();
                    reason = this.controlFrameBuffer.readUtf8();
                    String codeExceptionMessage = WebSocketProtocol.closeCodeExceptionMessage(code);
                    if (codeExceptionMessage != null) {
                        void var3_4;
                        throw new ProtocolException((String)var3_4);
                    }
                }
                this.frameCallback.onReadClose((int)var1_1, (String)var2_2);
                this.closed = true;
                return;
            }
        }
        throw new ProtocolException("Unknown control opcode: " + Util.toHexString(this.opcode));
    }

    @Override
    public final void close() throws IOException {
        MessageInflater messageInflater = this.messageInflater;
        if (messageInflater != null) {
            messageInflater.close();
            return;
        }
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

