/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.tls.TrustRootIndex;

@SourceDebugExtension(value={"SMAP\nBasicTrustRootIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicTrustRootIndex.kt\nokhttp3/internal/tls/BasicTrustRootIndex\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n372#2,7:57\n288#3,2:64\n*S KotlinDebug\n*F\n+ 1 BasicTrustRootIndex.kt\nokhttp3/internal/tls/BasicTrustRootIndex\n*L\n28#1:57,7\n37#1:64,2\n*E\n"})
public final class BasicTrustRootIndex
implements TrustRootIndex {
    private final Map<X500Principal, Set<X509Certificate>> subjectToCaCerts;

    /*
     * WARNING - void declaration
     */
    public BasicTrustRootIndex(X509Certificate ... caCerts) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)caCerts, (String)"caCerts");
        Map map = new LinkedHashMap();
        for (X509Certificate caCert : caCerts) {
            Set set;
            X500Principal key$iv;
            void $this$getOrPut$iv;
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)caCert.getSubjectX500Principal(), (String)"caCert.subjectX500Principal");
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                set = answer$iv;
            } else {
                void var8_8;
                set = var8_8;
            }
            ((Set)set).add(caCert);
        }
        this.subjectToCaCerts = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final X509Certificate findByIssuerAndSignature(X509Certificate cert) {
        Object v3;
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            X500Principal issuer = cert.getIssuerX500Principal();
            Set<X509Certificate> set = this.subjectToCaCerts.get(object);
            if (set == null) {
                return null;
            }
            object = set;
            object = set;
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                boolean bl;
                Object element$iv = object.next();
                X509Certificate it = (X509Certificate)element$iv;
                try {
                    cert.verify(it.getPublicKey());
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl) continue;
                v3 = var3_3;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other == this || other instanceof BasicTrustRootIndex && Intrinsics.areEqual(((BasicTrustRootIndex)var1_1).subjectToCaCerts, this.subjectToCaCerts);
    }

    public final int hashCode() {
        return ((Object)this.subjectToCaCerts).hashCode();
    }
}

