/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidCertificateChainCleaner;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import okhttp3.internal.platform.android.CloseGuard;
import okhttp3.internal.platform.android.ConscryptSocketAdapter;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import okhttp3.internal.platform.android.StandardAndroidSocketAdapter;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 22\u00020\u0001:\u000223B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ4\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0011\u0010\u0013\u001a\r\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u00120\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010!\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b&\u0010'J!\u0010*\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u000e2\b\u0010)\u001a\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0004\b*\u0010+R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020/0\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101"}, d2={"Lokhttp3/internal/platform/AndroidPlatform;", "Lokhttp3/internal/platform/Platform;", "<init>", "()V", "Ljavax/net/ssl/X509TrustManager;", "trustManager", "Lokhttp3/internal/tls/CertificateChainCleaner;", "buildCertificateChainCleaner", "(Ljavax/net/ssl/X509TrustManager;)Lokhttp3/internal/tls/CertificateChainCleaner;", "Lokhttp3/internal/tls/TrustRootIndex;", "buildTrustRootIndex", "(Ljavax/net/ssl/X509TrustManager;)Lokhttp3/internal/tls/TrustRootIndex;", "Ljavax/net/ssl/SSLSocket;", "sslSocket", "", "hostname", "", "Lokhttp3/Protocol;", "Lkotlin/jvm/JvmSuppressWildcards;", "protocols", "", "configureTlsExtensions", "(Ljavax/net/ssl/SSLSocket;Ljava/lang/String;Ljava/util/List;)V", "Ljava/net/Socket;", "socket", "Ljava/net/InetSocketAddress;", "address", "", "connectTimeout", "connectSocket", "(Ljava/net/Socket;Ljava/net/InetSocketAddress;I)V", "getSelectedProtocol", "(Ljavax/net/ssl/SSLSocket;)Ljava/lang/String;", "closer", "", "getStackTraceForCloseable", "(Ljava/lang/String;)Ljava/lang/Object;", "", "isCleartextTrafficPermitted", "(Ljava/lang/String;)Z", "message", "stackTrace", "logCloseableLeak", "(Ljava/lang/String;Ljava/lang/Object;)V", "Lokhttp3/internal/platform/android/CloseGuard;", "closeGuard", "Lokhttp3/internal/platform/android/CloseGuard;", "Lokhttp3/internal/platform/android/SocketAdapter;", "socketAdapters", "Ljava/util/List;", "Companion", "CustomTrustRootIndex"})
@SourceDebugExtension(value={"SMAP\nAndroidPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPlatform.kt\nokhttp3/internal/platform/AndroidPlatform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n766#2:164\n857#2,2:165\n1#3:167\n*S KotlinDebug\n*F\n+ 1 AndroidPlatform.kt\nokhttp3/internal/platform/AndroidPlatform\n*L\n52#1:164\n52#1:165,2\n*E\n"})
public final class AndroidPlatform
extends Platform {
    public static final Companion Companion;
    private final List<SocketAdapter> socketAdapters;
    private final CloseGuard closeGuard;
    private static final boolean isSupported;

    /*
     * WARNING - void declaration
     */
    public AndroidPlatform() {
        void var2_3;
        Object[] objectArray = new SocketAdapter[4];
        Object object = objectArray;
        objectArray[0] = StandardAndroidSocketAdapter.Companion.buildIfSupported$default$3b3c3554(StandardAndroidSocketAdapter.Companion, null, 1);
        object[1] = new DeferredSocketAdapter(AndroidSocketAdapter.Companion.getPlayProviderFactory());
        object[2] = new DeferredSocketAdapter(ConscryptSocketAdapter.Companion.getFactory());
        object[3] = new DeferredSocketAdapter(BouncyCastleSocketAdapter.Companion.getFactory());
        object = CollectionsKt.listOfNotNull((Object[])object);
        AndroidPlatform androidPlatform = this;
        Collection destination$iv$iv = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_4;
            Object element$iv$iv = object.next();
            SocketAdapter socketAdapter = (SocketAdapter)element$iv$iv;
            if (!socketAdapter.isSupported()) continue;
            destination$iv$iv.add(var3_4);
        }
        androidPlatform.socketAdapters = (List)var2_3;
        this.closeGuard = CloseGuard.Companion.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        try {
            void var3_4;
            void var2_3;
            socket.connect((SocketAddress)var2_3, (int)var3_4);
            return;
        }
        catch (ClassCastException e) {
            void var1_2;
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", e);
            }
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        Object v0;
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            object = this.socketAdapters;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                SocketAdapter socketAdapter = (SocketAdapter)e;
                if (!socketAdapter.matchesSocket(sslSocket)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        object = v0;
        if (object != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            object.configureTlsExtensions((SSLSocket)var1_1, (String)var2_2, (List<? extends Protocol>)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getSelectedProtocol(SSLSocket sslSocket) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            Object object = this.socketAdapters;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                SocketAdapter socketAdapter = (SocketAdapter)e;
                if (!socketAdapter.matchesSocket(sslSocket)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        if (socketAdapter != null) {
            void var1_1;
            return socketAdapter.getSelectedProtocol((SSLSocket)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object getStackTraceForCloseable(String closer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        return this.closeGuard.createAndOpen((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void logCloseableLeak(String message, Object stackTrace) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = this.closeGuard.warnIfOpen(var2_2);
        if (!bl) {
            void var1_1;
            Platform.log$default(this, (String)var1_1, 5, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isCleartextTrafficPermitted(String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (Build.VERSION.SDK_INT >= 24) {
            void var1_1;
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted((String)var1_1);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        AndroidCertificateChainCleaner androidCertificateChainCleaner = AndroidCertificateChainCleaner.Companion.buildIfSupported(trustManager);
        if (androidCertificateChainCleaner != null) {
            return androidCertificateChainCleaner;
        }
        return super.buildCertificateChainCleaner((X509TrustManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        try {
            Class[] classArray = new Class[1];
            object = classArray;
            classArray[0] = X509Certificate.class;
            Method method = trustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", (Class<?>)object);
            method.setAccessible(true);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            object = new CustomTrustRootIndex(trustManager, (Method)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var1_1;
            object = super.buildTrustRootIndex((X509TrustManager)var1_1);
        }
        return object;
    }

    static {
        boolean bl;
        Companion = new Companion(null);
        if (!Platform.Companion.isAndroid()) {
            bl = false;
        } else if (Build.VERSION.SDK_INT >= 30) {
            bl = false;
        } else {
            if (!(Build.VERSION.SDK_INT >= 21)) {
                String string = "Expected Android API level 21+ but was " + Build.VERSION.SDK_INT;
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        isSupported = bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0005\u0010\u0007"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$Companion;", "", "<init>", "()V", "", "isSupported", "Z", "()Z"})
    public static final class Companion {
        private Companion() {
        }

        public static boolean isSupported() {
            return isSupported;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class CustomTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        /*
         * WARNING - void declaration
         */
        public CustomTrustRootIndex(X509TrustManager trustManager, Method findByIssuerAndSignatureMethod) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
            Intrinsics.checkNotNullParameter((Object)findByIssuerAndSignatureMethod, (String)"findByIssuerAndSignatureMethod");
            this.trustManager = var1_1;
            this.findByIssuerAndSignatureMethod = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final X509Certificate findByIssuerAndSignature(X509Certificate cert) {
            X509Certificate x509Certificate;
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            try {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = cert;
                Object object = this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, objectArray2);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.cert.TrustAnchor");
                cert = (TrustAnchor)object;
                cert = ((TrustAnchor)cert).getTrustedCert();
            }
            catch (IllegalAccessException e) {
                void var1_2;
                throw new AssertionError("unable to get issues and signature", (Throwable)var1_2);
            }
            catch (InvocationTargetException invocationTargetException) {
                x509Certificate = null;
            }
            return x509Certificate;
        }

        public final String toString() {
            return "CustomTrustRootIndex(trustManager=" + this.trustManager + ", findByIssuerAndSignatureMethod=" + this.findByIssuerAndSignatureMethod + ')';
        }

        public final int hashCode() {
            int n = this.trustManager.hashCode();
            n = n * 31 + this.findByIssuerAndSignatureMethod.hashCode();
            return n;
        }

        public final boolean equals(Object other) {
            CustomTrustRootIndex customTrustRootIndex;
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomTrustRootIndex)) {
                return false;
            }
            customTrustRootIndex = customTrustRootIndex;
            if (!Intrinsics.areEqual((Object)this.trustManager, (Object)customTrustRootIndex.trustManager)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.findByIssuerAndSignatureMethod, (Object)customTrustRootIndex.findByIssuerAndSignatureMethod);
        }
    }
}

