/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.StreamResetException;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 e2\u00020\u0001:\u0004efghB3\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0016\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u001f\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0017\u00a2\u0006\u0004\b \u0010!J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\r\u0010&\u001a\u00020%\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010+\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0002\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010-\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010/\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0017\u00a2\u0006\u0004\b/\u0010!J\r\u00100\u001a\u00020\t\u00a2\u0006\u0004\b0\u00101J\u000f\u00103\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b2\u0010\u0013J\r\u00104\u001a\u00020%\u00a2\u0006\u0004\b4\u0010'R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00105\u001a\u0004\b6\u00107R\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u00178@@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b\u001d\u00108\u001a\u0004\b9\u0010:R\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u00198\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b\u001a\u0010;\u001a\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020\t0@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010C\u001a\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0011\u0010H\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bH\u0010GR*\u0010J\u001a\u00020\r2\u0006\u0010I\u001a\u00020\r8\u0006@@X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\"\u0004\bN\u0010\u0011R*\u0010O\u001a\u00020\r2\u0006\u0010I\u001a\u00020\r8\u0006@@X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010K\u001a\u0004\bP\u0010M\"\u0004\bQ\u0010\u0011R\u001e\u0010&\u001a\u00060RR\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b&\u0010S\u001a\u0004\bT\u0010UR\u001e\u0010W\u001a\u00060VR\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u0010ZR\u001e\u0010)\u001a\u00060[R\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b)\u0010\\\u001a\u0004\b]\u0010^R\u001c\u0010_\u001a\u00020\r8\u0006@@X\u0086\f\u00a2\u0006\f\n\u0004\b_\u0010K\u001a\u0004\b`\u0010MR*\u0010a\u001a\u00020\r2\u0006\u0010I\u001a\u00020\r8\u0006@@X\u0086\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010K\u001a\u0004\bb\u0010M\"\u0004\bc\u0010\u0011R\u001e\u00104\u001a\u00060RR\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b4\u0010S\u001a\u0004\bd\u0010U"}, d2={"Lokhttp3/internal/http2/Http2Stream;", "", "", "id", "Lokhttp3/internal/http2/Http2Connection;", "connection", "", "outFinished", "inFinished", "Lokhttp3/Headers;", "headers", "<init>", "(ILokhttp3/internal/http2/Http2Connection;ZZLokhttp3/Headers;)V", "", "delta", "", "addBytesToWriteWindow", "(J)V", "cancelStreamIfNecessary$okhttp", "()V", "cancelStreamIfNecessary", "checkOutNotClosed$okhttp", "checkOutNotClosed", "Lokhttp3/internal/http2/ErrorCode;", "rstStatusCode", "Ljava/io/IOException;", "errorException", "close", "(Lokhttp3/internal/http2/ErrorCode;Ljava/io/IOException;)V", "errorCode", "closeInternal", "(Lokhttp3/internal/http2/ErrorCode;Ljava/io/IOException;)Z", "closeLater", "(Lokhttp3/internal/http2/ErrorCode;)V", "Lokio/Sink;", "getSink", "()Lokio/Sink;", "Lokio/Timeout;", "readTimeout", "()Lokio/Timeout;", "Lokio/BufferedSource;", "source", "length", "receiveData", "(Lokio/BufferedSource;I)V", "receiveHeaders", "(Lokhttp3/Headers;Z)V", "receiveRstStream", "takeHeaders", "()Lokhttp3/Headers;", "waitForIo$okhttp", "waitForIo", "writeTimeout", "Lokhttp3/internal/http2/Http2Connection;", "getConnection", "()Lokhttp3/internal/http2/Http2Connection;", "Lokhttp3/internal/http2/ErrorCode;", "getErrorCode$okhttp", "()Lokhttp3/internal/http2/ErrorCode;", "Ljava/io/IOException;", "getErrorException$okhttp", "()Ljava/io/IOException;", "hasResponseHeaders", "Z", "Ljava/util/ArrayDeque;", "headersQueue", "Ljava/util/ArrayDeque;", "I", "getId", "()I", "isLocallyInitiated", "()Z", "isOpen", "<set-?>", "readBytesAcknowledged", "J", "getReadBytesAcknowledged", "()J", "setReadBytesAcknowledged$okhttp", "readBytesTotal", "getReadBytesTotal", "setReadBytesTotal$okhttp", "Lokhttp3/internal/http2/Http2Stream$StreamTimeout;", "Lokhttp3/internal/http2/Http2Stream$StreamTimeout;", "getReadTimeout$okhttp", "()Lokhttp3/internal/http2/Http2Stream$StreamTimeout;", "Lokhttp3/internal/http2/Http2Stream$FramingSink;", "sink", "Lokhttp3/internal/http2/Http2Stream$FramingSink;", "getSink$okhttp", "()Lokhttp3/internal/http2/Http2Stream$FramingSink;", "Lokhttp3/internal/http2/Http2Stream$FramingSource;", "Lokhttp3/internal/http2/Http2Stream$FramingSource;", "getSource$okhttp", "()Lokhttp3/internal/http2/Http2Stream$FramingSource;", "writeBytesMaximum", "getWriteBytesMaximum", "writeBytesTotal", "getWriteBytesTotal", "setWriteBytesTotal$okhttp", "getWriteTimeout$okhttp", "Companion", "FramingSink", "FramingSource", "StreamTimeout"})
@SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n*L\n1#1,688:1\n1#2:689\n615#3,4:690\n615#3,4:694\n563#3:698\n615#3,4:699\n615#3,4:703\n563#3:707\n563#3:708\n615#3,4:709\n563#3:713\n557#3:714\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream\n*L\n176#1:690,4\n255#1:694,4\n263#1:698\n274#1:699,4\n281#1:703,4\n295#1:707\n305#1:708\n491#1:709,4\n637#1:713\n657#1:714\n*E\n"})
public final class Http2Stream {
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final Http2Connection connection;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    private final ArrayDeque<Headers> headersQueue;
    private boolean hasResponseHeaders;
    private final FramingSource source;
    private final FramingSink sink;
    private final StreamTimeout readTimeout;
    private final StreamTimeout writeTimeout;
    private ErrorCode errorCode;
    private IOException errorException;

    /*
     * WARNING - void declaration
     */
    public Http2Stream(int id, Http2Connection connection, boolean outFinished, boolean inFinished, Headers headers) {
        void var3_5;
        void var2_4;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.id = var1_1;
        this.connection = var2_4;
        this.writeBytesMaximum = this.connection.getPeerSettings().getInitialWindowSize();
        this.headersQueue = new ArrayDeque();
        Http2Stream http2Stream = this;
        this.source = new FramingSource(http2Stream, http2Stream.connection.getOkHttpSettings().getInitialWindowSize(), inFinished);
        this.sink = new FramingSink(this, (boolean)var3_5);
        this.readTimeout = new StreamTimeout(this);
        this.writeTimeout = new StreamTimeout(this);
        if (headers != null) {
            if (!(!this.isLocallyInitiated())) {
                String string = "locally-initiated streams shouldn't have headers yet";
                throw new IllegalStateException(string.toString());
            }
            ((Collection)this.headersQueue).add(headers);
            return;
        }
        if (!this.isLocallyInitiated()) {
            String string = "remotely-initiated streams should have headers";
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getId() {
        return this.id;
    }

    public final Http2Connection getConnection() {
        return this.connection;
    }

    public final long getReadBytesTotal() {
        return this.readBytesTotal;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReadBytesTotal$okhttp(long l) {
        void var1_1;
        this.readBytesTotal = var1_1;
    }

    public final long getReadBytesAcknowledged() {
        return this.readBytesAcknowledged;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReadBytesAcknowledged$okhttp(long l) {
        void var1_1;
        this.readBytesAcknowledged = var1_1;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    /*
     * WARNING - void declaration
     */
    public final void setWriteBytesTotal$okhttp(long l) {
        void var1_1;
        this.writeBytesTotal = var1_1;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final FramingSource getSource$okhttp() {
        return this.source;
    }

    public final FramingSink getSink$okhttp() {
        return this.sink;
    }

    public final StreamTimeout getReadTimeout$okhttp() {
        return this.readTimeout;
    }

    public final StreamTimeout getWriteTimeout$okhttp() {
        return this.writeTimeout;
    }

    public final synchronized ErrorCode getErrorCode$okhttp() {
        return this.errorCode;
    }

    public final IOException getErrorException$okhttp() {
        return this.errorException;
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.getFinished$okhttp() && !this.source.getClosed$okhttp() || !this.sink.getFinished() && !this.sink.getClosed() || !this.hasResponseHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isLocallyInitiated() {
        void var1_1;
        boolean streamIsClient;
        boolean bl = streamIsClient = (this.id & 1) == 1;
        return this.connection.getClient$okhttp() == var1_1;
    }

    public final synchronized Headers takeHeaders() throws IOException {
        Throwable throwable;
        this.readTimeout.enter();
        try {
            while (this.headersQueue.isEmpty() && this.errorCode == null) {
                this.waitForIo$okhttp();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        if (!((Collection)this.headersQueue).isEmpty()) {
            Headers headers = this.headersQueue.removeFirst();
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"headersQueue.removeFirst()");
            return headers;
        }
        IOException iOException = this.errorException;
        if (iOException != null) {
            throwable = iOException;
        } else {
            ErrorCode errorCode = this.errorCode;
            Intrinsics.checkNotNull((Object)((Object)errorCode));
            throwable = new StreamResetException(errorCode);
        }
        throw throwable;
    }

    public final Timeout readTimeout() {
        return (Timeout)this.readTimeout;
    }

    public final Timeout writeTimeout() {
        return (Timeout)this.writeTimeout;
    }

    public final Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (!(this.hasResponseHeaders || this.isLocallyInitiated())) {
                String string = "reply before requesting the sink";
                throw new IllegalStateException(string.toString());
            }
        }
        return this.sink;
    }

    /*
     * WARNING - void declaration
     */
    public final void close(ErrorCode rstStatusCode, IOException errorException) throws IOException {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)((Object)rstStatusCode), (String)"rstStatusCode");
        if (!this.closeInternal(rstStatusCode, (IOException)var2_2)) {
            return;
        }
        this.connection.writeSynReset$okhttp(this.id, (ErrorCode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void closeLater(ErrorCode errorCode) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        if (!this.closeInternal(errorCode, null)) {
            return;
        }
        this.connection.writeSynResetLater$okhttp(this.id, (ErrorCode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean closeInternal(ErrorCode errorCode, IOException errorException) {
        Http2Stream http2Stream;
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        http2Stream = this;
        synchronized (http2Stream) {
            block7: {
                void var1_1;
                void var2_3;
                block6: {
                    if (this.errorCode == null) break block6;
                    return false;
                }
                this.errorCode = errorCode;
                this.errorException = var2_3;
                Http2Stream $this$notifyAll$iv = this;
                Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)var1_1).notifyAll();
                if (!this.source.getFinished$okhttp() || !this.sink.getFinished()) break block7;
                return false;
            }
        }
        this.connection.removeStream$okhttp(this.id);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void receiveData(BufferedSource source, int length) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            void var3_3;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + var3_3));
        }
        this.source.receive$okhttp((BufferedSource)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void receiveHeaders(Headers headers, boolean inFinished) {
        void var3_5;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            void var1_1;
            void var2_3;
            if (!this.hasResponseHeaders || !inFinished) {
                this.hasResponseHeaders = true;
                ((Collection)this.headersQueue).add(headers);
            } else {
                this.source.setTrailers(headers);
            }
            if (var2_3 != false) {
                this.source.setFinished$okhttp(true);
            }
            boolean open = this.isOpen();
            Http2Stream $this$notifyAll$iv = this;
            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)var1_1).notifyAll();
        }
        if (var3_5 == false) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void receiveRstStream(ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        if (this.errorCode == null) {
            void var1_1;
            this.errorCode = errorCode;
            Http2Stream $this$notifyAll$iv = this;
            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)var1_1).notifyAll();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void cancelStreamIfNecessary$okhttp() throws IOException {
        void var1_2;
        void var2_5;
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            boolean cancel = !this.source.getFinished$okhttp() && this.source.getClosed$okhttp() && (this.sink.getFinished() || this.sink.getClosed());
            boolean open = this.isOpen();
        }
        if (var2_5 != false) {
            this.close(ErrorCode.CANCEL, null);
            return;
        }
        if (var1_2 == false) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addBytesToWriteWindow(long delta) {
        this.writeBytesMaximum += delta;
        if (delta > 0L) {
            void var1_2;
            Http2Stream $this$notifyAll$iv = this;
            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)var1_2).notifyAll();
        }
    }

    public final void checkOutNotClosed$okhttp() throws IOException {
        if (this.sink.getClosed()) {
            throw new IOException("stream closed");
        }
        if (this.sink.getFinished()) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            Throwable throwable;
            IOException iOException = this.errorException;
            if (iOException != null) {
                throwable = iOException;
            } else {
                ErrorCode errorCode = this.errorCode;
                Intrinsics.checkNotNull((Object)((Object)errorCode));
                throwable = new StreamResetException(errorCode);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void waitForIo$okhttp() throws InterruptedIOException {
        try {
            void var1_1;
            Http2Stream $this$wait$iv = this;
            Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)var1_1).wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lokhttp3/internal/http2/Http2Stream$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\bJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u00020\u00028\u0006@\u0006X\u0086\f\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\f\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001d8\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f"}, d2={"Lokhttp3/internal/http2/Http2Stream$FramingSink;", "Lokio/Sink;", "", "finished", "<init>", "(Lokhttp3/internal/http2/Http2Stream;Z)V", "", "close", "()V", "outFinishedOnLastFrame", "emitFrame", "(Z)V", "flush", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "Lokio/Buffer;", "source", "", "byteCount", "write", "(Lokio/Buffer;J)V", "closed", "Z", "getClosed", "()Z", "getFinished", "sendBuffer", "Lokio/Buffer;", "Lokhttp3/Headers;", "trailers", "Lokhttp3/Headers;"})
    @SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSink\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,688:1\n615#2,4:689\n615#2,4:693\n615#2,4:697\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSink\n*L\n528#1:689,4\n573#1:693,4\n589#1:697,4\n*E\n"})
    public final class FramingSink
    implements Sink {
        private boolean finished;
        private final Buffer sendBuffer;
        public Headers trailers;
        private boolean closed;
        final /* synthetic */ Http2Stream this$0;

        /*
         * WARNING - void declaration
         */
        public FramingSink(Http2Stream this$0, boolean finished) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.finished = var2_2;
            this.sendBuffer = new Buffer();
        }

        public final boolean getFinished() {
            return this.finished;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Buffer source, long byteCount) throws IOException {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            this.sendBuffer.write((Buffer)var1_1, (long)var2_2);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void emitFrame(boolean outFinishedOnLastFrame) throws IOException {
            long toWrite;
            Http2Stream http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream) {
                http2Stream2.getWriteTimeout$okhttp().enter();
                try {
                    while (http2Stream2.getWriteBytesTotal() >= http2Stream2.getWriteBytesMaximum() && !this.finished && !this.closed && http2Stream2.getErrorCode$okhttp() == null) {
                        http2Stream2.waitForIo$okhttp();
                    }
                }
                finally {
                    http2Stream2.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
                }
                http2Stream2.checkOutNotClosed$okhttp();
                toWrite = Math.min(http2Stream2.getWriteBytesMaximum() - http2Stream2.getWriteBytesTotal(), this.sendBuffer.size());
                Http2Stream http2Stream3 = http2Stream2;
                http2Stream3.setWriteBytesTotal$okhttp(http2Stream3.getWriteBytesTotal() + toWrite);
                boolean outFinished = outFinishedOnLastFrame && toWrite == this.sendBuffer.size();
            }
            this.this$0.getWriteTimeout$okhttp().enter();
            try {
                void var1_1;
                this.this$0.getConnection().writeData(this.this$0.getId(), (boolean)var1_1, this.sendBuffer, toWrite);
                return;
            }
            finally {
                this.this$0.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
            }
        }

        public final void flush() throws IOException {
            Http2Stream http2Stream;
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
            }
            http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream) {
                http2Stream2.checkOutNotClosed$okhttp();
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                this.this$0.getConnection().flush();
            }
        }

        public final Timeout timeout() {
            return (Timeout)this.this$0.getWriteTimeout$okhttp();
        }

        /*
         * WARNING - void declaration
         */
        public final void close() throws IOException {
            boolean outFinished;
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            Http2Stream http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream) {
                if (this.closed) {
                    return;
                }
                outFinished = http2Stream2.getErrorCode$okhttp() == null;
            }
            if (!this.this$0.getSink$okhttp().finished) {
                void var1_2;
                void var2_5;
                boolean hasData = this.sendBuffer.size() > 0L;
                boolean bl = this.trailers != null;
                if (bl) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(false);
                    }
                    Http2Connection http2Connection = this.this$0.getConnection();
                    int n = this.this$0.getId();
                    Headers headers = this.trailers;
                    Intrinsics.checkNotNull((Object)headers);
                    http2Connection.writeHeaders$okhttp(n, outFinished, Util.toHeaderList(headers));
                } else if (var2_5 != false) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else if (var1_2 != false) {
                    this.this$0.getConnection().writeData(this.this$0.getId(), true, null, 0L);
                }
            }
            Http2Stream http2Stream3 = this.this$0;
            synchronized (http2Stream3) {
                this.closed = true;
            }
            this.this$0.getConnection().flush();
            this.this$0.cancelStreamIfNecessary$okhttp();
        }
    }

    @SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n*L\n1#1,688:1\n1#2:689\n615#3,4:690\n615#3,4:694\n563#3:698\n563#3:699\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSource\n*L\n407#1:690,4\n418#1:694,4\n458#1:698\n480#1:699\n*E\n"})
    public final class FramingSource
    implements Source {
        private final long maxByteCount;
        private boolean finished;
        private final Buffer receiveBuffer;
        private final Buffer readBuffer;
        private Headers trailers;
        private boolean closed;
        final /* synthetic */ Http2Stream this$0;

        /*
         * WARNING - void declaration
         */
        public FramingSource(Http2Stream this$0, long maxByteCount, boolean finished) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.maxByteCount = var2_2;
            this.finished = finished;
            this.receiveBuffer = new Buffer();
            this.readBuffer = new Buffer();
        }

        public final boolean getFinished$okhttp() {
            return this.finished;
        }

        public final void setFinished$okhttp(boolean bl) {
            this.finished = true;
        }

        /*
         * WARNING - void declaration
         */
        public final void setTrailers(Headers headers) {
            void var1_1;
            this.trailers = var1_1;
        }

        public final boolean getClosed$okhttp() {
            return this.closed;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final long read(Buffer sink, long byteCount) throws IOException {
            IOException errorExceptionToDeliver;
            long readBytesDelivered;
            boolean tryAgain;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                sink = "byteCount < 0: " + (long)byteCount;
                throw new IllegalArgumentException(sink.toString());
            }
            do {
                block14: {
                    tryAgain = false;
                    readBytesDelivered = -1L;
                    errorExceptionToDeliver = null;
                    Http2Stream http2Stream = this.this$0;
                    Http2Stream http2Stream2 = this.this$0;
                    synchronized (http2Stream) {
                        http2Stream2.getReadTimeout$okhttp().enter();
                        try {
                            IOException iOException;
                            if (http2Stream2.getErrorCode$okhttp() != null && !this.finished && (iOException = http2Stream2.getErrorException$okhttp()) == null) {
                                ErrorCode errorCode = http2Stream2.getErrorCode$okhttp();
                                Intrinsics.checkNotNull((Object)((Object)errorCode));
                                iOException = errorExceptionToDeliver = (IOException)new StreamResetException(errorCode);
                            }
                            if (this.closed) {
                                throw new IOException("stream closed");
                            }
                            if (this.readBuffer.size() > 0L) {
                                readBytesDelivered = this.readBuffer.read((Buffer)sink, Math.min((long)byteCount, this.readBuffer.size()));
                                Http2Stream http2Stream3 = http2Stream2;
                                http2Stream3.setReadBytesTotal$okhttp(http2Stream3.getReadBytesTotal() + readBytesDelivered);
                                long unacknowledgedBytesRead = http2Stream2.getReadBytesTotal() - http2Stream2.getReadBytesAcknowledged();
                                if (errorExceptionToDeliver == null && unacknowledgedBytesRead >= (long)(http2Stream2.getConnection().getOkHttpSettings().getInitialWindowSize() / 2)) {
                                    http2Stream2.getConnection().writeWindowUpdateLater$okhttp(http2Stream2.getId(), unacknowledgedBytesRead);
                                    Http2Stream http2Stream4 = http2Stream2;
                                    http2Stream4.setReadBytesAcknowledged$okhttp(http2Stream4.getReadBytesTotal());
                                }
                                break block14;
                            }
                            if (!this.finished && errorExceptionToDeliver == null) {
                                http2Stream2.waitForIo$okhttp();
                                tryAgain = true;
                            }
                        }
                        finally {
                            http2Stream2.getReadTimeout$okhttp().exitAndThrowIfTimedOut();
                        }
                    }
                }
            } while (tryAgain);
            if (readBytesDelivered != -1L) {
                return readBytesDelivered;
            }
            if (errorExceptionToDeliver != null) {
                throw (Throwable)errorExceptionToDeliver;
            }
            return -1L;
        }

        /*
         * WARNING - void declaration
         */
        private final void updateConnectionFlowControl(long read) {
            void var1_1;
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                void var3_2;
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + var3_2));
            }
            this.this$0.getConnection().updateConnectionFlowControl$okhttp((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void receive$okhttp(BufferedSource source, long byteCount) throws IOException {
            void var2_3;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            long remainingByteCount = byteCount;
            while (remainingByteCount > 0L) {
                boolean flowControlError22;
                boolean finished;
                Http2Stream http2Stream = this.this$0;
                synchronized (http2Stream) {
                    finished = this.finished;
                    flowControlError22 = remainingByteCount + this.readBuffer.size() > this.maxByteCount;
                }
                if (flowControlError22) {
                    source.skip(remainingByteCount);
                    this.this$0.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (finished) {
                    source.skip(remainingByteCount);
                    return;
                }
                long read = source.read(this.receiveBuffer, remainingByteCount);
                if (read == -1L) {
                    throw new EOFException();
                }
                remainingByteCount -= read;
                Http2Stream http2Stream2 = this.this$0;
                Http2Stream flowControlError22 = this.this$0;
                synchronized (http2Stream2) {
                    if (this.closed) {
                        this.receiveBuffer.clear();
                    } else {
                        boolean wasEmpty = this.readBuffer.size() == 0L;
                        this.readBuffer.writeAll((Source)this.receiveBuffer);
                        if (wasEmpty) {
                            Http2Stream $this$notifyAll$iv = flowControlError22;
                            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                            ((Object)$this$notifyAll$iv).notifyAll();
                        }
                    }
                }
            }
            this.updateConnectionFlowControl((long)var2_3);
        }

        public final Timeout timeout() {
            return (Timeout)this.this$0.getReadTimeout$okhttp();
        }

        public final void close() throws IOException {
            long bytesDiscarded;
            Http2Stream http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream) {
                this.closed = true;
                bytesDiscarded = this.readBuffer.size();
                this.readBuffer.clear();
                Http2Stream $this$notifyAll$iv = http2Stream2;
                Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)http2Stream2).notifyAll();
            }
            if (bytesDiscarded > 0L) {
                this.updateConnectionFlowControl(bytesDiscarded);
            }
            this.this$0.cancelStreamIfNecessary$okhttp();
        }
    }

    public final class StreamTimeout
    extends AsyncTimeout {
        final /* synthetic */ Http2Stream this$0;

        /*
         * WARNING - void declaration
         */
        public StreamTimeout(Http2Stream this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        protected final void timedOut() {
            this.this$0.closeLater(ErrorCode.CANCEL);
            this.this$0.getConnection().sendDegradedPingLater$okhttp();
        }

        /*
         * WARNING - void declaration
         */
        protected final IOException newTimeoutException(IOException cause) {
            SocketTimeoutException socketTimeoutException;
            SocketTimeoutException $this$newTimeoutException_u24lambda_u240 = socketTimeoutException = new SocketTimeoutException("timeout");
            if (cause != null) {
                void var1_1;
                void var3_3;
                var3_3.initCause((Throwable)var1_1);
            }
            return socketTimeoutException;
        }

        public final void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }
    }
}

