/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u000eJ\u000f\u0010\u0017\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010(R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0018\u00101\u001a\u0004\u0018\u0001008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102"}, d2={"Lokhttp3/internal/http2/Http2ExchangeCodec;", "Lokhttp3/internal/http/ExchangeCodec;", "Lokhttp3/OkHttpClient;", "client", "Lokhttp3/internal/connection/RealConnection;", "connection", "Lokhttp3/internal/http/RealInterceptorChain;", "chain", "Lokhttp3/internal/http2/Http2Connection;", "http2Connection", "<init>", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/connection/RealConnection;Lokhttp3/internal/http/RealInterceptorChain;Lokhttp3/internal/http2/Http2Connection;)V", "", "cancel", "()V", "Lokhttp3/Request;", "request", "", "contentLength", "Lokio/Sink;", "createRequestBody", "(Lokhttp3/Request;J)Lokio/Sink;", "finishRequest", "flushRequest", "Lokhttp3/Response;", "response", "Lokio/Source;", "openResponseBodySource", "(Lokhttp3/Response;)Lokio/Source;", "", "expectContinue", "Lokhttp3/Response$Builder;", "readResponseHeaders", "(Z)Lokhttp3/Response$Builder;", "reportedContentLength", "(Lokhttp3/Response;)J", "writeRequestHeaders", "(Lokhttp3/Request;)V", "canceled", "Z", "Lokhttp3/internal/http/RealInterceptorChain;", "Lokhttp3/internal/connection/RealConnection;", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "Lokhttp3/internal/http2/Http2Connection;", "Lokhttp3/Protocol;", "protocol", "Lokhttp3/Protocol;", "Lokhttp3/internal/http2/Http2Stream;", "stream", "Lokhttp3/internal/http2/Http2Stream;", "Companion"})
public final class Http2ExchangeCodec
implements ExchangeCodec {
    public static final Companion Companion = new Companion(null);
    private final RealConnection connection;
    private final RealInterceptorChain chain;
    private final Http2Connection http2Connection;
    private volatile Http2Stream stream;
    private final Protocol protocol;
    private volatile boolean canceled;
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS;
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS;

    /*
     * WARNING - void declaration
     */
    public Http2ExchangeCodec(OkHttpClient client, RealConnection connection, RealInterceptorChain chain, Http2Connection http2Connection) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)http2Connection, (String)"http2Connection");
        this.connection = var2_2;
        this.chain = var3_3;
        this.http2Connection = http2Connection;
        this.protocol = var1_1.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }

    @Override
    public final Sink createRequestBody(Request request, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSink();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeRequestHeaders(Request request) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request.body() != null;
        List<Header> requestHeaders = okhttp3.internal.http2.Http2ExchangeCodec$Companion.http2HeadersList(request);
        this.stream = this.http2Connection.newStream((List<Header>)var1_1, (boolean)var2_2);
        if (this.canceled) {
            Http2Stream http2Stream = this.stream;
            Intrinsics.checkNotNull((Object)http2Stream);
            http2Stream.closeLater(ErrorCode.CANCEL);
            throw new IOException("Canceled");
        }
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.readTimeout().timeout((long)this.chain.getReadTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        Http2Stream http2Stream2 = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream2);
        http2Stream2.writeTimeout().timeout((long)this.chain.getWriteTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void flushRequest() {
        this.http2Connection.flush();
    }

    @Override
    public final void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.getSink().close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response.Builder readResponseHeaders(boolean expectContinue) {
        void var1_1;
        Http2Stream http2Stream = this.stream;
        if (http2Stream == null) {
            throw new IOException("stream wasn't created");
        }
        Object object = http2Stream;
        object = http2Stream.takeHeaders();
        Response.Builder responseBuilder = okhttp3.internal.http2.Http2ExchangeCodec$Companion.readHttp2HeadersList((Headers)object, this.protocol);
        if (var1_1 != false && responseBuilder.getCode$okhttp() == 100) {
            return null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long reportedContentLength(Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody(response)) {
            return 0L;
        }
        return Util.headersContentLength((Response)var1_1);
    }

    @Override
    public final Source openResponseBodySource(Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSource$okhttp();
    }

    @Override
    public final void cancel() {
        this.canceled = true;
        Http2Stream http2Stream = this.stream;
        if (http2Stream != null) {
            http2Stream.closeLater(ErrorCode.CANCEL);
            return;
        }
    }

    static {
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        stringArray[0] = "connection";
        stringArray2[1] = "host";
        stringArray2[2] = "keep-alive";
        stringArray2[3] = "proxy-connection";
        stringArray2[4] = "te";
        stringArray2[5] = "transfer-encoding";
        stringArray2[6] = "encoding";
        stringArray2[7] = "upgrade";
        stringArray2[8] = ":method";
        stringArray2[9] = ":path";
        stringArray2[10] = ":scheme";
        stringArray2[11] = ":authority";
        HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableListOf(stringArray2);
        String[] stringArray3 = new String[8];
        stringArray2 = stringArray3;
        stringArray3[0] = "connection";
        stringArray2[1] = "host";
        stringArray2[2] = "keep-alive";
        stringArray2[3] = "proxy-connection";
        stringArray2[4] = "te";
        stringArray2[5] = "transfer-encoding";
        stringArray2[6] = "encoding";
        stringArray2[7] = "upgrade";
        HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableListOf(stringArray2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013"}, d2={"Lokhttp3/internal/http2/Http2ExchangeCodec$Companion;", "", "<init>", "()V", "Lokhttp3/Request;", "request", "", "Lokhttp3/internal/http2/Header;", "http2HeadersList", "(Lokhttp3/Request;)Ljava/util/List;", "Lokhttp3/Headers;", "headerBlock", "Lokhttp3/Protocol;", "protocol", "Lokhttp3/Response$Builder;", "readHttp2HeadersList", "(Lokhttp3/Headers;Lokhttp3/Protocol;)Lokhttp3/Response$Builder;", "", "HTTP_2_SKIPPED_REQUEST_HEADERS", "Ljava/util/List;", "HTTP_2_SKIPPED_RESPONSE_HEADERS"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public static List<Header> http2HeadersList(Request request) {
            void var2_3;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Headers headers = request.headers();
            ArrayList<Header> result = new ArrayList<Header>(headers.size() + 4);
            result.add(new Header(Header.TARGET_METHOD, request.method()));
            result.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
            String host = request.header("Host");
            if (host != null) {
                void var3_4;
                result.add(new Header(Header.TARGET_AUTHORITY, (String)var3_4));
            }
            result.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                String name;
                String string = headers.name(i);
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
                if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name) && (!Intrinsics.areEqual((Object)name, (Object)"te") || !Intrinsics.areEqual((Object)headers.value(i), (Object)"trailers"))) continue;
                result.add(new Header(name, headers.value(i)));
            }
            return (List)var2_3;
        }

        /*
         * WARNING - void declaration
         */
        public static Response.Builder readHttp2HeadersList(Headers headerBlock, Protocol protocol) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)headerBlock, (String)"headerBlock");
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            StatusLine statusLine = null;
            Headers.Builder headersBuilder = new Headers.Builder();
            int n = headerBlock.size();
            for (int i = 0; i < n; ++i) {
                String name = headerBlock.name(i);
                String value = headerBlock.value(i);
                if (Intrinsics.areEqual((Object)name, (Object)":status")) {
                    statusLine = StatusLine.Companion.parse("HTTP/1.1 " + value);
                    continue;
                }
                if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
                headersBuilder.addLenient$okhttp(name, value);
            }
            if (statusLine == null) {
                throw new ProtocolException("Expected ':status' header not present");
            }
            return new Response.Builder().protocol((Protocol)var1_1).code(statusLine.code).message(var2_2.message).headers(var3_3.build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

