/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00a8\u00012\u00020\u0001:\b\u00a9\u0001\u00a8\u0001\u00aa\u0001\u00ab\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0011\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010#\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\"\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b#\u0010$J#\u0010#\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b#\u0010%J/\u0010-\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b+\u0010,J-\u00100\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010*\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b.\u0010/J%\u00103\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0000\u00a2\u0006\u0004\b1\u00102J\u001f\u00107\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u00104\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b5\u00106J\u0017\u0010:\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b8\u00109J\u0019\u0010<\u001a\u0004\u0018\u00010\u00162\u0006\u0010&\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b;\u0010\u0018J\u000f\u0010>\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b=\u0010\bJ\u0015\u0010@\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\t\u00a2\u0006\u0004\b@\u0010AJ\u0017\u0010E\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\bC\u0010DJ/\u0010I\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u001b2\b\u0010H\u001a\u0004\u0018\u00010G2\u0006\u0010)\u001a\u00020\u0019\u00a2\u0006\u0004\bI\u0010JJ-\u0010N\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u001b2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0000\u00a2\u0006\u0004\bL\u0010MJ%\u0010R\u001a\u00020\u00062\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020\u00142\u0006\u0010Q\u001a\u00020\u0014\u00a2\u0006\u0004\bR\u0010SJ\u001f\u0010U\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010?\u001a\u00020\tH\u0000\u00a2\u0006\u0004\bT\u00106J\u001f\u0010W\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u00104\u001a\u00020\tH\u0000\u00a2\u0006\u0004\bV\u00106J\u001f\u0010[\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00142\u0006\u0010X\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\bY\u0010ZR\u0016\u0010\\\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u001a\u0010^\u001a\u00020\u001b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b^\u0010_\u001a\u0004\b`\u0010aR\u001a\u0010c\u001a\u00020b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bc\u0010d\u001a\u0004\be\u0010fR\u001a\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00140g8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bh\u0010iR\u0016\u0010j\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bj\u0010]R\u0016\u0010k\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bk\u0010]R\u0016\u0010l\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bl\u0010]R\u0016\u0010m\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bm\u0010]R\u0016\u0010n\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bn\u0010]R\u0016\u0010o\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bo\u0010_R\"\u0010p\u001a\u00020\u00148\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bp\u0010q\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR\u001a\u0010w\u001a\u00020v8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bw\u0010x\u001a\u0004\by\u0010zR\u001c\u0010{\u001a\u00020\u00148\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b{\u0010q\u001a\u0004\b|\u0010sR\u0019\u0010~\u001a\u00020}8\u0006\u00a2\u0006\u000e\n\u0004\b~\u0010\u007f\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001R(\u0010\u0082\u0001\u001a\u00020}8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0005\b\u0082\u0001\u0010\u007f\u001a\u0006\b\u0083\u0001\u0010\u0081\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R\u0018\u0010\u0087\u0001\u001a\u00030\u0086\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0087\u0001\u0010\u0088\u0001R\u0018\u0010\u008a\u0001\u001a\u00030\u0089\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008a\u0001\u0010\u008b\u0001R!\u0010\u008d\u0001\u001a\u00020\u00192\u0007\u0010\u008c\u0001\u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u0007\n\u0005\b\u008d\u0001\u0010]R!\u0010\u008e\u0001\u001a\u00020\u00192\u0007\u0010\u008c\u0001\u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u0007\n\u0005\b\u008e\u0001\u0010]R\u0019\u0010\u0090\u0001\u001a\u00070\u008f\u0001R\u00020\u00008\u0006\u00a2\u0006\b\n\u0006\b\u0090\u0001\u0010\u0091\u0001R\u0018\u0010\u0092\u0001\u001a\u00030\u0089\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0092\u0001\u0010\u008b\u0001R\u0018\u0010\u0094\u0001\u001a\u00030\u0093\u00018\u0000X\u0080\u0004\u00a2\u0006\b\n\u0006\b\u0094\u0001\u0010\u0095\u0001R,\u0010\u0097\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u0096\u00018\u0000X\u0080\u0004\u00a2\u0006\u0010\n\u0006\b\u0097\u0001\u0010\u0098\u0001\u001a\u0006\b\u0099\u0001\u0010\u009a\u0001R\u0018\u0010\u009c\u0001\u001a\u00030\u009b\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u009c\u0001\u0010\u009d\u0001R)\u0010\u009e\u0001\u001a\u00020\u00192\u0007\u0010\u008c\u0001\u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u000f\n\u0005\b\u009e\u0001\u0010]\u001a\u0006\b\u009f\u0001\u0010\u00a0\u0001R!\u0010\u00a1\u0001\u001a\u00020\u00192\u0007\u0010\u008c\u0001\u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u0007\n\u0005\b\u00a1\u0001\u0010]R\u001d\u0010\u00a3\u0001\u001a\u00030\u00a2\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u00a3\u0001\u0010\u00a4\u0001\u001a\u0006\b\u00a5\u0001\u0010\u00a6\u0001R\u0018\u0010\u00a7\u0001\u001a\u00030\u0089\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u00a7\u0001\u0010\u008b\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "Lokhttp3/internal/http2/Http2Connection$Builder;", "builder", "<init>", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "", "close", "()V", "Lokhttp3/internal/http2/ErrorCode;", "connectionCode", "streamCode", "Ljava/io/IOException;", "cause", "close$okhttp", "(Lokhttp3/internal/http2/ErrorCode;Lokhttp3/internal/http2/ErrorCode;Ljava/io/IOException;)V", "e", "failConnection", "(Ljava/io/IOException;)V", "flush", "", "id", "Lokhttp3/internal/http2/Http2Stream;", "getStream", "(I)Lokhttp3/internal/http2/Http2Stream;", "", "nowNs", "", "isHealthy", "(J)Z", "associatedStreamId", "", "Lokhttp3/internal/http2/Header;", "requestHeaders", "out", "newStream", "(ILjava/util/List;Z)Lokhttp3/internal/http2/Http2Stream;", "(Ljava/util/List;Z)Lokhttp3/internal/http2/Http2Stream;", "streamId", "Lokio/BufferedSource;", "source", "byteCount", "inFinished", "pushDataLater$okhttp", "(ILokio/BufferedSource;IZ)V", "pushDataLater", "pushHeadersLater$okhttp", "(ILjava/util/List;Z)V", "pushHeadersLater", "pushRequestLater$okhttp", "(ILjava/util/List;)V", "pushRequestLater", "errorCode", "pushResetLater$okhttp", "(ILokhttp3/internal/http2/ErrorCode;)V", "pushResetLater", "pushedStream$okhttp", "(I)Z", "pushedStream", "removeStream$okhttp", "removeStream", "sendDegradedPingLater$okhttp", "sendDegradedPingLater", "statusCode", "shutdown", "(Lokhttp3/internal/http2/ErrorCode;)V", "read", "updateConnectionFlowControl$okhttp", "(J)V", "updateConnectionFlowControl", "outFinished", "Lokio/Buffer;", "buffer", "writeData", "(IZLokio/Buffer;J)V", "alternating", "writeHeaders$okhttp", "(IZLjava/util/List;)V", "writeHeaders", "reply", "payload1", "payload2", "writePing", "(ZII)V", "writeSynReset$okhttp", "writeSynReset", "writeSynResetLater$okhttp", "writeSynResetLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "(IJ)V", "writeWindowUpdateLater", "awaitPongsReceived", "J", "client", "Z", "getClient$okhttp", "()Z", "", "connectionName", "Ljava/lang/String;", "getConnectionName$okhttp", "()Ljava/lang/String;", "", "currentPushRequests", "Ljava/util/Set;", "degradedPingsSent", "degradedPongDeadlineNs", "degradedPongsReceived", "intervalPingsSent", "intervalPongsReceived", "isShutdown", "lastGoodStreamId", "I", "getLastGoodStreamId$okhttp", "()I", "setLastGoodStreamId$okhttp", "(I)V", "Lokhttp3/internal/http2/Http2Connection$Listener;", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "nextStreamId", "getNextStreamId$okhttp", "Lokhttp3/internal/http2/Settings;", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "(Lokhttp3/internal/http2/Settings;)V", "Lokhttp3/internal/http2/PushObserver;", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "Lokhttp3/internal/concurrent/TaskQueue;", "pushQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "<set-?>", "readBytesAcknowledged", "readBytesTotal", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "settingsListenerQueue", "Ljava/net/Socket;", "socket", "Ljava/net/Socket;", "", "streams", "Ljava/util/Map;", "getStreams$okhttp", "()Ljava/util/Map;", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "writeBytesMaximum", "getWriteBytesMaximum", "()J", "writeBytesTotal", "Lokhttp3/internal/http2/Http2Writer;", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "writerQueue", "Companion", "Builder", "Listener", "ReaderRunnable"})
@SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1006:1\n84#2,4:1007\n90#2,13:1014\n90#2,13:1027\n90#2,13:1069\n90#2,13:1082\n90#2,13:1095\n90#2,13:1108\n90#2,13:1121\n90#2,13:1134\n563#3:1011\n557#3:1013\n557#3:1040\n615#3,4:1041\n402#3,5:1045\n402#3,5:1053\n402#3,5:1059\n402#3,5:1064\n1#4:1012\n37#5,2:1050\n13309#6:1052\n13310#6:1058\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n*L\n152#1:1007,4\n340#1:1014,13\n361#1:1027,13\n506#1:1069,13\n554#1:1082,13\n893#1:1095,13\n911#1:1108,13\n938#1:1121,13\n952#1:1134,13\n183#1:1011\n319#1:1013\n402#1:1040\n446#1:1041,4\n448#1:1045,5\n461#1:1053,5\n467#1:1059,5\n472#1:1064,5\n455#1:1050,2\n460#1:1052\n460#1:1058\n*E\n"})
public final class Http2Connection
implements Closeable {
    public static final Companion Companion;
    private final boolean client;
    private final Listener listener;
    private final Map<Integer, Http2Stream> streams;
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    private final TaskRunner taskRunner;
    private final TaskQueue writerQueue;
    private final TaskQueue pushQueue;
    private final TaskQueue settingsListenerQueue;
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    private final Settings okHttpSettings;
    private Settings peerSettings;
    public long readBytesTotal;
    public long readBytesAcknowledged;
    public long writeBytesTotal;
    private long writeBytesMaximum;
    public final Socket socket;
    private final Http2Writer writer;
    public final ReaderRunnable readerRunnable;
    private final Set<Integer> currentPushRequests;
    private static final Settings DEFAULT_SETTINGS;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.client = ((Builder)builder).getClient$okhttp();
        this.listener = ((Builder)builder).getListener$okhttp();
        this.streams = new LinkedHashMap();
        Object object = builder;
        String string = ((Builder)object).connectionName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectionName");
            string = null;
        }
        this.connectionName = string;
        this.nextStreamId = ((Builder)builder).getClient$okhttp() ? 3 : 2;
        this.taskRunner = ((Builder)builder).getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = ((Builder)builder).getPushObserver$okhttp();
        object = new Settings();
        Settings settings = object;
        Http2Connection http2Connection = this;
        if (((Builder)builder).getClient$okhttp()) {
            settings.set(7, 0x1000000);
        }
        http2Connection.okHttpSettings = object;
        this.peerSettings = DEFAULT_SETTINGS;
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        object = builder;
        Socket socket = ((Builder)object).socket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        this.socket = socket;
        object = builder;
        BufferedSink bufferedSink = ((Builder)object).sink;
        if (bufferedSink == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sink");
            bufferedSink = null;
        }
        this.writer = new Http2Writer(bufferedSink, this.client);
        object = builder;
        BufferedSource bufferedSource = ((Builder)object).source;
        if (bufferedSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"source");
            bufferedSource = null;
        }
        this.readerRunnable = new ReaderRunnable(this, new Http2Reader(bufferedSource, this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (((Builder)builder).getPingIntervalMillis$okhttp() != 0) {
            void var2_3;
            void var1_1;
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(((Builder)builder).getPingIntervalMillis$okhttp());
            builder = this.writerQueue;
            String name$iv = this.connectionName + " ping";
            var1_1.schedule(new Task(name$iv, this, pingIntervalNanos){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ long $pingIntervalNanos$inlined;
                {
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$pingIntervalNanos$inlined = l;
                    super((String)var1_1, false, 2, null);
                }

                public final long runOnce() {
                    boolean bl;
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        boolean bl2;
                        if (Http2Connection.access$getIntervalPongsReceived$p(this.this$0) < Http2Connection.access$getIntervalPingsSent$p(this.this$0)) {
                            bl2 = true;
                        } else {
                            long l = Http2Connection.access$getIntervalPingsSent$p(this.this$0);
                            Http2Connection.access$setIntervalPingsSent$p(this.this$0, l + 1L);
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    boolean bl3 = bl;
                    if (bl3) {
                        Http2Connection.access$failConnection(this.this$0, null);
                        return -1L;
                    }
                    this.this$0.writePing(false, 1, 0);
                    return this.$pingIntervalNanos$inlined;
                }
            }, (long)var2_3);
        }
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    public final Listener getListener$okhttp() {
        return this.listener;
    }

    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLastGoodStreamId$okhttp(int n) {
        void var1_1;
        this.lastGoodStreamId = var1_1;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPeerSettings(Settings settings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.peerSettings = var1_1;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final Http2Writer getWriter() {
        return this.writer;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Http2Stream getStream(int id) {
        void var1_1;
        return this.streams.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Http2Stream removeStream$okhttp(int streamId) {
        void var1_2;
        void var2_3;
        Http2Stream stream = this.streams.remove(streamId);
        Http2Connection $this$notifyAll$iv = this;
        Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
        ((Object)var2_3).notifyAll();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void updateConnectionFlowControl$okhttp(long read) {
        void var1_1;
        this.readBytesTotal += var1_1;
        long readBytesToAcknowledge = this.readBytesTotal - this.readBytesAcknowledged;
        if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            void var3_2;
            this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
            this.readBytesAcknowledged += var3_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Stream newStream(List<Header> requestHeaders, boolean out) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        return this.newStream(0, (List<Header>)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final Http2Stream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        void var3_5;
        Http2Stream stream;
        boolean outFinished = !out;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            void var2_4;
            void var1_1;
            int streamId;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean flushHeaders;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, false, null);
                boolean bl = flushHeaders = !out || this.writeBytesTotal >= this.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
            }
            this.writer.headers((boolean)var1_1, streamId, (List<Header>)var2_4);
        }
        if (var3_5 != false) {
            this.writer.flush();
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeHeaders$okhttp(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(alternating, (String)"alternating");
        this.writer.headers((boolean)var2_2, (int)var1_1, (List<Header>)var3_3);
    }

    public final void writeData(int streamId, boolean outFinished, Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            int toWrite;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        Http2Connection $this$wait$iv = this;
                        Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                        ((Object)$this$wait$iv).wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                int $this$wait$iv = (int)Math.min(byteCount2, this.writeBytesMaximum - this.writeBytesTotal);
                toWrite = Math.min($this$wait$iv, this.writer.maxDataLength());
                this.writeBytesTotal += (long)toWrite;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] writeSynReset";
        taskQueue.schedule(new Task(name$iv, true, this, (int)var1_1, (ErrorCode)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super((String)var1_1, true);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                try {
                    this.this$0.writeSynReset$okhttp(this.$streamId$inlined, this.$errorCode$inlined);
                }
                catch (IOException e) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynReset$okhttp(int streamId, ErrorCode statusCode) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        this.writer.rstStream((int)var1_1, (ErrorCode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        void var2_2;
        void var1_1;
        void $this$iv;
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] windowUpdate";
        $this$iv.schedule(new Task(name$iv, true, this, (int)var1_1, (long)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ long $unacknowledgedBytesRead$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$unacknowledgedBytesRead$inlined = l;
                super((String)var1_1, true);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                try {
                    this.this$0.getWriter().windowUpdate(this.$streamId$inlined, this.$unacknowledgedBytesRead$inlined);
                }
                catch (IOException e) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            void var3_4;
            void var2_3;
            this.writer.ping(reply, (int)var2_3, (int)var3_4);
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.failConnection((IOException)var1_2);
            return;
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void shutdown(ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            void var1_1;
            void var3_5;
            Ref.IntRef lastGoodStreamId = new Ref.IntRef();
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId.element = this.lastGoodStreamId;
            }
            this.writer.goAway(var3_5.element, (ErrorCode)var1_1, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    @Override
    public final void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    public final void close$okhttp(ErrorCode connectionCode, ErrorCode streamCode, IOException cause) {
        Http2Connection http2Connection;
        Intrinsics.checkNotNullParameter((Object)((Object)connectionCode), (String)"connectionCode");
        Intrinsics.checkNotNullParameter((Object)((Object)streamCode), (String)"streamCode");
        Http2Connection $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        try {
            this.shutdown((ErrorCode)((Object)http2Connection));
        }
        catch (IOException iOException) {}
        Http2Stream[] streamsToClose = null;
        http2Connection = this;
        synchronized (http2Connection) {
            if (!this.streams.isEmpty()) {
                Http2Stream[] http2StreamArray = streamsToClose = this.streams.values();
                streamsToClose = streamsToClose.toArray(new Http2Stream[0]);
                this.streams.clear();
            }
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream http2Stream;
                Http2Stream stream = http2Stream = $this$forEach$iv[i];
                try {
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {}
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private final void failConnection(IOException e) {
        void var1_1;
        ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
        this.close$okhttp(errorCode, errorCode, (IOException)var1_1);
    }

    public static /* synthetic */ void start$default$48aa1d6a(Http2Connection http2Connection, boolean n, TaskRunner object, int n2) throws IOException {
        object = TaskRunner.INSTANCE;
        n = 1;
        Intrinsics.checkNotNullParameter((Object)object, (String)"taskRunner");
        if (n) {
            http2Connection.writer.connectionPreface();
            http2Connection.writer.settings(http2Connection.okHttpSettings);
            n = http2Connection.okHttpSettings.getInitialWindowSize();
            if (n != 65535) {
                http2Connection.writer.windowUpdate(0, n - 65535);
            }
        }
        TaskQueue taskQueue = ((TaskRunner)object).newQueue();
        object = http2Connection.connectionName;
        http2Connection = http2Connection.readerRunnable;
        taskQueue.schedule(new Task((String)object, true, (Function0<Unit>)http2Connection){
            final /* synthetic */ Function0<Unit> $block;
            {
                void var1_1;
                void var3_3;
                this.$block = var3_3;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean isHealthy(long nowNs) {
        void var1_1;
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || var1_1 < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - void declaration
     */
    public final void sendDegradedPingLater$okhttp() {
        void var2_4;
        Object object = this;
        synchronized (object) {
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        }
        object = this.writerQueue;
        String name$iv = this.connectionName + " ping";
        ((TaskQueue)object).schedule(new Task((String)var2_4, true, this){
            final /* synthetic */ Http2Connection this$0;
            {
                void var1_1;
                this.this$0 = http2Connection;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                this.this$0.writePing(false, 2, 0);
                return -1L;
            }
        }, 0L);
    }

    public static boolean pushedStream$okhttp(int streamId) {
        int n;
        return streamId != 0 && (n & 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushRequestLater$okhttp(int streamId, List<Header> requestHeaders) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Object object = this;
        synchronized (object) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        object = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onRequest";
        ((TaskQueue)object).schedule(new Task(name$iv, true, this, (int)var1_1, (List)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                Http2Connection.access$getPushObserver$p(this.this$0).onRequest$163bb723(this.$requestHeaders$inlined);
                try {
                    this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    }
                }
                catch (IOException iOException) {}
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushHeadersLater$okhttp(int streamId, List<Header> requestHeaders, boolean inFinished) {
        void var3_3;
        void var2_2;
        void var1_1;
        void $this$iv;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onHeaders";
        $this$iv.schedule(new Task(name$iv, true, this, (int)var1_1, (List)var2_2, (boolean)var3_3){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                this.$inFinished$inlined = bl;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                Http2Connection.access$getPushObserver$p(this.this$0).onHeaders$4ec42067(this.$requestHeaders$inlined);
                try {
                    this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    }
                }
                catch (IOException iOException) {}
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDataLater$okhttp(int streamId, BufferedSource source, int byteCount, boolean inFinished) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Buffer buffer = new Buffer();
        source.require((long)byteCount);
        source.read(buffer, (long)byteCount);
        source = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onData";
        var2_2.schedule(new Task(name$iv, true, this, (int)var1_1, buffer, (int)var3_3, inFinished){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ Buffer $buffer$inlined;
            final /* synthetic */ int $byteCount$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$buffer$inlined = buffer;
                this.$byteCount$inlined = n2;
                this.$inFinished$inlined = bl;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                try {
                    Http2Connection.access$getPushObserver$p(this.this$0).onData$749b27ff((BufferedSource)this.$buffer$inlined, this.$byteCount$inlined);
                    this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    }
                }
                catch (IOException iOException) {}
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onReset";
        taskQueue.schedule(new Task(name$iv, true, this, (int)var1_1, (ErrorCode)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                Http2Connection.access$getPushObserver$p(this.this$0).onReset$613c779f(this.$errorCode$inlined);
                Http2Connection http2Connection = this.this$0;
                synchronized (http2Connection) {
                    Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                }
                return -1L;
            }
        }, 0L);
    }

    public static final /* synthetic */ TaskQueue access$getSettingsListenerQueue$p(Http2Connection $this) {
        return $this.settingsListenerQueue;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$failConnection(Http2Connection $this, IOException e) {
        void var1_1;
        $this.failConnection((IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.intervalPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setDegradedPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.degradedPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setAwaitPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.awaitPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setWriteBytesMaximum$p(Http2Connection $this, long l) {
        void var1_1;
        $this.writeBytesMaximum = var1_1;
    }

    public static final /* synthetic */ long access$getIntervalPingsSent$p(Http2Connection $this) {
        return $this.intervalPingsSent;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection $this, long l) {
        void var1_1;
        $this.intervalPingsSent = var1_1;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection $this) {
        return $this.currentPushRequests;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection $this) {
        return $this.pushObserver;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Settings settings;
        Companion = new Companion(null);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u2435 = settings = new Settings();
        settings.set(7, 65535);
        var1_1.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    public static final class Builder {
        private boolean client;
        private final TaskRunner taskRunner;
        public Socket socket;
        public String connectionName;
        public BufferedSource source;
        public BufferedSink sink;
        private Listener listener;
        private PushObserver pushObserver;
        private int pingIntervalMillis;

        /*
         * WARNING - void declaration
         */
        public Builder(boolean client, TaskRunner taskRunner) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            this.client = true;
            this.taskRunner = var2_2;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        public final Listener getListener$okhttp() {
            return this.listener;
        }

        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public final Builder socket(Socket socket, String peerName, BufferedSource source, BufferedSink sink) throws IOException {
            void var3_3;
            void var2_2;
            Builder builder;
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Builder $this$socket_u24lambda_u240 = builder2 = this;
            String string = builder;
            builder = builder2;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            builder.socket = string;
            Builder builder3 = $this$socket_u24lambda_u240;
            string = builder3.client ? Util.okHttpName + ' ' + peerName : "MockWebServer " + (String)var2_2;
            builder = builder3;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            builder.connectionName = string;
            string = var3_3;
            builder = $this$socket_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            builder.source = string;
            string = sink;
            builder = $this$socket_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            builder.sink = string;
            return builder2;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder listener(Listener listener) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder builder2 = builder = this;
            builder.listener = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.pingIntervalMillis = var1_1;
            return builder;
        }

        public final Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "<init>", "()V", "Lokhttp3/internal/http2/Settings;", "DEFAULT_SETTINGS", "Lokhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lokhttp3/internal/http2/Settings;"})
    public static final class Companion {
        private Companion() {
        }

        public static Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH&\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "<init>", "()V", "Lokhttp3/internal/http2/Http2Connection;", "connection", "Lokhttp3/internal/http2/Settings;", "settings", "", "onSettings", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Settings;)V", "Lokhttp3/internal/http2/Http2Stream;", "stream", "onStream", "(Lokhttp3/internal/http2/Http2Stream;)V", "Companion"})
    public static abstract class Listener {
        public static final Companion Companion = new Companion(null);
        @JvmField
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            /*
             * WARNING - void declaration
             */
            public final void onStream(Http2Stream stream) throws IOException {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                var1_1.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        /*
         * WARNING - void declaration
         */
        public void onSettings(Http2Connection connection, Settings settings) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"settings");
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "<init>", "()V", "Lokhttp3/internal/http2/Http2Connection$Listener;", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,1006:1\n90#2,13:1007\n90#2,13:1020\n90#2,13:1035\n90#2,13:1049\n37#3,2:1033\n37#3,2:1062\n563#4:1048\n563#4:1064\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n*L\n687#1:1007,13\n715#1:1020,13\n758#1:1035,13\n806#1:1049,13\n753#1:1033,2\n824#1:1062,2\n797#1:1048\n841#1:1064\n*E\n"})
    public final class ReaderRunnable
    implements Function0<Unit>,
    Http2Reader.Handler {
        private final Http2Reader reader;
        final /* synthetic */ Http2Connection this$0;

        /*
         * WARNING - void declaration
         */
        public ReaderRunnable(Http2Connection this$0, Http2Reader reader) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.this$0 = var1_1;
            this.reader = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void data(boolean inFinished, int streamId, BufferedSource source, int length) throws IOException {
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (Http2Connection.pushedStream$okhttp(streamId)) {
                this.this$0.pushDataLater$okhttp(streamId, source, length, inFinished);
                return;
            }
            Http2Stream dataStream = this.this$0.getStream(streamId);
            if (dataStream == null) {
                void var2_2;
                this.this$0.writeSynResetLater$okhttp((int)var2_2, ErrorCode.PROTOCOL_ERROR);
                this.this$0.updateConnectionFlowControl$okhttp(length);
                source.skip((long)length);
                return;
            }
            dataStream.receiveData((BufferedSource)var3_3, length);
            if (var1_1 != false) {
                dataStream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void headers$64c3d190(boolean inFinished, int streamId, List<Header> headerBlock) {
            void var1_1;
            void var3_5;
            Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
            if (Http2Connection.pushedStream$okhttp(streamId)) {
                this.this$0.pushHeadersLater$okhttp(streamId, headerBlock, inFinished);
                return;
            }
            Http2Connection http2Connection = this.this$0;
            Http2Connection http2Connection2 = this.this$0;
            Http2Connection http2Connection3 = http2Connection;
            synchronized (http2Connection3) {
                Object stream = http2Connection2.getStream(streamId);
                if (stream == null) {
                    void var1_2;
                    void $this$iv;
                    void var2_4;
                    if (http2Connection2.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection2.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection2.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Object headers = Util.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection2, false, inFinished, (Headers)headers);
                    http2Connection2.setLastGoodStreamId$okhttp(streamId);
                    headers = streamId;
                    http2Connection2.getStreams$okhttp().put((Integer)headers, newStream);
                    stream = http2Connection2.taskRunner.newQueue();
                    String name$iv = http2Connection2.getConnectionName$okhttp() + '[' + (int)var2_4 + "] onStream";
                    $this$iv.schedule(new Task((String)var3_5, true, http2Connection2, (Http2Stream)var1_2){
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Http2Stream $newStream$inlined;
                        {
                            void var1_1;
                            this.this$0 = http2Connection;
                            this.$newStream$inlined = http2Stream;
                            super((String)var1_1, true);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final long runOnce() {
                            try {
                                this.this$0.getListener$okhttp().onStream(this.$newStream$inlined);
                            }
                            catch (IOException e) {
                                Platform.Companion.get();
                                Platform.log("Http2Connection.Listener failure for " + this.this$0.getConnectionName$okhttp(), 4, e);
                                try {
                                    void var1_1;
                                    this.$newStream$inlined.close(ErrorCode.PROTOCOL_ERROR, (IOException)var1_1);
                                }
                                catch (IOException iOException) {}
                            }
                            return -1L;
                        }
                    }, 0L);
                    return;
                }
            }
            ((Http2Stream)((Object)http2Connection)).receiveHeaders(Util.toHeaders((List<Header>)var3_5), (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void rstStream(int streamId, ErrorCode errorCode) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
            if (Http2Connection.pushedStream$okhttp(streamId)) {
                this.this$0.pushResetLater$okhttp(streamId, errorCode);
                return;
            }
            Http2Stream http2Stream = this.this$0.removeStream$okhttp((int)var1_1);
            if (http2Stream != null) {
                void var2_3;
                http2Stream.receiveRstStream((ErrorCode)var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void settings(boolean clearPrevious2, Settings settings) {
            void var2_3;
            void var3_4;
            void var1_2;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            TaskQueue clearPrevious2 = this.this$0.writerQueue;
            String name$iv = this.this$0.getConnectionName$okhttp() + " applyAndAckSettings";
            var1_2.schedule(new Task((String)var3_4, true, this, false, (Settings)var2_3){
                final /* synthetic */ ReaderRunnable this$0;
                final /* synthetic */ boolean $clearPrevious$inlined;
                final /* synthetic */ Settings $settings$inlined;
                {
                    void var1_1;
                    this.this$0 = readerRunnable;
                    this.$clearPrevious$inlined = bl;
                    this.$settings$inlined = settings;
                    super((String)var1_1, true);
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public final long runOnce() {
                    Http2Stream[] http2StreamArray;
                    Settings settings;
                    Object object = this.$settings$inlined;
                    boolean bl = this.$clearPrevious$inlined;
                    ReaderRunnable readerRunnable = this.this$0;
                    Intrinsics.checkNotNullParameter((Object)object, (String)"settings");
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    Http2Stream[] http2StreamArray2 = readerRunnable.this$0.getWriter();
                    Http2Connection http2Connection = readerRunnable.this$0;
                    Http2Writer http2Writer = http2StreamArray2;
                    // MONITORENTER : http2Writer
                    Object object2 = http2Connection;
                    // MONITORENTER : object2
                    Settings settings2 = http2Connection.getPeerSettings();
                    Ref.ObjectRef objectRef2 = objectRef;
                    if (bl) {
                        settings = object;
                    } else {
                        Settings settings3 = new Settings();
                        http2StreamArray2 = settings3;
                        Ref.ObjectRef objectRef3 = objectRef2;
                        http2StreamArray2.merge(settings2);
                        http2StreamArray2.merge((Settings)object);
                        objectRef2 = objectRef3;
                        settings = settings3;
                    }
                    objectRef2.element = settings;
                    long l = ((Settings)objectRef.element).getInitialWindowSize();
                    long l2 = l - (long)settings2.getInitialWindowSize();
                    if (l2 == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                        http2StreamArray = null;
                    } else {
                        Collection<Http2Stream> collection;
                        Collection<Http2Stream> collection2 = collection = http2Connection.getStreams$okhttp().values();
                        http2StreamArray = collection.toArray(new Http2Stream[0]);
                    }
                    Http2Stream[] http2StreamArray3 = http2StreamArray;
                    http2Connection.setPeerSettings((Settings)objectRef.element);
                    TaskQueue taskQueue = Http2Connection.access$getSettingsListenerQueue$p(http2Connection);
                    object = http2Connection.getConnectionName$okhttp() + " onSettings";
                    taskQueue.schedule(new Task((String)object, true, http2Connection, objectRef){
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Ref.ObjectRef $newPeerSettings$inlined;
                        {
                            void var1_1;
                            this.this$0 = http2Connection;
                            this.$newPeerSettings$inlined = objectRef;
                            super((String)var1_1, true);
                        }

                        public final long runOnce() {
                            this.this$0.getListener$okhttp().onSettings(this.this$0, (Settings)this.$newPeerSettings$inlined.element);
                            return -1L;
                        }
                    }, 0L);
                    // MONITOREXIT : object2
                    try {
                        http2Connection.getWriter().applyAndAckSettings((Settings)objectRef.element);
                    }
                    catch (IOException iOException) {
                        Http2Connection.access$failConnection(http2Connection, iOException);
                    }
                    // MONITOREXIT : http2Writer
                    if (http2StreamArray3 == null) return -1L;
                    http2StreamArray2 = http2StreamArray3;
                    int n = 0;
                    int n2 = http2StreamArray2.length;
                    while (n < n2) {
                        Http2Stream http2Stream = http2StreamArray2[n];
                        object2 = http2Stream;
                        // MONITORENTER : http2Stream
                        http2Stream.addBytesToWriteWindow(l2);
                        // MONITOREXIT : object2
                        ++n;
                    }
                    return -1L;
                }
            }, 0L);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void ping(boolean ack2, int payload1, int payload2) {
            void var3_7;
            void var2_4;
            void name$iv;
            void var1_3;
            if (ack2) {
                Http2Connection ack2 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (ack2) {
                    switch (payload1) {
                        case 1: {
                            long l = http2Connection.intervalPongsReceived;
                            Http2Connection.access$setIntervalPongsReceived$p(http2Connection, l + 1L);
                            Long.valueOf(l);
                            break;
                        }
                        case 2: {
                            long l = http2Connection.degradedPongsReceived;
                            Http2Connection.access$setDegradedPongsReceived$p(http2Connection, l + 1L);
                            Long.valueOf(l);
                            break;
                        }
                        case 3: {
                            void var2_5;
                            long l = http2Connection.awaitPongsReceived;
                            Http2Connection.access$setAwaitPongsReceived$p(http2Connection, l + 1L);
                            Http2Connection $this$notifyAll$iv = http2Connection;
                            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                            ((Object)var2_5).notifyAll();
                            break;
                        }
                    }
                    return;
                }
            }
            TaskQueue ack2 = this.this$0.writerQueue;
            String string = this.this$0.getConnectionName$okhttp() + " ping";
            Http2Connection http2Connection = this.this$0;
            var1_3.schedule(new Task((String)name$iv, true, http2Connection, (int)var2_4, (int)var3_7){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ int $payload1$inlined;
                final /* synthetic */ int $payload2$inlined;
                {
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$payload1$inlined = n;
                    this.$payload2$inlined = n2;
                    super((String)var1_1, true);
                }

                public final long runOnce() {
                    this.this$0.writePing(true, this.$payload1$inlined, this.$payload2$inlined);
                    return -1L;
                }
            }, 0L);
        }

        @Override
        public final void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            Http2Stream[] http2StreamArray;
            Http2Connection http2Connection;
            Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
            Intrinsics.checkNotNullParameter((Object)debugData, (String)"debugData");
            http2Connection.size();
            errorCode = this.this$0;
            http2Connection = this.this$0;
            Object object = errorCode;
            synchronized (object) {
                Collection<Http2Stream> collection = http2Connection.getStreams$okhttp().values();
                errorCode = collection;
                errorCode = collection;
                Http2Stream[] streamsCopy = collection.toArray(new Http2Stream[0]);
                http2Connection.isShutdown = true;
            }
            for (Http2Stream http2Stream : (Http2Stream[])http2StreamArray) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                this.this$0.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void windowUpdate(int streamId22, long windowSizeIncrement) {
            int streamId22;
            if (streamId22 == 0) {
                Http2Connection streamId22 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (streamId22) {
                    void var2_6;
                    Http2Connection http2Connection2 = http2Connection;
                    Http2Connection.access$setWriteBytesMaximum$p(http2Connection2, http2Connection2.getWriteBytesMaximum() + windowSizeIncrement);
                    Http2Connection $this$notifyAll$iv = http2Connection;
                    Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                    ((Object)var2_6).notifyAll();
                    return;
                }
            }
            Http2Stream stream = this.this$0.getStream(streamId22);
            if (stream != null) {
                Http2Stream http2Stream = stream;
                synchronized (http2Stream) {
                    void var2_5;
                    void var1_3;
                    var1_3.addBytesToWriteWindow((long)var2_5);
                    return;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void pushPromise$16014a7a(int promisedStreamId, List<Header> requestHeaders) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            this.this$0.pushRequestLater$okhttp((int)var1_1, (List<Header>)var2_2);
        }
    }
}

