/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import kotlin.ExceptionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    /*
     * WARNING - void declaration
     */
    public CallServerInterceptor(boolean forWebSocket) {
        void var1_1;
        this.forWebSocket = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Exchange exchange = realChain.getExchange$okhttp();
        Intrinsics.checkNotNull((Object)exchange);
        Exchange exchange2 = exchange;
        Request request = realChain.getRequest$okhttp();
        RequestBody requestBody = request.body();
        long sentRequestMillis = System.currentTimeMillis();
        boolean invokeStartEvent = true;
        Response.Builder responseBuilder22 = null;
        IOException sendRequestException = null;
        try {
            exchange2.writeRequestHeaders(request);
            if (HttpMethod.permitsRequestBody(request.method()) && requestBody != null) {
                if (StringsKt.equals((String)"100-continue", (String)request.header("Expect"), (boolean)true)) {
                    exchange2.flushRequest();
                    responseBuilder22 = exchange2.readResponseHeaders(true);
                    exchange2.responseHeadersStart();
                    invokeStartEvent = false;
                }
                if (responseBuilder22 == null) {
                    BufferedSink bufferedRequestBody;
                    if (requestBody.isDuplex()) {
                        exchange2.flushRequest();
                        bufferedRequestBody = Okio.buffer((Sink)exchange2.createRequestBody(request, true));
                        requestBody.writeTo(bufferedRequestBody);
                    } else {
                        bufferedRequestBody = Okio.buffer((Sink)exchange2.createRequestBody(request, false));
                        requestBody.writeTo(bufferedRequestBody);
                        bufferedRequestBody.close();
                    }
                } else {
                    exchange2.noRequestBody();
                    if (!exchange2.getConnection$okhttp().isMultiplexed$okhttp()) {
                        exchange2.noNewExchangesOnConnection();
                    }
                }
            } else {
                exchange2.noRequestBody();
            }
            if (requestBody == null || !requestBody.isDuplex()) {
                exchange2.finishRequest();
            }
        }
        catch (IOException iOException) {
            IOException e = iOException;
            if (iOException instanceof ConnectionShutdownException) {
                throw e;
            }
            if (!exchange2.getHasFailure$okhttp()) {
                throw e;
            }
            sendRequestException = e;
        }
        try {
            int code;
            if (responseBuilder22 == null) {
                Response.Builder builder = exchange2.readResponseHeaders(false);
                Intrinsics.checkNotNull((Object)builder);
                responseBuilder22 = builder;
                if (invokeStartEvent) {
                    exchange2.responseHeadersStart();
                    invokeStartEvent = false;
                }
            }
            Response response = responseBuilder22.request(request).handshake(exchange2.getConnection$okhttp().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
            int responseBuilder22 = code = response.code();
            boolean bl = code == 100 ? true : (102 <= responseBuilder22 ? responseBuilder22 < 200 : false);
            if (bl) {
                void var1_1;
                Response.Builder builder = exchange2.readResponseHeaders(false);
                Intrinsics.checkNotNull((Object)builder);
                Response.Builder responseBuilder22 = builder;
                if (invokeStartEvent) {
                    exchange2.responseHeadersStart();
                }
                response = responseBuilder22.request((Request)var1_1).handshake(exchange2.getConnection$okhttp().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
                code = response.code();
            }
            exchange2.responseHeadersEnd(response);
            Response response2 = response = this.forWebSocket && code == 101 ? response.newBuilder().body(Util.EMPTY_RESPONSE).build() : response.newBuilder().body(exchange2.openResponseBody(response)).build();
            if (StringsKt.equals((String)"close", (String)response.request().header("Connection"), (boolean)true) || StringsKt.equals((String)"close", (String)Response.header$default$b4243d8(response, "Connection", null, 2), (boolean)true)) {
                void var2_2;
                var2_2.noNewExchangesOnConnection();
            }
            if (code == 204 || code == 205) {
                ResponseBody responseBody = response.body();
                if ((responseBody != null ? responseBody.contentLength() : -1L) > 0L) {
                    void var3_4;
                    ResponseBody responseBody2 = response.body();
                    throw new ProtocolException("HTTP " + (int)var3_4 + " had non-zero Content-Length: " + (responseBody2 != null ? Long.valueOf(responseBody2.contentLength()) : null));
                }
            }
            return response;
        }
        catch (IOException e) {
            if (sendRequestException != null) {
                ExceptionsKt.addSuppressed((Throwable)sendRequestException, (Throwable)e);
                throw sendRequestException;
            }
            throw e;
        }
    }
}

