/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.ConnectionSpec;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.ConnectionSpecSelector;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2ExchangeCodec;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.http2.StreamResetException;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.OkHostnameVerifier;
import okhttp3.internal.ws.RealWebSocket;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u0084\u00012\u00020\u00012\u00020\u0002:\u0002\u0084\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJE\u0010\u0017\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u0019\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0011\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\"\u0010\u000bJ'\u0010*\u001a\u00020\u00112\u0006\u0010%\u001a\u00020$2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010&H\u0000\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010,\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0011\u00a2\u0006\u0004\b,\u0010-J\u001f\u00105\u001a\u0002022\u0006\u0010/\u001a\u00020.2\u0006\u00101\u001a\u000200H\u0000\u00a2\u0006\u0004\b3\u00104J\u0017\u0010;\u001a\u0002082\u0006\u00107\u001a\u000206H\u0000\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010=\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b<\u0010\u000bJ\u000f\u0010?\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b>\u0010\u000bJ\u001f\u0010D\u001a\u00020\t2\u0006\u0010A\u001a\u00020@2\u0006\u0010C\u001a\u00020BH\u0016\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010H\u001a\u00020\t2\u0006\u0010G\u001a\u00020FH\u0016\u00a2\u0006\u0004\bH\u0010IJ\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010JJ\u000f\u0010L\u001a\u00020KH\u0016\u00a2\u0006\u0004\bL\u0010MJ\u0017\u0010N\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bN\u0010OJ\u000f\u0010Q\u001a\u00020PH\u0016\u00a2\u0006\u0004\bQ\u0010RJ!\u0010X\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020S2\b\u0010U\u001a\u0004\u0018\u00010TH\u0000\u00a2\u0006\u0004\bV\u0010WR\u0016\u0010Y\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bY\u0010ZR#\u0010]\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020S0\\0[8\u0006\u00a2\u0006\f\n\u0004\b]\u0010^\u001a\u0004\b_\u0010`R\u0011\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010aR\u0018\u0010 \u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010bR\u0018\u0010c\u001a\u0004\u0018\u00010@8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bc\u0010dR\"\u0010f\u001a\u00020e8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bf\u0010g\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\u0014\u0010n\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR\u0016\u0010=\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010oR\"\u0010?\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010o\u001a\u0004\bp\u0010m\"\u0004\bq\u0010rR\u0018\u0010t\u001a\u0004\u0018\u00010s8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010uR\u0018\u0010v\u001a\u0004\u0018\u00010K8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bv\u0010wR\u0016\u0010x\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010ZR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010yR\u001c\u0010z\u001a\u00020\f8\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\bz\u0010Z\u001a\u0004\b{\u0010|R\u0018\u0010~\u001a\u0004\u0018\u00010}8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b~\u0010\u007fR\u0018\u0010L\u001a\u0004\u0018\u00010K8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010wR\u001c\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0080\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0081\u0001\u0010\u0082\u0001R\u0018\u0010\u0083\u0001\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0083\u0001\u0010Z"}, d2={"Lokhttp3/internal/connection/RealConnection;", "Lokhttp3/internal/http2/Http2Connection$Listener;", "Lokhttp3/Connection;", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionPool", "Lokhttp3/Route;", "route", "<init>", "(Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Route;)V", "", "cancel", "()V", "", "connectTimeout", "readTimeout", "writeTimeout", "pingIntervalMillis", "", "connectionRetryEnabled", "Lokhttp3/Call;", "call", "Lokhttp3/EventListener;", "eventListener", "connect", "(IIIIZLokhttp3/Call;Lokhttp3/EventListener;)V", "connectSocket", "(IILokhttp3/Call;Lokhttp3/EventListener;)V", "Lokhttp3/internal/connection/ConnectionSpecSelector;", "connectionSpecSelector", "connectTls", "(Lokhttp3/internal/connection/ConnectionSpecSelector;)V", "Lokhttp3/Handshake;", "handshake", "()Lokhttp3/Handshake;", "incrementSuccessCount$okhttp", "incrementSuccessCount", "Lokhttp3/Address;", "address", "", "routes", "isEligible$okhttp", "(Lokhttp3/Address;Ljava/util/List;)Z", "isEligible", "doExtensiveChecks", "isHealthy", "(Z)Z", "Lokhttp3/OkHttpClient;", "client", "Lokhttp3/internal/http/RealInterceptorChain;", "chain", "Lokhttp3/internal/http/ExchangeCodec;", "newCodec$okhttp", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/http/RealInterceptorChain;)Lokhttp3/internal/http/ExchangeCodec;", "newCodec", "Lokhttp3/internal/connection/Exchange;", "exchange", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "newWebSocketStreams$okhttp", "(Lokhttp3/internal/connection/Exchange;)Lokhttp3/internal/ws/RealWebSocket$Streams;", "newWebSocketStreams", "noCoalescedConnections$okhttp", "noCoalescedConnections", "noNewExchanges$okhttp", "noNewExchanges", "Lokhttp3/internal/http2/Http2Connection;", "connection", "Lokhttp3/internal/http2/Settings;", "settings", "onSettings", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Settings;)V", "Lokhttp3/internal/http2/Http2Stream;", "stream", "onStream", "(Lokhttp3/internal/http2/Http2Stream;)V", "()Lokhttp3/Route;", "Ljava/net/Socket;", "socket", "()Ljava/net/Socket;", "startHttp2", "(I)V", "", "toString", "()Ljava/lang/String;", "Lokhttp3/internal/connection/RealCall;", "Ljava/io/IOException;", "e", "trackFailure$okhttp", "(Lokhttp3/internal/connection/RealCall;Ljava/io/IOException;)V", "trackFailure", "allocationLimit", "I", "", "Ljava/lang/ref/Reference;", "calls", "Ljava/util/List;", "getCalls", "()Ljava/util/List;", "Lokhttp3/internal/connection/RealConnectionPool;", "Lokhttp3/Handshake;", "http2Connection", "Lokhttp3/internal/http2/Http2Connection;", "", "idleAtNs", "J", "getIdleAtNs$okhttp", "()J", "setIdleAtNs$okhttp", "(J)V", "isMultiplexed$okhttp", "()Z", "isMultiplexed", "Z", "getNoNewExchanges", "setNoNewExchanges", "(Z)V", "Lokhttp3/Protocol;", "protocol", "Lokhttp3/Protocol;", "rawSocket", "Ljava/net/Socket;", "refusedStreamCount", "Lokhttp3/Route;", "routeFailureCount", "getRouteFailureCount$okhttp", "()I", "Lokio/BufferedSink;", "sink", "Lokio/BufferedSink;", "Lokio/BufferedSource;", "source", "Lokio/BufferedSource;", "successCount", "Companion"})
@SourceDebugExtension(value={"SMAP\nRealConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealConnection.kt\nokhttp3/internal/connection/RealConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,765:1\n1#2:766\n608#3,4:767\n608#3,4:774\n615#3,4:778\n1747#4,3:771\n*S KotlinDebug\n*F\n+ 1 RealConnection.kt\nokhttp3/internal/connection/RealConnection\n*L\n529#1:767,4\n582#1:774,4\n648#1:778,4\n574#1:771,3\n*E\n"})
public final class RealConnection
extends Http2Connection.Listener
implements Connection {
    public static final Companion Companion = new Companion(null);
    public final RealConnectionPool connectionPool;
    private final Route route;
    private Socket rawSocket;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private Http2Connection http2Connection;
    private BufferedSource source;
    private BufferedSink sink;
    private boolean noNewExchanges;
    private boolean noCoalescedConnections;
    private int routeFailureCount;
    private int successCount;
    private int refusedStreamCount;
    private int allocationLimit;
    private final List<Reference<RealCall>> calls;
    private long idleAtNs;

    /*
     * WARNING - void declaration
     */
    public RealConnection(RealConnectionPool connectionPool, Route route) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.connectionPool = var1_1;
        this.route = var2_2;
        this.allocationLimit = 1;
        this.calls = new ArrayList();
        this.idleAtNs = Long.MAX_VALUE;
    }

    public final boolean getNoNewExchanges() {
        return this.noNewExchanges;
    }

    public final void setNoNewExchanges(boolean bl) {
        this.noNewExchanges = true;
    }

    public final int getRouteFailureCount$okhttp() {
        return this.routeFailureCount;
    }

    public final List<Reference<RealCall>> getCalls() {
        return this.calls;
    }

    public final long getIdleAtNs$okhttp() {
        return this.idleAtNs;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIdleAtNs$okhttp(long l) {
        void var1_1;
        this.idleAtNs = var1_1;
    }

    public final boolean isMultiplexed$okhttp() {
        return this.http2Connection != null;
    }

    public final synchronized void noNewExchanges$okhttp() {
        this.noNewExchanges = true;
    }

    public final synchronized void noCoalescedConnections$okhttp() {
        this.noCoalescedConnections = true;
    }

    public final synchronized void incrementSuccessCount$okhttp() {
        int n = this.successCount;
        this.successCount = n + 1;
    }

    public final void connect(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled, Call call, EventListener eventListener) {
        Object host;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        if (!(this.protocol == null)) {
            String string = "already connected";
            throw new IllegalStateException(string.toString());
        }
        RouteException routeException = null;
        List<ConnectionSpec> connectionSpecs = this.route.address().connectionSpecs();
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector(connectionSpecs);
        if (this.route.address().sslSocketFactory() == null) {
            if (!connectionSpecs.contains(ConnectionSpec.CLEARTEXT)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            }
            host = this.route.address().url().host();
            if (!Platform.Companion.get().isCleartextTrafficPermitted((String)host)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication to " + (String)host + " not permitted by network security policy"));
            }
        } else if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new RouteException(new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS"));
        }
        while (true) {
            try {
                int n;
                Object object;
                if (this.route.requiresTunnel()) {
                    EventListener eventListener2 = eventListener;
                    object = call;
                    int n2 = writeTimeout;
                    n = readTimeout;
                    int n3 = connectTimeout;
                    Object object2 = host = this;
                    Request request = new Request.Builder().url(((RealConnection)object2).route.address().url()).method("CONNECT", null).header("Host", Util.toHostHeader(((RealConnection)object2).route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "okhttp/4.12.0").build();
                    Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
                    Object object3 = ((RealConnection)object2).route.address().proxyAuthenticator().authenticate(((RealConnection)object2).route, response);
                    Request request2 = object3;
                    if (object3 == null) {
                        request2 = request;
                    }
                    object2 = request2;
                    HttpUrl httpUrl = request2.url();
                    for (int i = 0; i < 21; ++i) {
                        Object object4;
                        super.connectSocket(n3, n, (Call)object, eventListener2);
                        Object object5 = httpUrl;
                        object3 = object2;
                        int n4 = n2;
                        int n5 = n;
                        object2 = host;
                        object5 = "CONNECT " + Util.toHostHeader((HttpUrl)object5, true) + " HTTP/1.1";
                        block8: while (true) {
                            BufferedSink bufferedSink;
                            BufferedSource bufferedSource;
                            Intrinsics.checkNotNull((Object)((RealConnection)object2).source);
                            Intrinsics.checkNotNull((Object)((RealConnection)object2).sink);
                            Http1ExchangeCodec http1ExchangeCodec = new Http1ExchangeCodec(null, (RealConnection)object2, bufferedSource, bufferedSink);
                            bufferedSource.timeout().timeout((long)n5, TimeUnit.MILLISECONDS);
                            bufferedSink.timeout().timeout((long)n4, TimeUnit.MILLISECONDS);
                            http1ExchangeCodec.writeRequest(((Request)object3).headers(), (String)object5);
                            http1ExchangeCodec.finishRequest();
                            Response.Builder builder = http1ExchangeCodec.readResponseHeaders(false);
                            Intrinsics.checkNotNull((Object)builder);
                            Response response2 = builder.request((Request)object3).build();
                            http1ExchangeCodec.skipConnectBody(response2);
                            switch (response2.code()) {
                                case 200: {
                                    if (!bufferedSource.getBuffer().exhausted() || !bufferedSink.getBuffer().exhausted()) {
                                        throw new IOException("TLS tunnel buffered too many bytes!");
                                    }
                                    object4 = null;
                                    break block8;
                                }
                                case 407: {
                                    if (((RealConnection)object2).route.address().proxyAuthenticator().authenticate(((RealConnection)object2).route, response2) != null) continue block8;
                                    throw new IOException("Failed to authenticate with proxy");
                                    if (!StringsKt.equals((String)"close", (String)Response.header$default$b4243d8(response2, "Connection", null, 2), (boolean)true)) continue block8;
                                    object4 = object3;
                                    break block8;
                                }
                                default: {
                                    throw new IOException("Unexpected response code for CONNECT: " + response2.code());
                                }
                            }
                            break;
                        }
                        if (object4 == null) break;
                        object2 = object4;
                        Socket socket = ((RealConnection)host).rawSocket;
                        if (socket != null) {
                            Util.closeQuietly(socket);
                        }
                        ((RealConnection)host).rawSocket = null;
                        ((RealConnection)host).sink = null;
                        ((RealConnection)host).source = null;
                        EventListener.connectEnd$786dda5e((Call)object, ((RealConnection)host).route.socketAddress(), ((RealConnection)host).route.proxy());
                    }
                    if (this.rawSocket == null) {
                        break;
                    }
                } else {
                    this.connectSocket(connectTimeout, readTimeout, call, eventListener);
                }
                object = eventListener;
                Call call2 = call;
                n = pingIntervalMillis;
                ConnectionSpecSelector connectionSpecSelector2 = connectionSpecSelector;
                host = this;
                if (((RealConnection)host).route.address().sslSocketFactory() == null) {
                    if (((RealConnection)host).route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                        ((RealConnection)host).socket = ((RealConnection)host).rawSocket;
                        ((RealConnection)host).protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                        super.startHttp2(n);
                    } else {
                        ((RealConnection)host).socket = ((RealConnection)host).rawSocket;
                        ((RealConnection)host).protocol = Protocol.HTTP_1_1;
                    }
                } else {
                    EventListener.secureConnectStart(call2);
                    super.connectTls(connectionSpecSelector2);
                    Handshake cfr_ignored_0 = ((RealConnection)host).handshake;
                    EventListener.secureConnectEnd$30e623dc(call2);
                    if (((RealConnection)host).protocol == Protocol.HTTP_2) {
                        super.startHttp2(n);
                    }
                }
                EventListener.connectEnd$786dda5e(call, this.route.socketAddress(), this.route.proxy());
            }
            catch (IOException e) {
                Socket socket = this.socket;
                if (socket != null) {
                    Util.closeQuietly(socket);
                }
                Socket socket2 = this.rawSocket;
                if (socket2 != null) {
                    Util.closeQuietly(socket2);
                }
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                this.http2Connection = null;
                this.allocationLimit = 1;
                EventListener.connectFailed$2677936a(call, this.route.socketAddress(), this.route.proxy(), e);
                if (routeException == null) {
                    routeException = new RouteException(e);
                    continue;
                }
                routeException.addConnectException(e);
                if (connectionRetryEnabled && connectionSpecSelector.connectionFailed(e)) continue;
                throw routeException;
            }
            break;
        }
        if (this.route.requiresTunnel() && this.rawSocket == null) {
            throw new RouteException(new ProtocolException("Too many tunnel connections attempted: 21"));
        }
        this.idleAtNs = System.nanoTime();
    }

    /*
     * WARNING - void declaration
     */
    private final void connectSocket(int connectTimeout, int readTimeout, Call call, EventListener eventListener) throws IOException {
        void var2_4;
        ConnectException connectException;
        Socket rawSocket;
        Socket socket;
        Proxy proxy = this.route.proxy();
        Address address = this.route.address();
        Proxy.Type type = proxy.type();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                Socket socket2 = address.socketFactory().createSocket();
                socket = socket2;
                Intrinsics.checkNotNull((Object)socket2);
                break;
            }
            default: {
                socket = new Socket(proxy);
            }
        }
        this.rawSocket = rawSocket = socket;
        EventListener.connectStart((Call)((Object)connectException), this.route.socketAddress(), proxy);
        rawSocket.setSoTimeout((int)var2_4);
        try {
            Platform.Companion.get().connectSocket(rawSocket, this.route.socketAddress(), connectTimeout);
        }
        catch (ConnectException e) {
            ConnectException connectException2;
            connectException = connectException2 = new ConnectException("Failed to connect to " + this.route.socketAddress());
            connectException2.initCause(e);
            throw (Throwable)connectException2;
        }
        try {
            this.source = Okio.buffer((Source)Okio.source((Socket)rawSocket));
            this.sink = Okio.buffer((Sink)Okio.sink((Socket)rawSocket));
            return;
        }
        catch (NullPointerException nullPointerException) {
            NullPointerException npe = nullPointerException;
            if (Intrinsics.areEqual((Object)nullPointerException.getMessage(), (Object)"throw with null exception")) {
                void var1_3;
                throw new IOException((Throwable)var1_3);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startHttp2(int pingIntervalMillis) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        Http2Connection http2Connection;
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        Intrinsics.checkNotNull((Object)bufferedSource);
        BufferedSource source = bufferedSource;
        BufferedSink bufferedSink = this.sink;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink sink = bufferedSink;
        socket2.setSoTimeout(0);
        this.http2Connection = http2Connection = new Http2Connection.Builder(true, TaskRunner.INSTANCE).socket((Socket)var2_3, this.route.address().url().host(), (BufferedSource)var3_4, sink).listener(this).pingIntervalMillis(pingIntervalMillis).build();
        this.allocationLimit = Http2Connection.Companion.getDEFAULT_SETTINGS().getMaxConcurrentStreams();
        Http2Connection.start$default$48aa1d6a((Http2Connection)var1_2, false, null, 3);
    }

    /*
     * WARNING - void declaration
     */
    private final void connectTls(ConnectionSpecSelector connectionSpecSelector) throws IOException {
        Address address = this.route.address();
        SSLSocketFactory sslSocketFactory = address.sslSocketFactory();
        SSLSocket sslSocket = null;
        try {
            void var1_1;
            void var2_3;
            void var3_4;
            X509Certificate cert;
            SSLSocketFactory sSLSocketFactory = sslSocketFactory;
            Intrinsics.checkNotNull((Object)sSLSocketFactory);
            Socket socket = sSLSocketFactory.createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
            Intrinsics.checkNotNull((Object)socket, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
            sslSocket = (SSLSocket)socket;
            ConnectionSpec connectionSpec = connectionSpecSelector.configureSecureSocket(sslSocket);
            if (connectionSpec.supportsTlsExtensions()) {
                Platform.Companion.get().configureTlsExtensions(sslSocket, address.url().host(), address.protocols());
            }
            sslSocket.startHandshake();
            SSLSession sslSocketSession = sslSocket.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)sslSocketSession, (String)"sslSocketSession");
            Handshake unverifiedHandshake = Handshake.Companion.get(sslSocketSession);
            HostnameVerifier hostnameVerifier = address.hostnameVerifier();
            Intrinsics.checkNotNull((Object)hostnameVerifier);
            if (!hostnameVerifier.verify(address.url().host(), sslSocketSession)) {
                List<Certificate> peerCertificates2 = unverifiedHandshake.peerCertificates();
                if (!((Collection)peerCertificates2).isEmpty()) {
                    Certificate certificate = peerCertificates2.get(0);
                    Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                    cert = (X509Certificate)certificate;
                    throw new SSLPeerUnverifiedException(StringsKt.trimMargin$default((String)("\n              |Hostname " + address.url().host() + " not verified:\n              |    certificate: " + CertificatePinner.Companion.pin(cert) + "\n              |    DN: " + cert.getSubjectDN().getName() + "\n              |    subjectAltNames: " + OkHostnameVerifier.INSTANCE.allSubjectAltNames(cert) + "\n              "), null, (int)1, null));
                }
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified (no certificates)");
            }
            CertificatePinner certificatePinner = address.certificatePinner();
            Intrinsics.checkNotNull((Object)certificatePinner);
            CertificatePinner certificatePinner2 = certificatePinner;
            this.handshake = new Handshake(unverifiedHandshake.tlsVersion(), unverifiedHandshake.cipherSuite(), unverifiedHandshake.localCertificates(), (Function0<? extends List<? extends Certificate>>)((Function0)new Function0<List<? extends Certificate>>(certificatePinner2, unverifiedHandshake, address){
                final /* synthetic */ CertificatePinner $certificatePinner;
                final /* synthetic */ Handshake $unverifiedHandshake;
                final /* synthetic */ Address $address;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.$certificatePinner = var1_1;
                    this.$unverifiedHandshake = var2_2;
                    this.$address = var3_3;
                    super(0);
                }

                public final List<Certificate> invoke() {
                    CertificateChainCleaner certificateChainCleaner = this.$certificatePinner.getCertificateChainCleaner$okhttp();
                    Intrinsics.checkNotNull((Object)certificateChainCleaner);
                    return certificateChainCleaner.clean(this.$unverifiedHandshake.peerCertificates(), this.$address.url().host());
                }
            }));
            var3_4.check$okhttp(var2_3.url().host(), (Function0<? extends List<? extends X509Certificate>>)((Function0)new Function0<List<? extends X509Certificate>>(this){
                final /* synthetic */ RealConnection this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final List<X509Certificate> invoke() {
                    void var1_1;
                    Handshake handshake2 = RealConnection.access$getHandshake$p(this.this$0);
                    Intrinsics.checkNotNull((Object)handshake2);
                    Iterable $this$map$iv = handshake2.peerCertificates();
                    Object object = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    object = object.iterator();
                    while (object.hasNext()) {
                        void var3_3;
                        void it;
                        Object item$iv$iv = object.next();
                        item$iv$iv = (Certificate)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                        collection.add((X509Certificate)var3_3);
                    }
                    return (List)var1_1;
                }
            }));
            String maybeProtocol = ((ConnectionSpec)((Object)cert)).supportsTlsExtensions() ? Platform.Companion.get().getSelectedProtocol(sslSocket) : null;
            this.socket = sslSocket;
            this.source = Okio.buffer((Source)Okio.source((Socket)sslSocket));
            this.sink = Okio.buffer((Sink)Okio.sink((Socket)sslSocket));
            void v5 = var1_1;
            this.protocol = v5 != null ? Protocol.Companion.get((String)v5) : Protocol.HTTP_1_1;
        }
        catch (Throwable throwable) {
            block6: {
                if (sslSocket != null) {
                    Platform.Companion.get().afterHandshake(sslSocket);
                }
                SSLSocket sSLSocket = sslSocket;
                if (sSLSocket == null) break block6;
                Util.closeQuietly(sSLSocket);
            }
            throw throwable;
        }
        Platform.Companion.get().afterHandshake(sslSocket);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEligible$okhttp(Address address, List<Route> routes) {
        boolean bl;
        Object e;
        Route route;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        RealConnection $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + object2));
        }
        if (this.calls.size() >= this.allocationLimit) return false;
        if (this.noNewExchanges) {
            return false;
        }
        if (!this.route.address().equalsNonHost$okhttp(address)) {
            return false;
        }
        object2 = this;
        if (Intrinsics.areEqual((Object)address.url().host(), (Object)((RealConnection)object2).route.address().url().host())) {
            return true;
        }
        if (this.http2Connection == null) {
            return false;
        }
        if (routes == null) return false;
        object2 = object;
        object = this;
        Iterable iterable = (Iterable)object2;
        if (iterable instanceof Collection) {
            if (((Collection)iterable).isEmpty()) return false;
        }
        object2 = iterable.iterator();
        do {
            if (!object2.hasNext()) return false;
        } while (!((route = (Route)(e = object2.next())).proxy().type() == Proxy.Type.DIRECT && ((RealConnection)object).route.proxy().type() == Proxy.Type.DIRECT && Intrinsics.areEqual((Object)((RealConnection)object).route.socketAddress(), (Object)route.socketAddress())));
        boolean bl2 = true;
        if (!bl2) {
            return false;
        }
        if (address.hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
            return false;
        }
        object2 = address.url();
        object = this;
        RealConnection realConnection = object;
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        HttpUrl httpUrl = ((RealConnection)object).route.address().url();
        if (((HttpUrl)object2).port() != httpUrl.port()) return false;
        if (Intrinsics.areEqual((Object)((HttpUrl)object2).host(), (Object)httpUrl.host())) {
            bl = true;
        } else {
            if (((RealConnection)object).noCoalescedConnections) return false;
            if (((RealConnection)object).handshake == null) return false;
            Object object3 = object2;
            Handshake handshake2 = ((RealConnection)object).handshake;
            Intrinsics.checkNotNull((Object)handshake2);
            object2 = handshake2;
            object = object3;
            List<Certificate> list = ((Handshake)object2).peerCertificates();
            if (((Collection)list).isEmpty()) return false;
            boolean bl3 = true;
            if (!bl3) return false;
            String string = ((HttpUrl)object).host();
            Certificate certificate = list.get(0);
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            if (!OkHostnameVerifier.INSTANCE.verify(string, (X509Certificate)certificate)) return false;
            boolean bl4 = true;
            if (!bl4) return false;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            void var1_1;
            CertificatePinner certificatePinner = address.certificatePinner();
            Intrinsics.checkNotNull((Object)certificatePinner);
            String string = var1_1.url().host();
            object2 = this;
            Handshake handshake3 = ((RealConnection)object2).handshake;
            Intrinsics.checkNotNull((Object)handshake3);
            certificatePinner.check(string, handshake3.peerCertificates());
            return true;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ExchangeCodec newCodec$okhttp(OkHttpClient client, RealInterceptorChain chain) throws SocketException {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        Intrinsics.checkNotNull((Object)bufferedSource);
        BufferedSource source = bufferedSource;
        BufferedSink bufferedSink = this.sink;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink sink = bufferedSink;
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            return new Http2ExchangeCodec(client, this, chain, http2Connection);
        }
        var3_3.setSoTimeout(chain.readTimeoutMillis());
        source.timeout().timeout((long)chain.getReadTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        sink.timeout().timeout((long)var2_2.getWriteTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        return new Http1ExchangeCodec((OkHttpClient)var1_1, this, source, sink);
    }

    /*
     * WARNING - void declaration
     */
    public final RealWebSocket.Streams newWebSocketStreams$okhttp(Exchange exchange) throws SocketException {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        Intrinsics.checkNotNull((Object)bufferedSource);
        BufferedSource source = bufferedSource;
        BufferedSink bufferedSink = this.sink;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink sink = bufferedSink;
        var2_2.setSoTimeout(0);
        this.noNewExchanges$okhttp();
        return new RealWebSocket.Streams((BufferedSource)var3_3, sink, (Exchange)var1_1){
            final /* synthetic */ Exchange $exchange;
            {
                void var2_2;
                void var1_1;
                void var3_3;
                this.$exchange = var3_3;
                super(true, (BufferedSource)var1_1, (BufferedSink)var2_2);
            }

            public final void close() {
                this.$exchange.bodyComplete(-1L, true, true, null);
            }
        };
    }

    public final Route route() {
        return this.route;
    }

    public final void cancel() {
        Socket socket = this.rawSocket;
        if (socket != null) {
            Util.closeQuietly(socket);
            return;
        }
    }

    public final Socket socket() {
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isHealthy(boolean doExtensiveChecks) {
        void var1_1;
        void var11_7;
        RealConnection $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        long nowNs = System.nanoTime();
        Socket socket = this.rawSocket;
        Intrinsics.checkNotNull((Object)socket);
        Socket rawSocket = socket;
        Socket socket2 = this.socket;
        Intrinsics.checkNotNull((Object)socket2);
        Socket socket3 = socket2;
        BufferedSource bufferedSource = this.source;
        Intrinsics.checkNotNull((Object)bufferedSource);
        BufferedSource source = bufferedSource;
        if (rawSocket.isClosed() || socket3.isClosed() || socket3.isInputShutdown() || socket3.isOutputShutdown()) {
            return false;
        }
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            return http2Connection.isHealthy(nowNs);
        }
        RealConnection realConnection = this;
        synchronized (realConnection) {
            void var2_3;
            var11_7 = var2_3 - this.idleAtNs;
        }
        void var8_9 = var11_7;
        if (var8_9 >= 10000000000L && var1_1 != false) {
            return Util.isHealthy(socket3, source);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onStream(Http2Stream stream) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        var1_1.close(ErrorCode.REFUSED_STREAM, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void onSettings(Http2Connection connection, Settings settings) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.allocationLimit = var2_2.getMaxConcurrentStreams();
    }

    public final Handshake handshake() {
        return this.handshake;
    }

    public final synchronized void trackFailure$okhttp(RealCall call22, IOException e) {
        block7: {
            block8: {
                block5: {
                    RealCall call22;
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)call22, (String)"call");
                        if (!(e instanceof StreamResetException)) break block5;
                        if (((StreamResetException)e).errorCode != ErrorCode.REFUSED_STREAM) break block6;
                        int call22 = this.refusedStreamCount;
                        this.refusedStreamCount = call22 + 1;
                        if (this.refusedStreamCount <= 1) break block7;
                        this.noNewExchanges = true;
                        break block8;
                    }
                    if (((StreamResetException)e).errorCode == ErrorCode.CANCEL && call22.isCanceled()) break block7;
                    this.noNewExchanges = true;
                    break block8;
                }
                if (this.isMultiplexed$okhttp() && !(e instanceof ConnectionShutdownException)) break block7;
                this.noNewExchanges = true;
                if (this.successCount != 0) break block7;
                if (e != null) {
                    OkHttpClient okHttpClient;
                    Route route;
                    void var3_5 = route;
                    route = this.route;
                    okHttpClient = ((RealCall)((Object)okHttpClient)).getClient();
                    Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"client");
                    Intrinsics.checkNotNullParameter((Object)route, (String)"failedRoute");
                    Intrinsics.checkNotNullParameter((Object)var3_5, (String)"failure");
                    if (route.proxy().type() != Proxy.Type.DIRECT) {
                        Address address = route.address();
                        address.proxySelector().connectFailed(address.url().uri(), route.proxy().address(), (IOException)var3_5);
                    }
                    okHttpClient.getRouteDatabase().failed(route);
                }
            }
            int n = this.routeFailureCount;
            this.routeFailureCount = n + 1;
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("Connection{").append(this.route.address().url().host()).append(':').append(this.route.address().url().port()).append(", proxy=").append(this.route.proxy()).append(" hostAddress=").append(this.route.socketAddress()).append(" cipherSuite=");
        Object object = this.handshake;
        if (object == null || (object = ((Handshake)object).cipherSuite()) == null) {
            object = "none";
        }
        return stringBuilder.append(object).append(" protocol=").append((Object)this.protocol).append('}').toString();
    }

    public static final /* synthetic */ Handshake access$getHandshake$p(RealConnection $this) {
        return $this.handshake;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lokhttp3/internal/connection/RealConnection$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.DIRECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

