/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.EventListener;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealResponseBody;
import okhttp3.internal.ws.RealWebSocket;
import okio.Buffer;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Exchange {
    private final RealCall call;
    private final EventListener eventListener;
    private final ExchangeFinder finder;
    private final ExchangeCodec codec;
    private boolean isDuplex;
    private boolean hasFailure;
    private final RealConnection connection;

    /*
     * WARNING - void declaration
     */
    public Exchange(RealCall call, EventListener eventListener, ExchangeFinder finder, ExchangeCodec codec) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.call = var1_1;
        this.eventListener = var2_2;
        this.finder = var3_3;
        this.codec = codec;
        this.connection = this.codec.getConnection();
    }

    public final RealCall getCall$okhttp() {
        return this.call;
    }

    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    public final ExchangeFinder getFinder$okhttp() {
        return this.finder;
    }

    public final boolean isDuplex$okhttp() {
        return this.isDuplex;
    }

    public final boolean getHasFailure$okhttp() {
        return this.hasFailure;
    }

    public final RealConnection getConnection$okhttp() {
        return this.connection;
    }

    public final boolean isCoalescedConnection$okhttp() {
        return !Intrinsics.areEqual((Object)this.finder.getAddress$okhttp().url().host(), (Object)this.connection.route().address().url().host());
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRequestHeaders(Request request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            EventListener.requestHeadersStart(this.call);
            this.codec.writeRequestHeaders(request);
            EventListener.requestHeadersEnd(this.call, request);
            return;
        }
        catch (IOException e) {
            void var1_2;
            EventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Sink createRequestBody(Request request, boolean duplex) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.isDuplex = var2_2;
        RequestBody requestBody = request.body();
        Intrinsics.checkNotNull((Object)requestBody);
        long contentLength = requestBody.contentLength();
        EventListener.requestBodyStart(this.call);
        Sink rawRequestBody = this.codec.createRequestBody(request, contentLength);
        return (Sink)new RequestBodySink(this, (Sink)var1_1, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void flushRequest() throws IOException {
        try {
            this.codec.flushRequest();
            return;
        }
        catch (IOException e) {
            void var1_1;
            EventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void finishRequest() throws IOException {
        try {
            this.codec.finishRequest();
            return;
        }
        catch (IOException e) {
            void var1_1;
            EventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw var1_1;
        }
    }

    public final void responseHeadersStart() {
        EventListener.responseHeadersStart(this.call);
    }

    /*
     * WARNING - void declaration
     */
    public final Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        try {
            Response.Builder result = this.codec.readResponseHeaders(expectContinue);
            if (result != null) {
                result.initExchange$okhttp(this);
            }
            return result;
        }
        catch (IOException e) {
            void var1_3;
            EventListener.responseFailed(this.call, e);
            this.trackFailure(e);
            throw var1_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void responseHeadersEnd(Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        EventListener.responseHeadersEnd(this.call, (Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ResponseBody openResponseBody(Response response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            void var1_1;
            void var3_4;
            String contentType = Response.header$default$b4243d8(response, "Content-Type", null, 2);
            long contentLength = this.codec.reportedContentLength(response);
            Source rawSource = this.codec.openResponseBodySource(response);
            ResponseBodySource source = new ResponseBodySource(this, rawSource, contentLength);
            return new RealResponseBody(contentType, (long)var3_4, Okio.buffer((Source)((Source)var1_1)));
        }
        catch (IOException e) {
            void var2_3;
            EventListener.responseFailed(this.call, e);
            this.trackFailure(e);
            throw var2_3;
        }
    }

    public final RealWebSocket.Streams newWebSocketStreams() throws SocketException {
        this.call.timeoutEarlyExit();
        return this.codec.getConnection().newWebSocketStreams$okhttp(this);
    }

    public final void webSocketUpgradeFailed() {
        this.bodyComplete(-1L, true, true, null);
    }

    public final void noNewExchangesOnConnection() {
        this.codec.getConnection().noNewExchanges$okhttp();
    }

    public final void cancel() {
        this.codec.cancel();
    }

    public final void detachWithViolence() {
        this.codec.cancel();
        this.call.messageDone$okhttp(this, true, true, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void trackFailure(IOException e) {
        void var1_1;
        this.hasFailure = true;
        this.finder.trackFailure(e);
        this.codec.getConnection().trackFailure$okhttp(this.call, (IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <E extends IOException> E bodyComplete(long bytesRead, boolean responseDone, boolean requestDone, E e) {
        void var3_2;
        if (e != null) {
            this.trackFailure(e);
        }
        if (requestDone) {
            if (e != null) {
                EventListener.requestFailed(this.call, e);
            } else {
                EventListener.requestBodyEnd$58ea2f5e(this.call);
            }
        }
        if (responseDone) {
            if (e != null) {
                EventListener.responseFailed(this.call, e);
            } else {
                EventListener.responseBodyEnd$58ea2f5e(this.call);
            }
        }
        return this.call.messageDone$okhttp(this, requestDone, (boolean)var3_2, e);
    }

    public final void noRequestBody() {
        this.call.messageDone$okhttp(this, true, false, null);
    }

    @SourceDebugExtension(value={"SMAP\nExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchange.kt\nokhttp3/internal/connection/Exchange$RequestBodySink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    private final class RequestBodySink
    extends ForwardingSink {
        private final long contentLength;
        private boolean completed;
        private long bytesReceived;
        private boolean closed;
        final /* synthetic */ Exchange this$0;

        /*
         * WARNING - void declaration
         */
        public RequestBodySink(Exchange this$0, Sink delegate, long contentLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.this$0 = var1_1;
            super((Sink)var2_2);
            this.contentLength = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Buffer source, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!this.closed)) {
                source = "closed";
                throw new IllegalStateException(source.toString());
            }
            if (this.contentLength != -1L && this.bytesReceived + byteCount > this.contentLength) {
                throw new ProtocolException("expected " + this.contentLength + " bytes but received " + (this.bytesReceived + byteCount));
            }
            try {
                void var2_3;
                super.write((Buffer)source, byteCount);
                this.bytesReceived += var2_3;
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw this.complete(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void flush() throws IOException {
            try {
                super.flush();
                return;
            }
            catch (IOException e) {
                void var1_1;
                throw this.complete(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.contentLength != -1L && this.bytesReceived != this.contentLength) {
                throw new ProtocolException("unexpected end of stream");
            }
            try {
                super.close();
                this.complete(null);
                return;
            }
            catch (IOException e) {
                void var1_1;
                throw this.complete(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final <E extends IOException> E complete(E e) {
            void var1_1;
            if (this.completed) {
                return e;
            }
            this.completed = true;
            return this.this$0.bodyComplete(this.bytesReceived, false, true, var1_1);
        }
    }

    @SourceDebugExtension(value={"SMAP\nExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchange.kt\nokhttp3/internal/connection/Exchange$ResponseBodySource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    public final class ResponseBodySource
    extends ForwardingSource {
        private final long contentLength;
        private long bytesReceived;
        private boolean invokeStartEvent;
        private boolean completed;
        private boolean closed;
        final /* synthetic */ Exchange this$0;

        /*
         * WARNING - void declaration
         */
        public ResponseBodySource(Exchange this$0, Source delegate, long contentLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.this$0 = var1_1;
            super((Source)var2_2);
            this.contentLength = var3_3;
            this.invokeStartEvent = true;
            if (this.contentLength == 0L) {
                this.complete(null);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final long read(Buffer sink, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            try {
                void var2_2;
                void var1_1;
                long read = this.delegate().read((Buffer)var1_1, (long)var2_2);
                if (this.invokeStartEvent) {
                    this.invokeStartEvent = false;
                    this.this$0.getEventListener$okhttp();
                    EventListener.responseBodyStart(this.this$0.getCall$okhttp());
                }
                if (read == -1L) {
                    this.complete(null);
                    return -1L;
                }
                long newBytesReceived = this.bytesReceived + read;
                if (this.contentLength != -1L && newBytesReceived > this.contentLength) {
                    throw new ProtocolException("expected " + this.contentLength + " bytes but received " + newBytesReceived);
                }
                this.bytesReceived = newBytesReceived;
                if (newBytesReceived == this.contentLength) {
                    this.complete(null);
                }
                return read;
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
                this.complete(null);
                return;
            }
            catch (IOException e) {
                void var1_1;
                throw this.complete(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private <E extends IOException> E complete(E e) {
            void var1_1;
            if (this.completed) {
                return e;
            }
            this.completed = true;
            if (e == null && this.invokeStartEvent) {
                this.invokeStartEvent = false;
                this.this$0.getEventListener$okhttp();
                EventListener.responseBodyStart(this.this$0.getCall$okhttp());
            }
            return this.this$0.bodyComplete(this.bytesReceived, true, false, var1_1);
        }
    }
}

