/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionSpec;

public final class ConnectionSpecSelector {
    private final List<ConnectionSpec> connectionSpecs;
    private int nextModeIndex;
    private boolean isFallbackPossible;
    private boolean isFallback;

    /*
     * WARNING - void declaration
     */
    public ConnectionSpecSelector(List<ConnectionSpec> connectionSpecs) {
        void var1_1;
        Intrinsics.checkNotNullParameter(connectionSpecs, (String)"connectionSpecs");
        this.connectionSpecs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final ConnectionSpec configureSecureSocket(SSLSocket sslSocket) throws IOException {
        void var2_2;
        void var1_1;
        boolean bl;
        ConnectionSpec tlsConfiguration;
        block3: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            tlsConfiguration = null;
            int n = this.connectionSpecs.size();
            for (int i = this.nextModeIndex; i < n; ++i) {
                ConnectionSpec connectionSpec = this.connectionSpecs.get(i);
                if (!connectionSpec.isCompatible(sslSocket)) continue;
                tlsConfiguration = connectionSpec;
                this.nextModeIndex = i + 1;
                break;
            }
            if (tlsConfiguration == null) {
                StringBuilder stringBuilder = new StringBuilder("Unable to find acceptable protocols. isFallback=").append(this.isFallback).append(", modes=").append(this.connectionSpecs).append(", supported protocols=");
                Object[] objectArray = sslSocket.getEnabledProtocols();
                Intrinsics.checkNotNull((Object)objectArray);
                String string = Arrays.toString(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                throw new UnknownServiceException(stringBuilder.append(string).toString());
            }
            SSLSocket sSLSocket = sslSocket;
            ConnectionSpecSelector connectionSpecSelector = this;
            int n2 = connectionSpecSelector.connectionSpecs.size();
            for (int i = connectionSpecSelector.nextModeIndex; i < n2; ++i) {
                if (!connectionSpecSelector.connectionSpecs.get(i).isCompatible(sSLSocket)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        connectionSpecSelector.isFallbackPossible = bl;
        tlsConfiguration.apply$okhttp((SSLSocket)var1_1, this.isFallback);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean connectionFailed(IOException e) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.isFallback = true;
        return this.isFallbackPossible && !(e instanceof ProtocolException) && !(e instanceof InterruptedIOException) && (!(e instanceof SSLHandshakeException) || !(e.getCause() instanceof CertificateException)) && !(e instanceof SSLPeerUnverifiedException) && var1_1 instanceof SSLException;
    }
}

