/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.cache.FaultHidingSink;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.io.FileSystem;
import okhttp3.internal.platform.Platform;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010)\n\u0002\b\u0007*\u0001\u0014\u0018\u0000 [2\u00020\u00012\u00020\u0002:\u0004[\\]^B7\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0016J!\u0010;\u001a\u0002092\n\u0010<\u001a\u00060=R\u00020\u00002\u0006\u0010>\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b?J\u0006\u0010@\u001a\u000209J \u0010A\u001a\b\u0018\u00010=R\u00020\u00002\u0006\u0010B\u001a\u00020(2\b\b\u0002\u0010C\u001a\u00020\u000bH\u0007J\u0006\u0010D\u001a\u000209J\b\u0010E\u001a\u000209H\u0016J\u0017\u0010F\u001a\b\u0018\u00010GR\u00020\u00002\u0006\u0010B\u001a\u00020(H\u0086\u0002J\u0006\u0010H\u001a\u000209J\u0006\u0010I\u001a\u00020\u0010J\b\u0010J\u001a\u00020\u0010H\u0002J\b\u0010K\u001a\u00020%H\u0002J\b\u0010L\u001a\u000209H\u0002J\b\u0010M\u001a\u000209H\u0002J\u0010\u0010N\u001a\u0002092\u0006\u0010O\u001a\u00020(H\u0002J\r\u0010P\u001a\u000209H\u0000\u00a2\u0006\u0002\bQJ\u000e\u0010R\u001a\u00020\u00102\u0006\u0010B\u001a\u00020(J\u0019\u0010S\u001a\u00020\u00102\n\u0010T\u001a\u00060)R\u00020\u0000H\u0000\u00a2\u0006\u0002\bUJ\b\u0010V\u001a\u00020\u0010H\u0002J\u0006\u00105\u001a\u00020\u000bJ\u0010\u0010W\u001a\f\u0012\b\u0012\u00060GR\u00020\u00000XJ\u0006\u0010Y\u001a\u000209J\u0010\u0010Z\u001a\u0002092\u0006\u0010B\u001a\u00020(H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\b\u0012\u00060)R\u00020\u00000'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R&\u0010\n\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006_"}, d2={"Lokhttp3/internal/cache/DiskLruCache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "fileSystem", "Lokhttp3/internal/io/FileSystem;", "directory", "Ljava/io/File;", "appVersion", "", "valueCount", "maxSize", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(Lokhttp3/internal/io/FileSystem;Ljava/io/File;IIJLokhttp3/internal/concurrent/TaskRunner;)V", "civilizedFileSystem", "", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "okhttp3/internal/cache/DiskLruCache$cleanupTask$1", "Lokhttp3/internal/cache/DiskLruCache$cleanupTask$1;", "closed", "getClosed$okhttp", "()Z", "setClosed$okhttp", "(Z)V", "getDirectory", "()Ljava/io/File;", "getFileSystem$okhttp", "()Lokhttp3/internal/io/FileSystem;", "hasJournalErrors", "initialized", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lokhttp3/internal/cache/DiskLruCache$Entry;", "getLruEntries$okhttp", "()Ljava/util/LinkedHashMap;", "value", "getMaxSize", "()J", "setMaxSize", "(J)V", "mostRecentRebuildFailed", "mostRecentTrimFailed", "nextSequenceNumber", "redundantOpCount", "size", "getValueCount$okhttp", "()I", "checkNotClosed", "", "close", "completeEdit", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "success", "completeEdit$okhttp", "delete", "edit", "key", "expectedSequenceNumber", "evictAll", "flush", "get", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "initialize", "isClosed", "journalRebuildRequired", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "rebuildJournal", "rebuildJournal$okhttp", "remove", "removeEntry", "entry", "removeEntry$okhttp", "removeOldestEntry", "snapshots", "", "trimToSize", "validateKey", "Companion", "Editor", "Entry", "Snapshot", "okhttp"})
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1065:1\n1#2:1066\n608#3,4:1067\n37#4,2:1071\n37#4,2:1073\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache\n*L\n215#1:1067,4\n672#1:1071,2\n721#1:1073,2\n*E\n"})
public final class DiskLruCache
implements Closeable,
Flushable {
    public static final Companion Companion = new Companion(null);
    private final FileSystem fileSystem;
    private final File directory;
    private final int appVersion;
    private final int valueCount;
    public long maxSize;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private long size;
    private BufferedSink journalWriter;
    public final LinkedHashMap<String, Entry> lruEntries;
    private int redundantOpCount;
    private boolean hasJournalErrors;
    private boolean civilizedFileSystem;
    private boolean initialized;
    public boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    @JvmField
    public static final String JOURNAL_FILE = "journal";
    @JvmField
    public static final String JOURNAL_FILE_TEMP = "journal.tmp";
    @JvmField
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @JvmField
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @JvmField
    public static final String VERSION_1 = "1";
    @JvmField
    public static final long ANY_SEQUENCE_NUMBER = -1L;
    @JvmField
    public static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");
    @JvmField
    public static final String CLEAN = "CLEAN";
    @JvmField
    public static final String DIRTY = "DIRTY";
    @JvmField
    public static final String REMOVE = "REMOVE";
    @JvmField
    public static final String READ = "READ";

    public final FileSystem getFileSystem$okhttp() {
        return this.fileSystem;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final int getValueCount$okhttp() {
        return this.valueCount;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void initialize() throws IOException {
        block31: {
            DiskLruCache $this$assertThreadHoldsLock$iv = this;
            if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            if (this.initialized) {
                return;
            }
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.rename(this.journalFileBackup, this.journalFile);
                }
            }
            this.civilizedFileSystem = Util.isCivilized(this.fileSystem, this.journalFileBackup);
            if (!this.fileSystem.exists(this.journalFile)) break block31;
            try {
                int n;
                $this$assertThreadHoldsLock$iv = this;
                Object object = (Closeable)Okio.buffer((Source)$this$assertThreadHoldsLock$iv.fileSystem.source($this$assertThreadHoldsLock$iv.journalFile));
                Object object2 = null;
                try {
                    BufferedSource bufferedSource = (BufferedSource)object;
                    String string = bufferedSource.readUtf8LineStrict();
                    Object object3 = bufferedSource.readUtf8LineStrict();
                    String string2 = bufferedSource.readUtf8LineStrict();
                    String string3 = bufferedSource.readUtf8LineStrict();
                    String string4 = bufferedSource.readUtf8LineStrict();
                    if (!(Intrinsics.areEqual((Object)MAGIC, (Object)string) && Intrinsics.areEqual((Object)VERSION_1, (Object)object3) && Intrinsics.areEqual((Object)String.valueOf($this$assertThreadHoldsLock$iv.appVersion), (Object)string2) && Intrinsics.areEqual((Object)String.valueOf($this$assertThreadHoldsLock$iv.valueCount), (Object)string3) && !(((CharSequence)string4).length() > 0))) {
                        throw new IOException("unexpected journal header: [" + string + ", " + (String)object3 + ", " + string3 + ", " + string4 + ']');
                    }
                    n = 0;
                    try {
                        while (true) {
                            block34: {
                                Entry entry;
                                int n2;
                                int n3;
                                block33: {
                                    int n4;
                                    block32: {
                                        string2 = bufferedSource.readUtf8LineStrict();
                                        object3 = $this$assertThreadHoldsLock$iv;
                                        n3 = StringsKt.indexOf$default((CharSequence)string2, (char)' ', (int)0, (boolean)false, (int)6, null);
                                        if (n3 == -1) {
                                            throw new IOException("unexpected journal line: " + string2);
                                        }
                                        n4 = n3 + 1;
                                        n2 = StringsKt.indexOf$default((CharSequence)string2, (char)' ', (int)n4, (boolean)false, (int)4, null);
                                        if (n2 != -1) break block32;
                                        Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n4), (String)"this as java.lang.String).substring(startIndex)");
                                        if (n3 != REMOVE.length() || !StringsKt.startsWith$default((String)string2, (String)REMOVE, (boolean)false, (int)2, null)) break block33;
                                        ((DiskLruCache)object3).lruEntries.remove(string4);
                                        break block34;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n4, n2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                }
                                if ((entry = ((DiskLruCache)object3).lruEntries.get(string4)) == null) {
                                    entry = (DiskLruCache)object3.new Entry(string4);
                                    ((Map)((DiskLruCache)object3).lruEntries).put(string4, entry);
                                }
                                if (n2 != -1 && n3 == CLEAN.length() && StringsKt.startsWith$default((String)string2, (String)CLEAN, (boolean)false, (int)2, null)) {
                                    String string5 = string2.substring(n2 + 1);
                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                                    char[] cArray = new char[1];
                                    object3 = cArray;
                                    cArray[0] = 32;
                                    object3 = StringsKt.split$default((CharSequence)string5, (char[])object3, (boolean)false, (int)0, (int)6, null);
                                    entry.setReadable$okhttp(true);
                                    entry.setCurrentEditor$okhttp(null);
                                    entry.setLengths$okhttp((List<String>)object3);
                                } else if (n2 == -1 && n3 == DIRTY.length() && StringsKt.startsWith$default((String)string2, (String)DIRTY, (boolean)false, (int)2, null)) {
                                    entry.setCurrentEditor$okhttp(new Editor((DiskLruCache)object3, entry));
                                } else if (n2 != -1 || n3 != READ.length() || !StringsKt.startsWith$default((String)string2, (String)READ, (boolean)false, (int)2, null)) {
                                    throw new IOException("unexpected journal line: " + string2);
                                }
                            }
                            ++n;
                        }
                    }
                    catch (EOFException eOFException) {
                        $this$assertThreadHoldsLock$iv.redundantOpCount = n - $this$assertThreadHoldsLock$iv.lruEntries.size();
                        if (!bufferedSource.exhausted()) {
                            $this$assertThreadHoldsLock$iv.rebuildJournal$okhttp();
                        } else {
                            $this$assertThreadHoldsLock$iv.journalWriter = $this$assertThreadHoldsLock$iv.newJournalWriter();
                        }
                        CloseableKt.closeFinally((Closeable)object, null);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = throwable;
                        object2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                        throw throwable3;
                    }
                }
                $this$assertThreadHoldsLock$iv = this;
                $this$assertThreadHoldsLock$iv.fileSystem.delete($this$assertThreadHoldsLock$iv.journalFileTmp);
                object = $this$assertThreadHoldsLock$iv.lruEntries.values().iterator();
                while (object.hasNext()) {
                    int n5;
                    Object e = object.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"i.next()");
                    object2 = (Entry)e;
                    if (((Entry)object2).getCurrentEditor$okhttp() == null) {
                        n = $this$assertThreadHoldsLock$iv.valueCount;
                        for (n5 = 0; n5 < n; ++n5) {
                            $this$assertThreadHoldsLock$iv.size += ((Entry)object2).getLengths$okhttp()[n5];
                        }
                        continue;
                    }
                    ((Entry)object2).setCurrentEditor$okhttp(null);
                    n = $this$assertThreadHoldsLock$iv.valueCount;
                    for (n5 = 0; n5 < n; ++n5) {
                        $this$assertThreadHoldsLock$iv.fileSystem.delete(((Entry)object2).getCleanFiles$okhttp().get(n5));
                        $this$assertThreadHoldsLock$iv.fileSystem.delete(((Entry)object2).getDirtyFiles$okhttp().get(n5));
                    }
                    object.remove();
                }
                this.initialized = true;
                return;
            }
            catch (IOException journalIsCorrupt) {
                void var1_2;
                Platform.Companion.get();
                Platform.log("DiskLruCache " + this.directory + " is corrupt: " + journalIsCorrupt.getMessage() + ", removing", 5, (Throwable)var1_2);
                try {
                    DiskLruCache diskLruCache = this;
                    diskLruCache.close();
                    diskLruCache.fileSystem.deleteContents(diskLruCache.directory);
                }
                finally {
                    this.closed = false;
                }
            }
        }
        this.rebuildJournal$okhttp();
        this.initialized = true;
    }

    private final BufferedSink newJournalWriter() throws FileNotFoundException {
        FaultHidingSink faultHidingSink2;
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        faultHidingSink2 = new FaultHidingSink((Sink)faultHidingSink2, (Function1<? super IOException, Unit>)((Function1)new Function1<IOException, Unit>(this){
            final /* synthetic */ DiskLruCache this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(IOException it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DiskLruCache $this$assertThreadHoldsLock$iv = this.this$0;
                if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                    void var1_1;
                    throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var1_1));
                }
                DiskLruCache.access$setHasJournalErrors$p(this.this$0, true);
            }
        }));
        return Okio.buffer((Sink)((Sink)faultHidingSink2));
    }

    public final synchronized void rebuildJournal$okhttp() throws IOException {
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            bufferedSink.close();
        }
        Closeable closeable = (Closeable)Okio.buffer((Sink)this.fileSystem.sink(this.journalFileTmp));
        Throwable throwable = null;
        try {
            BufferedSink sink = (BufferedSink)closeable;
            sink.writeUtf8(MAGIC).writeByte(10);
            sink.writeUtf8(VERSION_1).writeByte(10);
            sink.writeDecimalLong((long)this.appVersion).writeByte(10);
            sink.writeDecimalLong((long)this.valueCount).writeByte(10);
            sink.writeByte(10);
            for (Entry entry : this.lruEntries.values()) {
                if (entry.getCurrentEditor$okhttp() != null) {
                    sink.writeUtf8(DIRTY).writeByte(32);
                    sink.writeUtf8(entry.getKey$okhttp());
                    sink.writeByte(10);
                    continue;
                }
                sink.writeUtf8(CLEAN).writeByte(32);
                sink.writeUtf8(entry.getKey$okhttp());
                entry.writeLengths$okhttp(sink);
                sink.writeByte(10);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.rename(this.journalFile, this.journalFileBackup);
        }
        this.fileSystem.rename(this.journalFileTmp, this.journalFile);
        this.fileSystem.delete(this.journalFileBackup);
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Snapshot get(String key) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        DiskLruCache.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry;
        Snapshot snapshot = entry.snapshot$okhttp();
        if (snapshot == null) {
            return null;
        }
        Snapshot snapshot2 = snapshot;
        int n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.writeUtf8(READ).writeByte(32).writeUtf8((String)var1_1).writeByte(10);
        if (this.journalRebuildRequired()) {
            TaskQueue.schedule$default$6ac1683b(this.cleanupQueue, this.cleanupTask, 0L, 2);
        }
        return entry2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final synchronized Editor edit(String key, long expectedSequenceNumber) throws IOException {
        void var1_1;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        DiskLruCache.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (expectedSequenceNumber != ANY_SEQUENCE_NUMBER && (entry == null || entry.getSequenceNumber$okhttp() != expectedSequenceNumber)) {
            return null;
        }
        Entry entry2 = entry;
        if ((entry2 != null ? entry2.getCurrentEditor$okhttp() : null) != null) {
            return null;
        }
        if (entry != null && entry.getLockingSourceCount$okhttp() != 0) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            TaskQueue.schedule$default$6ac1683b(this.cleanupQueue, this.cleanupTask, 0L, 2);
            return null;
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink journalWriter = bufferedSink;
        bufferedSink.writeUtf8(DIRTY).writeByte(32).writeUtf8(key).writeByte(10);
        var2_3.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        Editor editor = new Editor(this, entry);
        entry.setCurrentEditor$okhttp(editor);
        return var1_1;
    }

    public static /* synthetic */ Editor edit$default$4dbb4a5f(DiskLruCache diskLruCache, String string, long l, int n) throws IOException {
        l = ANY_SEQUENCE_NUMBER;
        return diskLruCache.edit(string, l);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void completeEdit$okhttp(Editor editor, boolean success) throws IOException {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Entry entry = editor.getEntry$okhttp();
        if (!Intrinsics.areEqual((Object)entry.getCurrentEditor$okhttp(), (Object)editor)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (success && !entry.getReadable$okhttp()) {
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                boolean[] blArray = editor.getWritten$okhttp();
                Intrinsics.checkNotNull((Object)blArray);
                if (!blArray[i]) {
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i);
                }
                if (this.fileSystem.exists(entry.getDirtyFiles$okhttp().get(i))) continue;
                editor.abort();
                return;
            }
        }
        n = this.valueCount;
        for (i = 0; i < n; ++i) {
            void var1_1;
            File dirty = entry.getDirtyFiles$okhttp().get(i);
            if (success && !entry.getZombie$okhttp()) {
                long newLength;
                if (!this.fileSystem.exists(dirty)) continue;
                File clean = entry.getCleanFiles$okhttp().get(i);
                this.fileSystem.rename(dirty, clean);
                long oldLength = entry.getLengths$okhttp()[i];
                entry.getLengths$okhttp()[i] = newLength = this.fileSystem.size(clean);
                this.size = this.size - oldLength + newLength;
                continue;
            }
            this.fileSystem.delete((File)var1_1);
        }
        entry.setCurrentEditor$okhttp(null);
        if (entry.getZombie$okhttp()) {
            this.removeEntry$okhttp(entry);
            return;
        }
        int n2 = this.redundantOpCount;
        this.redundantOpCount = n2 + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink bufferedSink2 = bufferedSink;
        BufferedSink $this$completeEdit_u24lambda_u244 = bufferedSink;
        if (entry.getReadable$okhttp() || success) {
            void var2_2;
            entry.setReadable$okhttp(true);
            $this$completeEdit_u24lambda_u244.writeUtf8(CLEAN).writeByte(32);
            $this$completeEdit_u24lambda_u244.writeUtf8(entry.getKey$okhttp());
            entry.writeLengths$okhttp($this$completeEdit_u24lambda_u244);
            $this$completeEdit_u24lambda_u244.writeByte(10);
            if (var2_2 != false) {
                long l = this.nextSequenceNumber;
                this.nextSequenceNumber = l + 1L;
                entry.setSequenceNumber$okhttp(l);
            }
        } else {
            void var3_3;
            this.lruEntries.remove(entry.getKey$okhttp());
            $this$completeEdit_u24lambda_u244.writeUtf8(REMOVE).writeByte(32);
            $this$completeEdit_u24lambda_u244.writeUtf8(var3_3.getKey$okhttp());
            $this$completeEdit_u24lambda_u244.writeByte(10);
        }
        $this$completeEdit_u24lambda_u244.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            TaskQueue.schedule$default$6ac1683b(this.cleanupQueue, this.cleanupTask, 0L, 2);
        }
    }

    private final boolean journalRebuildRequired() {
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean remove(String key) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        DiskLruCache.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        this.removeEntry$okhttp((Entry)var1_1);
        if (this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeEntry$okhttp(Entry entry) throws IOException {
        void var1_1;
        int i;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (!this.civilizedFileSystem) {
            if (entry.getLockingSourceCount$okhttp() > 0) {
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    BufferedSink it = bufferedSink;
                    bufferedSink.writeUtf8(DIRTY);
                    it.writeByte(32);
                    it.writeUtf8(entry.getKey$okhttp());
                    it.writeByte(10);
                    it.flush();
                }
            }
            if (entry.getLockingSourceCount$okhttp() > 0 || entry.getCurrentEditor$okhttp() != null) {
                entry.setZombie$okhttp(true);
                return true;
            }
        }
        Editor editor = entry.getCurrentEditor$okhttp();
        if (editor != null) {
            editor.detach$okhttp();
        }
        int n = this.valueCount;
        for (i = 0; i < n; ++i) {
            this.fileSystem.delete(entry.getCleanFiles$okhttp().get(i));
            this.size -= entry.getLengths$okhttp()[i];
            entry.getLengths$okhttp()[i] = 0L;
        }
        i = this.redundantOpCount;
        this.redundantOpCount = i + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            void var2_4;
            BufferedSink it = bufferedSink;
            bufferedSink.writeUtf8(REMOVE);
            it.writeByte(32);
            it.writeUtf8(entry.getKey$okhttp());
            var2_4.writeByte(10);
        }
        this.lruEntries.remove(var1_1.getKey$okhttp());
        if (this.journalRebuildRequired()) {
            TaskQueue.schedule$default$6ac1683b(this.cleanupQueue, this.cleanupTask, 0L, 2);
        }
        return true;
    }

    private final synchronized void checkNotClosed() {
        if (!(!this.closed)) {
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public final synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.flush();
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.initialized || this.closed) {
            this.closed = true;
            return;
        }
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"lruEntries.values");
        Collection<Entry> collection2 = collection;
        Collection<Entry> collection3 = collection;
        for (Entry entry : collection.toArray(new Entry[0])) {
            if (entry.getCurrentEditor$okhttp() == null) continue;
            Editor editor = entry.getCurrentEditor$okhttp();
            if (editor == null) continue;
            editor.detach$okhttp();
        }
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.close();
        this.journalWriter = null;
        this.closed = true;
    }

    public final void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            void var2_2;
            if (toEvict.getZombie$okhttp()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)toEvict, (String)"toEvict");
            this.removeEntry$okhttp((Entry)var2_2);
            return true;
        }
        return false;
    }

    private static void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            String string;
            string = "keys must match regex [a-z0-9_-]{1,120}: \"" + string + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ void access$setHasJournalErrors$p(DiskLruCache $this, boolean bl) {
        $this.hasJournalErrors = true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\r\u0010\tR\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\tR\u0014\u0010\u0013\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\tR\u0014\u0010\u0014\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\t"}, d2={"Lokhttp3/internal/cache/DiskLruCache$Companion;", "", "<init>", "()V", "", "ANY_SEQUENCE_NUMBER", "J", "", "CLEAN", "Ljava/lang/String;", "DIRTY", "JOURNAL_FILE", "JOURNAL_FILE_BACKUP", "JOURNAL_FILE_TEMP", "Lkotlin/text/Regex;", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "MAGIC", "READ", "REMOVE", "VERSION_1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean done;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Editor(DiskLruCache this$0, Entry entry) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.this$0 = var1_1;
            this.entry = var2_2;
            this.written = this.entry.getReadable$okhttp() ? null : new boolean[this.this$0.getValueCount$okhttp()];
        }

        public final Entry getEntry$okhttp() {
            return this.entry;
        }

        public final boolean[] getWritten$okhttp() {
            return this.written;
        }

        public final void detach$okhttp() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this)) {
                if (this.this$0.civilizedFileSystem) {
                    this.this$0.completeEdit$okhttp(this, false);
                    return;
                }
                this.entry.setZombie$okhttp(true);
            }
        }

        public final Sink newSink(int index22) {
            DiskLruCache diskLruCache = this.this$0;
            DiskLruCache diskLruCache2 = this.this$0;
            synchronized (diskLruCache) {
                Sink sink;
                Sink sink2;
                int index22;
                block9: {
                    if (!(!this.done)) {
                        String index22 = "Check failed.";
                        throw new IllegalStateException(index22.toString());
                    }
                    if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this)) break block9;
                    Sink index22 = Okio.blackhole();
                    return index22;
                }
                if (!this.entry.getReadable$okhttp()) {
                    Intrinsics.checkNotNull((Object)this.written);
                    this.written[index22] = true;
                }
                File dirtyFile = this.entry.getDirtyFiles$okhttp().get(index22);
                try {
                    sink2 = diskLruCache2.getFileSystem$okhttp().sink(dirtyFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    sink2 = Okio.blackhole();
                    return sink2;
                }
                sink = (Sink)new FaultHidingSink(sink, (Function1<? super IOException, Unit>)((Function1)new Function1<IOException, Unit>(diskLruCache2, this){
                    final /* synthetic */ DiskLruCache this$0;
                    final /* synthetic */ Editor this$1;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.this$1 = var2_2;
                        super(1);
                    }

                    public final void invoke(IOException it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DiskLruCache diskLruCache = this.this$0;
                        Editor editor = this.this$1;
                        synchronized (diskLruCache) {
                            editor.detach$okhttp();
                            return;
                        }
                    }
                }));
                return sink;
            }
        }

        public final void commit() throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            Object object = this.this$0;
            synchronized (diskLruCache) {
                if (!(!this.done)) {
                    object = "Check failed.";
                    throw new IllegalStateException(object.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this)) {
                    ((DiskLruCache)object).completeEdit$okhttp(this, true);
                }
                this.done = true;
                return;
            }
        }

        public final void abort() throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            Object object = this.this$0;
            synchronized (diskLruCache) {
                if (!(!this.done)) {
                    object = "Check failed.";
                    throw new IllegalStateException(object.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this)) {
                    ((DiskLruCache)object).completeEdit$okhttp(this, false);
                }
                this.done = true;
                return;
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache$Entry\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,1065:1\n608#2,4:1066\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache$Entry\n*L\n1001#1:1066,4\n*E\n"})
    public final class Entry {
        private final String key;
        private final long[] lengths;
        private final List<File> cleanFiles;
        private final List<File> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        private Editor currentEditor;
        private int lockingSourceCount;
        private long sequenceNumber;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.getValueCount$okhttp()];
            this.cleanFiles = new ArrayList();
            this.dirtyFiles = new ArrayList();
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.getValueCount$okhttp();
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                ((Collection)this.cleanFiles).add(new File(DiskLruCache.this.getDirectory(), fileBuilder.toString()));
                fileBuilder.append(".tmp");
                ((Collection)this.dirtyFiles).add(new File(DiskLruCache.this.getDirectory(), fileBuilder.toString()));
                fileBuilder.setLength(truncateTo);
            }
        }

        public final String getKey$okhttp() {
            return this.key;
        }

        public final long[] getLengths$okhttp() {
            return this.lengths;
        }

        public final List<File> getCleanFiles$okhttp() {
            return this.cleanFiles;
        }

        public final List<File> getDirtyFiles$okhttp() {
            return this.dirtyFiles;
        }

        public final boolean getReadable$okhttp() {
            return this.readable;
        }

        public final void setReadable$okhttp(boolean bl) {
            this.readable = true;
        }

        public final boolean getZombie$okhttp() {
            return this.zombie;
        }

        public final void setZombie$okhttp(boolean bl) {
            this.zombie = true;
        }

        public final Editor getCurrentEditor$okhttp() {
            return this.currentEditor;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCurrentEditor$okhttp(Editor editor) {
            void var1_1;
            this.currentEditor = var1_1;
        }

        public final int getLockingSourceCount$okhttp() {
            return this.lockingSourceCount;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLockingSourceCount$okhttp(int n) {
            void var1_1;
            this.lockingSourceCount = var1_1;
        }

        public final long getSequenceNumber$okhttp() {
            return this.sequenceNumber;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSequenceNumber$okhttp(long l) {
            void var1_1;
            this.sequenceNumber = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLengths$okhttp(List<String> strings) throws IOException {
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            if (strings.size() != DiskLruCache.this.getValueCount$okhttp()) {
                Entry.invalidLengths(strings);
                throw new KotlinNothingValueException();
            }
            try {
                int n = strings.size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                void var1_1;
                Entry.invalidLengths((List<String>)var1_1);
                throw new KotlinNothingValueException();
            }
        }

        public final void writeLengths$okhttp(BufferedSink writer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        private static Void invalidLengths(List<String> strings) throws IOException {
            List<String> list;
            throw new IOException("unexpected journal line: " + list);
        }

        /*
         * WARNING - void declaration
         */
        public final Snapshot snapshot$okhttp() {
            DiskLruCache $this$assertThreadHoldsLock$iv = DiskLruCache.this;
            if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            if (!this.readable) {
                return null;
            }
            if (!DiskLruCache.this.civilizedFileSystem && (this.currentEditor != null || this.zombie)) {
                return null;
            }
            List sources = new ArrayList();
            long[] lengths = (long[])this.lengths.clone();
            try {
                void var2_2;
                int n = DiskLruCache.this.getValueCount$okhttp();
                for (int i = 0; i < n; ++i) {
                    Source source;
                    Collection collection = sources;
                    int n2 = i;
                    Entry entry = this;
                    Source source2 = entry.DiskLruCache.this.getFileSystem$okhttp().source(entry.cleanFiles.get(n2));
                    if (entry.DiskLruCache.this.civilizedFileSystem) {
                        source = source2;
                    } else {
                        int n3 = entry.lockingSourceCount;
                        entry.lockingSourceCount = n3 + 1;
                        source = (Source)new ForwardingSource(source2, entry.DiskLruCache.this, entry){
                            private boolean closed;
                            final /* synthetic */ DiskLruCache this$0;
                            final /* synthetic */ Entry this$1;
                            {
                                void var1_1;
                                void var3_3;
                                void var2_2;
                                this.this$0 = var2_2;
                                this.this$1 = var3_3;
                                super((Source)var1_1);
                            }

                            public final void close() {
                                super.close();
                                if (!this.closed) {
                                    this.closed = true;
                                    DiskLruCache diskLruCache = this.this$0;
                                    Entry entry = this.this$1;
                                    DiskLruCache diskLruCache2 = this.this$0;
                                    synchronized (diskLruCache) {
                                        int n = entry.getLockingSourceCount$okhttp();
                                        entry.setLockingSourceCount$okhttp(n + -1);
                                        if (entry.getLockingSourceCount$okhttp() == 0 && entry.getZombie$okhttp()) {
                                            diskLruCache2.removeEntry$okhttp(entry);
                                        }
                                        return;
                                    }
                                }
                            }
                        };
                    }
                    collection.add(source);
                }
                return new Snapshot(DiskLruCache.this, this.key, this.sequenceNumber, sources, (long[])var2_2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                for (Source source : source) {
                    Util.closeQuietly((Closeable)source);
                }
                try {
                    DiskLruCache.this.removeEntry$okhttp(this);
                }
                catch (IOException iOException) {}
                return null;
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private final List<Source> sources;
        private final long[] lengths;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Snapshot(DiskLruCache this$0, String key, long sequenceNumber, List<? extends Source> sources, long[] lengths) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            this.this$0 = var1_1;
            this.key = var2_2;
            this.sequenceNumber = var3_3;
            this.sources = sources;
            this.lengths = lengths;
        }

        public final Editor edit() throws IOException {
            return this.this$0.edit(this.key, this.sequenceNumber);
        }

        /*
         * WARNING - void declaration
         */
        public final Source getSource(int index) {
            void var1_1;
            return this.sources.get((int)var1_1);
        }

        @Override
        public final void close() {
            for (Source source : this.sources) {
                Util.closeQuietly((Closeable)source);
            }
        }
    }
}

