/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.net.IDN;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.Buffer;

public final class HostnamesKt {
    /*
     * WARNING - void declaration
     */
    public static final String toCanonicalHost(String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter((Object)$this$toCanonicalHost, (String)"<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, (CharSequence)":", (boolean)false, (int)2, null)) {
            void var2_4;
            InetAddress inetAddress = StringsKt.startsWith$default((String)host, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)host, (String)"]", (boolean)false, (int)2, null) ? HostnamesKt.decodeIpv6(host, 1, host.length() - 1) : HostnamesKt.decodeIpv6(host, 0, host.length());
            if (inetAddress == null) {
                return null;
            }
            InetAddress inetAddress22 = inetAddress;
            byte[] address2 = inetAddress.getAddress();
            if (address2.length == 16) {
                int n;
                int inetAddress22;
                Intrinsics.checkNotNullExpressionValue((Object)address2, (String)"address");
                host = (String)address2;
                int address2 = -1;
                int n2 = 0;
                for (inetAddress22 = 0; inetAddress22 < ((Object)host).length; inetAddress22 += 2) {
                    n = inetAddress22;
                    while (inetAddress22 < 16 && host[inetAddress22] == false && host[inetAddress22 + 1] == false) {
                        inetAddress22 += 2;
                    }
                    int n3 = inetAddress22 - n;
                    if (n3 <= n2 || n3 < 4) continue;
                    address2 = n;
                    n2 = n3;
                }
                Buffer buffer = new Buffer();
                inetAddress22 = 0;
                while (inetAddress22 < ((Object)host).length) {
                    if (inetAddress22 == address2) {
                        buffer.writeByte(58);
                        if ((inetAddress22 += n2) != 16) continue;
                        buffer.writeByte(58);
                        continue;
                    }
                    if (inetAddress22 > 0) {
                        buffer.writeByte(58);
                    }
                    n = Util.and((byte)host[inetAddress22], 255) << 8 | Util.and((byte)host[inetAddress22 + 1], 255);
                    buffer.writeHexadecimalUnsignedLong((long)n);
                    inetAddress22 += 2;
                }
                return buffer.readUtf8();
            }
            if (((void)var2_4).length == 4) {
                return inetAddress22.getHostAddress();
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + (String)host + '\''));
        }
        try {
            void var1_3;
            boolean bl;
            block16: {
                String string;
                String string2 = IDN.toASCII(string);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toASCII(host)");
                String string3 = string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string4 = string3.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
                String result = string4;
                if (((CharSequence)string4).length() == 0) {
                    return null;
                }
                string = result;
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (Intrinsics.compare((int)c, (int)31) <= 0 || Intrinsics.compare((int)c, (int)127) >= 0) {
                        bl = true;
                    } else {
                        if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", (char)c, (int)0, (boolean)false, (int)6, null) == -1) continue;
                        bl = true;
                    }
                    break block16;
                }
                bl = false;
            }
            if (bl) {
                return null;
            }
            return var1_3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final InetAddress decodeIpv6(String input, int pos, int limit) {
        void var3_3;
        void i;
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        while (i < limit) {
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i + 2 <= limit && StringsKt.startsWith$default((String)input, (String)"::", (int)i, (boolean)false, (int)4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !StringsKt.startsWith$default((String)input, (String)":", (int)i, (boolean)false, (int)4, null)) {
                if (StringsKt.startsWith$default((String)input, (String)".", (int)i, (boolean)false, (int)4, null)) {
                    if (!HostnamesKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value = 0;
            groupOffset = ++i;
            while (i < limit && (hexDigit = Util.parseHexDigit(input.charAt((int)i))) != -1) {
                value = (value << 4) + hexDigit;
                ++i;
            }
            void groupLength = i - groupOffset;
            if (groupLength == false || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value >>> 8 & 0xFF);
            address[b++] = (byte)(value & 0xFF);
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            System.arraycopy(address, compress, address, address.length - (b - compress), b - compress);
            int n = compress;
            Arrays.fill(address, n, n + (address.length - b), (byte)0);
        }
        return InetAddress.getByAddress((byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
        void i;
        int b = addressOffset;
        while (i < limit) {
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input.charAt((int)i) != '.') {
                return false;
            }
            int value = 0;
            void groupOffset = ++i;
            while (i < limit && Intrinsics.compare((int)(c = input.charAt((int)i)), (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                if (value == 0 && groupOffset != i) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                ++i;
            }
            void var8_8 = i - groupOffset;
            if (var8_8 == false) {
                return false;
            }
            address[b++] = (byte)value;
        }
        return b == addressOffset + 4;
    }
}

