/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;

@SourceDebugExtension(value={"SMAP\nDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dispatcher.kt\nokhttp3/Dispatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1#2:242\n615#3,4:243\n1549#4:247\n1620#4,3:248\n1549#4:251\n1620#4,3:252\n*S KotlinDebug\n*F\n+ 1 Dispatcher.kt\nokhttp3/Dispatcher\n*L\n162#1:243,4\n222#1:247\n222#1:248,3\n227#1:251\n227#1:252,3\n*E\n"})
public final class Dispatcher {
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    private Runnable idleCallback;
    private ExecutorService executorServiceOrNull;
    private final ArrayDeque<RealCall.AsyncCall> readyAsyncCalls = new ArrayDeque();
    private final ArrayDeque<RealCall.AsyncCall> runningAsyncCalls = new ArrayDeque();
    private final ArrayDeque<RealCall> runningSyncCalls = new ArrayDeque();

    @JvmName(name="executorService")
    public final synchronized ExecutorService executorService() {
        if (this.executorServiceOrNull == null) {
            this.executorServiceOrNull = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), Util.threadFactory(Util.okHttpName + " Dispatcher", false));
        }
        ExecutorService executorService = this.executorServiceOrNull;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService;
    }

    /*
     * WARNING - void declaration
     */
    public final void enqueue$okhttp(RealCall.AsyncCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            this.readyAsyncCalls.add(call);
            if (!call.getCall().getForWebSocket()) {
                RealCall.AsyncCall asyncCall;
                Dispatcher dispatcher2;
                block7: {
                    RealCall.AsyncCall existingCall;
                    String string = call.getHost();
                    dispatcher2 = this;
                    for (RealCall.AsyncCall asyncCall2 : dispatcher2.runningAsyncCalls) {
                        if (!Intrinsics.areEqual((Object)asyncCall2.getHost(), (Object)string)) continue;
                        asyncCall = asyncCall2;
                        break block7;
                    }
                    for (RealCall.AsyncCall asyncCall2 : dispatcher2.readyAsyncCalls) {
                        if (!Intrinsics.areEqual((Object)asyncCall2.getHost(), (Object)string)) continue;
                        asyncCall = asyncCall2;
                        break block7;
                    }
                    asyncCall = existingCall = null;
                }
                if (asyncCall != null) {
                    void var1_1;
                    var1_1.reuseCallsPerHostFrom((RealCall.AsyncCall)((Object)dispatcher2));
                }
            }
        }
        this.promoteAndExecute();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean promoteAndExecute() {
        void var2_6;
        Dispatcher $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        List executableCalls = new ArrayList();
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Iterator<RealCall.AsyncCall> iterator = this.readyAsyncCalls.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"readyAsyncCalls.iterator()");
            Iterator<RealCall.AsyncCall> i = iterator;
            while (i.hasNext()) {
                RealCall.AsyncCall asyncCall = i.next();
                if (this.runningAsyncCalls.size() >= this.maxRequests) break;
                if (asyncCall.getCallsPerHost().get() >= this.maxRequestsPerHost) continue;
                i.remove();
                asyncCall.getCallsPerHost().incrementAndGet();
                Intrinsics.checkNotNullExpressionValue((Object)asyncCall, (String)"asyncCall");
                executableCalls.add(asyncCall);
                this.runningAsyncCalls.add(asyncCall);
            }
            boolean isRunning = this.runningCallsCount() > 0;
        }
        int n = executableCalls.size();
        for (int i = 0; i < n; ++i) {
            RealCall.AsyncCall asyncCall = (RealCall.AsyncCall)executableCalls.get(i);
            asyncCall.executeOn(this.executorService());
        }
        return (boolean)var2_6;
    }

    public final void finished$okhttp(RealCall.AsyncCall call) {
        Dispatcher dispatcher;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        call.getCallsPerHost().decrementAndGet();
        Dispatcher dispatcher2 = this;
        void var3_3 = dispatcher;
        Object object = dispatcher2.runningAsyncCalls;
        dispatcher = dispatcher2;
        Dispatcher dispatcher3 = dispatcher2;
        synchronized (dispatcher2) {
            if (!object.remove(var3_3)) {
                throw new AssertionError((Object)"Call wasn't in-flight!");
            }
            object = dispatcher.idleCallback;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            boolean bl = dispatcher.promoteAndExecute();
            if (!bl && object != null) {
                object.run();
            }
            return;
        }
    }

    private synchronized int runningCallsCount() {
        return this.runningAsyncCalls.size() + this.runningSyncCalls.size();
    }
}

