/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;

public final class Challenge {
    private final String scheme;
    private final Map<String, String> authParams;

    /*
     * WARNING - void declaration
     */
    public Challenge(String scheme, Map<String, String> authParams) {
        void var1_1;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter(authParams, (String)"authParams");
        this.scheme = scheme;
        Map newAuthParams = new LinkedHashMap();
        for (Map.Entry entry : iterator.entrySet()) {
            String string;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String string2 = key;
            if (string2 != null) {
                key = string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = key.toLowerCase(locale);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            } else {
                string = null;
            }
            String newKey = string;
            newAuthParams.put(newKey, entry);
        }
        Map map = Collections.unmodifiableMap(var1_1);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap<String?, String>(newAuthParams)");
        this.authParams = map;
    }

    @JvmName(name="scheme")
    public final String scheme() {
        return this.scheme;
    }

    @JvmName(name="realm")
    public final String realm() {
        return this.authParams.get("realm");
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="charset")
    public final Charset charset() {
        String charset = this.authParams.get("charset");
        if (charset != null) {
            try {
                void var1_1;
                Charset charset2 = Charset.forName((String)var1_1);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charset)");
                return charset2;
            }
            catch (Exception exception) {}
        }
        Charset charset3 = StandardCharsets.ISO_8859_1;
        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"ISO_8859_1");
        return charset3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof Challenge && Intrinsics.areEqual((Object)((Challenge)other).scheme, (Object)this.scheme) && Intrinsics.areEqual(((Challenge)var1_1).authParams, this.authParams);
    }

    public final int hashCode() {
        int n;
        int result = 899 + this.scheme.hashCode();
        n = 31 * n + ((Object)this.authParams).hashCode();
        return n;
    }

    public final String toString() {
        return this.scheme + " authParams=" + this.authParams;
    }
}

