/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import java.util.Objects;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Authenticator;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.internal.Util;

public final class Address {
    private final Dns dns;
    private final SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final CertificatePinner certificatePinner;
    private final Authenticator proxyAuthenticator;
    private final Proxy proxy;
    private final ProxySelector proxySelector;
    private final HttpUrl url;
    private final List<Protocol> protocols;
    private final List<ConnectionSpec> connectionSpecs;

    /*
     * WARNING - void declaration
     */
    public Address(String uriHost, int uriPort, Dns dns, SocketFactory socketFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, CertificatePinner certificatePinner, Authenticator proxyAuthenticator, Proxy proxy, List<? extends Protocol> protocols, List<ConnectionSpec> connectionSpecs, ProxySelector proxySelector) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)uriHost, (String)"uriHost");
        Intrinsics.checkNotNullParameter((Object)dns, (String)"dns");
        Intrinsics.checkNotNullParameter((Object)socketFactory, (String)"socketFactory");
        Intrinsics.checkNotNullParameter((Object)proxyAuthenticator, (String)"proxyAuthenticator");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        Intrinsics.checkNotNullParameter(connectionSpecs, (String)"connectionSpecs");
        Intrinsics.checkNotNullParameter((Object)proxySelector, (String)"proxySelector");
        this.dns = var3_3;
        this.socketFactory = socketFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.certificatePinner = certificatePinner;
        this.proxyAuthenticator = proxyAuthenticator;
        this.proxy = proxy;
        this.proxySelector = proxySelector;
        this.url = new HttpUrl.Builder().scheme(this.sslSocketFactory != null ? "https" : "http").host((String)var1_1).port((int)var2_2).build();
        this.protocols = Util.toImmutableList(protocols);
        this.connectionSpecs = Util.toImmutableList(connectionSpecs);
    }

    @JvmName(name="dns")
    public final Dns dns() {
        return this.dns;
    }

    @JvmName(name="socketFactory")
    public final SocketFactory socketFactory() {
        return this.socketFactory;
    }

    @JvmName(name="sslSocketFactory")
    public final SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    @JvmName(name="hostnameVerifier")
    public final HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    @JvmName(name="certificatePinner")
    public final CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    @JvmName(name="proxyAuthenticator")
    public final Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    @JvmName(name="proxy")
    public final Proxy proxy() {
        return this.proxy;
    }

    @JvmName(name="proxySelector")
    public final ProxySelector proxySelector() {
        return this.proxySelector;
    }

    @JvmName(name="url")
    public final HttpUrl url() {
        return this.url;
    }

    @JvmName(name="protocols")
    public final List<Protocol> protocols() {
        return this.protocols;
    }

    @JvmName(name="connectionSpecs")
    public final List<ConnectionSpec> connectionSpecs() {
        return this.connectionSpecs;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof Address && Intrinsics.areEqual((Object)this.url, (Object)((Address)other).url) && this.equalsNonHost$okhttp((Address)var1_1);
    }

    public final int hashCode() {
        int n;
        int result = 527 + this.url.hashCode();
        result = 31 * result + this.dns.hashCode();
        result = 31 * result + this.proxyAuthenticator.hashCode();
        result = 31 * result + ((Object)this.protocols).hashCode();
        result = 31 * result + ((Object)this.connectionSpecs).hashCode();
        result = 31 * result + this.proxySelector.hashCode();
        result = 31 * result + Objects.hashCode(this.proxy);
        result = 31 * result + Objects.hashCode(this.sslSocketFactory);
        result = 31 * result + Objects.hashCode(this.hostnameVerifier);
        n = 31 * n + Objects.hashCode(this.certificatePinner);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equalsNonHost$okhttp(Address that) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return Intrinsics.areEqual((Object)this.dns, (Object)that.dns) && Intrinsics.areEqual((Object)this.proxyAuthenticator, (Object)that.proxyAuthenticator) && Intrinsics.areEqual(this.protocols, that.protocols) && Intrinsics.areEqual(this.connectionSpecs, that.connectionSpecs) && Intrinsics.areEqual((Object)this.proxySelector, (Object)that.proxySelector) && Intrinsics.areEqual((Object)this.proxy, (Object)that.proxy) && Intrinsics.areEqual((Object)this.sslSocketFactory, (Object)that.sslSocketFactory) && Intrinsics.areEqual((Object)this.hostnameVerifier, (Object)that.hostnameVerifier) && Intrinsics.areEqual((Object)this.certificatePinner, (Object)that.certificatePinner) && this.url.port() == var1_1.url.port();
    }

    public final String toString() {
        return "Address{" + this.url.host() + ':' + this.url.port() + ", " + (this.proxy != null ? "proxy=" + this.proxy : "proxySelector=" + this.proxySelector) + '}';
    }
}

