/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.singleinstanceapp;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleInstanceApp<T>
implements AutoCloseable {
    private static final Companion Companion = new Companion(null);
    private final MessageIO<T> messageIO;
    private final Function1<T, Unit> onIncomingMessage;
    private final Function0<Unit> onClientExit;
    private final CoroutineDispatcher serverDispatcher;
    private final Path socketPath;
    private AFUNIXServerSocket server;
    public static final Logger logger = LoggerFactory.getLogger(SingleInstanceApp.class);
    public static final boolean isWindows;
    public static final Set<PosixFilePermission> posixOwnerOnlyDirectoryPermissions;
    public static final Set<PosixFilePermission> posixOwnerOnlyFilePermissions;

    /*
     * WARNING - void declaration
     */
    public SingleInstanceApp(Path unixSocketPath, MessageIO<T> messageIO, Function1<? super T, Unit> onIncomingMessage, Function0<Unit> onClientExit, CoroutineDispatcher serverDispatcher) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)unixSocketPath, (String)"unixSocketPath");
        Intrinsics.checkNotNullParameter(messageIO, (String)"messageIO");
        Intrinsics.checkNotNullParameter(onIncomingMessage, (String)"onIncomingMessage");
        Intrinsics.checkNotNullParameter(onClientExit, (String)"onClientExit");
        Intrinsics.checkNotNullParameter((Object)serverDispatcher, (String)"serverDispatcher");
        this.messageIO = var2_2;
        this.onIncomingMessage = var3_3;
        this.onClientExit = onClientExit;
        this.serverDispatcher = serverDispatcher;
        Path path = var1_1.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        this.socketPath = path;
    }

    /*
     * WARNING - void declaration
     */
    public final void lock(T message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Files.createDirectories(this.socketPath.getParent(), new FileAttribute[0]);
        SingleInstanceApp singleInstanceApp = this;
        Path path = singleInstanceApp.socketPath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        singleInstanceApp.setOwnerOnlyPermissions(path);
        AFUNIXSocketAddress socketAddress = AFUNIXSocketAddress.of((Path)this.socketPath);
        boolean isClientConnectedToServer = false;
        try {
            Closeable closeable = (Closeable)AFUNIXSocket.connectTo((AFUNIXSocketAddress)socketAddress);
            Throwable throwable = null;
            try {
                AFUNIXSocket socket = (AFUNIXSocket)closeable;
                isClientConnectedToServer = true;
                SingleInstanceApp singleInstanceApp2 = this;
                singleInstanceApp2.setOwnerOnlyPermissions(singleInstanceApp2.socketPath);
                logger.debug("Connected to single instance application on '{}'", (Object)this.socketPath);
                Intrinsics.checkNotNull((Object)socket);
                Function0<Unit> function0 = this.onClientExit;
                T t = message;
                Object object = socket;
                Object object2 = this;
                Closeable closeable2 = new DataInputStream((InputStream)object.getInputStream());
                Throwable throwable2 = null;
                try {
                    DataInputStream dataInputStream = (DataInputStream)closeable2;
                    String string = dataInputStream.readUTF();
                    if (!Intrinsics.areEqual((Object)string, (Object)"READY")) {
                        object = "Invalid server ready message '" + string + "', expected 'READY'";
                        throw new IllegalArgumentException(object.toString());
                    }
                    Closeable closeable3 = new DataOutputStream((OutputStream)object.getOutputStream());
                    object = null;
                    try {
                        DataOutputStream dataOutputStream = (DataOutputStream)closeable3;
                        ((SingleInstanceApp)object2).messageIO.writeMessage(t, dataOutputStream);
                        dataOutputStream.flush();
                        object2 = dataInputStream.readUTF();
                        if (!Intrinsics.areEqual((Object)object2, (Object)"OK")) {
                            object2 = "Invalid server response message '" + string + "', expected 'OK'";
                            throw new IllegalArgumentException(object2.toString());
                        }
                        logger.trace("Sent message '{}' to server, got response '{}'", t, object2);
                        function0.invoke();
                    }
                    catch (Throwable throwable3) {
                        try {
                            object2 = throwable3;
                            object = throwable3;
                            throw object2;
                        }
                        catch (Throwable throwable4) {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)object);
                            throw throwable4;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable3, null);
                }
                catch (Throwable throwable5) {
                    try {
                        object2 = throwable5;
                        throwable2 = throwable5;
                        throw object2;
                    }
                    catch (Throwable throwable6) {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        throw throwable6;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable2, null);
            }
            catch (Throwable throwable7) {
                try {
                    Throwable throwable8 = throwable7;
                    throwable = throwable7;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    throw throwable9;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, null);
            return;
        }
        catch (Exception clientException) {
            AFUNIXServerSocket aFUNIXServerSocket;
            void var2_2;
            void var1_1;
            void var3_3;
            if (var3_3 != false) {
                logger.error("Unable to send request to single instance application", (Throwable)clientException);
                throw clientException;
            }
            logger.debug("Starting single instance application with lock on '{}'", (Object)this.socketPath);
            this.onIncomingMessage.invoke((Object)var1_1);
            Intrinsics.checkNotNull((Object)socketAddress);
            Function1<T, Unit> function1 = this.onIncomingMessage;
            void var7_18 = var2_2;
            SingleInstanceApp singleInstanceApp3 = this;
            singleInstanceApp3.server = aFUNIXServerSocket = AFUNIXServerSocket.newInstance();
            aFUNIXServerSocket.bind((SocketAddress)var7_18);
            SingleInstanceApp singleInstanceApp4 = singleInstanceApp3;
            singleInstanceApp4.setOwnerOnlyPermissions(singleInstanceApp4.socketPath);
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)singleInstanceApp3.serverDispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(aFUNIXServerSocket, singleInstanceApp3, function1, null){
                int label;
                final /* synthetic */ AFUNIXServerSocket $server;
                final /* synthetic */ SingleInstanceApp<T> this$0;
                final /* synthetic */ Function1<T, Unit> $onIncomingMessage;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.$server = var1_1;
                    this.this$0 = var2_2;
                    this.$onIncomingMessage = var3_3;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            while (JobKt.isActive((CoroutineContext)this.getContext()) && !this.$server.isClosed()) {
                                isClientReady = false;
                                try {
                                    socket = this.$server.accept();
                                    output = new DataOutputStream((OutputStream)socket.getOutputStream());
                                    input = new DataInputStream((InputStream)socket.getInputStream());
                                    try {
                                        isClientReady = true;
                                        if (!socket.checkConnectionClosed()) ** GOTO lbl23
                                    }
                                    catch (Throwable message) {
                                        var3_7.close();
                                        input.close();
                                        throw message;
                                    }
                                    output.close();
                                    input.close();
                                    continue;
lbl23:
                                    // 2 sources

                                    output.writeUTF("READY");
                                    output.flush();
                                    message = SingleInstanceApp.access$getMessageIO$p(this.this$0).readMessage(input);
                                    this.$onIncomingMessage.invoke(message);
                                    output.writeUTF("OK");
                                    output.flush();
                                    output.close();
                                    input.close();
                                }
                                catch (SocketClosedException ex) {
                                    if (var1_2 == false || this.$server.isClosed()) continue;
                                    throw ex;
                                }
                                catch (Exception ex) {
                                    if (this.$server.isClosed()) continue;
                                    throw var2_6;
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                /*
                 * WARNING - void declaration
                 */
                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    void var2_2;
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }
            }), (int)3, null);
            return;
        }
    }

    @Override
    public final void close() {
        AFUNIXServerSocket aFUNIXServerSocket = this.server;
        if (aFUNIXServerSocket != null) {
            aFUNIXServerSocket.close();
        }
        this.server = null;
        Files.deleteIfExists(this.socketPath);
    }

    private final void setOwnerOnlyPermissions(Path $this$setOwnerOnlyPermissions) {
        File file = $this$setOwnerOnlyPermissions.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        SingleInstanceApp.setOwnerOnlyPermissions(file);
    }

    private static void setOwnerOnlyPermissions(File $this$setOwnerOnlyPermissions) {
        File file;
        if (isWindows) {
            File file2 = $this$setOwnerOnlyPermissions;
            file2.setExecutable(file2.isDirectory(), true);
            $this$setOwnerOnlyPermissions.setWritable(true, true);
            Comparable cfr_ignored_0 = Boolean.valueOf($this$setOwnerOnlyPermissions.setReadable(true, true));
            return;
        }
        Comparable cfr_ignored_1 = Files.setPosixFilePermissions($this$setOwnerOnlyPermissions.toPath(), file.isDirectory() ? posixOwnerOnlyDirectoryPermissions : posixOwnerOnlyFilePermissions);
    }

    public static final /* synthetic */ MessageIO access$getMessageIO$p(SingleInstanceApp $this) {
        return $this.messageIO;
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        isWindows = StringsKt.startsWith((String)string, (String)"Win", (boolean)true);
        posixOwnerOnlyDirectoryPermissions = PosixFilePermissions.fromString("rwx------");
        posixOwnerOnlyFilePermissions = PosixFilePermissions.fromString("rw-------");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005"}, d2={"Lorg/codeartisans/singleinstanceapp/SingleInstanceApp$ArgsMessageIO;", "Lorg/codeartisans/singleinstanceapp/SingleInstanceApp$MessageIO;", "", "", "<init>", "()V"})
    @SourceDebugExtension(value={"SMAP\nSingleInstanceApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleInstanceApp.kt\norg/codeartisans/singleinstanceapp/SingleInstanceApp$ArgsMessageIO\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,206:1\n13402#2,2:207\n37#3:209\n36#3,3:210\n*S KotlinDebug\n*F\n+ 1 SingleInstanceApp.kt\norg/codeartisans/singleinstanceapp/SingleInstanceApp$ArgsMessageIO\n*L\n50#1:207,2\n61#1:209\n61#1:210,3\n*E\n"})
    public static final class ArgsMessageIO
    implements MessageIO<String[]> {
        public static final ArgsMessageIO INSTANCE = new ArgsMessageIO();

        private ArgsMessageIO() {
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0005\u001a\u0006*\u00020\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR,\u0010\r\u001a\u001a\u0012\b\u0012\u0006*\u00020\u000b0\u000b*\f\u0012\b\u0012\u0006*\u00020\u000b0\u000b0\f0\n8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR,\u0010\u000f\u001a\u001a\u0012\b\u0012\u0006*\u00020\u000b0\u000b*\f\u0012\b\u0012\u0006*\u00020\u000b0\u000b0\f0\n8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000e"}, d2={"Lorg/codeartisans/singleinstanceapp/SingleInstanceApp$Companion;", "", "<init>", "()V", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "", "isWindows", "Z", "", "Ljava/nio/file/attribute/PosixFilePermission;", "", "posixOwnerOnlyDirectoryPermissions", "Ljava/util/Set;", "posixOwnerOnlyFilePermissions"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static interface MessageIO<T> {
        public void writeMessage(T var1, DataOutputStream var2);

        public T readMessage(DataInputStream var1);
    }
}

