/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.DebugStringsKt;
import kotlinx.coroutines.internal.ResizableAtomicArray;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TasksKt;
import kotlinx.coroutines.scheduling.WorkQueue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0000\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0003MNOB+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0012\u0010\u001b\u001a\u00020\u00102\n\u0010\u0017\u001a\u00060\u0018R\u00020\u0000J\u000e\u0010\u001c\u001a\b\u0018\u00010\u0018R\u00020\u0000H\u0002J\u0014\u0010\u001d\u001a\u00020\u00042\n\u0010\u0017\u001a\u00060\u0018R\u00020\u0000H\u0002J\u0011\u0010!\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0007H\u0082\bJ\u0011\u0010'\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0007H\u0082\bJ\u0011\u0010$\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0007H\u0086\bJ\t\u0010(\u001a\u00020\u0004H\u0082\bJ\t\u0010)\u001a\u00020\u0004H\u0082\bJ\t\u0010*\u001a\u00020\u0007H\u0082\bJ\t\u0010+\u001a\u00020\u0016H\u0082\bJ\t\u0010,\u001a\u00020\u0010H\u0082\bJ\t\u0010-\u001a\u00020\u0007H\u0082\bJ\u0019\u00102\u001a\u00020\u00162\n\u00103\u001a\u000605j\u0002`4H\u0016\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020\u0016H\u0016J\u000e\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0007J/\u0010:\u001a\u00020\u00162\n\u0010;\u001a\u000605j\u0002`42\f\b\u0002\u0010<\u001a\u00060\u0010j\u0002`=2\b\b\u0002\u0010>\u001a\u00020\u0010\u00a2\u0006\u0002\u0010?J#\u0010@\u001a\u00020\u00122\n\u0010;\u001a\u000605j\u0002`42\n\u0010<\u001a\u00060\u0010j\u0002`=\u00a2\u0006\u0002\u0010AJ\u0018\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0010H\u0002J\u0006\u0010E\u001a\u00020\u0016J\u0012\u0010F\u001a\u00020\u00102\b\b\u0002\u0010&\u001a\u00020\u0007H\u0002J\b\u0010G\u001a\u00020\u0010H\u0002J\b\u0010H\u001a\u00020\u0004H\u0002J$\u0010I\u001a\u0004\u0018\u00010\u0012*\b\u0018\u00010\u0018R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u0010H\u0002J\u000e\u0010J\u001a\b\u0018\u00010\u0018R\u00020\u0000H\u0002J\b\u0010K\u001a\u00020\tH\u0016J\u000e\u0010L\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\t\u0010\u0013\u001a\u00020\u0014X\u0082\u0004R\u001a\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u0018R\u00020\u00000\u001f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\t\u0010 \u001a\u00020\u0014X\u0082\u0004R\u0015\u0010!\u001a\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0015\u0010$\u001a\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\t\u0010.\u001a\u00020/X\u0082\u0004R\u0011\u00100\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006P"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "Ljava/util/concurrent/Executor;", "Ljava/io/Closeable;", "corePoolSize", "", "maxPoolSize", "idleWorkerKeepAliveNs", "", "schedulerName", "", "<init>", "(IIJLjava/lang/String;)V", "globalCpuQueue", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "globalBlockingQueue", "addToGlobalQueue", "", "task", "Lkotlinx/coroutines/scheduling/Task;", "parkedWorkersStack", "Lkotlinx/atomicfu/AtomicLong;", "parkedWorkersStackTopUpdate", "", "worker", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "oldIndex", "newIndex", "parkedWorkersStackPush", "parkedWorkersStackPop", "parkedWorkersStackNextIndex", "workers", "Lkotlinx/coroutines/internal/ResizableAtomicArray;", "controlState", "createdWorkers", "getCreatedWorkers", "()I", "availableCpuPermits", "getAvailableCpuPermits", "state", "blockingTasks", "incrementCreatedWorkers", "decrementCreatedWorkers", "incrementBlockingTasks", "decrementBlockingTasks", "tryAcquireCpuPermit", "releaseCpuPermit", "_isTerminated", "Lkotlinx/atomicfu/AtomicBoolean;", "isTerminated", "()Z", "execute", "command", "Lkotlinx/coroutines/Runnable;", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "close", "shutdown", "timeout", "dispatch", "block", "taskContext", "Lkotlinx/coroutines/scheduling/TaskContext;", "tailDispatch", "(Ljava/lang/Runnable;ZZ)V", "createTask", "(Ljava/lang/Runnable;Z)Lkotlinx/coroutines/scheduling/Task;", "signalBlockingWork", "stateSnapshot", "skipUnpark", "signalCpuWork", "tryCreateWorker", "tryUnpark", "createNewWorker", "submitToLocalQueue", "currentWorker", "toString", "runSafely", "Companion", "Worker", "WorkerState", "kotlinx-coroutines-core"})
@SourceDebugExtension(value={"SMAP\nCoroutineScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineScheduler.kt\nkotlinx/coroutines/scheduling/CoroutineScheduler\n+ 2 Tasks.kt\nkotlinx/coroutines/scheduling/TasksKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 5 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 6 CoroutineScheduler.kt\nkotlinx/coroutines/scheduling/CoroutineScheduler$Worker\n*L\n1#1,1044:1\n286#1:1047\n284#1:1048\n284#1:1049\n286#1:1050\n281#1:1053\n282#1,5:1054\n292#1:1060\n284#1:1061\n285#1:1062\n284#1:1065\n285#1:1066\n281#1:1067\n289#1:1068\n284#1:1069\n284#1:1072\n285#1:1073\n286#1:1074\n77#2:1045\n77#2:1059\n77#2:1070\n1#3:1046\n27#4:1051\n27#4:1063\n16#5:1052\n16#5:1064\n622#6:1071\n*S KotlinDebug\n*F\n+ 1 CoroutineScheduler.kt\nkotlinx/coroutines/scheduling/CoroutineScheduler\n*L\n282#1:1047\n289#1:1048\n290#1:1049\n299#1:1050\n348#1:1053\n377#1:1054,5\n400#1:1060\n447#1:1061\n448#1:1062\n484#1:1065\n485#1:1066\n491#1:1067\n500#1:1068\n500#1:1069\n581#1:1072\n582#1:1073\n583#1:1074\n120#1:1045\n397#1:1059\n517#1:1070\n348#1:1051\n480#1:1063\n348#1:1052\n480#1:1064\n524#1:1071\n*E\n"})
public final class CoroutineScheduler
implements Closeable,
Executor {
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final int corePoolSize;
    @JvmField
    public final int maxPoolSize;
    @JvmField
    public final long idleWorkerKeepAliveNs;
    @JvmField
    public final String schedulerName;
    @JvmField
    public final GlobalQueue globalCpuQueue;
    @JvmField
    public final GlobalQueue globalBlockingQueue;
    private volatile /* synthetic */ long parkedWorkersStack$volatile;
    @JvmField
    public final ResizableAtomicArray<Worker> workers;
    private volatile /* synthetic */ long controlState$volatile;
    private volatile /* synthetic */ int _isTerminated$volatile;
    private static final /* synthetic */ AtomicLongFieldUpdater parkedWorkersStack$volatile$FU;
    private static final /* synthetic */ AtomicLongFieldUpdater controlState$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater _isTerminated$volatile$FU;
    @JvmField
    public static final Symbol NOT_IN_STACK;

    /*
     * WARNING - void declaration
     */
    public CoroutineScheduler(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs, String schedulerName) {
        void var3_7;
        void var2_6;
        void var1_1;
        this.corePoolSize = var1_1;
        this.maxPoolSize = var2_6;
        this.idleWorkerKeepAliveNs = var3_7;
        this.schedulerName = schedulerName;
        if (!(this.corePoolSize > 0)) {
            String string = "Core pool size " + this.corePoolSize + " should be at least 1";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.maxPoolSize >= this.corePoolSize)) {
            String string = "Max pool size " + this.maxPoolSize + " should be greater than or equals to core pool size " + this.corePoolSize;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.maxPoolSize <= 0x1FFFFE)) {
            String string = "Max pool size " + this.maxPoolSize + " should not exceed maximal supported number of threads 2097150";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.idleWorkerKeepAliveNs > 0L)) {
            String string = "Idle worker keep alive time " + this.idleWorkerKeepAliveNs + " must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        this.globalCpuQueue = new GlobalQueue();
        this.globalBlockingQueue = new GlobalQueue();
        this.workers = new ResizableAtomicArray((this.corePoolSize + 1) * 2);
        this.controlState$volatile = (long)this.corePoolSize << 42;
        this._isTerminated$volatile = 0;
    }

    public final void parkedWorkersStackTopUpdate(Worker worker, int oldIndex, int newIndex) {
        int updIndex;
        long updVersion;
        long top;
        int n;
        AtomicLongFieldUpdater handler$atomicfu$iv = parkedWorkersStack$volatile$FU;
        do {
            top = handler$atomicfu$iv.get(this);
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            if (index == oldIndex) {
                if (newIndex == 0) {
                    n = CoroutineScheduler.parkedWorkersStackNextIndex(worker);
                    continue;
                }
                n = newIndex;
                continue;
            }
            n = updIndex = index;
        } while (n < 0 || !parkedWorkersStack$volatile$FU.compareAndSet(this, top, updVersion | (long)updIndex));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean parkedWorkersStackPush(Worker worker) {
        int updIndex;
        long updVersion;
        void var3_3;
        if (worker.getNextParkedWorker() != NOT_IN_STACK) {
            return false;
        }
        AtomicLongFieldUpdater handler$atomicfu$iv = parkedWorkersStack$volatile$FU;
        do {
            long top = handler$atomicfu$iv.get(this);
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            updIndex = worker.getIndexInArray();
            if (DebugKt.getASSERTIONS_ENABLED() && !(updIndex != 0)) {
                throw new AssertionError();
            }
            worker.setNextParkedWorker(this.workers.get(index));
        } while (!parkedWorkersStack$volatile$FU.compareAndSet(this, (long)var3_3, updVersion | (long)updIndex));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Worker parkedWorkersStackPop() {
        long updVersion;
        void var2_2;
        Worker worker;
        int updIndex;
        AtomicLongFieldUpdater handler$atomicfu$iv = parkedWorkersStack$volatile$FU;
        do {
            long top;
            int index;
            if (this.workers.get(index = (int)((top = handler$atomicfu$iv.get(this)) & 0x1FFFFFL)) == null) {
                return null;
            }
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
        } while ((updIndex = CoroutineScheduler.parkedWorkersStackNextIndex(worker)) < 0 || !parkedWorkersStack$volatile$FU.compareAndSet(this, (long)var2_2, updVersion | (long)updIndex));
        worker.setNextParkedWorker(NOT_IN_STACK);
        return worker;
    }

    /*
     * WARNING - void declaration
     */
    private static int parkedWorkersStackNextIndex(Worker worker) {
        Worker next = worker.getNextParkedWorker();
        while (next != NOT_IN_STACK) {
            Worker worker2;
            if (next == null) {
                return 0;
            }
            Worker nextWorker = next;
            int updIndex = nextWorker.getIndexInArray();
            if (updIndex != 0) {
                void var1_1;
                return (int)var1_1;
            }
            worker2 = worker2.getNextParkedWorker();
        }
        return -1;
    }

    public final boolean isTerminated() {
        return _isTerminated$volatile$FU.get(this) != 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(Runnable command) {
        void var1_1;
        CoroutineScheduler.dispatch$default$23379181(this, (Runnable)var1_1, false, false, 6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void close() {
        ResizableAtomicArray<Worker> resizableAtomicArray;
        long l = 10000L;
        CoroutineScheduler coroutineScheduler = this;
        if (!_isTerminated$volatile$FU.compareAndSet(coroutineScheduler, 0, 1)) return;
        Worker worker = coroutineScheduler.currentWorker();
        ResizableAtomicArray<Worker> resizableAtomicArray2 = resizableAtomicArray = coroutineScheduler.workers;
        synchronized (resizableAtomicArray) {
            long l2;
            Runnable runnable;
            Object object;
            CoroutineScheduler coroutineScheduler2 = coroutineScheduler;
            int n = (int)(controlState$volatile$FU.get(coroutineScheduler2) & 0x1FFFFFL);
            // ** MonitorExit[var3_7] (shouldn't be in output)
            int n2 = n;
            int n3 = 1;
            if (n2 > 0) {
                while (true) {
                    Intrinsics.checkNotNull((Object)coroutineScheduler.workers.get(n3));
                    if (object != worker) {
                        while (((Thread)object).getState() != Thread.State.TERMINATED) {
                            LockSupport.unpark((Thread)object);
                            ((Thread)object).join(10000L);
                        }
                        if (DebugKt.getASSERTIONS_ENABLED() && !(((Worker)object).state == WorkerState.TERMINATED)) {
                            throw new AssertionError();
                        }
                        ((Worker)object).localQueue.offloadAllWorkTo(coroutineScheduler.globalBlockingQueue);
                    }
                    if (n3 == n2) break;
                    ++n3;
                }
            }
            coroutineScheduler.globalBlockingQueue.close();
            coroutineScheduler.globalCpuQueue.close();
            while ((runnable = worker) != null && (runnable = runnable.findTask(true)) != null || (runnable = (Task)coroutineScheduler.globalCpuQueue.removeFirstOrNull()) != null || (runnable = (Task)coroutineScheduler.globalBlockingQueue.removeFirstOrNull()) != null) {
                Runnable runnable2 = runnable;
                CoroutineScheduler.runSafely((Task)runnable);
            }
            Worker worker2 = worker;
            if (worker2 != null) {
                worker2.tryReleaseCpu(WorkerState.TERMINATED);
            }
            if (DebugKt.getASSERTIONS_ENABLED() && !((int)(((l2 = controlState$volatile$FU.get(object = coroutineScheduler)) & 0x7FFFFC0000000000L) >> 42) == coroutineScheduler.corePoolSize)) {
                throw new AssertionError();
            }
            parkedWorkersStack$volatile$FU.set(coroutineScheduler, 0L);
            controlState$volatile$FU.set(coroutineScheduler, 0L);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dispatch(Runnable block, boolean taskContext, boolean tailDispatch) {
        void var1_2;
        void var2_4;
        void var3_5;
        boolean skipUnpark2;
        Object notAdded;
        Object object;
        long l;
        Task task;
        boolean bl = taskContext;
        long l2 = TasksKt.schedulerTimeSource.nanoTime();
        if (block instanceof Task) {
            ((Task)block).submissionTime = l2;
            ((Task)block).taskContext = bl;
            task = (Task)block;
        } else {
            task = TasksKt.asTask(block, l2, bl);
        }
        Runnable task2 = task;
        Task task3 = task;
        boolean isBlockingTask = task.taskContext;
        if (isBlockingTask) {
            CoroutineScheduler this_$iv = this;
            l = controlState$volatile$FU.addAndGet(this_$iv, 0x200000L);
        } else {
            l = 0L;
        }
        long stateSnapshot = l;
        Worker currentWorker = this.currentWorker();
        boolean bl2 = tailDispatch;
        Task task4 = task2;
        task2 = currentWorker;
        if (currentWorker == null) {
            object = task4;
        } else if (((Worker)task2).state == WorkerState.TERMINATED) {
            object = task4;
        } else {
            Task task5 = task4;
            if (!task5.taskContext && ((Worker)task2).state == WorkerState.BLOCKING) {
                object = task4;
            } else {
                ((Worker)task2).mayHaveLocalTasks = true;
                object = notAdded = ((Worker)task2).localQueue.add(task4, bl2);
            }
        }
        if (object != null) {
            task4 = notAdded;
            notAdded = this;
            Task task6 = task4;
            if (!(task6.taskContext ? ((CoroutineScheduler)notAdded).globalBlockingQueue.addLast(task4) : ((CoroutineScheduler)notAdded).globalCpuQueue.addLast(task4))) {
                throw new RejectedExecutionException(this.schedulerName + " was terminated");
            }
        }
        boolean bl3 = skipUnpark2 = var3_5 != false && currentWorker != null;
        if (var2_4 != false) {
            boolean bl4 = skipUnpark2;
            long l3 = stateSnapshot;
            CoroutineScheduler skipUnpark2 = this;
            if (!(bl4 || skipUnpark2.tryUnpark() || skipUnpark2.tryCreateWorker(l3))) {
                skipUnpark2.tryUnpark();
            }
            return;
        }
        if (var1_2 != false) {
            return;
        }
        this.signalCpuWork();
    }

    public static /* synthetic */ void dispatch$default$23379181(CoroutineScheduler coroutineScheduler, Runnable runnable, boolean bl, boolean bl2, int n) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        coroutineScheduler.dispatch(runnable, false, bl2);
    }

    public final void signalCpuWork() {
        if (this.tryUnpark()) {
            return;
        }
        if (CoroutineScheduler.tryCreateWorker$default$1f38147f(this, 0L, 1)) {
            return;
        }
        this.tryUnpark();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryCreateWorker(long $i$f$createdWorkers) {
        void var3_3;
        int created = (int)($i$f$createdWorkers & 0x1FFFFFL);
        int blocking = (int)(($i$f$createdWorkers & 0x3FFFFE00000L) >> 21);
        if ((blocking = RangesKt.coerceAtLeast((int)(var3_3 - blocking), (int)0)) < this.corePoolSize) {
            void var1_2;
            int newCpuWorkers = this.createNewWorker();
            if (newCpuWorkers == 1 && this.corePoolSize > 1) {
                this.createNewWorker();
            }
            if (var1_2 > 0) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ boolean tryCreateWorker$default$1f38147f(CoroutineScheduler coroutineScheduler, long l, int n) {
        l = controlState$volatile$FU.get(coroutineScheduler);
        return coroutineScheduler.tryCreateWorker(l);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryUnpark() {
        void var1_1;
        Worker worker;
        do {
            if (this.parkedWorkersStackPop() != null) continue;
            return false;
        } while (!Worker.workerCtl$volatile$FU.compareAndSet(worker, -1, 0));
        LockSupport.unpark((Thread)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int createNewWorker() {
        ResizableAtomicArray<Worker> resizableAtomicArray = this.workers;
        ResizableAtomicArray<Worker> resizableAtomicArray2 = resizableAtomicArray;
        resizableAtomicArray2 = resizableAtomicArray;
        synchronized (resizableAtomicArray) {
            void var1_10;
            void var3_11;
            block10: {
                int created;
                block9: {
                    block8: {
                        if (!this.isTerminated()) break block8;
                        // ** MonitorExit[var2_1] (shouldn't be in output)
                        return -1;
                    }
                    long state = controlState$volatile$FU.get(this);
                    created = (int)(state & 0x1FFFFFL);
                    int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
                    int cpuWorkers = RangesKt.coerceAtLeast((int)(created - blocking), (int)0);
                    if (cpuWorkers < this.corePoolSize) break block9;
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return 0;
                }
                if (created < this.maxPoolSize) break block10;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return 0;
            }
            CoroutineScheduler this_$iv = this;
            int newIndex = (int)(controlState$volatile$FU.get(this_$iv) & 0x1FFFFFL) + 1;
            if (!(newIndex > 0 && this.workers.get(newIndex) == null)) {
                String blocking = "Failed requirement.";
                throw new IllegalArgumentException(blocking.toString());
            }
            Object worker = new Worker(newIndex);
            this.workers.setSynchronized$1ef468a(newIndex, (Worker)worker);
            this_$iv = this;
            long l = controlState$volatile$FU.incrementAndGet(this_$iv);
            if (!(newIndex == (int)(l & 0x1FFFFFL))) {
                worker = "Failed requirement.";
                throw new IllegalArgumentException(worker.toString());
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            void var2_2 = ++var3_11;
            var1_10.start();
            return (int)var2_2;
        }
    }

    private final Worker currentWorker() {
        Thread thread = Thread.currentThread();
        Worker worker = thread instanceof Worker ? (Worker)thread : null;
        if (worker != null) {
            thread = worker;
            Worker worker2 = worker;
            worker2 = worker;
            if (Intrinsics.areEqual((Object)worker.CoroutineScheduler.this, (Object)this)) {
                return thread;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        void var2_2;
        void var3_3;
        int parkedWorkers = 0;
        int blockingWorkers = 0;
        int cpuWorkers = 0;
        int dormant = 0;
        int terminated = 0;
        ArrayList queueSizes = new ArrayList();
        int n = this.workers.currentLength();
        block7: for (int index = 1; index < n; ++index) {
            Worker worker;
            if (this.workers.get(index) == null) continue;
            int queueSize = worker.localQueue.getSize$kotlinx_coroutines_core();
            switch (WhenMappings.$EnumSwitchMapping$0[worker.state.ordinal()]) {
                case 1: {
                    ++parkedWorkers;
                    continue block7;
                }
                case 2: {
                    ++blockingWorkers;
                    ((Collection)queueSizes).add("" + queueSize + 'b');
                    continue block7;
                }
                case 3: {
                    ++cpuWorkers;
                    ((Collection)queueSizes).add("" + queueSize + 'c');
                    continue block7;
                }
                case 4: {
                    ++dormant;
                    if (queueSize <= 0) continue block7;
                    ((Collection)queueSizes).add("" + queueSize + 'd');
                    continue block7;
                }
                case 5: {
                    ++terminated;
                    continue block7;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        long state = controlState$volatile$FU.get(this);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.schedulerName).append('@').append(DebugStringsKt.getHexAddress(this)).append("[Pool Size {core = ").append(this.corePoolSize).append(", max = ").append(this.maxPoolSize).append("}, Worker States {CPU = ").append((int)var3_3).append(", blocking = ").append((int)var2_2).append(", parked = ").append((int)var1_1).append(", dormant = ").append(dormant).append(", terminated = ").append(terminated).append("}, running workers queues = ").append(queueSizes).append(", global CPU queue size = ").append(this.globalCpuQueue.getSize()).append(", global blocking queue size = ").append(this.globalBlockingQueue.getSize());
        stringBuilder.append(", Control State {created workers= ").append((int)(state & 0x1FFFFFL)).append(", blocking tasks = ").append((int)((state & 0x3FFFFE00000L) >> 21)).append(", CPUs acquired = ").append(this.corePoolSize - (int)((state & 0x7FFFFC0000000000L) >> 42)).append("}]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void runSafely(Task task) {
        try {
            task.run();
            return;
        }
        catch (Throwable e) {
            void var0_1;
            void var1_3;
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException((Thread)var1_3, (Throwable)var0_1);
            return;
        }
    }

    static {
        parkedWorkersStack$volatile$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "parkedWorkersStack$volatile");
        controlState$volatile$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "controlState$volatile");
        _isTerminated$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(CoroutineScheduler.class, "_isTerminated$volatile");
        NOT_IN_STACK = new Symbol("NOT_IN_STACK");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$Companion;", "", "<init>", "()V", "Lkotlinx/coroutines/internal/Symbol;", "NOT_IN_STACK", "Lkotlinx/coroutines/internal/Symbol;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorkerState.values().length];
            try {
                nArray[WorkerState.PARKING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WorkerState.BLOCKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WorkerState.CPU_ACQUIRED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WorkerState.DORMANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WorkerState.TERMINATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\b\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020(H\u0002J\u0006\u0010+\u001a\u00020\u001aJ\u0006\u0010,\u001a\u00020$J\b\u0010-\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020$H\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u0014H\u0002J\u000e\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005J\b\u00103\u001a\u00020(H\u0002J\b\u00104\u001a\u00020(H\u0002J\u0010\u00105\u001a\u0004\u0018\u00010\u00142\u0006\u0010)\u001a\u00020$J\n\u00106\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u00107\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u00142\u0006\u00109\u001a\u00020$H\u0002J\n\u0010:\u001a\u0004\u0018\u00010\u0014H\u0002J\u001b\u0010;\u001a\u0004\u0018\u00010\u00142\n\u0010<\u001a\u00060\u0005j\u0002`=H\u0002\u00a2\u0006\u0002\u0010>R$\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "Ljava/lang/Thread;", "<init>", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;)V", "index", "", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;I)V", "indexInArray", "getIndexInArray", "()I", "setIndexInArray", "(I)V", "scheduler", "Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "getScheduler", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "localQueue", "Lkotlinx/coroutines/scheduling/WorkQueue;", "stolenTask", "Lkotlin/jvm/internal/Ref$ObjectRef;", "Lkotlinx/coroutines/scheduling/Task;", "state", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "workerCtl", "Lkotlinx/atomicfu/AtomicInt;", "terminationDeadline", "", "nextParkedWorker", "", "getNextParkedWorker", "()Ljava/lang/Object;", "setNextParkedWorker", "(Ljava/lang/Object;)V", "minDelayUntilStealableTaskNs", "rngState", "tryAcquireCpuPermit", "", "tryReleaseCpu", "newState", "run", "", "mayHaveLocalTasks", "runWorker", "runSingleTask", "isIo", "tryPark", "inStack", "executeTask", "task", "nextInt", "upperBound", "park", "tryTerminateWorker", "findTask", "findBlockingTask", "findCpuTask", "findAnyTask", "scanLocalQueue", "pollGlobalQueues", "trySteal", "stealingMode", "Lkotlinx/coroutines/scheduling/StealingMode;", "(I)Lkotlinx/coroutines/scheduling/Task;", "kotlinx-coroutines-core"})
    @SourceDebugExtension(value={"SMAP\nCoroutineScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineScheduler.kt\nkotlinx/coroutines/scheduling/CoroutineScheduler$Worker\n+ 2 CoroutineScheduler.kt\nkotlinx/coroutines/scheduling/CoroutineScheduler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Tasks.kt\nkotlinx/coroutines/scheduling/TasksKt\n+ 5 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 6 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n*L\n1#1,1044:1\n298#2,2:1045\n286#2:1047\n300#2,4:1048\n305#2:1052\n295#2,2:1053\n295#2,2:1058\n281#2:1062\n290#2:1063\n284#2:1064\n281#2:1065\n1#3:1055\n77#4:1056\n77#4:1057\n27#5:1060\n16#6:1061\n*S KotlinDebug\n*F\n+ 1 CoroutineScheduler.kt\nkotlinx/coroutines/scheduling/CoroutineScheduler$Worker\n*L\n687#1:1045,2\n687#1:1047\n687#1:1048,4\n702#1:1052\n776#1:1053,2\n824#1:1058,2\n875#1:1062\n901#1:1063\n901#1:1064\n974#1:1065\n815#1:1056\n818#1:1057\n871#1:1060\n871#1:1061\n*E\n"})
    public final class Worker
    extends Thread {
        private volatile int indexInArray;
        @JvmField
        public final WorkQueue localQueue;
        private final Ref.ObjectRef<Task> stolenTask;
        @JvmField
        public WorkerState state;
        private volatile /* synthetic */ int workerCtl$volatile;
        private long terminationDeadline;
        private volatile Object nextParkedWorker;
        private long minDelayUntilStealableTaskNs;
        private int rngState;
        @JvmField
        public boolean mayHaveLocalTasks;
        private static final /* synthetic */ AtomicIntegerFieldUpdater workerCtl$volatile$FU;

        private Worker() {
            int n;
            this.setDaemon(true);
            Worker worker = this;
            worker.setContextClassLoader(worker.CoroutineScheduler.this.getClass().getClassLoader());
            this.localQueue = new WorkQueue();
            this.stolenTask = new Ref.ObjectRef();
            this.state = WorkerState.DORMANT;
            this.nextParkedWorker = NOT_IN_STACK;
            Worker worker2 = this;
            int seed = (int)System.nanoTime();
            worker2.rngState = n = seed != 0 ? n : 42;
        }

        public final int getIndexInArray() {
            return this.indexInArray;
        }

        /*
         * WARNING - void declaration
         */
        private void setIndexInArray(int index) {
            void var1_1;
            this.setName(CoroutineScheduler.this.schedulerName + "-worker-" + (index == 0 ? "TERMINATED" : String.valueOf(index)));
            this.indexInArray = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Worker(int index) {
            this();
            void var2_2;
            void var1_1;
            this.setIndexInArray((int)var2_2);
        }

        public final Object getNextParkedWorker() {
            return this.nextParkedWorker;
        }

        /*
         * WARNING - void declaration
         */
        public final void setNextParkedWorker(Object object) {
            void var1_1;
            this.nextParkedWorker = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean tryAcquireCpuPermit() {
            boolean bl;
            block4: {
                long update$iv;
                void var3_3;
                if (this.state == WorkerState.CPU_ACQUIRED) {
                    return true;
                }
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                AtomicLongFieldUpdater handler$atomicfu$iv$iv = controlState$volatile$FU;
                do {
                    long state$iv;
                    int n;
                    if ((n = (int)(((state$iv = handler$atomicfu$iv$iv.get(this_$iv)) & 0x7FFFFC0000000000L) >> 42)) == 0) {
                        bl = false;
                        break block4;
                    }
                    update$iv = state$iv - 0x40000000000L;
                } while (!controlState$volatile$FU.compareAndSet(this_$iv, (long)var3_3, update$iv));
                bl = true;
            }
            if (bl) {
                this.state = WorkerState.CPU_ACQUIRED;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean tryReleaseCpu(WorkerState newState) {
            void var3_3;
            void var2_2;
            WorkerState previousState = this.state;
            boolean hadCpu = previousState == WorkerState.CPU_ACQUIRED;
            if (hadCpu) {
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                controlState$volatile$FU.addAndGet(this_$iv, 0x40000000000L);
            }
            if (var2_2 != newState) {
                void var1_1;
                this.state = var1_1;
            }
            return (boolean)var3_3;
        }

        @Override
        public final void run() {
            Worker worker = this;
            boolean bl = false;
            while (!worker.CoroutineScheduler.this.isTerminated() && worker.state != WorkerState.TERMINATED) {
                Runnable runnable;
                Worker worker2 = worker;
                Runnable runnable2 = worker2.findTask(worker2.mayHaveLocalTasks);
                if (runnable2 != null) {
                    Object object;
                    bl = false;
                    worker.minDelayUntilStealableTaskNs = 0L;
                    runnable = runnable2;
                    runnable2 = worker;
                    worker.terminationDeadline = 0L;
                    if (((Worker)runnable2).state == WorkerState.PARKING) {
                        if (DebugKt.getASSERTIONS_ENABLED()) {
                            object = runnable;
                            if (!((Task)object).taskContext) {
                                throw new AssertionError();
                            }
                        }
                        ((Worker)runnable2).state = WorkerState.BLOCKING;
                    }
                    object = runnable;
                    if (((Task)object).taskContext) {
                        if (((Worker)runnable2).tryReleaseCpu(WorkerState.BLOCKING)) {
                            ((Worker)runnable2).CoroutineScheduler.this.signalCpuWork();
                        }
                        CoroutineScheduler cfr_ignored_0 = ((Worker)runnable2).CoroutineScheduler.this;
                        CoroutineScheduler.runSafely((Task)runnable);
                        object = ((Worker)runnable2).CoroutineScheduler.this;
                        controlState$volatile$FU.addAndGet(object, -2097152L);
                        object = ((Worker)runnable2).state;
                        if (object == WorkerState.TERMINATED) continue;
                        if (DebugKt.getASSERTIONS_ENABLED() && !(object == WorkerState.BLOCKING)) {
                            throw new AssertionError();
                        }
                        ((Worker)runnable2).state = WorkerState.DORMANT;
                        continue;
                    }
                    CoroutineScheduler cfr_ignored_1 = ((Worker)runnable2).CoroutineScheduler.this;
                    CoroutineScheduler.runSafely((Task)runnable);
                    continue;
                }
                worker.mayHaveLocalTasks = false;
                if (worker.minDelayUntilStealableTaskNs != 0L) {
                    if (!bl) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    worker.tryReleaseCpu(WorkerState.PARKING);
                    Thread.interrupted();
                    LockSupport.parkNanos(worker.minDelayUntilStealableTaskNs);
                    worker.minDelayUntilStealableTaskNs = 0L;
                    continue;
                }
                runnable2 = worker;
                if (!((Worker)runnable2).inStack()) {
                    ((Worker)runnable2).CoroutineScheduler.this.parkedWorkersStackPush((Worker)runnable2);
                    continue;
                }
                workerCtl$volatile$FU.set(runnable2, -1);
                while (super.inStack() && workerCtl$volatile$FU.get(runnable2) == -1 && !((Worker)runnable2).CoroutineScheduler.this.isTerminated() && ((Worker)runnable2).state != WorkerState.TERMINATED) {
                    ((Worker)runnable2).tryReleaseCpu(WorkerState.PARKING);
                    Thread.interrupted();
                    runnable = runnable2;
                    if (((Worker)runnable).terminationDeadline == 0L) {
                        ((Worker)runnable).terminationDeadline = System.nanoTime() + ((Worker)runnable).CoroutineScheduler.this.idleWorkerKeepAliveNs;
                    }
                    LockSupport.parkNanos(((Worker)runnable).CoroutineScheduler.this.idleWorkerKeepAliveNs);
                    if (System.nanoTime() - ((Worker)runnable).terminationDeadline < 0L) continue;
                    ((Worker)runnable).terminationDeadline = 0L;
                    super.tryTerminateWorker();
                }
            }
            worker.tryReleaseCpu(WorkerState.TERMINATED);
        }

        private final boolean inStack() {
            return this.nextParkedWorker != NOT_IN_STACK;
        }

        /*
         * WARNING - void declaration
         */
        private int nextInt(int upperBound) {
            void var1_1;
            void var2_2;
            int r = this.rngState;
            r ^= r << 13;
            r ^= r >> 17;
            r ^= r << 5;
            this.rngState = r;
            int mask = upperBound - 1;
            if ((mask & upperBound) == 0) {
                void var3_3;
                return r & var3_3;
            }
            return (var2_2 & Integer.MAX_VALUE) % var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private final void tryTerminateWorker() {
            ResizableAtomicArray<Worker> resizableAtomicArray = CoroutineScheduler.this.workers;
            CoroutineScheduler coroutineScheduler = CoroutineScheduler.this;
            synchronized (resizableAtomicArray) {
                if (coroutineScheduler.isTerminated()) {
                    return;
                }
                CoroutineScheduler this_$iv = coroutineScheduler;
                if ((int)(controlState$volatile$FU.get(this_$iv) & 0x1FFFFFL) <= coroutineScheduler.corePoolSize) {
                    return;
                }
                if (!workerCtl$volatile$FU.compareAndSet(this, -1, 1)) {
                    return;
                }
                int oldIndex = this.indexInArray;
                this.setIndexInArray(0);
                coroutineScheduler.parkedWorkersStackTopUpdate(this, oldIndex, 0);
                CoroutineScheduler this_$iv2 = coroutineScheduler;
                long l = controlState$volatile$FU.getAndDecrement(this_$iv2);
                int lastIndex = (int)(l & 0x1FFFFFL);
                if (lastIndex != oldIndex) {
                    void var3_5;
                    Worker worker = coroutineScheduler.workers.get(lastIndex);
                    Intrinsics.checkNotNull((Object)worker);
                    Worker lastWorker = worker;
                    coroutineScheduler.workers.setSynchronized$1ef468a(oldIndex, lastWorker);
                    lastWorker.setIndexInArray(oldIndex);
                    coroutineScheduler.parkedWorkersStackTopUpdate(lastWorker, lastIndex, (int)var3_5);
                }
                coroutineScheduler.workers.setSynchronized$1ef468a(lastIndex, null);
            }
            this.state = WorkerState.TERMINATED;
        }

        /*
         * WARNING - void declaration
         */
        public final Task findTask(boolean mayHaveLocalTasks) {
            if (this.tryAcquireCpuPermit()) {
                void var1_1;
                return this.findAnyTask((boolean)var1_1);
            }
            return this.findBlockingTask();
        }

        private final Task findBlockingTask() {
            Task task = this.localQueue.pollBlocking();
            if (task == null && (task = (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull()) == null) {
                task = this.trySteal(1);
            }
            return task;
        }

        /*
         * WARNING - void declaration
         */
        private final Task findAnyTask(boolean scanLocalQueue) {
            if (scanLocalQueue) {
                void var1_1;
                Task task;
                boolean globalFirst2 = this.nextInt(2 * CoroutineScheduler.this.corePoolSize) == 0;
                if (globalFirst2 && (task = this.pollGlobalQueues()) != null) {
                    Task globalFirst2 = task;
                    return globalFirst2;
                }
                task = this.localQueue.poll();
                if (task != null) {
                    Task globalFirst2 = task;
                    return globalFirst2;
                }
                if (var1_1 == false && (task = this.pollGlobalQueues()) != null) {
                    Task task2 = task;
                    return task2;
                }
            } else {
                Task task = this.pollGlobalQueues();
                if (task != null) {
                    return task;
                }
            }
            return this.trySteal(3);
        }

        private final Task pollGlobalQueues() {
            if (this.nextInt(2) == 0) {
                Task task = (Task)CoroutineScheduler.this.globalCpuQueue.removeFirstOrNull();
                if (task != null) {
                    return task;
                }
                return (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull();
            }
            Task task = (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull();
            if (task != null) {
                return task;
            }
            return (Task)CoroutineScheduler.this.globalCpuQueue.removeFirstOrNull();
        }

        /*
         * WARNING - void declaration
         */
        private final Task trySteal(int stealingMode) {
            CoroutineScheduler this_$iv = CoroutineScheduler.this;
            int created = (int)(controlState$volatile$FU.get(this_$iv) & 0x1FFFFFL);
            if (created < 2) {
                return null;
            }
            int currentIndex = this.nextInt(created);
            long minDelay = Long.MAX_VALUE;
            CoroutineScheduler coroutineScheduler = CoroutineScheduler.this;
            for (int i = 0; i < created; ++i) {
                Worker worker;
                if (++currentIndex > created) {
                    currentIndex = 1;
                }
                if ((worker = coroutineScheduler.workers.get(currentIndex)) == null || worker == this) continue;
                long stealResult = worker.localQueue.trySteal(stealingMode, this.stolenTask);
                if (stealResult == -1L) {
                    void var1_2;
                    Task result = (Task)this.stolenTask.element;
                    this.stolenTask.element = null;
                    return var1_2;
                }
                if (stealResult <= 0L) continue;
                minDelay = Math.min(minDelay, stealResult);
            }
            this.minDelayUntilStealableTaskNs = minDelay != Long.MAX_VALUE ? minDelay : 0L;
            return null;
        }

        static {
            workerCtl$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "workerCtl$volatile");
        }
    }

    public static final class WorkerState
    extends Enum<WorkerState> {
        public static final /* enum */ WorkerState CPU_ACQUIRED = new WorkerState();
        public static final /* enum */ WorkerState BLOCKING = new WorkerState();
        public static final /* enum */ WorkerState PARKING = new WorkerState();
        public static final /* enum */ WorkerState DORMANT = new WorkerState();
        public static final /* enum */ WorkerState TERMINATED = new WorkerState();
        private static final /* synthetic */ WorkerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        /*
         * WARNING - void declaration
         */
        private WorkerState() {
            void var2_2;
            void var1_1;
        }

        public static WorkerState[] values() {
            return (WorkerState[])$VALUES.clone();
        }

        private static WorkerState valueOf(String value) {
            String string;
            return Enum.valueOf(WorkerState.class, string);
        }

        static {
            WorkerState[] workerStateArray = new WorkerState[5];
            WorkerState[] workerStateArray2 = workerStateArray;
            workerStateArray[0] = CPU_ACQUIRED;
            workerStateArray2[1] = BLOCKING;
            workerStateArray2[2] = PARKING;
            workerStateArray2[3] = DORMANT;
            workerStateArray2[4] = TERMINATED;
            $VALUES = workerStateArray2;
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])workerStateArray2);
        }
    }
}

