/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.options.QrCodeMatrix;
import io.github.alexzhirkevich.qrose.qrcode.ErrorCorrectionLevel;
import io.github.alexzhirkevich.qrose.qrcode.MaskPattern;
import io.github.alexzhirkevich.qrose.qrcode.QRCodeDataType;
import io.github.alexzhirkevich.qrose.qrcode.internals.BitBuffer;
import io.github.alexzhirkevich.qrose.qrcode.internals.Polynomial;
import io.github.alexzhirkevich.qrose.qrcode.internals.QR8BitByte;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRAlphaNum;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSetup;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSquare;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRData;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRNumber;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRUtil;
import io.github.alexzhirkevich.qrose.qrcode.internals.RSBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/QRCode;", "", "", "data", "Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;", "errorCorrectionLevel", "Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;", "dataType", "<init>", "(Ljava/lang/String;Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;", "Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;", "Lio/github/alexzhirkevich/qrose/qrcode/internals/QRData;", "qrCodeData", "Lio/github/alexzhirkevich/qrose/qrcode/internals/QRData;", "Companion"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nQRCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QRCode.kt\nio/github/alexzhirkevich/qrose/qrcode/QRCode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n11065#2:210\n11400#2,2:211\n11065#2:213\n11400#2,3:214\n11402#2:217\n13374#2,3:219\n1#3:218\n*S KotlinDebug\n*F\n+ 1 QRCode.kt\nio/github/alexzhirkevich/qrose/qrcode/QRCode\n*L\n98#1:210\n98#1:211,2\n99#1:213\n99#1:214,3\n98#1:217\n155#1:219,3\n*E\n"})
public final class QRCode {
    public static final Companion Companion = new Companion(null);
    private final String data;
    private final ErrorCorrectionLevel errorCorrectionLevel;
    private final QRCodeDataType dataType;
    private final QRData qrCodeData;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    private QRCode(String data, ErrorCorrectionLevel errorCorrectionLevel, QRCodeDataType dataType) {
        QRData qRData;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        this.data = var1_1;
        this.errorCorrectionLevel = var2_2;
        this.dataType = var3_3;
        switch (WhenMappings.$EnumSwitchMapping$0[this.dataType.ordinal()]) {
            case 1: {
                qRData = new QRNumber(this.data);
                break;
            }
            case 2: {
                qRData = new QRAlphaNum(this.data);
                break;
            }
            case 3: {
                qRData = new QR8BitByte(this.data);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.qrCodeData = qRData;
    }

    public /* synthetic */ QRCode(String string, ErrorCorrectionLevel errorCorrectionLevel, QRCodeDataType qRCodeDataType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            errorCorrectionLevel = ErrorCorrectionLevel.M;
        }
        if ((n & 4) != 0) {
            qRCodeDataType = QRUtil.INSTANCE.getDataType(string);
        }
        this(string, errorCorrectionLevel, qRCodeDataType);
    }

    public static /* synthetic */ QrCodeMatrix encode$default$4bdcd0cc(QRCode rSBlockArray, int n, MaskPattern object6, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        MaskPattern maskPattern;
        n = io.github.alexzhirkevich.qrose.qrcode.QRCode$Companion.typeForDataAndECL$default$66bda13(Companion, rSBlockArray.data, rSBlockArray.errorCorrectionLevel, null, 4);
        MaskPattern maskPattern2 = maskPattern = MaskPattern.PATTERN000;
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern2), (String)"maskPattern");
        int n9 = n * 4 + 17;
        QRCodeSquare[][] qRCodeSquareArray = new QRCodeSquare[n9][];
        for (int i = 0; i < n9; ++i) {
            int n10;
            int n11 = n10 = i;
            n10 = 0;
            QRCodeSquare[] qRCodeSquareArray2 = new QRCodeSquare[n9];
            n8 = n11;
            QRCodeSquare[][] qRCodeSquareArray3 = qRCodeSquareArray;
            while (n10 < n9) {
                n7 = n10++;
                qRCodeSquareArray2[n7] = null;
            }
            qRCodeSquareArray3[n8] = qRCodeSquareArray2;
        }
        QRCodeSetup.setupTopLeftPositionProbePattern$default$73e5a9a3(QRCodeSetup.INSTANCE, qRCodeSquareArray, 0, 2);
        QRCodeSetup.setupTopRightPositionProbePattern$default$73e5a9a3(QRCodeSetup.INSTANCE, qRCodeSquareArray, 0, 2);
        QRCodeSetup.setupBottomLeftPositionProbePattern$default$73e5a9a3(QRCodeSetup.INSTANCE, qRCodeSquareArray, 0, 2);
        QRCodeSetup.setupPositionAdjustPattern(n, qRCodeSquareArray);
        QRCodeSetup.setupTimingPattern(n9, qRCodeSquareArray);
        QRCodeSetup.INSTANCE.setupTypeInfo(rSBlockArray.errorCorrectionLevel, maskPattern2, n9, qRCodeSquareArray);
        if (n >= 7) {
            QRCodeSetup.INSTANCE.setupTypeNumber(n, n9, qRCodeSquareArray);
        }
        RSBlock[] rSBlockArray2 = RSBlock.Companion.getRSBlocks(n, rSBlockArray.errorCorrectionLevel);
        BitBuffer bitBuffer = new BitBuffer();
        bitBuffer.put(rSBlockArray.qrCodeData.getDataType().getValue(), 4);
        bitBuffer.put(rSBlockArray.qrCodeData.length(), rSBlockArray.qrCodeData.getLengthInBits(n));
        rSBlockArray.qrCodeData.write(bitBuffer);
        rSBlockArray = rSBlockArray2;
        n = 0;
        n7 = rSBlockArray.length;
        for (n6 = 0; n6 < n7; ++n6) {
            RSBlock rSBlock;
            RSBlock rSBlock2 = rSBlock = rSBlockArray[n6];
            int n12 = n;
            n = rSBlock2.getDataCount();
            n = n12 + n;
        }
        int n12 = n * 8;
        if (bitBuffer.getLengthInBits() > n12) {
            throw new IllegalArgumentException("Code length overflow (" + bitBuffer.getLengthInBits() + " > " + n12 + ")");
        }
        if (bitBuffer.getLengthInBits() + 4 <= n12) {
            bitBuffer.put(0, 4);
        }
        while (bitBuffer.getLengthInBits() % 8 != 0) {
            bitBuffer.put(false);
        }
        while (bitBuffer.getLengthInBits() < n12) {
            bitBuffer.put(236, 8);
            if (bitBuffer.getLengthInBits() >= n12) break;
            bitBuffer.put(17, 8);
        }
        RSBlock[] rSBlockArray3 = rSBlockArray2;
        BitBuffer bitBuffer2 = bitBuffer;
        int n13 = 0;
        int n14 = 0;
        n6 = 0;
        n7 = 0;
        n8 = 0;
        int n15 = rSBlockArray3.length;
        int[][] nArrayArray = new int[n15][];
        while (n8 < n15) {
            int n16 = n8++;
            nArrayArray[n16] = new int[0];
        }
        Object object = nArrayArray;
        n15 = 0;
        int n17 = rSBlockArray3.length;
        int[][] nArrayArray2 = new int[n17][];
        while (n15 < n17) {
            n5 = n15++;
            nArrayArray2[n5] = new int[0];
        }
        Object object2 = nArrayArray2;
        RSBlock[] rSBlockArray4 = rSBlockArray3;
        int n18 = 0;
        for (RSBlock rSBlock : rSBlockArray4) {
            int n19 = n18++;
            RSBlock rSBlock2 = rSBlock;
            n4 = n19;
            int n20 = rSBlock2.getDataCount();
            int n21 = rSBlock2.getTotalCount() - n20;
            n7 += rSBlock2.getTotalCount();
            n14 = RangesKt.coerceAtLeast((int)n14, (int)n20);
            n6 = RangesKt.coerceAtLeast((int)n6, (int)n21);
            int n22 = 0;
            Object object3 = new int[n20];
            int n23 = n4;
            Object object4 = object;
            while (n22 < n20) {
                int n24 = n22++;
                object3[n24] = 0xFF & bitBuffer2.getBuffer()[n24 + n13];
            }
            object4[n23] = object3;
            n13 += n20;
            Polynomial polynomial = QRUtil.getErrorCorrectPolynomial(n21);
            Polynomial polynomial2 = new Polynomial(object[n4], polynomial.len() - 1);
            object3 = polynomial2;
            Polynomial polynomial3 = polynomial2.mod(polynomial);
            int n25 = polynomial.len() - 1;
            int[] nArray = new int[n25];
            n23 = n4;
            object4 = object2;
            for (int i = 0; i < n25; ++i) {
                int n26;
                int n27 = n26 = i;
                int n28 = n27 + polynomial3.len() - n25;
                nArray[n27] = n28 >= 0 ? polynomial3.get(n28) : 0;
            }
            object4[n23] = nArray;
        }
        int n29 = 0;
        int[] nArray = new int[n7];
        n5 = n14;
        for (n18 = 0; n18 < n5; ++n18) {
            n4 = rSBlockArray3.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (n18 >= object[n3].length) continue;
                nArray[n29++] = object[n3][n18];
            }
        }
        n5 = n6;
        for (n18 = 0; n18 < n5; ++n18) {
            n4 = rSBlockArray3.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (n18 >= object2[n3].length) continue;
                nArray[n29++] = object2[n3][n18];
            }
        }
        int[] nArray2 = nArray;
        QRCodeSetup.INSTANCE.applyMaskPattern(nArray2, maskPattern2, n9, qRCodeSquareArray);
        qRCodeSquareArray = (Object[])qRCodeSquareArray;
        Object[] objectArray = qRCodeSquareArray;
        Collection collection = new ArrayList(qRCodeSquareArray.length);
        for (Object object5 : objectArray) {
            QRCodeSquare[] qRCodeSquareArray4 = (QRCodeSquare[])object5;
            object2 = collection;
            QRCodeSquare[] qRCodeSquareArray5 = qRCodeSquareArray4;
            QRCodeSquare[] qRCodeSquareArray6 = qRCodeSquareArray4;
            Collection collection2 = new ArrayList(qRCodeSquareArray5.length);
            for (QRCodeSquare qRCodeSquare : qRCodeSquareArray6) {
                object = collection2;
                QRCodeSquare qRCodeSquare2 = qRCodeSquare;
                object.add((qRCodeSquare2 != null ? qRCodeSquare2.getDark() : false) ? QrCodeMatrix.PixelType.DarkPixel : QrCodeMatrix.PixelType.LightPixel);
            }
            object2.add((List)collection2);
        }
        List list = (List)collection;
        return new QrCodeMatrix(list);
    }

    public final String toString() {
        return "QRCode(data=" + this.data + ", errorCorrectionLevel=" + this.errorCorrectionLevel + ", dataType=" + this.dataType + ", qrCodeData=" + Reflection.getOrCreateKotlinClass(this.qrCodeData.getClass()).getSimpleName() + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/QRCode$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ int typeForDataAndECL$default$66bda13(Companion object, String object2, ErrorCorrectionLevel enum_, QRCodeDataType qRCodeDataType, int n) {
            QRData qRData;
            qRCodeDataType = QRUtil.INSTANCE.getDataType((String)object2);
            String string = object2;
            ErrorCorrectionLevel errorCorrectionLevel = enum_;
            enum_ = qRCodeDataType;
            object2 = errorCorrectionLevel;
            object = string;
            Intrinsics.checkNotNullParameter((Object)string, (String)"data");
            Intrinsics.checkNotNullParameter((Object)object2, (String)"errorCorrectionLevel");
            Intrinsics.checkNotNullParameter((Object)enum_, (String)"dataType");
            switch (WhenMappings.$EnumSwitchMapping$0[enum_.ordinal()]) {
                case 1: {
                    qRData = new QRNumber((String)object);
                    break;
                }
                case 2: {
                    qRData = new QRAlphaNum((String)object);
                    break;
                }
                case 3: {
                    qRData = new QR8BitByte((String)object);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object = qRData;
            int n2 = qRData.length();
            n = ((ErrorCorrectionLevel)((Object)object2)).getMaxTypeNum();
            for (int i = 1; i < n; ++i) {
                if (n2 > QRUtil.getMaxLength(i, (QRCodeDataType)enum_, (ErrorCorrectionLevel)((Object)object2))) continue;
                return i;
            }
            return 40;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[QRCodeDataType.values().length];
                try {
                    nArray[QRCodeDataType.NUMBERS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[QRCodeDataType.UPPER_ALPHA_NUM.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[QRCodeDataType.DEFAULT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QRCodeDataType.values().length];
            try {
                nArray[QRCodeDataType.NUMBERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[QRCodeDataType.UPPER_ALPHA_NUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[QRCodeDataType.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

