/*
 * Decompiled with CFR 0.152.
 */
package application.desktop.main.bootstrap;

import androidx.compose.runtime.internal.StabilityInferred;
import application.deeplinks.AppLink;
import application.desktop.main.bootstrap.DesktopCrashHandlingKt;
import application.desktop.main.bootstrap.LinuxBootstrap;
import application.desktop.main.bootstrap.MacBootstrap;
import application.desktop.main.bootstrap.WindowsBootstrap;
import application.presentation.IncomingUrl;
import application.presentation.util.coroutines.NavFlowEmitter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import shared.system.os.DesktopOS;
import shared.system.os.DesktopOSKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000e\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lapplication/desktop/main/bootstrap/DesktopBootstrap;", "", "<init>", "()V", "", "applicationVersion", "", "beforeSingleInstanceLock", "(Ljava/lang/String;)V", "Lapplication/presentation/util/coroutines/NavFlowEmitter;", "Lapplication/presentation/IncomingUrl;", "incomingUrlEmitter", "Lapplication/deeplinks/AppLink;", "appLinkEmitter", "afterSingleInstanceLock", "(Lapplication/presentation/util/coroutines/NavFlowEmitter;Lapplication/presentation/util/coroutines/NavFlowEmitter;)V"})
@StabilityInferred(parameters=1)
public final class DesktopBootstrap {
    public static final DesktopBootstrap INSTANCE = new DesktopBootstrap();

    private DesktopBootstrap() {
    }

    public static void beforeSingleInstanceLock(String applicationVersion) {
        String string;
        Intrinsics.checkNotNullParameter((Object)applicationVersion, (String)"applicationVersion");
        DesktopCrashHandlingKt.installCrashHandling(string);
        if (DesktopOSKt.getCurrentDesktopOS().isWindows()) {
            System.setProperty("jdk.lang.Process.allowAmbiguousCommands", "true");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void afterSingleInstanceLock(NavFlowEmitter<IncomingUrl> incomingUrlEmitter, NavFlowEmitter<AppLink> appLinkEmitter) {
        Intrinsics.checkNotNullParameter(incomingUrlEmitter, (String)"incomingUrlEmitter");
        Intrinsics.checkNotNullParameter(appLinkEmitter, (String)"appLinkEmitter");
        switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1: {
                LinuxBootstrap.INSTANCE.afterSingleInstanceLock();
                return;
            }
            case 2: {
                void var1_1;
                NavFlowEmitter<IncomingUrl> navFlowEmitter;
                MacBootstrap.afterSingleInstanceLock(navFlowEmitter, (NavFlowEmitter<AppLink>)var1_1);
                return;
            }
            case 3: {
                WindowsBootstrap.INSTANCE.afterSingleInstanceLock();
                return;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DesktopOS.values().length];
            try {
                nArray[DesktopOS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

