/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.WasExperimental;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.internal.InlineOnly;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.io.path.FileVisitorBuilder;
import kotlin.io.path.FileVisitorBuilderImpl;
import kotlin.io.path.PathRelativizer;
import kotlin.io.path.PathTreeWalk;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u001a\u0014\u0010\u0001\u001a\u00020\u0000*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0003*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\u0007\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u001b\u0010\t\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\t\u0010\b\u001a\u001d\u0010\n\u001a\u0004\u0018\u00010\u0000*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\n\u0010\b\u001a&\u0010\u000e\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\fH\u0087\b\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a0\u0010\u000e\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0087\b\u00a2\u0006\u0004\b\u000e\u0010\u0013\u001a(\u0010\u0015\u001a\u00020\f*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a(\u0010\u0017\u001a\u00020\f*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\b\u0017\u0010\u0016\u001a(\u0010\u0018\u001a\u00020\f*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\b\u0018\u0010\u0016\u001a(\u0010\u0019\u001a\u00020\f*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\b\u0019\u0010\u0016\u001a\u0014\u0010\u001a\u001a\u00020\f*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u00020\f*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b\u001c\u0010\u001b\u001a\u0014\u0010\u001d\u001a\u00020\f*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b\u001d\u0010\u001b\u001a\u0014\u0010\u001e\u001a\u00020\f*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b\u001e\u0010\u001b\u001a\u0014\u0010\u001f\u001a\u00020\f*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b\u001f\u0010\u001b\u001a\u001c\u0010!\u001a\u00020\f*\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b!\u0010\"\u001a#\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00000$*\u00020\u00002\b\b\u0002\u0010#\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b%\u0010&\u001aA\u0010+\u001a\u00028\u0000\"\u0004\b\u0000\u0010'*\u00020\u00002\b\b\u0002\u0010#\u001a\u00020\u00032\u0018\u0010*\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000)\u0012\u0004\u0012\u00028\u00000(H\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,\u001a5\u0010/\u001a\u00020-*\u00020\u00002\b\b\u0002\u0010#\u001a\u00020\u00032\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020-0(H\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u00100\u001a\u0014\u00102\u001a\u000201*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b2\u00103\u001a\u0014\u00104\u001a\u00020-*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b4\u00105\u001a\u0014\u00106\u001a\u00020\f*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b6\u0010\u001b\u001a0\u00109\u001a\u00020\u0000*\u00020\u00002\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0087\b\u00a2\u0006\u0004\b9\u0010:\u001a0\u0010;\u001a\u00020\u0000*\u00020\u00002\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0087\b\u00a2\u0006\u0004\b;\u0010:\u001a/\u0010<\u001a\u00020\u0000*\u00020\u00002\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0007\u00a2\u0006\u0004\b<\u0010:\u001a0\u0010=\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0087\b\u00a2\u0006\u0004\b=\u0010\u0013\u001a&\u0010=\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\fH\u0087\b\u00a2\u0006\u0004\b=\u0010\u000f\u001a\u0014\u0010?\u001a\u00020>*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\b?\u0010@\u001a2\u0010C\u001a\u0004\u0018\u00010B*\u00020\u00002\u0006\u0010A\u001a\u00020\u00032\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\bC\u0010D\u001a:\u0010F\u001a\u00020\u0000*\u00020\u00002\u0006\u0010A\u001a\u00020\u00032\b\u0010E\u001a\u0004\u0018\u00010B2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\bF\u0010G\u001a6\u0010J\u001a\u0004\u0018\u00018\u0000\"\n\b\u0000\u0010I\u0018\u0001*\u00020H*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\bJ\u0010K\u001a4\u0010L\u001a\u00028\u0000\"\n\b\u0000\u0010I\u0018\u0001*\u00020H*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\bL\u0010K\u001a#\u0010Q\u001a\u00020P2\u0006\u0010M\u001a\u00020\u00002\n\u0010O\u001a\u0006\u0012\u0002\b\u00030NH\u0001\u00a2\u0006\u0004\bQ\u0010R\u001a4\u0010U\u001a\u00028\u0000\"\n\b\u0000\u0010T\u0018\u0001*\u00020S*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\bU\u0010V\u001a>\u0010U\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010B0W*\u00020\u00002\u0006\u00108\u001a\u00020\u00032\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\bU\u0010X\u001a(\u0010Z\u001a\u00020Y*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\bZ\u0010[\u001a\u001c\u0010\\\u001a\u00020\u0000*\u00020\u00002\u0006\u0010E\u001a\u00020YH\u0087\b\u00a2\u0006\u0004\b\\\u0010]\u001a*\u0010_\u001a\u0004\u0018\u00010^*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\b_\u0010`\u001a\u001c\u0010a\u001a\u00020\u0000*\u00020\u00002\u0006\u0010E\u001a\u00020^H\u0087\b\u00a2\u0006\u0004\ba\u0010b\u001a.\u0010e\u001a\b\u0012\u0004\u0012\u00020d0c*\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0010\"\u00020\u0014H\u0087\b\u00a2\u0006\u0004\be\u0010f\u001a\"\u0010g\u001a\u00020\u0000*\u00020\u00002\f\u0010E\u001a\b\u0012\u0004\u0012\u00020d0cH\u0087\b\u00a2\u0006\u0004\bg\u0010h\u001a\u001c\u0010i\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0087\b\u00a2\u0006\u0004\bi\u0010\b\u001a8\u0010j\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0087\b\u00a2\u0006\u0004\bj\u0010k\u001a\u0014\u0010l\u001a\u00020\u0000*\u00020\u0000H\u0087\b\u00a2\u0006\u0004\bl\u0010\u0002\u001a0\u0010m\u001a\u00020\u0000*\u00020\u00002\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0087\b\u00a2\u0006\u0004\bm\u0010:\u001aD\u0010p\u001a\u00020\u00002\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010o\u001a\u0004\u0018\u00010\u00032\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0087\b\u00a2\u0006\u0004\bp\u0010q\u001aM\u0010p\u001a\u00020\u00002\b\u0010r\u001a\u0004\u0018\u00010\u00002\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010o\u001a\u0004\u0018\u00010\u00032\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0007\u00a2\u0006\u0004\bp\u0010s\u001a8\u0010t\u001a\u00020\u00002\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00032\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0087\b\u00a2\u0006\u0004\bt\u0010u\u001aA\u0010t\u001a\u00020\u00002\b\u0010r\u001a\u0004\u0018\u00010\u00002\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00032\u001a\u00108\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003070\u0010\"\u0006\u0012\u0002\b\u000307H\u0007\u00a2\u0006\u0004\bt\u0010v\u001a\u001c\u0010w\u001a\u00020\u0000*\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0087\n\u00a2\u0006\u0004\bw\u0010\b\u001a\u001c\u0010w\u001a\u00020\u0000*\u00020\u00002\u0006\u0010 \u001a\u00020\u0003H\u0087\n\u00a2\u0006\u0004\bw\u0010x\u001a\u0018\u0010y\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u0003H\u0087\b\u00a2\u0006\u0004\by\u0010z\u001a,\u0010y\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00032\u0012\u0010{\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0010\"\u00020\u0003H\u0087\b\u00a2\u0006\u0004\by\u0010|\u001a\u0014\u0010~\u001a\u00020\u0000*\u00020}H\u0087\b\u00a2\u0006\u0004\b~\u0010\u007f\u001a2\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000)*\u00020\u00002\u0014\u0010\u0012\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u0080\u00010\u0010\"\u00030\u0080\u0001H\u0007\u00a2\u0006\u0006\b\u0081\u0001\u0010\u0082\u0001\u001a=\u0010\u0088\u0001\u001a\u00020-*\u00020\u00002\u000e\u0010\u0084\u0001\u001a\t\u0012\u0004\u0012\u00020\u00000\u0083\u00012\n\b\u0002\u0010\u0086\u0001\u001a\u00030\u0085\u00012\t\b\u0002\u0010\u0087\u0001\u001a\u00020\fH\u0007\u00a2\u0006\u0006\b\u0088\u0001\u0010\u0089\u0001\u001aV\u0010\u0088\u0001\u001a\u00020-*\u00020\u00002\n\b\u0002\u0010\u0086\u0001\u001a\u00030\u0085\u00012\t\b\u0002\u0010\u0087\u0001\u001a\u00020\f2\u001a\u0010\u008c\u0001\u001a\u0015\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u0004\u0012\u00020-0(\u00a2\u0006\u0003\b\u008b\u0001H\u0007\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0003 \u0001\u00a2\u0006\u0006\b\u0088\u0001\u0010\u008d\u0001\u001aB\u0010\u008e\u0001\u001a\t\u0012\u0004\u0012\u00020\u00000\u0083\u00012\u001a\u0010\u008c\u0001\u001a\u0015\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u0004\u0012\u00020-0(\u00a2\u0006\u0003\b\u008b\u0001H\u0007\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0006\b\u008e\u0001\u0010\u008f\u0001\"!\u0010\u0092\u0001\u001a\u00020\u0003*\u00020\u00008FX\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u0091\u0001\u00105\u001a\u0005\b\u0090\u0001\u0010\u0005\"!\u0010\u0095\u0001\u001a\u00020\u0003*\u00020\u00008FX\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u0094\u0001\u00105\u001a\u0005\b\u0093\u0001\u0010\u0005\"!\u0010\u0098\u0001\u001a\u00020\u0003*\u00020\u00008FX\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u0097\u0001\u00105\u001a\u0005\b\u0096\u0001\u0010\u0005\"\"\u0010\u009b\u0001\u001a\u00020\u0003*\u00020\u00008\u00c6\u0002X\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u009a\u0001\u00105\u001a\u0005\b\u0099\u0001\u0010\u0005\"!\u0010\u009e\u0001\u001a\u00020\u0003*\u00020\u00008FX\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u009d\u0001\u00105\u001a\u0005\b\u009c\u0001\u0010\u0005\"\"\u0010\u00a1\u0001\u001a\u00020\u0003*\u00020\u00008\u00c6\u0002X\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u00a0\u0001\u00105\u001a\u0005\b\u009f\u0001\u0010\u0005\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Ljava/nio/file/Path;", "absolute", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "", "absolutePathString", "(Ljava/nio/file/Path;)Ljava/lang/String;", "base", "relativeTo", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;", "relativeToOrSelf", "relativeToOrNull", "target", "", "overwrite", "copyTo", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Z)Ljava/nio/file/Path;", "", "Ljava/nio/file/CopyOption;", "options", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)Ljava/nio/file/Path;", "Ljava/nio/file/LinkOption;", "exists", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z", "notExists", "isRegularFile", "isDirectory", "isSymbolicLink", "(Ljava/nio/file/Path;)Z", "isExecutable", "isHidden", "isReadable", "isWritable", "other", "isSameFileAs", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Z", "glob", "", "listDirectoryEntries", "(Ljava/nio/file/Path;Ljava/lang/String;)Ljava/util/List;", "T", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "block", "useDirectoryEntries", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "action", "forEachDirectoryEntry", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "", "fileSize", "(Ljava/nio/file/Path;)J", "deleteExisting", "(Ljava/nio/file/Path;)V", "deleteIfExists", "Ljava/nio/file/attribute/FileAttribute;", "attributes", "createDirectory", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "createDirectories", "createParentDirectories", "moveTo", "Ljava/nio/file/FileStore;", "fileStore", "(Ljava/nio/file/Path;)Ljava/nio/file/FileStore;", "attribute", "", "getAttribute", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/lang/Object;", "value", "setAttribute", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)Ljava/nio/file/Path;", "Ljava/nio/file/attribute/FileAttributeView;", "V", "fileAttributesViewOrNull", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "fileAttributesView", "path", "Ljava/lang/Class;", "attributeViewClass", "", "fileAttributeViewNotAvailable", "(Ljava/nio/file/Path;Ljava/lang/Class;)Ljava/lang/Void;", "Ljava/nio/file/attribute/BasicFileAttributes;", "A", "readAttributes", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "Ljava/nio/file/attribute/FileTime;", "getLastModifiedTime", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileTime;", "setLastModifiedTime", "(Ljava/nio/file/Path;Ljava/nio/file/attribute/FileTime;)Ljava/nio/file/Path;", "Ljava/nio/file/attribute/UserPrincipal;", "getOwner", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/UserPrincipal;", "setOwner", "(Ljava/nio/file/Path;Ljava/nio/file/attribute/UserPrincipal;)Ljava/nio/file/Path;", "", "Ljava/nio/file/attribute/PosixFilePermission;", "getPosixFilePermissions", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/util/Set;", "setPosixFilePermissions", "(Ljava/nio/file/Path;Ljava/util/Set;)Ljava/nio/file/Path;", "createLinkPointingTo", "createSymbolicLinkPointingTo", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "readSymbolicLink", "createFile", "prefix", "suffix", "createTempFile", "(Ljava/lang/String;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "directory", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "createTempDirectory", "(Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "div", "(Ljava/nio/file/Path;Ljava/lang/String;)Ljava/nio/file/Path;", "Path", "(Ljava/lang/String;)Ljava/nio/file/Path;", "subpaths", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "Ljava/net/URI;", "toPath", "(Ljava/net/URI;)Ljava/nio/file/Path;", "Lkotlin/io/path/PathWalkOption;", "walk", "(Ljava/nio/file/Path;[Lkotlin/io/path/PathWalkOption;)Lkotlin/sequences/Sequence;", "Ljava/nio/file/FileVisitor;", "visitor", "", "maxDepth", "followLinks", "visitFileTree", "(Ljava/nio/file/Path;Ljava/nio/file/FileVisitor;IZ)V", "Lkotlin/io/path/FileVisitorBuilder;", "Lkotlin/ExtensionFunctionType;", "builderAction", "(Ljava/nio/file/Path;IZLkotlin/jvm/functions/Function1;)V", "fileVisitor", "(Lkotlin/jvm/functions/Function1;)Ljava/nio/file/FileVisitor;", "getName", "getName$annotations", "name", "getNameWithoutExtension", "getNameWithoutExtension$annotations", "nameWithoutExtension", "getExtension", "getExtension$annotations", "extension", "getPathString", "getPathString$annotations", "pathString", "getInvariantSeparatorsPathString", "getInvariantSeparatorsPathString$annotations", "invariantSeparatorsPathString", "getInvariantSeparatorsPath", "getInvariantSeparatorsPath$annotations", "invariantSeparatorsPath"}, xs="kotlin/io/path/PathsKt")
@SourceDebugExtension(value={"SMAP\nPathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathUtils.kt\nkotlin/io/path/PathsKt__PathUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1253:1\n1#2:1254\n1863#3,2:1255\n*S KotlinDebug\n*F\n+ 1 PathUtils.kt\nkotlin/io/path/PathsKt__PathUtilsKt\n*L\n440#1:1255,2\n*E\n"})
class PathsKt__PathUtilsKt
extends PathsKt__PathRecursiveFunctionsKt {
    public static final String getName(Path $this$name) {
        Path path;
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        Path path2 = path.getFileName();
        String string = path2 != null ? ((Object)path2).toString() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static /* synthetic */ void getName$annotations(Path path) {
    }

    public static final String getNameWithoutExtension(Path $this$nameWithoutExtension) {
        Path path;
        Intrinsics.checkNotNullParameter($this$nameWithoutExtension, "<this>");
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null || (object = StringsKt.substringBeforeLast$default((String)object, ".", null, 2, null)) == null) {
            object = "";
        }
        return object;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static /* synthetic */ void getNameWithoutExtension$annotations(Path path) {
    }

    public static final String getExtension(Path $this$extension) {
        Path path;
        Intrinsics.checkNotNullParameter($this$extension, "<this>");
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null || (object = StringsKt.substringAfterLast((String)object, '.', "")) == null) {
            object = "";
        }
        return object;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static /* synthetic */ void getExtension$annotations(Path path) {
    }

    private static final String getPathString(Path $this$pathString) {
        Path path;
        Intrinsics.checkNotNullParameter($this$pathString, "<this>");
        return ((Object)path).toString();
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    public static /* synthetic */ void getPathString$annotations(Path path) {
    }

    /*
     * WARNING - void declaration
     */
    public static final String getInvariantSeparatorsPathString(Path $this$invariantSeparatorsPathString) {
        Path path;
        Intrinsics.checkNotNullParameter($this$invariantSeparatorsPathString, "<this>");
        String separator = $this$invariantSeparatorsPathString.getFileSystem().getSeparator();
        if (!Intrinsics.areEqual(separator, "/")) {
            void var1_1;
            String string = ((Object)$this$invariantSeparatorsPathString).toString();
            Intrinsics.checkNotNull(separator);
            return StringsKt.replace$default(string, (String)var1_1, "/", false, 4, null);
        }
        return ((Object)path).toString();
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static /* synthetic */ void getInvariantSeparatorsPathString$annotations(Path path) {
    }

    private static final String getInvariantSeparatorsPath(Path $this$invariantSeparatorsPath) {
        Path path;
        Intrinsics.checkNotNullParameter($this$invariantSeparatorsPath, "<this>");
        return PathsKt.getInvariantSeparatorsPathString(path);
    }

    @Deprecated(message="Use invariantSeparatorsPathString property instead.", replaceWith=@ReplaceWith(expression="invariantSeparatorsPathString", imports={}), level=DeprecationLevel.ERROR)
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    public static /* synthetic */ void getInvariantSeparatorsPath$annotations(Path path) {
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path absolute(Path $this$absolute) {
        Path path;
        Intrinsics.checkNotNullParameter($this$absolute, "<this>");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(path2, "toAbsolutePath(...)");
        return path2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final String absolutePathString(Path $this$absolutePathString) {
        Path path;
        Intrinsics.checkNotNullParameter($this$absolutePathString, "<this>");
        return ((Object)path.toAbsolutePath()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static final Path relativeTo(Path $this$relativeTo, Path base) {
        Path path;
        Intrinsics.checkNotNullParameter($this$relativeTo, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        try {
            path = PathRelativizer.INSTANCE.tryRelativeTo($this$relativeTo, base);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            Path path2;
            throw new IllegalArgumentException(e.getMessage() + "\nthis path: " + path2 + "\nbase path: " + var1_1, (Throwable)var2_3);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static final Path relativeToOrSelf(Path $this$relativeToOrSelf, Path base) {
        void var1_1;
        Intrinsics.checkNotNullParameter($this$relativeToOrSelf, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        Path path = PathsKt.relativeToOrNull($this$relativeToOrSelf, (Path)var1_1);
        if (path == null) {
            Path path2;
            path = path2;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static final Path relativeToOrNull(Path $this$relativeToOrNull, Path base) {
        Path path;
        Intrinsics.checkNotNullParameter($this$relativeToOrNull, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        try {
            void var1_1;
            path = PathRelativizer.INSTANCE.tryRelativeTo(path, (Path)var1_1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            path = null;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path copyTo(Path $this$copyTo, Path target, boolean overwrite2) throws IOException {
        void var1_1;
        Path path;
        void var2_3;
        CopyOption[] copyOptionArray;
        Intrinsics.checkNotNullParameter($this$copyTo, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        if (overwrite2) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            CopyOption[] overwrite2 = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray = overwrite2;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        void v2 = var2_3;
        Path path2 = Files.copy(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkNotNullExpressionValue(path2, "copy(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path copyTo$default(Path $this$copyTo_u24default, Path target, boolean overwrite, int n, Object copyOptionArray) throws IOException {
        void var1_1;
        Path path;
        void var3_4;
        CopyOption[] copyOptionArray2;
        void var2_2;
        if ((n & 2) != 0) {
            overwrite = false;
        }
        Intrinsics.checkNotNullParameter($this$copyTo_u24default, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        if (var2_2 != false) {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray2 = copyOptionArray;
        } else {
            copyOptionArray2 = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray2;
        void v2 = var3_4;
        Path path2 = Files.copy(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkNotNullExpressionValue(path2, "copy(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path copyTo(Path $this$copyTo, Path target, CopyOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$copyTo, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        Path path2 = Files.copy(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "copy(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean exists(Path $this$exists, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$exists, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        return Files.exists(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean notExists(Path $this$notExists, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$notExists, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        return Files.notExists(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isRegularFile(Path $this$isRegularFile, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$isRegularFile, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        return Files.isRegularFile(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isDirectory(Path $this$isDirectory, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$isDirectory, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        return Files.isDirectory(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isSymbolicLink(Path $this$isSymbolicLink) {
        Path path;
        Intrinsics.checkNotNullParameter($this$isSymbolicLink, "<this>");
        return Files.isSymbolicLink(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isExecutable(Path $this$isExecutable) {
        Path path;
        Intrinsics.checkNotNullParameter($this$isExecutable, "<this>");
        return Files.isExecutable(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isHidden(Path $this$isHidden) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$isHidden, "<this>");
        return Files.isHidden(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isReadable(Path $this$isReadable) {
        Path path;
        Intrinsics.checkNotNullParameter($this$isReadable, "<this>");
        return Files.isReadable(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isWritable(Path $this$isWritable) {
        Path path;
        Intrinsics.checkNotNullParameter($this$isWritable, "<this>");
        return Files.isWritable(path);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isSameFileAs(Path $this$isSameFileAs, Path other) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$isSameFileAs, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return Files.isSameFile(path, (Path)var1_1);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static final List<Path> listDirectoryEntries(Path $this$listDirectoryEntries, String glob) throws IOException {
        List<Path> list;
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$listDirectoryEntries, "<this>");
        Intrinsics.checkNotNullParameter(glob, "glob");
        closeable = Files.newDirectoryStream((Path)((Object)closeable), (String)((Object)throwable));
        throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            list = CollectionsKt.toList((Iterable)list);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return list;
    }

    public static /* synthetic */ List listDirectoryEntries$default(Path path, String string, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            string = "*";
        }
        return PathsKt.listDirectoryEntries(path, string);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final <T> T useDirectoryEntries(Path $this$useDirectoryEntries, String glob, Function1<? super Sequence<? extends Path>, ? extends T> block) throws IOException {
        Object r;
        Throwable throwable;
        Throwable throwable2;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$useDirectoryEntries, "<this>");
        Intrinsics.checkNotNullParameter(glob, "glob");
        Intrinsics.checkNotNullParameter(block, "block");
        closeable = Files.newDirectoryStream((Path)((Object)closeable), (String)((Object)throwable2));
        throwable2 = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            r = throwable.invoke(CollectionsKt.asSequence((Iterable)r));
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable2);
                } else if (closeable != null) {
                    if (throwable2 == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable5) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable4;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return (T)r;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object useDirectoryEntries$default(Path $this$useDirectoryEntries_u24default, String glob, Function1 block, int n, Object object) throws IOException {
        DirectoryStream directoryStream;
        void var1_2;
        if ((n & 1) != 0) {
            glob = "*";
        }
        Intrinsics.checkNotNullParameter($this$useDirectoryEntries_u24default, "<this>");
        Intrinsics.checkNotNullParameter(glob, "glob");
        Intrinsics.checkNotNullParameter(block, "block");
        Closeable closeable = Files.newDirectoryStream($this$useDirectoryEntries_u24default, (String)var1_2);
        object = null;
        try {
            void var2_3;
            DirectoryStream it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            directoryStream = var2_3.invoke(CollectionsKt.asSequence(directoryStream));
        }
        catch (Throwable throwable) {
            try {
                directoryStream = throwable;
                object = throwable;
                throw directoryStream;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, (Throwable)object);
                } else if (closeable != null) {
                    if (object == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return directoryStream;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final void forEachDirectoryEntry(Path $this$forEachDirectoryEntry, String glob, Function1<? super Path, Unit> action) throws IOException {
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$forEachDirectoryEntry, "<this>");
        Intrinsics.checkNotNullParameter(glob, "glob");
        Intrinsics.checkNotNullParameter(action, "action");
        closeable = Files.newDirectoryStream((Path)((Object)closeable), (String)((Object)throwable));
        throwable = null;
        try {
            Object object;
            DirectoryStream it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                action.invoke((Path)element$iv);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (closeable != null) {
                    if (throwable == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable5) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable4;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void forEachDirectoryEntry$default(Path $this$forEachDirectoryEntry_u24default, String glob, Function1 action, int n, Object object) throws IOException {
        Iterator iterator2;
        if ((n & 1) != 0) {
            glob = "*";
        }
        Intrinsics.checkNotNullParameter($this$forEachDirectoryEntry_u24default, "<this>");
        Intrinsics.checkNotNullParameter(glob, "glob");
        Intrinsics.checkNotNullParameter(action, "action");
        Closeable closeable = Files.newDirectoryStream($this$forEachDirectoryEntry_u24default, glob);
        object = null;
        try {
            Iterator it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            iterator2 = (Iterable)((Object)iterator2);
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                void var1_2;
                Object element$iv = iterator2.next();
                action.invoke(var1_2);
            }
        }
        catch (Throwable throwable) {
            try {
                iterator2 = throwable;
                object = throwable;
                throw iterator2;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, (Throwable)object);
                } else if (closeable != null) {
                    if (object == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final long fileSize(Path $this$fileSize) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$fileSize, "<this>");
        return Files.size(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final void deleteExisting(Path $this$deleteExisting) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$deleteExisting, "<this>");
        Files.delete(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean deleteIfExists(Path $this$deleteIfExists) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$deleteIfExists, "<this>");
        return Files.deleteIfExists(path);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createDirectory(Path $this$createDirectory, FileAttribute<?> ... attributes) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$createDirectory, "<this>");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        void v0 = var1_1;
        Path path2 = Files.createDirectory(path, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "createDirectory(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createDirectories(Path $this$createDirectories, FileAttribute<?> ... attributes) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$createDirectories, "<this>");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        void v0 = var1_1;
        Path path2 = Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "createDirectories(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.9")
    public static final Path createParentDirectories(Path $this$createParentDirectories, FileAttribute<?> ... attributes) throws IOException {
        Path path;
        block4: {
            Intrinsics.checkNotNullParameter($this$createParentDirectories, "<this>");
            Intrinsics.checkNotNullParameter(attributes, "attributes");
            Path path2 = path;
            Path parent = path.getParent();
            if (parent != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(parent, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    try {
                        FileAttribute<?>[] fileAttributeArray = Arrays.copyOf(attributes, attributes.length);
                        Intrinsics.checkNotNullExpressionValue(Files.createDirectories(parent, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(...)");
                    }
                    catch (FileAlreadyExistsException e) {
                        void var1_2;
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block4;
                        throw var1_2;
                    }
                }
            }
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path moveTo(Path $this$moveTo, Path target, CopyOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$moveTo, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        Path path2 = Files.move(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "move(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path moveTo(Path $this$moveTo, Path target, boolean overwrite2) throws IOException {
        void var1_1;
        Path path;
        void var2_3;
        CopyOption[] copyOptionArray;
        Intrinsics.checkNotNullParameter($this$moveTo, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        if (overwrite2) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            CopyOption[] overwrite2 = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray = overwrite2;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        void v2 = var2_3;
        Path path2 = Files.move(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkNotNullExpressionValue(path2, "move(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path moveTo$default(Path $this$moveTo_u24default, Path target, boolean overwrite, int n, Object copyOptionArray) throws IOException {
        void var1_1;
        Path path;
        void var3_4;
        CopyOption[] copyOptionArray2;
        void var2_2;
        if ((n & 2) != 0) {
            overwrite = false;
        }
        Intrinsics.checkNotNullParameter($this$moveTo_u24default, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        if (var2_2 != false) {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray2 = copyOptionArray;
        } else {
            copyOptionArray2 = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray2;
        void v2 = var3_4;
        Path path2 = Files.move(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkNotNullExpressionValue(path2, "move(...)");
        return path2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final FileStore fileStore(Path $this$fileStore) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$fileStore, "<this>");
        FileStore fileStore = Files.getFileStore(path);
        Intrinsics.checkNotNullExpressionValue(fileStore, "getFileStore(...)");
        return fileStore;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Object getAttribute(Path $this$getAttribute, String attribute, LinkOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$getAttribute, "<this>");
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        return Files.getAttribute(path, (String)var1_1, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path setAttribute(Path $this$setAttribute, String attribute, Object value, LinkOption ... options) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        Intrinsics.checkNotNullParameter($this$setAttribute, "<this>");
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var3_3;
        Path path2 = Files.setAttribute(path, (String)var1_1, var2_2, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "setAttribute(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final /* synthetic */ <V extends FileAttributeView> V fileAttributesViewOrNull(Path $this$fileAttributesViewOrNull, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$fileAttributesViewOrNull, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.reifiedOperationMarker(4, "V");
        void v0 = var1_1;
        return (V)Files.getFileAttributeView(path, FileAttributeView.class, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final /* synthetic */ <V extends FileAttributeView> V fileAttributesView(Path $this$fileAttributesView, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$fileAttributesView, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.reifiedOperationMarker(4, "V");
        void v0 = var1_1;
        FileAttributeView fileAttributeView = Files.getFileAttributeView($this$fileAttributesView, FileAttributeView.class, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        if (fileAttributeView != null) {
            return (V)fileAttributeView;
        }
        Intrinsics.reifiedOperationMarker(4, "V");
        PathsKt.fileAttributeViewNotAvailable(path, FileAttributeView.class);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public static final Void fileAttributeViewNotAvailable(Path path, Class<?> attributeViewClass) {
        Path path2;
        void var1_1;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(attributeViewClass, "attributeViewClass");
        throw new UnsupportedOperationException("The desired attribute view type " + var1_1 + " is not available for the file " + path2 + '.');
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final /* synthetic */ <A extends BasicFileAttributes> A readAttributes(Path $this$readAttributes, LinkOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$readAttributes, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.reifiedOperationMarker(4, "A");
        void v0 = var1_1;
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(basicFileAttributes, "readAttributes(...)");
        return (A)basicFileAttributes;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Map<String, Object> readAttributes(Path $this$readAttributes, String attributes, LinkOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$readAttributes, "<this>");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var2_2;
        Map<String, Object> map = Files.readAttributes(path, (String)var1_1, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(map, "readAttributes(...)");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final FileTime getLastModifiedTime(Path $this$getLastModifiedTime, LinkOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$getLastModifiedTime, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        FileTime fileTime = Files.getLastModifiedTime(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(fileTime, "getLastModifiedTime(...)");
        return fileTime;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path setLastModifiedTime(Path $this$setLastModifiedTime, FileTime value) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$setLastModifiedTime, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        Path path2 = Files.setLastModifiedTime(path, (FileTime)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "setLastModifiedTime(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final UserPrincipal getOwner(Path $this$getOwner, LinkOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$getOwner, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        return Files.getOwner(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path setOwner(Path $this$setOwner, UserPrincipal value) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$setOwner, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        Path path2 = Files.setOwner(path, (UserPrincipal)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "setOwner(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Set<PosixFilePermission> getPosixFilePermissions(Path $this$getPosixFilePermissions, LinkOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$getPosixFilePermissions, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        void v0 = var1_1;
        Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(set, "getPosixFilePermissions(...)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path setPosixFilePermissions(Path $this$setPosixFilePermissions, Set<? extends PosixFilePermission> value) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$setPosixFilePermissions, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        Path path2 = Files.setPosixFilePermissions(path, (Set<PosixFilePermission>)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "setPosixFilePermissions(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createLinkPointingTo(Path $this$createLinkPointingTo, Path target) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$createLinkPointingTo, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        Path path2 = Files.createLink(path, (Path)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "createLink(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createSymbolicLinkPointingTo(Path $this$createSymbolicLinkPointingTo, Path target, FileAttribute<?> ... attributes) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$createSymbolicLinkPointingTo, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        void v0 = var2_2;
        Path path2 = Files.createSymbolicLink(path, (Path)var1_1, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "createSymbolicLink(...)");
        return path2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path readSymbolicLink(Path $this$readSymbolicLink) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$readSymbolicLink, "<this>");
        Path path2 = Files.readSymbolicLink(path);
        Intrinsics.checkNotNullExpressionValue(path2, "readSymbolicLink(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createFile(Path $this$createFile, FileAttribute<?> ... attributes) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$createFile, "<this>");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        void v0 = var1_1;
        Path path2 = Files.createFile(path, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "createFile(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attributes) throws IOException {
        void var1_1;
        String string;
        void var2_2;
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        void v0 = var2_2;
        Path path = Files.createTempFile(string, (String)var1_1, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "createTempFile(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path createTempFile$default(String prefix, String suffix, FileAttribute[] attributes, int n, Object object) throws IOException {
        void var1_1;
        String string;
        void var2_2;
        if ((n & 1) != 0) {
            prefix = null;
        }
        if ((n & 2) != 0) {
            suffix = null;
        }
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        void v0 = var2_2;
        Path path = Files.createTempFile(string, (String)var1_1, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "createTempFile(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static final Path createTempFile(Path directory, String prefix, String suffix, FileAttribute<?> ... attributes) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        if (directory != null) {
            Path path;
            Path path2 = Files.createTempFile(path, prefix, suffix, Arrays.copyOf(attributes, attributes.length));
            Intrinsics.checkNotNullExpressionValue(path2, "createTempFile(...)");
            return path2;
        }
        void v1 = var3_3;
        Path path = Files.createTempFile((String)var1_1, (String)var2_2, (FileAttribute[])Arrays.copyOf(v1, ((void)v1).length));
        Intrinsics.checkNotNullExpressionValue(path, "createTempFile(...)");
        return path;
    }

    public static /* synthetic */ Path createTempFile$default(Path path, String string, String string2, FileAttribute[] fileAttributeArray, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return PathsKt.createTempFile(path, string, string2, fileAttributeArray);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createTempDirectory(String prefix, FileAttribute<?> ... attributes) throws IOException {
        String string;
        void var1_1;
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        void v0 = var1_1;
        Path path = Files.createTempDirectory(string, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "createTempDirectory(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path createTempDirectory$default(String prefix, FileAttribute[] attributes, int n, Object object) throws IOException {
        String string;
        void var1_1;
        if ((n & 1) != 0) {
            prefix = null;
        }
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        void v0 = var1_1;
        Path path = Files.createTempDirectory(string, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "createTempDirectory(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static final Path createTempDirectory(Path directory, String prefix, FileAttribute<?> ... attributes) throws IOException {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        if (directory != null) {
            Path path;
            Path path2 = Files.createTempDirectory(path, prefix, Arrays.copyOf(attributes, attributes.length));
            Intrinsics.checkNotNullExpressionValue(path2, "createTempDirectory(...)");
            return path2;
        }
        void v1 = var2_2;
        Path path = Files.createTempDirectory((String)var1_1, (FileAttribute[])Arrays.copyOf(v1, ((void)v1).length));
        Intrinsics.checkNotNullExpressionValue(path, "createTempDirectory(...)");
        return path;
    }

    public static /* synthetic */ Path createTempDirectory$default(Path path, String string, FileAttribute[] fileAttributeArray, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string = null;
        }
        return PathsKt.createTempDirectory(path, string, fileAttributeArray);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path div(Path $this$div, Path other) {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$div, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Path path2 = path.resolve((Path)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "resolve(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path div(Path $this$div, String other) {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$div, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Path path2 = path.resolve((String)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "resolve(...)");
        return path2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path Path(String path) {
        String string;
        Intrinsics.checkNotNullParameter(path, "path");
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path Path(String base, String ... subpaths) {
        String string;
        void var1_1;
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(subpaths, "subpaths");
        void v0 = var1_1;
        Path path = Paths.get(string, (String[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        return path;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path toPath(URI $this$toPath) {
        URI uRI;
        Intrinsics.checkNotNullParameter($this$toPath, "<this>");
        Path path = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @SinceKotlin(version="2.1")
    public static final Sequence<Path> walk(Path $this$walk, PathWalkOption ... options) {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$walk, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        return new PathTreeWalk(path, (PathWalkOption[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @SinceKotlin(version="2.1")
    public static final void visitFileTree(Path $this$visitFileTree, FileVisitor<Path> visitor, int maxDepth, boolean followLinks) {
        void var1_1;
        void var2_2;
        void var3_4;
        Path path;
        Intrinsics.checkNotNullParameter($this$visitFileTree, "<this>");
        Intrinsics.checkNotNullParameter(visitor, "visitor");
        Set<Object> options = followLinks ? SetsKt.setOf(FileVisitOption.FOLLOW_LINKS) : SetsKt.emptySet();
        Files.walkFileTree(path, (Set<FileVisitOption>)var3_4, (int)var2_2, (FileVisitor<? super Path>)var1_1);
    }

    public static /* synthetic */ void visitFileTree$default(Path path, FileVisitor fileVisitor, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        PathsKt.visitFileTree(path, fileVisitor, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @SinceKotlin(version="2.1")
    public static final void visitFileTree(Path $this$visitFileTree, int maxDepth, boolean followLinks, Function1<? super FileVisitorBuilder, Unit> builderAction) {
        void var2_2;
        void var1_1;
        void var3_3;
        Path path;
        Intrinsics.checkNotNullParameter($this$visitFileTree, "<this>");
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        PathsKt.visitFileTree(path, PathsKt.fileVisitor((Function1<? super FileVisitorBuilder, Unit>)var3_3), (int)var1_1, (boolean)var2_2);
    }

    public static /* synthetic */ void visitFileTree$default(Path path, int n, boolean bl, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        PathsKt.visitFileTree(path, n, bl, function1);
    }

    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @SinceKotlin(version="2.1")
    public static final FileVisitor<Path> fileVisitor(Function1<? super FileVisitorBuilder, Unit> builderAction) {
        Function1<? super FileVisitorBuilder, Unit> function1;
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        FileVisitorBuilderImpl fileVisitorBuilderImpl = new FileVisitorBuilderImpl();
        function1.invoke(fileVisitorBuilderImpl);
        return fileVisitorBuilderImpl.build();
    }
}

