/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.collections.builders.SetBuilder;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000B\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00002\u0006\u0010\u0001\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a>\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\u001d\u0010\n\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001aF\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u000e\u001a\u00020\r2\u001d\u0010\n\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\u000f\u001a\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u0005H\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u000e\u001a\u00020\rH\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0012\u001a)\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018\"\u0004\b\u0000\u0010\u00002\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0016\"\u00028\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001aI\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018\"\u0004\b\u0000\u0010\u00002\u001a\u0010\u001d\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u001bj\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u001c2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0016\"\u00028\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"T", "element", "", "setOf", "(Ljava/lang/Object;)Ljava/util/Set;", "E", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "builderAction", "buildSetInternal", "(Lkotlin/jvm/functions/Function1;)Ljava/util/Set;", "", "capacity", "(ILkotlin/jvm/functions/Function1;)Ljava/util/Set;", "createSetBuilder", "()Ljava/util/Set;", "(I)Ljava/util/Set;", "builder", "build", "(Ljava/util/Set;)Ljava/util/Set;", "", "elements", "Ljava/util/TreeSet;", "sortedSetOf", "([Ljava/lang/Object;)Ljava/util/TreeSet;", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "comparator", "(Ljava/util/Comparator;[Ljava/lang/Object;)Ljava/util/TreeSet;"}, xs="kotlin/collections/SetsKt")
class SetsKt__SetsJVMKt {
    public static final <T> Set<T> setOf(T element) {
        Set<T> set = Collections.singleton(element);
        Intrinsics.checkNotNullExpressionValue(set, "singleton(...)");
        return set;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final <E> Set<E> buildSetInternal(Function1<? super Set<E>, Unit> builderAction) {
        Function1<Set<E>, Unit> function1;
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        Set<E> set = SetsKt.createSetBuilder();
        function1.invoke(set);
        return SetsKt.build(set);
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final <E> Set<E> buildSetInternal(int capacity, Function1<? super Set<E>, Unit> builderAction) {
        void var1_2;
        int n;
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        Set<E> set = SetsKt.createSetBuilder(n);
        var1_2.invoke(set);
        return SetsKt.build(set);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    public static final <E> Set<E> createSetBuilder() {
        return new SetBuilder();
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    public static final <E> Set<E> createSetBuilder(int capacity) {
        int n;
        return new SetBuilder(n);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    public static final <E> Set<E> build(Set<E> builder) {
        Set<E> set;
        Intrinsics.checkNotNullParameter(builder, "builder");
        return ((SetBuilder)set).build();
    }

    public static final <T> TreeSet<T> sortedSetOf(T ... elements) {
        T[] TArray;
        Intrinsics.checkNotNullParameter(elements, "elements");
        return (TreeSet)ArraysKt.toCollection(TArray, (Collection)new TreeSet());
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> TreeSet<T> sortedSetOf(Comparator<? super T> comparator, T ... elements) {
        Comparator<? super T> comparator2;
        void var1_1;
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        Intrinsics.checkNotNullParameter(elements, "elements");
        return (TreeSet)ArraysKt.toCollection(var1_1, (Collection)new TreeSet<T>(comparator2));
    }
}

