/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.runtime.Immutable;
import kotlin.jvm.internal.Intrinsics;

@Immutable
final class StartDelayVectorizedAnimationSpec<V extends AnimationVector>
implements VectorizedAnimationSpec<V> {
    private final VectorizedAnimationSpec<V> vectorizedAnimationSpec;
    private final long startDelayNanos;

    /*
     * WARNING - void declaration
     */
    public StartDelayVectorizedAnimationSpec(VectorizedAnimationSpec<V> vectorizedAnimationSpec, long startDelayNanos) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(vectorizedAnimationSpec, (String)"vectorizedAnimationSpec");
        this.vectorizedAnimationSpec = var1_1;
        this.startDelayNanos = var2_2;
    }

    @Override
    public final boolean isInfinite() {
        return this.vectorizedAnimationSpec.isInfinite();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getDurationNanos(V initialValue, V targetValue, V initialVelocity) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.vectorizedAnimationSpec.getDurationNanos(var1_1, var2_2, var3_3) + this.startDelayNanos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getVelocityFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (playTimeNanos < this.startDelayNanos) {
            return initialVelocity;
        }
        return this.vectorizedAnimationSpec.getVelocityFromNanos((long)(var1_1 - this.startDelayNanos), var3_2, (void)targetValue, (void)initialVelocity);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getValueFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (playTimeNanos < this.startDelayNanos) {
            return initialValue;
        }
        return this.vectorizedAnimationSpec.getValueFromNanos((long)(var1_1 - this.startDelayNanos), var3_2, (void)targetValue, (void)initialVelocity);
    }

    public final int hashCode() {
        return 31 * this.vectorizedAnimationSpec.hashCode() + Long.hashCode(this.startDelayNanos);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (!(other instanceof StartDelayVectorizedAnimationSpec)) {
            return false;
        }
        return ((StartDelayVectorizedAnimationSpec)other).startDelayNanos == this.startDelayNanos && Intrinsics.areEqual(((StartDelayVectorizedAnimationSpec)var1_1).vectorizedAnimationSpec, this.vectorizedAnimationSpec);
    }
}

