/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@StabilityInferred(parameters=3)
public final class DecayAnimation<T, V extends AnimationVector>
implements Animation<T, V> {
    private final VectorizedDecayAnimationSpec<V> animationSpec;
    private final TwoWayConverter<T, V> typeConverter;
    private final T initialValue;
    private final V initialValueVector;
    private final V initialVelocityVector;
    private final V endVelocity;
    private final T targetValue;
    private final long durationNanos;
    private final boolean isInfinite;

    /*
     * WARNING - void declaration
     */
    private DecayAnimation(VectorizedDecayAnimationSpec<V> animationSpec, TwoWayConverter<T, V> typeConverter, T initialValue, V initialVelocityVector) {
        void var3_5;
        void var2_3;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, (String)"initialVelocityVector");
        this.animationSpec = animationSpec;
        this.typeConverter = var2_3;
        this.initialValue = var3_5;
        animationSpec = this;
        ((DecayAnimation)animationSpec).initialValueVector = (AnimationVector)((DecayAnimation)animationSpec).typeConverter.getConvertToVector().invoke(this.initialValue);
        this.initialVelocityVector = AnimationVectorsKt.copy(initialVelocityVector);
        animationSpec = this;
        ((DecayAnimation)animationSpec).targetValue = ((DecayAnimation)animationSpec).typeConverter.getConvertFromVector().invoke(this.animationSpec.getTargetValue(this.initialValueVector, initialVelocityVector));
        this.durationNanos = this.animationSpec.getDurationNanos(this.initialValueVector, initialVelocityVector);
        animationSpec = this;
        this.endVelocity = AnimationVectorsKt.copy(this.animationSpec.getVelocityFromNanos(((DecayAnimation)animationSpec).durationNanos, this.initialValueVector, initialVelocityVector));
        int n = ((AnimationVector)this.endVelocity).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            V v = this.endVelocity;
            ((AnimationVector)v).set$animation_core(i, RangesKt.coerceIn((float)((AnimationVector)v).get$animation_core(i), (float)(-this.animationSpec.getAbsVelocityThreshold()), (float)this.animationSpec.getAbsVelocityThreshold()));
        }
    }

    @Override
    public final TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public final T getTargetValue() {
        return this.targetValue;
    }

    @Override
    public final long getDurationNanos() {
        return this.durationNanos;
    }

    @Override
    public final boolean isInfinite() {
        return this.isInfinite;
    }

    /*
     * WARNING - void declaration
     */
    public DecayAnimation(DecayAnimationSpec<T> animationSpec, TwoWayConverter<T, V> typeConverter, T initialValue, V initialVelocityVector) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, (String)"initialVelocityVector");
        this(var1_1.vectorize(typeConverter), (TwoWayConverter<void, V>)var2_2, var3_3, initialVelocityVector);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T getValueFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            void var1_1;
            DecayAnimation decayAnimation = this;
            return (T)decayAnimation.typeConverter.getConvertFromVector().invoke(this.animationSpec.getValueFromNanos((long)var1_1, this.initialValueVector, this.initialVelocityVector));
        }
        DecayAnimation decayAnimation = this;
        return decayAnimation.targetValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getVelocityVectorFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            void var1_1;
            return this.animationSpec.getVelocityFromNanos((long)var1_1, this.initialValueVector, this.initialVelocityVector);
        }
        return this.endVelocity;
    }
}

