/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.jvm.internal.SourceDebugExtension;

@Immutable
@SourceDebugExtension(value={"SMAP\nEasing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Easing.kt\nandroidx/compose/animation/core/CubicBezierEasing\n+ 2 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 3 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 4 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n+ 5 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,172:1\n33#2,7:173\n48#3:180\n54#3:182\n22#4:181\n22#4:183\n71#5,16:184\n*S KotlinDebug\n*F\n+ 1 Easing.kt\nandroidx/compose/animation/core/CubicBezierEasing\n*L\n115#1:173,7\n120#1:180\n121#1:182\n120#1:181\n121#1:183\n149#1:184,16\n*E\n"})
public final class CubicBezierEasing
implements Easing {
    private final float a;
    private final float b;
    private final float c;
    private final float d;
    private final float min;
    private final float max;

    /*
     * WARNING - void declaration
     */
    public CubicBezierEasing(float a2, float b, float c, float d) {
        void var1_3;
        void var3_6;
        void var2_5;
        this.a = a2;
        this.b = var2_5;
        this.c = var3_6;
        this.d = d;
        boolean a2 = !Float.isNaN(this.a) && !Float.isNaN(this.b) && !Float.isNaN(this.c) && !Float.isNaN(this.d);
        if (!a2) {
            PreconditionsKt.throwIllegalArgumentException("Parameters to CubicBezierEasing cannot be NaN. Actual parameters are: " + this.a + ", " + this.b + ", " + this.c + ", " + this.d + '.');
        }
        float[] roots = new float[5];
        long extrema = BezierKt.computeCubicVerticalBounds((float)0.0f, (float)this.b, (float)this.d, (float)1.0f, (float[])var1_3, (int)0);
        int n = (int)(extrema >> 32);
        this.min = Float.intBitsToFloat(n);
        n = (int)(extrema & 0xFFFFFFFFL);
        this.max = Float.intBitsToFloat(n);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final float transform(float fraction) {
        float f;
        void var1_1;
        if (fraction > 0.0f && fraction < 1.0f) {
            void minimumValue$iv;
            void v23;
            float $this$fastCoerceAtMost$iv$iv;
            void $this$fastCoerceIn$iv;
            float t2;
            float f2;
            double d;
            double d2;
            float f3 = 1.0f - fraction;
            float f4 = this.c - fraction;
            float f5 = this.a - fraction;
            float f6 = 0.0f - fraction;
            double d3 = 3.0 * ((double)f6 - 2.0 * (double)f5 + (double)f4);
            double d4 = 3.0 * (double)(f5 - f6);
            double d5 = f6;
            double d6 = d2 = (double)(-f6) + 3.0 * (double)(f5 - f4) + (double)f3;
            if (Math.abs(d - 0.0) < 1.0E-7) {
                double d7;
                d6 = d3;
                if (Math.abs(d7 - 0.0) < 1.0E-7) {
                    double d8;
                    d6 = d4;
                    if (Math.abs(d8 - 0.0) < 1.0E-7) {
                        f2 = Float.NaN;
                    } else {
                        float f7;
                        float f8 = (float)(-d5 / d4);
                        f2 = f7 < 0.0f ? (f8 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f8 > 1.0f ? (f8 <= 1.0000008f ? 1.0f : Float.NaN) : f8);
                    }
                } else {
                    float f9;
                    float f10;
                    double d9 = d4;
                    d6 = Math.sqrt(d9 * d9 - 4.0 * d3 * d5);
                    double d10 = 2.0 * d3;
                    float f11 = (float)((d6 - d4) / d10);
                    float f12 = f10 < 0.0f ? (f11 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f11 > 1.0f ? (f11 <= 1.0000008f ? 1.0f : Float.NaN) : (f9 = f11));
                    if (!Float.isNaN(f12)) {
                        f2 = f9;
                    } else {
                        float f13;
                        f11 = (float)((-d4 - d6) / d10);
                        f2 = f13 < 0.0f ? (f11 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f11 > 1.0f ? (f11 <= 1.0000008f ? 1.0f : Float.NaN) : f11);
                    }
                }
            } else {
                double d11 = d3 /= d2;
                d6 = (3.0 * (d4 /= d2) - d11 * d11) / 9.0;
                double d12 = (2.0 * d3 * d3 * d3 - 9.0 * d3 * d4 + 27.0 * (d5 /= d2)) / 54.0;
                double d13 = d6;
                double d14 = d12 * d12 + d13 * d13 * d6;
                double d15 = d3 / 3.0;
                if (d14 < 0.0) {
                    float f14;
                    double d16;
                    double d17;
                    double d18 = d6;
                    double d19 = -(d18 * d18 * d6);
                    double d20 = Math.sqrt(d19);
                    double d21 = d17 = -d12 / d20;
                    double d22 = d17;
                    d22 = d16 < -1.0 ? -1.0 : d22;
                    double d23 = d22 > 1.0 ? 1.0 : d22;
                    d21 = Math.acos(d23);
                    f6 = 2.0f * MathHelpersKt.fastCbrt((float)((float)d20));
                    f5 = (float)((double)f6 * Math.cos(d21 / 3.0) - d15);
                    float f15 = f14 < 0.0f ? (f5 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f5 > 1.0f ? (f5 <= 1.0000008f ? 1.0f : Float.NaN) : (f5 = f5));
                    if (!Float.isNaN(f15)) {
                        f2 = f5;
                    } else {
                        float f16;
                        f5 = (float)((double)f6 * Math.cos((d21 + Math.PI * 2) / 3.0) - d15);
                        float f17 = f16 < 0.0f ? (f5 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f5 > 1.0f ? (f5 <= 1.0000008f ? 1.0f : Float.NaN) : (f5 = f5));
                        if (!Float.isNaN(f17)) {
                            f2 = f5;
                        } else {
                            float f18;
                            f5 = (float)((double)f6 * Math.cos((d21 + Math.PI * 4) / 3.0) - d15);
                            f2 = f18 < 0.0f ? (f5 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f5 > 1.0f ? (f5 <= 1.0000008f ? 1.0f : Float.NaN) : f5);
                        }
                    }
                } else if (d14 == 0.0) {
                    float f19;
                    float f20;
                    float f21 = -MathHelpersKt.fastCbrt((float)((float)d12));
                    float f22 = 2.0f * f21 - (float)d15;
                    float f23 = f20 < 0.0f ? (f22 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f22 > 1.0f ? (f22 <= 1.0000008f ? 1.0f : Float.NaN) : (f19 = f22));
                    if (!Float.isNaN(f23)) {
                        f2 = f19;
                    } else {
                        float f24;
                        f22 = -f21 - (float)d15;
                        f2 = f24 < 0.0f ? (f22 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f22 > 1.0f ? (f22 <= 1.0000008f ? 1.0f : Float.NaN) : f22);
                    }
                } else {
                    float f25;
                    double d24 = Math.sqrt(d14);
                    float f26 = MathHelpersKt.fastCbrt((float)((float)(-d12 + d24)));
                    float f27 = MathHelpersKt.fastCbrt((float)((float)(d12 + d24)));
                    float f28 = (float)((double)(f26 - f27) - d15);
                    f2 = f25 < 0.0f ? (f28 >= -8.34465E-7f ? 0.0f : Float.NaN) : (f28 > 1.0f ? (f28 <= 1.0000008f ? 1.0f : Float.NaN) : (t2 = f28));
                }
            }
            if (Float.isNaN(f2)) {
                f5 = fraction;
                CubicBezierEasing t2 = this;
                throw new IllegalArgumentException("The cubic curve with parameters (" + t2.a + ", " + t2.b + ", " + t2.c + ", " + t2.d + ") has no solution at " + f5);
            }
            f4 = t2;
            f5 = this.d;
            t2 = this.b;
            f3 = 0.33333334f + (t2 - f5);
            float f29 = f5 - 2.0f * t2;
            float f30 = t2;
            fraction = 3.0f * ((f3 * f4 + f29) * f4 + f30) * f4;
            t2 = this.min;
            float maximumValue$iv = this.max;
            void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
            float f31 = $this$fastCoerceAtMost$iv$iv = v23 < minimumValue$iv ? f6 : $this$fastCoerceAtLeast$iv$iv;
            if (!(f31 > maximumValue$iv)) return (float)var1_1;
            f = f5;
            return f;
        } else {
            f = var1_1;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof CubicBezierEasing && this.a == ((CubicBezierEasing)other).a && this.b == ((CubicBezierEasing)other).b && this.c == ((CubicBezierEasing)other).c && this.d == ((CubicBezierEasing)var1_1).d;
    }

    public final int hashCode() {
        return ((Float.hashCode(this.a) * 31 + Float.hashCode(this.b)) * 31 + Float.hashCode(this.c)) * 31 + Float.hashCode(this.d);
    }

    public final String toString() {
        return "CubicBezierEasing(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ')';
    }
}

