/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.StringOpsKt;

public final class JsonToStringWriter
implements InternalJsonWriter {
    private char[] array = CharArrayPool.INSTANCE.take();
    private int size;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeLong(long value) {
        void var1_1;
        this.write(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeChar(char c) {
        void var1_1;
        this.ensureAdditionalCapacity(1);
        int n = this.size;
        this.size = n + 1;
        this.array[n] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(String text) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int length = text.length();
        if (length == 0) {
            return;
        }
        this.ensureAdditionalCapacity(length);
        String string = text;
        char[] cArray = this.array;
        int n = this.size;
        int n2 = var1_1.length();
        string.getChars(0, n2, cArray, n);
        this.size += var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeQuoted(String text) {
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ensureAdditionalCapacity(((String)text).length() + 2);
        char[] arr2 = this.array;
        int sz = this.size;
        arr2[sz++] = 34;
        int length = ((String)text).length();
        String string = text;
        string.getChars(0, length, arr2, sz);
        int n = sz + length;
        for (int i = sz; i < n; ++i) {
            char ch = arr2[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            int n2 = i - sz;
            String string2 = text;
            sz = i;
            int arr2 = n2;
            text = this;
            i = string2.length();
            while (arr2 < i) {
                byte by;
                sz = super.ensureTotalCapacity(sz, 2);
                char c = string2.charAt(arr2);
                if (c < StringOpsKt.getESCAPE_MARKERS().length && (by = StringOpsKt.getESCAPE_MARKERS()[c]) != 0) {
                    if (by == 1) {
                        String string3;
                        Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[c]);
                        sz = super.ensureTotalCapacity(sz, string3.length());
                        String string4 = string3;
                        char[] cArray = ((JsonToStringWriter)text).array;
                        int n3 = string3.length();
                        string4.getChars(0, n3, cArray, sz);
                        ((JsonToStringWriter)text).size = sz += string3.length();
                    } else {
                        ((JsonToStringWriter)text).array[sz] = 92;
                        ((JsonToStringWriter)text).array[sz + 1] = (char)by;
                        ((JsonToStringWriter)text).size = sz += 2;
                    }
                } else {
                    ((JsonToStringWriter)text).array[sz++] = c;
                }
                ++arr2;
            }
            sz = super.ensureTotalCapacity(sz, 1);
            ((JsonToStringWriter)text).array[sz++] = 34;
            ((JsonToStringWriter)text).size = sz;
            return;
        }
        sz = n;
        var2_2[sz++] = 34;
        this.size = var3_4;
    }

    public final void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }

    public final String toString() {
        return new String(this.array, 0, this.size);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureAdditionalCapacity(int expected) {
        void var1_1;
        JsonToStringWriter jsonToStringWriter = this;
        jsonToStringWriter.ensureTotalCapacity(jsonToStringWriter.size, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final int ensureTotalCapacity(int oldSize, int additional) {
        void var1_1;
        int newSize = oldSize + additional;
        if (this.array.length <= newSize) {
            void var2_2;
            char[] cArray = Arrays.copyOf(this.array, RangesKt.coerceAtLeast((int)var2_2, (int)(oldSize * 2)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(...)");
            this.array = cArray;
        }
        return (int)var1_1;
    }
}

