/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;

public final class JsonPath {
    private Object[] currentObjectPath = new Object[8];
    private int[] indicies;
    private int currentDepth;

    public JsonPath() {
        int n = 0;
        int[] nArray = new int[8];
        JsonPath jsonPath = this;
        while (n < 8) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        jsonPath.indicies = nArray;
        this.currentDepth = -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDescriptor(SerialDescriptor sd) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sd, (String)"sd");
        ++this.currentDepth;
        int depth = this.currentDepth;
        if (depth == this.currentObjectPath.length) {
            this.resize();
        }
        this.currentObjectPath[var2_2] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateDescriptorIndex(int index) {
        void var1_1;
        this.indicies[this.currentDepth] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCurrentMapKey(Object key) {
        void var1_1;
        if (this.indicies[this.currentDepth] != -2) {
            ++this.currentDepth;
            if (this.currentDepth == this.currentObjectPath.length) {
                this.resize();
            }
        }
        this.currentObjectPath[this.currentDepth] = var1_1;
        this.indicies[this.currentDepth] = -2;
    }

    public final void resetCurrentMapKey() {
        if (this.indicies[this.currentDepth] == -2) {
            this.currentObjectPath[this.currentDepth] = Tombstone.INSTANCE;
        }
    }

    public final void popDescriptor() {
        int n;
        int depth = this.currentDepth;
        if (this.indicies[depth] == -2) {
            this.indicies[n] = -1;
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
        if (this.currentDepth != -1) {
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
    }

    public final String getPath() {
        StringBuilder stringBuilder;
        StringBuilder $this$getPath_u24lambda_u241 = stringBuilder = new StringBuilder();
        stringBuilder.append("$");
        int n = this.currentDepth + 1;
        for (int i = 0; i < n; ++i) {
            int it = i;
            Object element = this.currentObjectPath[it];
            if (element instanceof SerialDescriptor) {
                if (Intrinsics.areEqual((Object)((SerialDescriptor)element).getKind(), (Object)StructureKind.LIST.INSTANCE)) {
                    if (this.indicies[it] == -1) continue;
                    $this$getPath_u24lambda_u241.append("[");
                    $this$getPath_u24lambda_u241.append(this.indicies[it]);
                    $this$getPath_u24lambda_u241.append("]");
                    continue;
                }
                int idx = this.indicies[it];
                if (idx < 0) continue;
                $this$getPath_u24lambda_u241.append(".");
                $this$getPath_u24lambda_u241.append(((SerialDescriptor)element).getElementName(idx));
                continue;
            }
            if (element == Tombstone.INSTANCE) continue;
            $this$getPath_u24lambda_u241.append("[");
            $this$getPath_u24lambda_u241.append("'");
            $this$getPath_u24lambda_u241.append(element);
            $this$getPath_u24lambda_u241.append("'");
            $this$getPath_u24lambda_u241.append("]");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void resize() {
        void var1_1;
        int newSize = this.currentDepth * 2;
        Object[] objectArray = Arrays.copyOf(this.currentObjectPath, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        this.currentObjectPath = objectArray;
        int[] nArray = Arrays.copyOf(this.indicies, (int)var1_1);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.indicies = nArray;
    }

    public final String toString() {
        return this.getPath();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lkotlinx/serialization/json/internal/JsonPath$Tombstone;", "", "<init>", "()V"})
    private static final class Tombstone {
        public static final Tombstone INSTANCE = new Tombstone();

        private Tombstone() {
        }
    }
}

