/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonNames;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.DescriptorSchemaCache;
import kotlinx.serialization.json.internal.JsonException;

@SourceDebugExtension(value={"SMAP\nJsonNamesMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n808#2,11:153\n13409#3,2:164\n1#4:166\n*S KotlinDebug\n*F\n+ 1 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n*L\n35#1:153,11\n35#1:164,2\n*E\n"})
public final class JsonNamesMapKt {
    private static final DescriptorSchemaCache.Key<Map<String, Integer>> JsonDeserializationNamesKey = new DescriptorSchemaCache.Key();
    private static final DescriptorSchemaCache.Key<String[]> JsonSerializationNamesKey = new DescriptorSchemaCache.Key();

    public static final DescriptorSchemaCache.Key<Map<String, Integer>> getJsonDeserializationNamesKey() {
        return JsonDeserializationNamesKey;
    }

    /*
     * WARNING - void declaration
     */
    public static final Map<String, Integer> deserializationNamesMap(Json $this$deserializationNamesMap, SerialDescriptor descriptor) {
        Json json;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$deserializationNamesMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return JsonSchemaCacheKt.getSchemaCache($this$deserializationNamesMap).getOrPut(descriptor, JsonDeserializationNamesKey, () -> JsonNamesMapKt.deserializationNamesMap$lambda$3((SerialDescriptor)var1_1, json));
    }

    /*
     * WARNING - void declaration
     */
    public static final String getJsonElementName(SerialDescriptor $this$getJsonElementName, Json json, int index) {
        void var2_2;
        void var3_3;
        void var1_1;
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$getJsonElementName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy($this$getJsonElementName, json);
        if (strategy == null) {
            return $this$getJsonElementName.getElementName(index);
        }
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"json");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"strategy");
        return JsonSchemaCacheKt.getSchemaCache((Json)var1_1).getOrPut(serialDescriptor, JsonSerializationNamesKey, () -> JsonNamesMapKt.serializationNamesIndices$lambda$4(serialDescriptor, (JsonNamingStrategy)var3_3))[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public static final JsonNamingStrategy namingStrategy(SerialDescriptor $this$namingStrategy, Json json) {
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$namingStrategy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)StructureKind.CLASS.INSTANCE)) {
            void var1_1;
            return var1_1.getConfiguration().getNamingStrategy();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final int getJsonNameIndexSlowPath(SerialDescriptor $this$getJsonNameIndexSlowPath, Json json, String name) {
        void var2_2;
        SerialDescriptor serialDescriptor;
        Integer n = JsonNamesMapKt.deserializationNamesMap(json, serialDescriptor).get(var2_2);
        if (n != null) {
            return n;
        }
        return -3;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean decodeCaseInsensitive(Json $this$decodeCaseInsensitive, SerialDescriptor descriptor) {
        void var1_1;
        return $this$decodeCaseInsensitive.getConfiguration().getDecodeEnumsCaseInsensitive() && Intrinsics.areEqual((Object)var1_1.getKind(), (Object)SerialKind.ENUM.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public static final int getJsonNameIndex(SerialDescriptor $this$getJsonNameIndex, Json json, String name) {
        void var2_2;
        void var1_1;
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$getJsonNameIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (JsonNamesMapKt.decodeCaseInsensitive(json, $this$getJsonNameIndex)) {
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return JsonNamesMapKt.getJsonNameIndexSlowPath($this$getJsonNameIndex, json, string);
        }
        JsonNamingStrategy jsonNamingStrategy = JsonNamesMapKt.namingStrategy($this$getJsonNameIndex, json);
        if (jsonNamingStrategy != null) {
            return JsonNamesMapKt.getJsonNameIndexSlowPath($this$getJsonNameIndex, json, name);
        }
        int index = $this$getJsonNameIndex.getElementIndex(name);
        if (index != -3) {
            return index;
        }
        if (!json.getConfiguration().getUseAlternativeNames()) {
            void var3_4;
            return (int)var3_4;
        }
        return JsonNamesMapKt.getJsonNameIndexSlowPath(serialDescriptor, (Json)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final int getJsonNameIndexOrThrow(SerialDescriptor $this$getJsonNameIndexOrThrow, Json json, String name, String suffix) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)$this$getJsonNameIndexOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        int index = JsonNamesMapKt.getJsonNameIndex($this$getJsonNameIndexOrThrow, json, name);
        if (index == -3) {
            void var3_4;
            void var2_3;
            SerialDescriptor serialDescriptor;
            throw new SerializationException(serialDescriptor.getSerialName() + " does not contain element with name '" + (String)var2_3 + '\'' + (String)var3_4);
        }
        return (int)var1_2;
    }

    public static /* synthetic */ int getJsonNameIndexOrThrow$default$2475c0f4(SerialDescriptor serialDescriptor, Json json, String string, String string2, int n) {
        string2 = "";
        return JsonNamesMapKt.getJsonNameIndexOrThrow(serialDescriptor, json, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildDeserializationNamesMap$putOrThrow(Map<String, Integer> $this$buildDeserializationNamesMap_u24putOrThrow, SerialDescriptor $this_buildDeserializationNamesMap, String name, int index) {
        void var2_2;
        Map<String, Integer> map;
        void var3_3;
        Integer n;
        String entity;
        String string = entity = Intrinsics.areEqual((Object)$this_buildDeserializationNamesMap.getKind(), (Object)SerialKind.ENUM.INSTANCE) ? "enum value" : "property";
        if ($this$buildDeserializationNamesMap_u24putOrThrow.containsKey(name)) {
            throw new JsonException("The suggested name '" + name + "' for " + entity + ' ' + $this_buildDeserializationNamesMap.getElementName(index) + " is already one of the names for " + entity + ' ' + $this_buildDeserializationNamesMap.getElementName(((Number)MapsKt.getValue($this$buildDeserializationNamesMap_u24putOrThrow, (Object)name)).intValue()) + " in " + n);
        }
        n = (int)var3_3;
        map.put((String)var2_2, n);
    }

    private static final Map deserializationNamesMap$lambda$3(SerialDescriptor $descriptor, Json $this_deserializationNamesMap) {
        JsonNamingStrategy jsonNamingStrategy;
        SerialDescriptor serialDescriptor = $descriptor;
        Map map = new LinkedHashMap();
        boolean bl = JsonNamesMapKt.decodeCaseInsensitive((Json)((Object)jsonNamingStrategy), serialDescriptor);
        jsonNamingStrategy = JsonNamesMapKt.namingStrategy(serialDescriptor, (Json)((Object)jsonNamingStrategy));
        int n = serialDescriptor.getElementsCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3 = (String[])serialDescriptor.getElementAnnotations(i);
            Collection collection = new ArrayList();
            Object object4 = object3.iterator();
            while (object4.hasNext()) {
                object2 = object4.next();
                if (!(object2 instanceof JsonNames)) continue;
                collection.add(object2);
            }
            String[] stringArray = (String[])CollectionsKt.singleOrNull((List)((List)collection));
            if (stringArray != null && (stringArray = stringArray.names()) != null) {
                object3 = stringArray;
                int n2 = ((String[])object3).length;
                for (int j = 0; j < n2; ++j) {
                    Object object5;
                    object2 = object4 = object3[j];
                    if (bl) {
                        String string = ((String)object2).toLowerCase(Locale.ROOT);
                        object5 = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    } else {
                        object5 = object2;
                    }
                    JsonNamesMapKt.buildDeserializationNamesMap$putOrThrow(map, serialDescriptor, (String)object5, i);
                }
            }
            if (bl) {
                String string = serialDescriptor.getElementName(i).toLowerCase(Locale.ROOT);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            } else {
                JsonNamingStrategy jsonNamingStrategy2 = jsonNamingStrategy;
                if (jsonNamingStrategy2 != null) {
                    SerialDescriptor serialDescriptor2 = serialDescriptor;
                    object = jsonNamingStrategy2.serialNameForJson$6575d912(serialDescriptor2, serialDescriptor2.getElementName(i));
                } else {
                    object = object3 = null;
                }
            }
            if (object == null) continue;
            object3 = object;
            JsonNamesMapKt.buildDeserializationNamesMap$putOrThrow(map, serialDescriptor, (String)object3, i);
        }
        Map map2 = map;
        if (map2.isEmpty()) {
            return MapsKt.emptyMap();
        }
        return map2;
    }

    private static final String[] serializationNamesIndices$lambda$4(SerialDescriptor $this_serializationNamesIndices, JsonNamingStrategy $strategy) {
        int n = 0;
        int n2 = $this_serializationNamesIndices.getElementsCount();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            String baseName = $this_serializationNamesIndices.getElementName(n3);
            stringArray[n3] = $strategy.serialNameForJson$6575d912($this_serializationNamesIndices, baseName);
        }
        return stringArray;
    }
}

