/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\b\u0010\u0005\u001a%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\b\u0010\u000b\u001a)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0002*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a+\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0011*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a#\u0010\u0018\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001aE\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u001c\u0010\u001c\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u001aj\b\u0012\u0004\u0012\u00020\u0003`\u001b0\u00122\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a=\u0010 \u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u001c\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\u001aj\b\u0012\u0004\u0012\u00020\u000e`\u001b0\u0012H\u0002\u00a2\u0006\u0004\b \u0010!\u001a+\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b#\u0010$\u001a+\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b%\u0010$\u001a\u001b\u0010&\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b&\u0010'"}, d2={"", "header", "", "Lio/ktor/http/HeaderValue;", "parseAndSortHeader", "(Ljava/lang/String;)Ljava/util/List;", "parseAndSortContentTypeHeader", "text", "parseHeaderValue", "", "parametersOnly", "(Ljava/lang/String;Z)Ljava/util/List;", "", "Lkotlin/Pair;", "Lio/ktor/http/HeaderValueParam;", "toHeaderParamsList", "(Ljava/lang/Iterable;)Ljava/util/List;", "T", "Lkotlin/Lazy;", "valueOrEmpty", "(Lkotlin/Lazy;)Ljava/util/List;", "", "start", "end", "subtrim", "(Ljava/lang/String;II)Ljava/lang/String;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "items", "parseHeaderValueItem", "(Ljava/lang/String;ILkotlin/Lazy;Z)I", "parameters", "parseHeaderValueParameter", "(Ljava/lang/String;ILkotlin/Lazy;)I", "value", "parseHeaderValueParameterValue", "(Ljava/lang/String;I)Lkotlin/Pair;", "parseHeaderValueParameterValueQuoted", "nextIsSemicolonOrEnd", "(Ljava/lang/String;I)Z"})
@SourceDebugExtension(value={"SMAP\nHttpHeaderValueParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpHeaderValueParser.kt\nio/ktor/http/HttpHeaderValueParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1062#2:225\n1557#2:226\n1628#2,3:227\n*S KotlinDebug\n*F\n+ 1 HttpHeaderValueParser.kt\nio/ktor/http/HttpHeaderValueParserKt\n*L\n49#1:225\n96#1:226\n96#1:227,3\n*E\n"})
public final class HttpHeaderValueParserKt {
    public static final List<HeaderValue> parseAndSortHeader(String header) {
        Iterable iterable = HttpHeaderValueParserKt.parseHeaderValue(header);
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var2_2;
                Comparable comparable;
                b = (HeaderValue)b;
                HeaderValue it = (HeaderValue)((Object)comparable);
                comparable = Double.valueOf(((HeaderValue)b).getQuality());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(var2_2.getQuality()));
            }
        });
    }

    public static final List<HeaderValue> parseAndSortContentTypeHeader(String header) {
        Object object = new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var2_2;
                Comparable comparable;
                b = (HeaderValue)b;
                HeaderValue it = (HeaderValue)((Object)comparable);
                comparable = Double.valueOf(((HeaderValue)b).getQuality());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(var2_2.getQuality()));
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                void var1_1;
                this.$this_thenBy = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var3_3;
                void var1_1;
                Comparable comparable;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    return previousCompare;
                }
                HeaderValue it = (HeaderValue)a;
                ContentType contentType = ContentType.Companion.parse(it.getValue());
                int asterisks = 0;
                if (Intrinsics.areEqual((Object)contentType.getContentType(), (Object)"*")) {
                    asterisks += 2;
                }
                if (Intrinsics.areEqual((Object)contentType.getContentSubtype(), (Object)"*")) {
                    ++asterisks;
                }
                it = (HeaderValue)((Object)comparable);
                comparable = Integer.valueOf(asterisks);
                contentType = ContentType.Companion.parse(it.getValue());
                asterisks = 0;
                if (Intrinsics.areEqual((Object)contentType.getContentType(), (Object)"*")) {
                    asterisks += 2;
                }
                if (Intrinsics.areEqual((Object)var1_1.getContentSubtype(), (Object)"*")) {
                    ++asterisks;
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf((int)var3_3));
            }
        };
        return CollectionsKt.sortedWith((Iterable)HttpHeaderValueParserKt.parseHeaderValue(header), (Comparator)new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                void var1_1;
                this.$this_thenByDescending = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var2_2;
                Comparable comparable;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    void var3_3;
                    return (int)var3_3;
                }
                b = (HeaderValue)b;
                HeaderValue it = (HeaderValue)((Object)comparable);
                comparable = Integer.valueOf(((HeaderValue)b).getParams().size());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(var2_2.getParams().size()));
            }
        });
    }

    public static final List<HeaderValue> parseHeaderValue(String text) {
        return HttpHeaderValueParserKt.parseHeaderValue(text, false);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<HeaderValue> parseHeaderValue(String text, boolean parametersOnly) {
        void var3_3;
        if (text == null) {
            return CollectionsKt.emptyList();
        }
        int position = 0;
        Lazy items = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, HttpHeaderValueParserKt::parseHeaderValue$lambda$4);
        while (position <= StringsKt.getLastIndex((CharSequence)text)) {
            position = HttpHeaderValueParserKt.parseHeaderValueItem(text, position, (Lazy<? extends ArrayList<HeaderValue>>)items, parametersOnly);
        }
        return HttpHeaderValueParserKt.valueOrEmpty(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<HeaderValueParam> toHeaderParamsList(Iterable<Pair<String, String>> $this$toHeaderParamsList) {
        Collection collection;
        Intrinsics.checkNotNullParameter($this$toHeaderParamsList, (String)"<this>");
        Collection $this$map$iv = $this$toHeaderParamsList;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            Object item$iv$iv = object.next();
            Pair it = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            collection2.add(new HeaderValueParam((String)it.getFirst(), (String)var2_2.getSecond()));
        }
        return (List)collection;
    }

    private static final <T> List<T> valueOrEmpty(Lazy<? extends List<? extends T>> $this$valueOrEmpty) {
        if ($this$valueOrEmpty.isInitialized()) {
            Lazy<? extends List<? extends T>> lazy;
            return (List)lazy.getValue();
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static final String subtrim(String $this$subtrim, int start, int end) {
        void var2_2;
        void var1_1;
        String string = $this$subtrim.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final int parseHeaderValueItem(String text, int start, Lazy<? extends ArrayList<HeaderValue>> items, boolean parametersOnly) {
        void var1_1;
        String string;
        void var2_2;
        Integer valueEnd;
        int position = start;
        Lazy parameters = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, HttpHeaderValueParserKt::parseHeaderValueItem$lambda$6);
        Integer n = valueEnd = parametersOnly ? Integer.valueOf(start) : null;
        block4: while (position <= StringsKt.getLastIndex((CharSequence)text)) {
            switch (text.charAt(position)) {
                case ',': {
                    Integer n2 = valueEnd;
                    ((ArrayList)items.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text, start, n2 != null ? n2 : position), HttpHeaderValueParserKt.valueOrEmpty(parameters)));
                    return position + 1;
                }
                case ';': {
                    if (valueEnd == null) {
                        valueEnd = position;
                    }
                    position = HttpHeaderValueParserKt.parseHeaderValueParameter(text, position + 1, (Lazy<? extends ArrayList<HeaderValueParam>>)parameters);
                    continue block4;
                }
            }
            position = parametersOnly ? HttpHeaderValueParserKt.parseHeaderValueParameter(text, position, (Lazy<? extends ArrayList<HeaderValueParam>>)parameters) : position + 1;
        }
        Integer n3 = valueEnd;
        ((ArrayList)var2_2.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(string, (int)var1_1, n3 != null ? n3 : position), HttpHeaderValueParserKt.valueOrEmpty(parameters)));
        return position;
    }

    /*
     * WARNING - void declaration
     */
    private static final int parseHeaderValueParameter(String text, int start, Lazy<? extends ArrayList<HeaderValueParam>> parameters) {
        void var3_3;
        void var1_1;
        String string;
        void var2_2;
        int position;
        for (position = start; position <= StringsKt.getLastIndex((CharSequence)text); ++position) {
            switch (text.charAt(position)) {
                case '=': {
                    Pair<Integer, String> pair = HttpHeaderValueParserKt.parseHeaderValueParameterValue(text, position + 1);
                    int paramEnd = ((Number)pair.component1()).intValue();
                    String paramValue = (String)pair.component2();
                    HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters, text, start, position, paramValue);
                    return paramEnd;
                }
                case ',': 
                case ';': {
                    HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters, text, start, position, "");
                    return position;
                }
            }
        }
        HttpHeaderValueParserKt.parseHeaderValueParameter$addParam((Lazy<? extends ArrayList<HeaderValueParam>>)var2_2, string, (int)var1_1, position, "");
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<Integer, String> parseHeaderValueParameterValue(String value, int start) {
        void var2_2;
        void var1_1;
        String string;
        int position;
        if (value.length() == start) {
            return TuplesKt.to((Object)start, (Object)"");
        }
        if (value.charAt(start) == '\"') {
            return HttpHeaderValueParserKt.parseHeaderValueParameterValueQuoted(value, start + 1);
        }
        for (position = start; position <= StringsKt.getLastIndex((CharSequence)value); ++position) {
            switch (value.charAt(position)) {
                case ',': 
                case ';': {
                    return TuplesKt.to((Object)position, (Object)HttpHeaderValueParserKt.subtrim(value, start, position));
                }
            }
        }
        return TuplesKt.to((Object)position, (Object)HttpHeaderValueParserKt.subtrim(string, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<Integer, String> parseHeaderValueParameterValueQuoted(String value, int start) {
        void var2_2;
        void var1_1;
        int position = start;
        StringBuilder builder = new StringBuilder();
        while (position <= StringsKt.getLastIndex((CharSequence)value)) {
            void var3_3;
            char currentChar = value.charAt(position);
            if (currentChar == '\"' && HttpHeaderValueParserKt.nextIsSemicolonOrEnd(value, position)) {
                return TuplesKt.to((Object)(position + 1), (Object)builder.toString());
            }
            if (currentChar == '\\' && position < StringsKt.getLastIndex((CharSequence)value) - 2) {
                builder.append(value.charAt(position + 1));
                position += 2;
                continue;
            }
            builder.append((char)var3_3);
            ++position;
        }
        Integer n = (int)var1_1;
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        return TuplesKt.to((Object)n, (Object)("\"" + string2));
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean nextIsSemicolonOrEnd(String $this$nextIsSemicolonOrEnd, int start) {
        void var1_1;
        String string;
        int position;
        for (position = start + 1; position < $this$nextIsSemicolonOrEnd.length() && $this$nextIsSemicolonOrEnd.charAt(position) == ' '; ++position) {
        }
        return position == $this$nextIsSemicolonOrEnd.length() || string.charAt((int)var1_1) == ';';
    }

    private static final ArrayList parseHeaderValue$lambda$4() {
        return new ArrayList();
    }

    private static final ArrayList parseHeaderValueItem$lambda$6() {
        return new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    private static final void parseHeaderValueParameter$addParam(Lazy<? extends ArrayList<HeaderValueParam>> $parameters, String text, int start, int end, String value) {
        void var1_1;
        Lazy<? extends ArrayList<HeaderValueParam>> lazy;
        void var3_3;
        void var2_2;
        String name = HttpHeaderValueParserKt.subtrim(text, (int)var2_2, (int)var3_3);
        if (((CharSequence)name).length() == 0) {
            return;
        }
        ((ArrayList)lazy.getValue()).add(new HeaderValueParam((String)var1_1, value));
    }
}

