/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization.kotlinx;

import io.ktor.serialization.WebsocketContentConverter;
import io.ktor.serialization.WebsocketConverterNotFoundException;
import io.ktor.serialization.WebsocketDeserializeException;
import io.ktor.serialization.kotlinx.SerializerLookupKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameCommonKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u000e\u001a\u00020\r2\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0096@\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\n\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0096@\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J-\u0010\u0019\u001a\u00020\r2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001b"}, d2={"Lio/ktor/serialization/kotlinx/KotlinxWebsocketSerializationConverter;", "Lio/ktor/serialization/WebsocketContentConverter;", "Lkotlinx/serialization/SerialFormat;", "format", "<init>", "(Lkotlinx/serialization/SerialFormat;)V", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "Lio/ktor/util/reflect/TypeInfo;", "typeInfo", "", "value", "Lio/ktor/websocket/Frame;", "serialize", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "content", "deserialize", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Lio/ktor/websocket/Frame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "frame", "", "isApplicable", "(Lio/ktor/websocket/Frame;)Z", "Lkotlinx/serialization/KSerializer;", "serializer", "serializeContent", "(Lkotlinx/serialization/KSerializer;Lkotlinx/serialization/SerialFormat;Ljava/lang/Object;)Lio/ktor/websocket/Frame;", "Lkotlinx/serialization/SerialFormat;"})
public final class KotlinxWebsocketSerializationConverter
implements WebsocketContentConverter {
    private final SerialFormat format;

    public KotlinxWebsocketSerializationConverter(SerialFormat format) {
        String string;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.format = string;
        if (!(this.format instanceof BinaryFormat || this.format instanceof StringFormat)) {
            string = "Only binary and string formats are supported, " + this.format + " is not supported.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Object serialize(Charset charset, TypeInfo typeInfo, Object value, Continuation<? super Frame> $completion) {
        void var3_3;
        void var1_1;
        try {
            void var2_2;
            charset = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), (TypeInfo)var2_2);
        }
        catch (SerializationException serializationException) {
            charset = SerializerLookupKt.guessSerializer(value, this.format.getSerializersModule());
        }
        return this.serializeContent((KSerializer<?>)var1_1, this.format, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final Object deserialize(Charset charset, TypeInfo typeInfo, Frame content, Continuation<Object> $completion) {
        SerialFormat serialFormat;
        if (!this.isApplicable(content)) {
            throw new WebsocketConverterNotFoundException("Unsupported frame " + content.getFrameType().name(), null, 2, null);
        }
        KSerializer<?> serializer = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), (TypeInfo)serialFormat);
        serialFormat = this.format;
        if (serialFormat instanceof StringFormat) {
            if (content instanceof Frame.Text) {
                return ((StringFormat)this.format).decodeFromString((DeserializationStrategy)serializer, FrameCommonKt.readText((Frame.Text)((Frame.Text)content)));
            }
            throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content.getFrameType().name(), null, content, 2, null);
        }
        if (serialFormat instanceof BinaryFormat) {
            void var3_3;
            if (content instanceof Frame.Binary) {
                void var1_1;
                BinaryFormat binaryFormat = (BinaryFormat)this.format;
                DeserializationStrategy cfr_ignored_0 = (DeserializationStrategy)var1_1;
                FrameCommonKt.readBytes((Frame)content);
                return binaryFormat.decodeFromByteArray$df7178a();
            }
            throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content.getFrameType().name(), null, (Frame)var3_3, 2, null);
        }
        throw new IllegalStateException(("Unsupported format " + this.format).toString());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isApplicable(Frame frame) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return frame instanceof Frame.Text || var1_1 instanceof Frame.Binary;
    }

    /*
     * WARNING - void declaration
     */
    private final Frame serializeContent(KSerializer<?> serializer, SerialFormat format, Object value) {
        void var2_2;
        Object content;
        SerialFormat serialFormat = format;
        if (serialFormat instanceof StringFormat) {
            void var3_3;
            StringFormat stringFormat = (StringFormat)format;
            Intrinsics.checkNotNull(serializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
            content = stringFormat.encodeToString((SerializationStrategy)serializer, (Object)var3_3);
            return (Frame)new Frame.Text((String)content);
        }
        if (serialFormat instanceof BinaryFormat) {
            void var1_1;
            BinaryFormat binaryFormat = (BinaryFormat)format;
            Intrinsics.checkNotNull((Object)content, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
            SerializationStrategy cfr_ignored_0 = (SerializationStrategy)content;
            content = binaryFormat.encodeToByteArray$1778e321();
            return (Frame)new Frame.Binary(true, (byte[])var1_1);
        }
        throw new IllegalStateException(("Unsupported format " + var2_2).toString());
    }
}

