/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.geometry;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.geometry.GeometryUtilsKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\b\b\u0087\b\u0018\u0000 :2\u00020\u0001:\u0001:B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\nJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\nJ\u001b\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001a\u0010!\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b!\u0010$R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010%\u001a\u0004\b&\u0010\nR\u0014\u0010)\u001a\u00020\u000e8F\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010+\u001a\u00020\u000e8F\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0011\u0010-\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b.\u0010\nR\u0011\u00100\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010%\u001a\u0004\b1\u0010\nR\u0014\u00104\u001a\u0002028F\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b3\u0010(R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010%\u001a\u0004\b5\u0010\nR\u0014\u00107\u001a\u00020\u000e8F\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b6\u0010(R\u0011\u00109\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\n\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!"}, d2={"Landroidx/compose/ui/geometry/Rect;", "", "", "left", "top", "right", "bottom", "<init>", "(FFFF)V", "component1", "()F", "component2", "component3", "component4", "Landroidx/compose/ui/geometry/Offset;", "offset", "", "contains-k-4lQ0M", "(J)Z", "contains", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "intersect", "(Landroidx/compose/ui/geometry/Rect;)Landroidx/compose/ui/geometry/Rect;", "", "toString", "()Ljava/lang/String;", "translate-k-4lQ0M", "(J)Landroidx/compose/ui/geometry/Rect;", "translate", "translateX", "translateY", "(FF)Landroidx/compose/ui/geometry/Rect;", "F", "getBottom", "getBottomRight-F1C5BW0", "()J", "bottomRight", "getCenter-F1C5BW0", "center", "getHeight", "height", "getLeft", "getMaxDimension", "maxDimension", "getRight", "Landroidx/compose/ui/geometry/Size;", "getSize-NH-jbRc", "size", "getTop", "getTopLeft-F1C5BW0", "topLeft", "getWidth", "width", "Companion"})
@Immutable
public final class Rect {
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    private static final Rect Zero = new Rect(0.0f, 0.0f, 0.0f, 0.0f);

    /*
     * WARNING - void declaration
     */
    public Rect(float left, float top, float right, float bottom) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.left = var1_1;
        this.top = var2_2;
        this.right = var3_3;
        this.bottom = bottom;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    public final long getSize-NH-jbRc() {
        return SizeKt.Size(this.getWidth(), this.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    @Stable
    public final Rect translate-k-4lQ0M(long offset) {
        void var1_1;
        return new Rect(this.left + Offset.getX-impl(offset), this.top + Offset.getY-impl(offset), this.right + Offset.getX-impl(offset), this.bottom + Offset.getY-impl((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Stable
    public final Rect translate(float translateX, float translateY) {
        void var2_2;
        void var1_1;
        return new Rect(this.left + translateX, this.top + translateY, this.right + var1_1, this.bottom + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Stable
    public final Rect intersect(Rect other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Rect(Math.max(this.left, other.left), Math.max(this.top, other.top), Math.min(this.right, other.right), Math.min(this.bottom, var1_1.bottom));
    }

    public final float getMaxDimension() {
        return Math.max(Math.abs(this.getWidth()), Math.abs(this.getHeight()));
    }

    public final long getTopLeft-F1C5BW0() {
        return OffsetKt.Offset(this.left, this.top);
    }

    public final long getCenter-F1C5BW0() {
        return OffsetKt.Offset(this.left + this.getWidth() / 2.0f, this.top + this.getHeight() / 2.0f);
    }

    public final long getBottomRight-F1C5BW0() {
        return OffsetKt.Offset(this.right, this.bottom);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains-k-4lQ0M(long offset) {
        void var1_1;
        return Offset.getX-impl(offset) >= this.left && Offset.getX-impl(offset) < this.right && Offset.getY-impl(offset) >= this.top && Offset.getY-impl((long)var1_1) < this.bottom;
    }

    public final String toString() {
        return "Rect.fromLTRB(" + GeometryUtilsKt.toStringAsFixed(this.left, 1) + ", " + GeometryUtilsKt.toStringAsFixed(this.top, 1) + ", " + GeometryUtilsKt.toStringAsFixed(this.right, 1) + ", " + GeometryUtilsKt.toStringAsFixed(this.bottom, 1) + ')';
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    public static /* synthetic */ Rect copy$default$2580b444(Rect rect, float f, float f2, float f3, float f4, int n) {
        if ((n & 1) != 0) {
            f = rect.left;
        }
        if ((n & 2) != 0) {
            f2 = rect.top;
        }
        if ((n & 4) != 0) {
            f3 = rect.right;
        }
        if ((n & 8) != 0) {
            f4 = rect.bottom;
        }
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        f3 = f4;
        f2 = f7;
        f = f6;
        float f8 = f5;
        return new Rect(f8, f, f2, f3);
    }

    public final int hashCode() {
        int n = Float.hashCode(this.left);
        n = n * 31 + Float.hashCode(this.top);
        n = n * 31 + Float.hashCode(this.right);
        n = n * 31 + Float.hashCode(this.bottom);
        return n;
    }

    public final boolean equals(Object other) {
        Rect rect;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        rect = rect;
        if (Float.compare(this.left, rect.left) != 0) {
            return false;
        }
        if (Float.compare(this.top, rect.top) != 0) {
            return false;
        }
        if (Float.compare(this.right, rect.right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, rect.bottom) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Landroidx/compose/ui/geometry/Rect$Companion;", "", "<init>", "()V", "Landroidx/compose/ui/geometry/Rect;", "Zero", "Landroidx/compose/ui/geometry/Rect;", "getZero", "()Landroidx/compose/ui/geometry/Rect;"})
    public static final class Companion {
        private Companion() {
        }

        public static Rect getZero() {
            return Zero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

