/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.select;

import com.fleeksoft.ksoup.nodes.Node;
import com.fleeksoft.ksoup.ported.AssertKt;
import com.fleeksoft.ksoup.select.NodeFilter;
import com.fleeksoft.ksoup.select.NodeVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\u000e"}, d2={"Lcom/fleeksoft/ksoup/select/NodeTraversor;", "", "<init>", "()V", "Lcom/fleeksoft/ksoup/select/NodeVisitor;", "visitor", "Lcom/fleeksoft/ksoup/nodes/Node;", "root", "", "traverse", "(Lcom/fleeksoft/ksoup/select/NodeVisitor;Lcom/fleeksoft/ksoup/nodes/Node;)V", "Lcom/fleeksoft/ksoup/select/NodeFilter;", "filter", "Lcom/fleeksoft/ksoup/select/NodeFilter$FilterResult;", "(Lcom/fleeksoft/ksoup/select/NodeFilter;Lcom/fleeksoft/ksoup/nodes/Node;)Lcom/fleeksoft/ksoup/select/NodeFilter$FilterResult;"})
@SourceDebugExtension(value={"SMAP\nNodeTraversor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeTraversor.kt\ncom/fleeksoft/ksoup/select/NodeTraversor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1863#2,2:142\n1863#2,2:144\n*S KotlinDebug\n*F\n+ 1 NodeTraversor.kt\ncom/fleeksoft/ksoup/select/NodeTraversor\n*L\n72#1:142,2\n136#1:144,2\n*E\n"})
public final class NodeTraversor {
    public static final NodeTraversor INSTANCE = new NodeTraversor();

    private NodeTraversor() {
    }

    public static void traverse(NodeVisitor visitor, Node root) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Node node = root;
        int depth = 0;
        while (node != null) {
            Node parent = node.parentNode();
            int origSize = parent != null ? parent.childNodeSize() : 0;
            Node next = node.nextSibling();
            visitor.head(node, depth);
            if (parent != null && !node.hasParent()) {
                if (origSize == parent.childNodeSize()) {
                    node = parent.childNode(node.siblingIndex());
                } else {
                    node = next;
                    if (node != null) continue;
                    node = parent;
                    --depth;
                    continue;
                }
            }
            if (node.childNodeSize() > 0) {
                node = node.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                if (node == null) {
                    throw new Exception("as depth > 0, will have parent");
                }
                if (node.nextSibling() != null || depth <= 0) break;
                visitor.tail(node, depth);
                node = node.parentNode();
                --depth;
            }
            visitor.tail(node, depth);
            if (Intrinsics.areEqual((Object)node, (Object)root)) break;
            node = node.nextSibling();
        }
    }

    public static NodeFilter.FilterResult filter(NodeFilter filter, Node root) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Node node = root;
        int depth = 0;
        while (node != null) {
            Node prev;
            NodeFilter.FilterResult result = filter.head$53d66d5c(node);
            if (result == NodeFilter.FilterResult.STOP) {
                return result;
            }
            if (result == NodeFilter.FilterResult.CONTINUE && node.childNodeSize() > 0) {
                node = node.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                AssertKt.assert(node != null, "depth > 0, so has parent");
                Node node2 = node;
                if ((node2 != null ? node2.nextSibling() : null) != null || depth <= 0) break;
                if ((result == NodeFilter.FilterResult.CONTINUE || result == NodeFilter.FilterResult.SKIP_CHILDREN) && (result = filter.tail(node, depth)) == NodeFilter.FilterResult.STOP) {
                    return result;
                }
                prev = node;
                Node node3 = node;
                node = node3 != null ? node3.parentNode() : null;
                --depth;
                if (result == NodeFilter.FilterResult.REMOVE) {
                    Node node4 = prev;
                    if (node4 != null) {
                        node4.remove();
                    }
                }
                result = NodeFilter.FilterResult.CONTINUE;
            }
            if ((result == NodeFilter.FilterResult.CONTINUE || result == NodeFilter.FilterResult.SKIP_CHILDREN) && (result = filter.tail(node, depth)) == NodeFilter.FilterResult.STOP) {
                return result;
            }
            if (Intrinsics.areEqual((Object)node, (Object)root)) {
                return result;
            }
            prev = node;
            Node node5 = node;
            Node node6 = node = node5 != null ? node5.nextSibling() : null;
            if (result != NodeFilter.FilterResult.REMOVE) continue;
            Node node7 = prev;
            if (node7 == null) continue;
            node7.remove();
        }
        return NodeFilter.FilterResult.CONTINUE;
    }
}

