/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.select;

import com.fleeksoft.ksoup.helper.Validate;
import com.fleeksoft.ksoup.internal.Normalizer;
import com.fleeksoft.ksoup.internal.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

public abstract class Evaluator {
    protected Evaluator() {
    }

    public int cost() {
        return 5;
    }

    public static final class AllElements
    extends Evaluator {
        @Override
        public final int cost() {
            return 10;
        }

        public final String toString() {
            return "*";
        }
    }

    public static final class Attribute
    extends Evaluator {
        private final String key;

        /*
         * WARNING - void declaration
         */
        public Attribute(String key) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = var1_1;
        }

        @Override
        public final int cost() {
            return 2;
        }

        public final String toString() {
            return "[" + this.key + "]";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u001c\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\f\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\f\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\f\u0010\u000b"}, d2={"Lcom/fleeksoft/ksoup/select/Evaluator$AttributeKeyPair;", "Lcom/fleeksoft/ksoup/select/Evaluator;", "", "key", "value", "", "trimValue", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "Ljava/lang/String;", "getKey", "()Ljava/lang/String;", "getValue"})
    public static abstract class AttributeKeyPair
    extends Evaluator {
        private String key;
        private String value;

        /*
         * WARNING - void declaration
         */
        public AttributeKeyPair(String key, String value, boolean trimValue) {
            String string;
            void var3_5;
            String resultValue;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Validate.notEmpty(key);
            Validate.notEmpty(resultValue);
            this.key = Normalizer.INSTANCE.normalize(key);
            boolean isStringLiteral = StringsKt.startsWith$default((String)resultValue, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)resultValue, (String)"'", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)resultValue, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)resultValue, (String)"\"", (boolean)false, (int)2, null);
            if (isStringLiteral) {
                String string2 = resultValue.substring(1, resultValue.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                resultValue = string2;
            }
            if (var3_5 != false) {
                string = Normalizer.INSTANCE.normalize(resultValue);
            } else {
                void var2_4;
                void var1_2;
                var3_5 = var1_2;
                Normalizer normalizer = Normalizer.INSTANCE;
                string = var3_5 != false ? Normalizer.lowerCase((String)var2_4) : normalizer.normalize((String)var2_4);
            }
            this.value = string;
        }

        public /* synthetic */ AttributeKeyPair(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(string, string2, bl);
        }

        public final String getKey() {
            return this.key;
        }

        public final String getValue() {
            return this.value;
        }
    }

    public static final class AttributeStarting
    extends Evaluator {
        private final String keyPrefix;

        /*
         * WARNING - void declaration
         */
        public AttributeStarting(String keyPrefix) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
            this.keyPrefix = Normalizer.lowerCase((String)var1_1);
        }

        @Override
        public final int cost() {
            return 6;
        }

        public final String toString() {
            return "[^" + this.keyPrefix + "]";
        }
    }

    public static final class AttributeWithValue
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValue(String key, String value) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super((String)var1_1, (String)var2_2, false, 4, null);
        }

        @Override
        public final int cost() {
            return 3;
        }

        public final String toString() {
            return "[" + this.getKey() + "=" + this.getValue() + "]";
        }
    }

    public static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueContaining(String key, String value) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super((String)var1_1, (String)var2_2, false, 4, null);
        }

        @Override
        public final int cost() {
            return 6;
        }

        public final String toString() {
            return "[" + this.getKey() + "*=" + this.getValue() + "]";
        }
    }

    public static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueEnding(String key, String value) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super((String)var1_1, (String)var2_2, false);
        }

        @Override
        public final int cost() {
            return 4;
        }

        public final String toString() {
            return "[" + this.getKey() + "$=" + this.getValue() + "]";
        }
    }

    public static final class AttributeWithValueMatching
    extends Evaluator {
        private Regex regex;
        private String key;

        /*
         * WARNING - void declaration
         */
        public AttributeWithValueMatching(String key, Regex regex) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            this.regex = var2_2;
            this.key = Normalizer.INSTANCE.normalize((String)var1_1);
        }

        @Override
        public final int cost() {
            return 8;
        }

        public final String toString() {
            return "[" + this.key + "~=" + this.regex + "]";
        }
    }

    public static final class AttributeWithValueNot
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueNot(String key, String value) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super((String)var1_1, (String)var2_2, false, 4, null);
        }

        @Override
        public final int cost() {
            return 3;
        }

        public final String toString() {
            return "[" + this.getKey() + "!=" + this.getValue() + "]";
        }
    }

    public static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueStarting(String key, String value) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super((String)var1_1, (String)var2_2, false);
        }

        @Override
        public final int cost() {
            return 4;
        }

        public final String toString() {
            return "[" + this.getKey() + "^=" + this.getValue() + "]";
        }
    }

    public static final class Class
    extends Evaluator {
        private final String className;

        /*
         * WARNING - void declaration
         */
        public Class(String className) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.className = var1_1;
        }

        @Override
        public final int cost() {
            return 6;
        }

        public final String toString() {
            return "." + this.className;
        }
    }

    public static final class ContainsData
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsData(String searchText) {
            void var1_1;
            this.searchText = Normalizer.lowerCase((String)var1_1);
        }

        public final String toString() {
            return ":containsData(" + this.searchText + ")";
        }
    }

    public static final class ContainsOwnText
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsOwnText(String searchText) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = Normalizer.lowerCase(StringUtil.INSTANCE.normaliseWhitespace((String)var1_1));
        }

        public final String toString() {
            return ":containsOwn(" + this.searchText + ")";
        }
    }

    public static final class ContainsText
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsText(String searchText) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = Normalizer.lowerCase(StringUtil.INSTANCE.normaliseWhitespace((String)var1_1));
        }

        @Override
        public final int cost() {
            return 10;
        }

        public final String toString() {
            return ":contains(" + this.searchText + ")";
        }
    }

    public static final class ContainsWholeOwnText
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsWholeOwnText(String searchText) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = var1_1;
        }

        public final String toString() {
            return ":containsWholeOwnText(" + this.searchText + ")";
        }
    }

    public static final class ContainsWholeText
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsWholeText(String searchText) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
            this.searchText = var1_1;
        }

        @Override
        public final int cost() {
            return 10;
        }

        public final String toString() {
            return ":containsWholeText(" + this.searchText + ")";
        }
    }

    public static abstract class CssNthEvaluator
    extends Evaluator {
        private final int a;
        private final int b;

        /*
         * WARNING - void declaration
         */
        public CssNthEvaluator(int a, int b) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            if (this.a == 0) {
                return ":" + this.getPseudoClass() + "(" + this.b + ")";
            }
            if (this.b == 0) {
                return ":" + this.getPseudoClass() + "(" + this.a + "n)";
            }
            String sign = this.b >= 0 ? "+" : "";
            return ":" + this.getPseudoClass() + "(" + this.a + "n" + (String)var1_1 + this.b + ")";
        }

        protected abstract String getPseudoClass();
    }

    public static final class Id
    extends Evaluator {
        private final String id;

        /*
         * WARNING - void declaration
         */
        public Id(String id) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = var1_1;
        }

        @Override
        public final int cost() {
            return 2;
        }

        public final String toString() {
            return "#" + this.id;
        }
    }

    public static final class IndexEquals
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexEquals(int index) {
            super((int)var1_1);
            void var1_1;
        }

        public final String toString() {
            return ":eq(" + this.getIndex() + ")";
        }
    }

    public static abstract class IndexEvaluator
    extends Evaluator {
        private int index;

        /*
         * WARNING - void declaration
         */
        public IndexEvaluator(int index) {
            void var1_1;
            this.index = var1_1;
        }

        public final int getIndex() {
            return this.index;
        }
    }

    public static final class IndexGreaterThan
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexGreaterThan(int index) {
            super((int)var1_1);
            void var1_1;
        }

        public final String toString() {
            return ":gt(" + this.getIndex() + ")";
        }
    }

    public static final class IndexLessThan
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexLessThan(int index) {
            super((int)var1_1);
            void var1_1;
        }

        public final String toString() {
            return ":lt(" + this.getIndex() + ")";
        }
    }

    public static final class IsEmpty
    extends Evaluator {
        public final String toString() {
            return ":empty";
        }
    }

    public static final class IsFirstChild
    extends Evaluator {
        public final String toString() {
            return ":first-child";
        }
    }

    public static final class IsFirstOfType
    extends IsNthOfType {
        public IsFirstOfType() {
            super(0, 1);
        }

        @Override
        public final String toString() {
            return ":first-of-type";
        }
    }

    public static final class IsLastChild
    extends Evaluator {
        public final String toString() {
            return ":last-child";
        }
    }

    public static final class IsLastOfType
    extends IsNthLastOfType {
        public IsLastOfType() {
            super(0, 1);
        }

        @Override
        public final String toString() {
            return ":last-of-type";
        }
    }

    public static final class IsNthChild
    extends CssNthEvaluator {
        private final String pseudoClass;

        /*
         * WARNING - void declaration
         */
        public IsNthChild(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
            this.pseudoClass = "nth-child";
        }

        @Override
        protected final String getPseudoClass() {
            return this.pseudoClass;
        }
    }

    public static final class IsNthLastChild
    extends CssNthEvaluator {
        private final String pseudoClass;

        /*
         * WARNING - void declaration
         */
        public IsNthLastChild(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
            this.pseudoClass = "nth-last-child";
        }

        @Override
        protected final String getPseudoClass() {
            return this.pseudoClass;
        }
    }

    public static class IsNthLastOfType
    extends CssNthEvaluator {
        private final String pseudoClass;

        /*
         * WARNING - void declaration
         */
        public IsNthLastOfType(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
            this.pseudoClass = "nth-last-of-type";
        }

        @Override
        protected final String getPseudoClass() {
            return this.pseudoClass;
        }
    }

    public static class IsNthOfType
    extends CssNthEvaluator {
        private final String pseudoClass;

        /*
         * WARNING - void declaration
         */
        public IsNthOfType(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
            this.pseudoClass = "nth-of-type";
        }

        @Override
        protected final String getPseudoClass() {
            return this.pseudoClass;
        }
    }

    public static final class IsOnlyChild
    extends Evaluator {
        public final String toString() {
            return ":only-child";
        }
    }

    public static final class IsOnlyOfType
    extends Evaluator {
        public final String toString() {
            return ":only-of-type";
        }
    }

    public static final class IsRoot
    extends Evaluator {
        @Override
        public final int cost() {
            return 1;
        }

        public final String toString() {
            return ":root";
        }
    }

    public static final class MatchText
    extends Evaluator {
        @Override
        public final int cost() {
            return -1;
        }

        public final String toString() {
            return ":matchText";
        }
    }

    public static final class Matches
    extends Evaluator {
        private final Regex pattern;

        /*
         * WARNING - void declaration
         */
        public Matches(Regex pattern) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = var1_1;
        }

        @Override
        public final int cost() {
            return 8;
        }

        public final String toString() {
            return ":matches(" + this.pattern + ")";
        }
    }

    public static final class MatchesOwn
    extends Evaluator {
        private final Regex pattern;

        /*
         * WARNING - void declaration
         */
        public MatchesOwn(Regex pattern) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = var1_1;
        }

        @Override
        public final int cost() {
            return 7;
        }

        public final String toString() {
            return ":matchesOwn(" + this.pattern + ")";
        }
    }

    public static final class MatchesWholeOwnText
    extends Evaluator {
        private final Regex pattern;

        /*
         * WARNING - void declaration
         */
        public MatchesWholeOwnText(Regex pattern) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = var1_1;
        }

        @Override
        public final int cost() {
            return 7;
        }

        public final String toString() {
            return ":matchesWholeOwnText(" + this.pattern + ")";
        }
    }

    public static final class MatchesWholeText
    extends Evaluator {
        private final Regex pattern;

        /*
         * WARNING - void declaration
         */
        public MatchesWholeText(Regex pattern) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = var1_1;
        }

        @Override
        public final int cost() {
            return 8;
        }

        public final String toString() {
            return ":matchesWholeText(" + this.pattern + ")";
        }
    }

    public static final class Tag
    extends Evaluator {
        private final String tagName;

        /*
         * WARNING - void declaration
         */
        public Tag(String tagName) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            this.tagName = var1_1;
        }

        @Override
        public final int cost() {
            return 1;
        }

        public final String toString() {
            return this.tagName;
        }
    }

    public static final class TagEndsWith
    extends Evaluator {
        private final String tagName;

        /*
         * WARNING - void declaration
         */
        public TagEndsWith(String tagName) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            this.tagName = var1_1;
        }

        public final String toString() {
            return this.tagName;
        }
    }

    public static final class TagStartsWith
    extends Evaluator {
        private final String tagName;

        /*
         * WARNING - void declaration
         */
        public TagStartsWith(String tagName) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            this.tagName = var1_1;
        }

        public final String toString() {
            return this.tagName;
        }
    }
}

