/*
 * Decompiled with CFR 0.152.
 */
package com.fleeksoft.ksoup.internal;

import com.fleeksoft.ksoup.internal.SoftPool;
import com.fleeksoft.ksoup.internal.URLUtil;
import com.fleeksoft.ksoup.ported.Character;
import com.fleeksoft.ksoup.ported.CharacterKt;
import com.fleeksoft.ksoup.ported.CodePoint;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001:B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010 \u001a\u00020\u001f2\n\u0010\u001d\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0010\u00a2\u0006\u0004\b \u0010!J)\u0010%\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00062\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060#\"\u00020\u0006\u00a2\u0006\u0004\b%\u0010&J%\u0010'\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00062\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060#\u00a2\u0006\u0004\b'\u0010&J\u001d\u0010*\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b-\u0010\u001aJ\u0011\u0010.\u001a\u00060\u001bj\u0002`\u001c\u00a2\u0006\u0004\b.\u0010/J\u0019\u00101\u001a\u00020\u00062\n\u00100\u001a\u00060\u001bj\u0002`\u001c\u00a2\u0006\u0004\b1\u00102R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060#8\u0006\u00a2\u0006\u0006\n\u0004\b\r\u00103R\u0014\u00105\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001e\u00108\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109"}, d2={"Lcom/fleeksoft/ksoup/internal/StringUtil;", "", "<init>", "()V", "", "strings", "", "sep", "join", "(Ljava/util/Collection;Ljava/lang/String;)Ljava/lang/String;", "", "width", "maxPaddingWidth", "padding", "(II)Ljava/lang/String;", "string", "", "isBlank", "(Ljava/lang/String;)Z", "isNumeric", "c", "isWhitespace", "(I)Z", "isActuallyWhitespace", "isInvisibleChar", "normaliseWhitespace", "(Ljava/lang/String;)Ljava/lang/String;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "accum", "stripLeading", "", "appendNormalisedWhitespace", "(Ljava/lang/StringBuilder;Ljava/lang/String;Z)V", "needle", "", "haystack", "isIn", "(Ljava/lang/String;[Ljava/lang/String;)Z", "inSorted", "baseUrl", "relUrl", "resolve", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "input", "stripControlChars", "borrowBuilder", "()Ljava/lang/StringBuilder;", "sb", "releaseBuilder", "(Ljava/lang/StringBuilder;)Ljava/lang/String;", "[Ljava/lang/String;", "Lkotlin/text/Regex;", "controlChars", "Lkotlin/text/Regex;", "Lcom/fleeksoft/ksoup/internal/SoftPool;", "StringBuilderPool", "Lcom/fleeksoft/ksoup/internal/SoftPool;", "StringJoiner"})
@SourceDebugExtension(value={"SMAP\nStringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtil.kt\ncom/fleeksoft/ksoup/internal/StringUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KsoupExt.kt\ncom/fleeksoft/ksoup/ported/KsoupExtKt\n*L\n1#1,315:1\n1#2:316\n4#3,16:317\n*S KotlinDebug\n*F\n+ 1 StringUtil.kt\ncom/fleeksoft/ksoup/internal/StringUtil\n*L\n202#1:317,16\n*E\n"})
public final class StringUtil {
    public static final StringUtil INSTANCE = new StringUtil();
    public static final String[] padding;
    private static final Regex controlChars;
    private static final SoftPool<StringBuilder> StringBuilderPool;

    private StringUtil() {
    }

    public final String join(Collection<?> strings, String sep) {
        StringJoiner stringJoiner;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)sep, (String)"sep");
        iterator2 = iterator2.iterator();
        Intrinsics.checkNotNullParameter(iterator2, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)stringJoiner, (String)"sep");
        if (!iterator2.hasNext()) {
            return "";
        }
        String string = String.valueOf(iterator2.next());
        if (!iterator2.hasNext()) {
            return string;
        }
        stringJoiner = new StringJoiner((String)((Object)stringJoiner));
        stringJoiner.add(string);
        while (iterator2.hasNext()) {
            stringJoiner.add(iterator2.next());
        }
        return stringJoiner.complete();
    }

    /*
     * WARNING - void declaration
     */
    public static String padding(int width22, int maxPaddingWidth) {
        int n;
        void var1_3;
        int width22;
        if (!(width22 >= 0)) {
            String width22 = "width must be >= 0";
            throw new IllegalArgumentException(width22.toString());
        }
        if (!(maxPaddingWidth >= -1)) {
            String width22 = "Failed requirement.";
            throw new IllegalArgumentException(width22.toString());
        }
        int effectiveWidth = maxPaddingWidth != -1 ? Math.min(width22, (int)var1_3) : width22;
        if (effectiveWidth < padding.length) {
            return padding[effectiveWidth];
        }
        return StringsKt.repeat((CharSequence)" ", (int)n);
    }

    public final boolean isBlank(String string) {
        CharSequence charSequence = string;
        if (charSequence == null || charSequence.length() == 0) {
            return true;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (StringUtil.isWhitespace(CharacterKt.codePointValueAt(string, i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        CharSequence charSequence = string;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(CharacterKt.codePointValueAt(string, i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c) {
        int n;
        return c == 32 || c == 9 || c == 10 || c == 12 || n == 13;
    }

    private static boolean isActuallyWhitespace(int c) {
        int n;
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13 || n == 160;
    }

    private static boolean isInvisibleChar(int c) {
        int n;
        return c == 8203 || n == 173;
    }

    /*
     * WARNING - void declaration
     */
    public final String normaliseWhitespace(String string) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        StringBuilder sb = StringUtil.borrowBuilder();
        this.appendNormalisedWhitespace(sb, (String)var1_1, false);
        return StringUtil.releaseBuilder((StringBuilder)var2_2);
    }

    public final void appendNormalisedWhitespace(StringBuilder accum, String string, boolean stripLeading) {
        Intrinsics.checkNotNullParameter((Object)accum, (String)"accum");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            CodePoint c = CharacterKt.codePointAt(string, i);
            if (StringUtil.isActuallyWhitespace(c.getValue())) {
                if (stripLeading && !reachedNonWhite || lastWasWhite) {
                    i += c.getCharCount();
                    continue;
                }
                accum.append(' ');
                lastWasWhite = true;
            } else if (!StringUtil.isInvisibleChar(c.getValue())) {
                accum.appendCodePoint(c.getValue());
                lastWasWhite = false;
                reachedNonWhite = true;
            }
            i += c.getCharCount();
        }
    }

    public static boolean isIn(String needle, String ... haystack) {
        Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
        Intrinsics.checkNotNullParameter((Object)haystack, (String)"haystack");
        int len = haystack.length;
        for (int i = 0; i < len; ++i) {
            if (!Intrinsics.areEqual((Object)haystack[i], (Object)needle)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean inSorted(String needle, String[] haystack) {
        int n;
        block3: {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            Intrinsics.checkNotNullParameter((Object)haystack, (String)"haystack");
            Comparable[] $this$binarySearch$iv = (Comparable[])haystack;
            int low$iv = 0;
            int high$iv = $this$binarySearch$iv.length - 1;
            while (low$iv <= high$iv) {
                int mid$iv = low$iv + high$iv >>> 1;
                Comparable comparable = $this$binarySearch$iv[mid$iv];
                int cmp$iv = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)needle)));
                if (cmp$iv < 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                n = mid$iv;
                break block3;
            }
            n = -(var2_2 + true);
        }
        return n >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final String resolve(String baseUrl, String relUrl) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)relUrl, (String)"relUrl");
        String cleanedBaseUrl = StringUtil.stripControlChars(baseUrl);
        String cleanedRelUrl = StringUtil.stripControlChars(relUrl);
        return URLUtil.INSTANCE.resolve((String)var1_1, (String)var2_2);
    }

    private static String stripControlChars(String input) {
        CharSequence charSequence = input;
        Regex regex = controlChars;
        String string = "";
        return regex.replace(charSequence, string);
    }

    public static StringBuilder borrowBuilder() {
        return StringBuilderPool.borrow();
    }

    /*
     * WARNING - void declaration
     */
    public static String releaseBuilder(StringBuilder sb) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String str = string;
        if (sb.length() <= 8192) {
            StringBuilder stringBuilder;
            StringsKt.clear((StringBuilder)sb);
            StringBuilderPool.release(stringBuilder);
        }
        return var1_1;
    }

    private static final StringBuilder StringBuilderPool$lambda$1() {
        return new StringBuilder(1024);
    }

    static {
        String[] stringArray = new String[21];
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        stringArray2[1] = " ";
        stringArray2[2] = "  ";
        stringArray2[3] = "   ";
        stringArray2[4] = "    ";
        stringArray2[5] = "     ";
        stringArray2[6] = "      ";
        stringArray2[7] = "       ";
        stringArray2[8] = "        ";
        stringArray2[9] = "         ";
        stringArray2[10] = "          ";
        stringArray2[11] = "           ";
        stringArray2[12] = "            ";
        stringArray2[13] = "             ";
        stringArray2[14] = "              ";
        stringArray2[15] = "               ";
        stringArray2[16] = "                ";
        stringArray2[17] = "                 ";
        stringArray2[18] = "                  ";
        stringArray2[19] = "                   ";
        stringArray2[20] = "                    ";
        padding = stringArray2;
        controlChars = new Regex("[\\x00-\\x1f]*");
        StringBuilderPool = new SoftPool(StringUtil::StringBuilderPool$lambda$1);
    }

    @SourceDebugExtension(value={"SMAP\nStringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtil.kt\ncom/fleeksoft/ksoup/internal/StringUtil$StringJoiner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n1#2:316\n*E\n"})
    public static final class StringJoiner {
        private final String separator;
        private StringBuilder sb;
        private boolean first;

        /*
         * WARNING - void declaration
         */
        public StringJoiner(String separator) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            this.separator = var1_1;
            this.sb = INSTANCE.borrowBuilder();
            this.first = true;
        }

        /*
         * WARNING - void declaration
         */
        public final StringJoiner add(Object stringy) {
            void var1_1;
            if (!this.first) {
                StringBuilder stringBuilder = this.sb;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.append(this.separator);
            }
            StringBuilder stringBuilder = this.sb;
            Intrinsics.checkNotNull((Object)stringBuilder);
            stringBuilder.append(var1_1);
            this.first = false;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final String complete() {
            void var1_1;
            String string;
            StringBuilder stringBuilder = this.sb;
            if (stringBuilder != null) {
                StringBuilder it = stringBuilder;
                string = StringUtil.releaseBuilder(it);
            } else {
                string = null;
            }
            String string2 = string;
            this.sb = null;
            String string3 = var1_1;
            if (string3 == null) {
                string3 = "";
            }
            return string3;
        }
    }
}

