/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.driver.jdbc;

import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlPreparedStatement;
import app.cash.sqldelight.driver.jdbc.JdbcCursor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nJdbcDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDriver.kt\napp/cash/sqldelight/driver/jdbc/JdbcPreparedStatement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,327:1\n1#2:328\n*E\n"})
public final class JdbcPreparedStatement
implements SqlPreparedStatement {
    private final PreparedStatement preparedStatement;

    /*
     * WARNING - void declaration
     */
    public JdbcPreparedStatement(PreparedStatement preparedStatement) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"preparedStatement");
        this.preparedStatement = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void bindBytes(int index, byte[] bytes) {
        void var2_2;
        this.preparedStatement.setBytes(2, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void bindLong(int index, Long l) {
        void var2_2;
        void var1_1;
        if (l == null) {
            this.preparedStatement.setNull(index + 1, -5);
            return;
        }
        this.preparedStatement.setLong((int)(var1_1 + true), var2_2.longValue());
    }

    /*
     * WARNING - void declaration
     */
    public final void bindString(int index, String string) {
        void var2_2;
        void var1_1;
        this.preparedStatement.setString((int)(var1_1 + true), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R executeQuery(Function1<? super SqlCursor, ? extends R> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        try {
            Object object;
            Object object2 = this.preparedStatement.executeQuery();
            Throwable throwable = null;
            try {
                void var1_1;
                ResultSet resultSet = (ResultSet)object2;
                Intrinsics.checkNotNull((Object)resultSet);
                object = var1_1.invoke((Object)new JdbcCursor(resultSet));
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
                    throw throwable4;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)object2, null);
            object2 = object;
            return (R)object2;
        }
        finally {
            this.preparedStatement.close();
        }
    }

    public final long execute() {
        if (this.preparedStatement.execute()) {
            return 0L;
        }
        return this.preparedStatement.getUpdateCount();
    }
}

