/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.io.RefCountingCopyTracker;
import kotlinx.io.Segment;
import kotlinx.io.SegmentCopyTracker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000e8\u0006\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000e8\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0017R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u000e8\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0017R\u0014\u0010 \u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u0017R\u001c\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001c\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#"}, d2={"Lkotlinx/io/SegmentPool;", "", "<init>", "()V", "Lkotlinx/io/Segment;", "take", "()Lkotlinx/io/Segment;", "segment", "", "recycle", "(Lkotlinx/io/Segment;)V", "Lkotlinx/io/SegmentCopyTracker;", "tracker", "()Lkotlinx/io/SegmentCopyTracker;", "", "l1BucketId", "()I", "l2BucketId", "", "mask", "bucketId", "(J)I", "MAX_SIZE", "I", "LOCK", "Lkotlinx/io/Segment;", "HASH_BUCKET_COUNT", "HASH_BUCKET_COUNT_L2", "", "DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE", "Ljava/lang/String;", "SECOND_LEVEL_POOL_TOTAL_SIZE", "SECOND_LEVEL_POOL_BUCKET_SIZE", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "hashBuckets", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "hashBucketsL2"})
public final class SegmentPool {
    public static final SegmentPool INSTANCE = new SegmentPool();
    public static final int MAX_SIZE = 65536;
    private static final Segment LOCK = Segment.Companion.new$kotlinx_io_core(new byte[0], 0, 0, null, false);
    public static final int HASH_BUCKET_COUNT = Integer.highestOneBit(Runtime.getRuntime().availableProcessors() * 2 - 1);
    private static final int HASH_BUCKET_COUNT_L2 = RangesKt.coerceAtLeast((int)(HASH_BUCKET_COUNT / 2), (int)1);
    private static final String DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE = Intrinsics.areEqual((Object)System.getProperty("java.vm.name"), (Object)"Dalvik") ? "0" : "4194304";
    public static final int SECOND_LEVEL_POOL_TOTAL_SIZE;
    private static final int SECOND_LEVEL_POOL_BUCKET_SIZE;
    private static final AtomicReferenceArray<Segment> hashBuckets;
    private static final AtomicReferenceArray<Segment> hashBucketsL2;

    private SegmentPool() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final Segment take() {
        void var2_2;
        void var1_1;
        void var0;
        Segment first2;
        AtomicReferenceArray<Segment> buckets = hashBuckets;
        int bucketId = INSTANCE.l1BucketId();
        while (Intrinsics.areEqual((Object)(first2 = buckets.getAndSet(bucketId, LOCK)), (Object)LOCK)) {
        }
        if (first2 == null) {
            buckets.set(bucketId, null);
            if (SECOND_LEVEL_POOL_TOTAL_SIZE > 0) {
                Segment segment;
                block5: {
                    buckets = hashBucketsL2;
                    bucketId = INSTANCE.l2BucketId();
                    int first2 = 0;
                    while (true) {
                        if (Intrinsics.areEqual((Object)(segment = buckets.getAndSet(bucketId, LOCK)), (Object)LOCK)) {
                            continue;
                        }
                        if (segment != null) break block5;
                        buckets.set(bucketId, null);
                        if (first2 >= HASH_BUCKET_COUNT_L2) break;
                        bucketId = bucketId + 1 & HASH_BUCKET_COUNT_L2 - 1;
                        ++first2;
                    }
                    return Segment.Companion.new$kotlinx_io_core();
                }
                buckets.set(bucketId, segment.getNext());
                segment.setNext(null);
                segment.setLimit(0);
                return segment;
            }
            return Segment.Companion.new$kotlinx_io_core();
        }
        var0.set((int)var1_1, first2.getNext());
        first2.setNext(null);
        first2.setLimit(0);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void recycle(Segment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        if (!(segment.getNext() == null && segment.getPrev() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SegmentCopyTracker segmentCopyTracker = segment.getCopyTracker$kotlinx_io_core();
        boolean bl = segmentCopyTracker != null ? segmentCopyTracker.removeCopy() : false;
        if (bl) {
            return;
        }
        AtomicReferenceArray<Segment> buckets2 = hashBuckets;
        int bucketId2 = INSTANCE.l1BucketId();
        segment.setPos(0);
        segment.owner = true;
        while (true) {
            void var3_6;
            Segment first2;
            if ((first2 = buckets2.get(bucketId2)) == LOCK) {
                continue;
            }
            Segment segment2 = first2;
            int firstLimit = segment2 != null ? segment2.getLimit() : 0;
            if (firstLimit >= MAX_SIZE) {
                if (SECOND_LEVEL_POOL_TOTAL_SIZE > 0) {
                    segment.setPos(0);
                    segment.owner = true;
                    int buckets2 = INSTANCE.l2BucketId();
                    AtomicReferenceArray<Segment> bucketId2 = hashBucketsL2;
                    int first2 = 0;
                    while (true) {
                        if ((firstLimit = bucketId2.get(buckets2)) == LOCK) {
                            continue;
                        }
                        Segment segment3 = firstLimit;
                        int n = segment3 != null ? segment3.getLimit() : 0;
                        if (n + 8192 > SECOND_LEVEL_POOL_BUCKET_SIZE) {
                            if (first2 < HASH_BUCKET_COUNT_L2) {
                                ++first2;
                                buckets2 = buckets2 + 1 & HASH_BUCKET_COUNT_L2 - 1;
                                continue;
                            }
                            return;
                        }
                        segment.setNext(firstLimit);
                        segment.setLimit(n + 8192);
                        if (bucketId2.compareAndSet(buckets2, firstLimit, segment)) break;
                    }
                }
                return;
            }
            segment.setNext(first2);
            segment.setLimit(firstLimit + 8192);
            if (buckets2.compareAndSet(bucketId2, (Segment)var3_6, segment)) break;
        }
    }

    @JvmStatic
    public static final SegmentCopyTracker tracker() {
        return new RefCountingCopyTracker();
    }

    private final int l1BucketId() {
        return SegmentPool.bucketId((long)HASH_BUCKET_COUNT - 1L);
    }

    private final int l2BucketId() {
        return SegmentPool.bucketId((long)HASH_BUCKET_COUNT_L2 - 1L);
    }

    private static int bucketId(long mask) {
        long l;
        return (int)(Thread.currentThread().getId() & l);
    }

    static {
        String string = System.getProperty("kotlinx.io.pool.size.bytes", DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        SECOND_LEVEL_POOL_TOTAL_SIZE = n != null ? RangesKt.coerceAtLeast((int)n, (int)0) : 0;
        SECOND_LEVEL_POOL_BUCKET_SIZE = RangesKt.coerceAtLeast((int)(SECOND_LEVEL_POOL_TOTAL_SIZE / HASH_BUCKET_COUNT_L2), (int)8192);
        hashBuckets = new AtomicReferenceArray(HASH_BUCKET_COUNT);
        hashBucketsL2 = new AtomicReferenceArray(HASH_BUCKET_COUNT_L2);
    }
}

