/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Loader;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;

public class EnvUtil {
    private EnvUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static String logbackVersion() {
        void var0;
        String moduleVersion = EnvUtil.logbackVersionByModule();
        if (moduleVersion != null) {
            return moduleVersion;
        }
        Package pkg = EnvUtil.class.getPackage();
        if (pkg == null) {
            return null;
        }
        return var0.getImplementationVersion();
    }

    private static String logbackVersionByModule() {
        Optional<String> optional;
        Module module = EnvUtil.class.getModule();
        if (module == null) {
            return null;
        }
        ModuleDescriptor md = module.getDescriptor();
        if (md == null) {
            return null;
        }
        optional = ((ModuleDescriptor)((Object)optional)).rawVersion();
        return optional.orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    public static int getJDKVersion(String javaVersionStr) {
        void var1_1;
        Object object;
        int version = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Object ch = object[i];
            if (Character.isDigit((char)ch)) {
                version = version * 10 + (ch - 48);
                continue;
            }
            if (version != 1) break;
            version = 0;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isJDK_N_OrHigher(int n) {
        void var1_2;
        int n2;
        String javaVersionStr = System.getProperty("java.version", "");
        if (javaVersionStr.isEmpty()) {
            return false;
        }
        int version = EnvUtil.getJDKVersion(javaVersionStr);
        return version > 0 && n2 <= var1_2;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK6OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(6);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }

    public static boolean isJDK16OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(16);
    }

    public static boolean isJDK18OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(18);
    }

    public static boolean isJDK21OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(21);
    }

    public static boolean isJaninoAvailable() {
        ClassLoader classLoader = EnvUtil.class.getClassLoader();
        try {
            Class<?> clazz;
            clazz = ((ClassLoader)((Object)clazz)).loadClass("org.codehaus.janino.ScriptEvaluator");
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isMacOs() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().contains("mac");
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.startsWith("Windows");
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClassAvailable(Class callerClass, String className) {
        Class<?> classLoader = Loader.getClassLoaderOfClass(callerClass);
        try {
            void var1_1;
            Class<?> clazz;
            clazz = ((ClassLoader)((Object)clazz)).loadClass((String)var1_1);
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

