/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.CharSequenceState;
import java.text.DateFormatSymbols;

class CharSequenceToRegexMapper {
    DateFormatSymbols symbols = DateFormatSymbols.getInstance();

    CharSequenceToRegexMapper() {
    }

    /*
     * WARNING - void declaration
     */
    String toRegex(CharSequenceState css) {
        void var2_2;
        void var3_3;
        void var1_1;
        int occurrences = css.occurrences;
        char c = css.c;
        switch (var1_1.c) {
            case 'G': 
            case 'z': {
                return ".*";
            }
            case 'M': {
                if (occurrences <= 2) {
                    return this.number(occurrences);
                }
                if (occurrences == 3) {
                    return this.getRegexForShortMonths();
                }
                return this.getRegexForLongMonths();
            }
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': 
            case 'w': 
            case 'y': {
                return this.number(occurrences);
            }
            case 'E': {
                if (occurrences >= 4) {
                    return this.getRegexForLongDaysOfTheWeek();
                }
                return this.getRegexForShortDaysOfTheWeek();
            }
            case 'a': {
                return this.getRegexForAmPms();
            }
            case 'Z': {
                return "(\\+|-)\\d{4}";
            }
            case '.': {
                return "\\.";
            }
            case '\\': {
                throw new IllegalStateException("Forward slashes are not allowed");
            }
            case '\'': {
                if (occurrences == 1) {
                    return "";
                }
                throw new IllegalStateException("Too many single quotes");
            }
        }
        if (occurrences == 1) {
            return "" + c;
        }
        return (char)var3_3 + "{" + (int)var2_2 + "}";
    }

    private String number(int occurrences) {
        return "\\d{" + occurrences + "}";
    }

    private String getRegexForAmPms() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getAmPmStrings());
    }

    private String getRegexForLongDaysOfTheWeek() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getWeekdays());
    }

    private String getRegexForShortDaysOfTheWeek() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getShortWeekdays());
    }

    private String getRegexForLongMonths() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getMonths());
    }

    String getRegexForShortMonths() {
        CharSequenceToRegexMapper charSequenceToRegexMapper = this;
        return charSequenceToRegexMapper.symbolArrayToRegex(charSequenceToRegexMapper.symbols.getShortMonths());
    }

    /*
     * WARNING - void declaration
     */
    private String symbolArrayToRegex(String[] symbolArray) {
        void var1_1;
        int[] minMax = CharSequenceToRegexMapper.findMinMaxLengthsInSymbols(symbolArray);
        return ".{" + minMax[0] + "," + (int)var1_1[1] + "}";
    }

    /*
     * WARNING - void declaration
     */
    static int[] findMinMaxLengthsInSymbols(String[] symbols) {
        void var2_2;
        void var1_1;
        String[] stringArray;
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (String string : stringArray) {
            int len = string.length();
            if (len == 0) continue;
            min = Math.min(min, len);
            max = Math.max(max, len);
        }
        return new int[]{var1_1, var2_2};
    }
}

