/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.model.SiftModel;
import ch.qos.logback.core.sift.AppenderFactory;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.sift.Discriminator;
import ch.qos.logback.core.util.Duration;

public abstract class SiftingAppenderBase<E>
extends AppenderBase<E> {
    protected AppenderTracker<E> appenderTracker;
    AppenderFactory<E> appenderFactory;
    Duration timeout = new Duration(1800000L);
    int maxAppenderCount = Integer.MAX_VALUE;
    SiftModel siftModel;
    Discriminator<E> discriminator;

    public Duration getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeout(Duration timeout) {
        void var1_1;
        this.timeout = var1_1;
    }

    public SiftModel getSiftModel() {
        return this.siftModel;
    }

    /*
     * WARNING - void declaration
     */
    public void setSiftModel(SiftModel siftModel) {
        void var1_1;
        this.siftModel = var1_1;
    }

    public int getMaxAppenderCount() {
        return this.maxAppenderCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxAppenderCount(int maxAppenderCount) {
        void var1_1;
        this.maxAppenderCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAppenderFactory(AppenderFactory<E> appenderFactory) {
        void var1_1;
        this.appenderFactory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        void var1_1;
        int errors = 0;
        if (this.discriminator == null) {
            this.addError("Missing discriminator. Aborting");
            ++errors;
        }
        if (!this.discriminator.isStarted()) {
            this.addError("Discriminator has not started successfully. Aborting");
            ++errors;
        }
        if (this.appenderFactory == null) {
            this.addError("AppenderFactory has not been set. Aborting");
            ++errors;
        } else {
            this.appenderTracker = new AppenderTracker<E>(this.context, this.appenderFactory);
            this.appenderTracker.setMaxComponents(this.maxAppenderCount);
            this.appenderTracker.setTimeout(this.timeout.getMilliseconds());
        }
        if (var1_1 == false) {
            super.start();
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        for (Appender appender : this.appenderTracker.allComponents()) {
            appender.stop();
        }
    }

    protected abstract long getTimestamp(E var1);

    /*
     * WARNING - void declaration
     */
    @Override
    protected void append(E event) {
        void var1_1;
        void var3_3;
        if (!this.isStarted()) {
            return;
        }
        String discriminatingValue = this.discriminator.getDiscriminatingValue(event);
        long timestamp = this.getTimestamp(event);
        Appender appender = (Appender)this.appenderTracker.getOrCreate(discriminatingValue, timestamp);
        if (this.eventMarksEndOfLife(event)) {
            void var2_2;
            this.appenderTracker.endOfLife((String)var2_2);
        }
        this.appenderTracker.removeStaleComponents((long)var3_3);
        appender.doAppend(var1_1);
    }

    protected abstract boolean eventMarksEndOfLife(E var1);

    public Discriminator<E> getDiscriminator() {
        return this.discriminator;
    }

    /*
     * WARNING - void declaration
     */
    public void setDiscriminator(Discriminator<E> discriminator) {
        void var1_1;
        this.discriminator = var1_1;
    }

    public AppenderTracker<E> getAppenderTracker() {
        return this.appenderTracker;
    }

    public String getDiscriminatorKey() {
        if (this.discriminator != null) {
            return this.discriminator.getKey();
        }
        return null;
    }
}

