/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class TimeBasedArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 2764800000L;
    static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    private int maxHistory = 0;
    private long totalSizeCap = 0L;
    final boolean parentClean;
    long lastHeartBeat = -1L;
    int callCount = 0;

    /*
     * WARNING - void declaration
     */
    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        void var1_1;
        void var2_2;
        this.fileNamePattern = fileNamePattern;
        this.rc = var2_2;
        this.parentClean = this.computeParentCleaningFlag((FileNamePattern)var1_1);
    }

    @Override
    public Future<?> cleanAsynchronously(Instant now) {
        Future<?> future;
        ArchiveRemoverRunnable runnable = new ArchiveRemoverRunnable(this, now);
        ExecutorService executorService = this.context.getAlternateExecutorService();
        future = executorService.submit((Runnable)((Object)future));
        return future;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clean(Instant now) {
        long nowInMillis = now.toEpochMilli();
        int periodsElapsed = this.computeElapsedPeriodsSinceLastClean(nowInMillis);
        this.lastHeartBeat = nowInMillis;
        if (periodsElapsed > 1) {
            this.addInfo("Multiple periods, i.e. " + periodsElapsed + " periods, seem to have elapsed. This is expected at application start.");
        }
        for (int i = 0; i < periodsElapsed; ++i) {
            void var3_5;
            int offset = this.getPeriodOffsetForDeletionTarget() - i;
            Instant instantOfPeriodToClean = this.rc.getEndOfNextNthPeriod(now, offset);
            this.cleanPeriod((Instant)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected File[] getFilesInPeriod(Instant instantOfPeriodToClean) {
        String filenameToDelete = this.fileNamePattern.convert(instantOfPeriodToClean);
        File file2Delete = new File(filenameToDelete);
        if (this.fileExistsAndIsFile(file2Delete)) {
            void var1_1;
            return new File[]{var1_1};
        }
        return new File[0];
    }

    /*
     * WARNING - void declaration
     */
    private boolean fileExistsAndIsFile(File file2Delete) {
        void var1_1;
        return file2Delete.exists() && var1_1.isFile();
    }

    /*
     * WARNING - void declaration
     */
    public void cleanPeriod(Instant instantOfPeriodToClean) {
        File[] matchingFileArray;
        File[] fileArray = matchingFileArray = this.getFilesInPeriod(instantOfPeriodToClean);
        int n = matchingFileArray.length;
        for (int i = 0; i < n; ++i) {
            File f = fileArray[i];
            this.checkAndDeleteFile(f);
        }
        if (this.parentClean && matchingFileArray.length > 0) {
            void var1_1;
            File parentDir = this.getParentDir((File)var1_1[0]);
            this.removeFolderIfEmpty((File)fileArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkAndDeleteFile(File f) {
        void var2_2;
        this.addInfo("deleting " + String.valueOf(f));
        if (f == null) {
            this.addWarn("Cannot delete empty file");
            return false;
        }
        if (!f.exists()) {
            this.addWarn("Cannot delete non existent file");
            return false;
        }
        boolean result = f.delete();
        if (!result) {
            void var1_1;
            this.addWarn("Failed to delete file " + var1_1.toString());
        }
        return (boolean)var2_2;
    }

    void capTotalSize(Instant now) {
        long totalSize = 0L;
        long totalRemoved = 0L;
        int successfulDeletions = 0;
        int failedDeletions = 0;
        for (int offset = 0; offset < this.maxHistory; ++offset) {
            Instant instant = this.rc.getEndOfNextNthPeriod(now, -offset);
            File[] matchingFileArray = this.getFilesInPeriod(instant);
            this.descendingSort(matchingFileArray, instant);
            File[] fileArray = matchingFileArray;
            int n = matchingFileArray.length;
            for (int i = 0; i < n; ++i) {
                File f = fileArray[i];
                long size = f.length();
                if ((totalSize += size) <= this.totalSizeCap) continue;
                this.addInfo("Deleting [" + String.valueOf(f) + "] of size " + String.valueOf(new FileSize(size)));
                boolean bl = this.checkAndDeleteFile(f);
                if (bl) {
                    ++successfulDeletions;
                    totalRemoved += size;
                    continue;
                }
                ++failedDeletions;
            }
        }
        if (successfulDeletions + failedDeletions == 0) {
            this.addInfo("No removal attempts were made.");
            return;
        }
        this.addInfo("Removed  " + String.valueOf(new FileSize(totalRemoved)) + " of files in " + successfulDeletions + " files.");
        if (failedDeletions != 0) {
            this.addInfo("There were " + failedDeletions + " failed deletion attempts.");
        }
    }

    protected void descendingSort(File[] matchingFileArray, Instant instant) {
    }

    File getParentDir(File file) {
        File file2 = file.getAbsoluteFile();
        file2 = file2.getParentFile();
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    int computeElapsedPeriodsSinceLastClean(long nowInMillis) {
        long periodsElapsed;
        long l;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            long l2 = nowInMillis;
            l = this.rc.periodBarriersCrossed(l2, l2 + 2764800000L);
            periodsElapsed = Math.min(l, 336L);
        } else {
            void var1_1;
            periodsElapsed = this.rc.periodBarriersCrossed(this.lastHeartBeat, (long)var1_1);
        }
        return (int)l;
    }

    boolean computeParentCleaningFlag(FileNamePattern fileNamePattern) {
        Converter<Object> p;
        DateTokenConverter<Object> dateTokenConverter = fileNamePattern.getPrimaryDateTokenConverter();
        if (dateTokenConverter.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (p = fileNamePattern.headTokenConverter; p != null && !(p instanceof DateTokenConverter); p = p.getNext()) {
        }
        while (p != null) {
            if (p instanceof LiteralConverter && ((String)((Object)(dateTokenConverter = p.convert(null)))).indexOf(47) != -1) {
                return true;
            }
            p = p.getNext();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void removeFolderIfEmpty(File dir) {
        void var1_1;
        this.removeFolderIfEmpty((File)var1_1, 0);
    }

    private void removeFolderIfEmpty(File dir, int depth) {
        while (true) {
            if (depth >= 3) {
                return;
            }
            if (!dir.isDirectory() || !FileFilterUtil.isEmptyDirectory(dir)) break;
            this.addInfo("deleting folder [" + String.valueOf(dir) + "]");
            this.checkAndDeleteFile(dir);
            ++depth;
            dir = dir.getParentFile();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxHistory(int maxHistory) {
        void var1_1;
        this.maxHistory = var1_1;
    }

    protected int getPeriodOffsetForDeletionTarget() {
        return -this.maxHistory - 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTotalSizeCap(long totalSizeCap) {
        void var1_1;
        this.totalSizeCap = var1_1;
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }

    public class ArchiveRemoverRunnable
    implements Runnable {
        Instant now;
        final /* synthetic */ TimeBasedArchiveRemover this$0;

        /*
         * WARNING - void declaration
         */
        ArchiveRemoverRunnable(TimeBasedArchiveRemover this$0, Instant now) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.now = var2_2;
        }

        @Override
        public void run() {
            this.this$0.clean(this.now);
            if (this.this$0.totalSizeCap != 0L && this.this$0.totalSizeCap > 0L) {
                this.this$0.capTotalSize(this.now);
            }
        }
    }
}

