/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.joran.spi.NoAutoStart;
import ch.qos.logback.core.rolling.LengthCounter;
import ch.qos.logback.core.rolling.LengthCounterBase;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.time.Instant;

@NoAutoStart
public class SizeAndTimeBasedFileNamingAndTriggeringPolicy<E>
extends TimeBasedFileNamingAndTriggeringPolicyBase<E> {
    volatile int currentPeriodsCounter = 0;
    FileSize maxFileSize;
    Duration checkIncrement = null;
    static String MISSING_INT_TOKEN = "Missing integer token, that is %i, in FileNamePattern [";
    static String MISSING_DATE_TOKEN = "Missing date token, that is %d, in FileNamePattern [";
    private final Usage usage;
    public LengthCounter lengthCounter = new LengthCounterBase();

    public SizeAndTimeBasedFileNamingAndTriggeringPolicy() {
        this(Usage.DIRECT);
    }

    /*
     * WARNING - void declaration
     */
    public SizeAndTimeBasedFileNamingAndTriggeringPolicy(Usage usage) {
        void var1_1;
        this.usage = var1_1;
    }

    @Override
    public void start() {
        super.start();
        if (this.usage == Usage.DIRECT) {
            this.addWarn("SizeAndTimeBasedFileNamingAndTriggeringPolicy is deprecated. Use SizeAndTimeBasedRollingPolicy instead");
            this.addWarn("For more information see http://logback.qos.ch/manual/appenders.html#SizeAndTimeBasedRollingPolicy");
        }
        if (!super.isErrorFree()) {
            return;
        }
        if (this.maxFileSize == null) {
            this.addError("maxFileSize property is mandatory.");
            this.withErrors();
        }
        if (!this.validateDateAndIntegerTokens()) {
            this.withErrors();
            return;
        }
        this.archiveRemover = this.createArchiveRemover();
        this.archiveRemover.setContext(this.context);
        String string = this.tbrp.fileNamePattern.toRegexForFixedDate(this.dateInCurrentPeriod);
        String stemRegex = FileFilterUtil.afterLastSlash(string);
        this.computeCurrentPeriodsHighestCounterValue(string);
        if (this.isErrorFree()) {
            this.started = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateDateAndIntegerTokens() {
        void var1_1;
        boolean inError = false;
        if (this.tbrp.fileNamePattern.getIntegerTokenConverter() == null) {
            inError = true;
            this.addError(MISSING_INT_TOKEN + this.tbrp.fileNamePatternStr + "]");
            this.addError("See also http://logback.qos.ch/codes.html#sat_missing_integer_token");
        }
        if (this.tbrp.fileNamePattern.getPrimaryDateTokenConverter() == null) {
            inError = true;
            this.addError(MISSING_DATE_TOKEN + this.tbrp.fileNamePatternStr + "]");
        }
        return var1_1 == false;
    }

    protected ArchiveRemover createArchiveRemover() {
        return new SizeAndTimeBasedArchiveRemover(this.tbrp.fileNamePattern, this.rc);
    }

    /*
     * WARNING - void declaration
     */
    void computeCurrentPeriodsHighestCounterValue(String stemRegex) {
        void var1_1;
        File file = new File(((TimeBasedFileNamingAndTriggeringPolicyBase)this).getCurrentPeriodsFileNameWithoutCompressionSuffix());
        File[] matchingFileArray = FileFilterUtil.filesInFolderMatchingStemRegex(file = file.getParentFile(), stemRegex);
        if (matchingFileArray == null || matchingFileArray.length == 0) {
            this.currentPeriodsCounter = 0;
            return;
        }
        this.currentPeriodsCounter = FileFilterUtil.findHighestCounter((File[])file, (String)var1_1);
        if (this.tbrp.getParentsRawFileProperty() != null || this.tbrp.compressionMode != CompressionMode.NONE) {
            ++this.currentPeriodsCounter;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isTriggeringEvent(File activeFile, E event) {
        void var3_3;
        void var1_1;
        long localNextCheck;
        long currentTime = this.getCurrentTime();
        if (currentTime >= (localNextCheck = this.atomicNextCheck.get())) {
            long nextCheckCandidate = this.computeNextCheck(currentTime);
            this.atomicNextCheck.set(nextCheckCandidate);
            Instant instantInElapsedPeriod = this.dateInCurrentPeriod;
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(var1_1, this.currentPeriodsCounter);
            this.currentPeriodsCounter = 0;
            this.setDateInCurrentPeriod(currentTime);
            this.lengthCounter.reset();
            return true;
        }
        boolean result = this.checkSizeBasedTrigger((File)var1_1, (long)var3_3);
        if (result) {
            this.lengthCounter.reset();
        }
        return result;
    }

    private boolean checkSizeBasedTrigger(File activeFile, long currentTime) {
        if (activeFile == null) {
            this.addWarn("activeFile == null");
            return false;
        }
        if (this.maxFileSize == null) {
            this.addWarn("maxFileSize = null");
            return false;
        }
        if (this.lengthCounter.getLength() >= this.maxFileSize.getSize()) {
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
            ++this.currentPeriodsCounter;
            return true;
        }
        return false;
    }

    public Duration getCheckIncrement() {
        return null;
    }

    public void setCheckIncrement(Duration checkIncrement) {
        this.addWarn("Since version 1.5.8, 'checkIncrement' property has no effect");
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxFileSize(FileSize aMaxFileSize) {
        void var1_1;
        this.maxFileSize = var1_1;
    }

    @Override
    public LengthCounter getLengthCounter() {
        return this.lengthCounter;
    }

    static enum Usage {
        EMBEDDED,
        DIRECT;

    }
}

