/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.util.DelayStrategy;
import ch.qos.logback.core.util.FixedDelay;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public class DefaultSocketConnector
implements SocketConnector {
    private final InetAddress address;
    private final int port;
    private final DelayStrategy delayStrategy;
    private SocketConnector.ExceptionHandler exceptionHandler;
    private SocketFactory socketFactory;

    /*
     * WARNING - void declaration
     */
    public DefaultSocketConnector(InetAddress address, int port, long initialDelay, long retryDelay) {
        this((InetAddress)var1_1, (int)var2_2, new FixedDelay((long)var3_3, retryDelay));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultSocketConnector(InetAddress address, int port, DelayStrategy delayStrategy) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.address = var1_1;
        this.port = var2_2;
        this.delayStrategy = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket call() throws InterruptedException {
        void var1_1;
        this.useDefaultsForMissingFields();
        Socket socket = this.createSocket();
        while (socket == null && !Thread.currentThread().isInterrupted()) {
            Thread.sleep(this.delayStrategy.nextDelay());
            socket = this.createSocket();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Socket createSocket() {
        void var1_1;
        Socket newSocket = null;
        try {
            newSocket = this.socketFactory.createSocket(this.address, this.port);
        }
        catch (IOException ioex) {
            void var2_2;
            this.exceptionHandler.connectionFailed(this, (Exception)var2_2);
        }
        return var1_1;
    }

    private void useDefaultsForMissingFields() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ConsoleExceptionHandler();
        }
        if (this.socketFactory == null) {
            this.socketFactory = SocketFactory.getDefault();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExceptionHandler(SocketConnector.ExceptionHandler exceptionHandler) {
        void var1_1;
        this.exceptionHandler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSocketFactory(SocketFactory socketFactory) {
        void var1_1;
        this.socketFactory = var1_1;
    }

    private static class ConsoleExceptionHandler
    implements SocketConnector.ExceptionHandler {
        private ConsoleExceptionHandler() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void connectionFailed(SocketConnector connector, Exception ex) {
            void var2_2;
            System.out.println(var2_2);
        }
    }
}

