/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.net.AutoFlushingObjectWriter;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.ObjectWriter;
import ch.qos.logback.core.net.ObjectWriterFactory;
import ch.qos.logback.core.net.QueueFactory;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

public abstract class AbstractSocketAppender<E>
extends AppenderBase<E>
implements SocketConnector.ExceptionHandler {
    public static final int DEFAULT_PORT = 4560;
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 128;
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private static final int DEFAULT_EVENT_DELAY_TIMEOUT = 100;
    private final ObjectWriterFactory objectWriterFactory;
    private final QueueFactory queueFactory;
    private String remoteHost;
    private int port = 4560;
    private InetAddress address;
    private Duration reconnectionDelay = new Duration(30000L);
    private int queueSize = 128;
    private int acceptConnectionTimeout = 5000;
    private Duration eventDelayLimit = new Duration(100L);
    private BlockingDeque<E> deque;
    private String peerId;
    private SocketConnector connector;
    private Future<?> task;
    private volatile Socket socket;

    protected AbstractSocketAppender() {
        this(new QueueFactory(), new ObjectWriterFactory());
    }

    /*
     * WARNING - void declaration
     */
    AbstractSocketAppender(QueueFactory queueFactory, ObjectWriterFactory objectWriterFactory) {
        void var1_1;
        void var2_2;
        this.objectWriterFactory = var2_2;
        this.queueFactory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        void var1_1;
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.port <= 0) {
            ++errorCount;
            AbstractSocketAppender abstractSocketAppender = this;
            abstractSocketAppender.addError("No port was configured for appender" + abstractSocketAppender.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            AbstractSocketAppender abstractSocketAppender = this;
            abstractSocketAppender.addError("No remote host was configured for appender" + abstractSocketAppender.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        if (this.queueSize == 0) {
            this.addWarn("Queue size of zero is deprecated, use a size of one to indicate synchronous processing");
        }
        if (this.queueSize < 0) {
            ++errorCount;
            this.addError("Queue size must be greater than zero");
        }
        if (errorCount == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                AbstractSocketAppender abstractSocketAppender = this;
                abstractSocketAppender.addError("unknown host: " + abstractSocketAppender.remoteHost);
                ++errorCount;
            }
        }
        if (var1_1 == false) {
            this.deque = this.queueFactory.newLinkedBlockingDeque(this.queueSize);
            this.peerId = "remote peer " + this.remoteHost + ":" + this.port + ": ";
            this.connector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay.getMilliseconds());
            this.task = this.getContext().getExecutorService().submit(new Runnable(this){
                final /* synthetic */ AbstractSocketAppender this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void run() {
                    this.this$0.connectSocketAndDispatchEvents();
                }
            });
            super.start();
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly(this.socket);
        this.task.cancel(true);
        super.stop();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void append(E event2) {
        if (event2 == null || !this.isStarted()) {
            return;
        }
        try {
            boolean event2 = this.deque.offer(event2, this.eventDelayLimit.getMilliseconds(), TimeUnit.MILLISECONDS);
            if (!event2) {
                AbstractSocketAppender abstractSocketAppender = this;
                abstractSocketAppender.addInfo("Dropping event due to timeout limit of [" + String.valueOf(abstractSocketAppender.eventDelayLimit) + "] being exceeded");
            }
            return;
        }
        catch (InterruptedException e) {
            void var1_3;
            this.addError("Interrupted while appending event to SocketAppender", (Throwable)var1_3);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void connectSocketAndDispatchEvents() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean socketConnectionCouldBeEstablished() throws InterruptedException {
        this.socket = this.connector.call();
        return this.socket != null;
    }

    /*
     * WARNING - void declaration
     */
    private ObjectWriter createObjectWriterForSocket() throws IOException {
        void var1_1;
        this.socket.setSoTimeout(this.acceptConnectionTimeout);
        AutoFlushingObjectWriter objectWriter = this.objectWriterFactory.newAutoFlushingObjectWriter(this.socket.getOutputStream());
        this.socket.setSoTimeout(0);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SocketConnector createConnector(InetAddress address, int port, int initialDelay, long retryDelay) {
        void var1_1;
        void var3_3;
        void var2_2;
        SocketConnector connector = this.newConnector(address, (int)var2_2, (long)var3_3, retryDelay);
        connector.setExceptionHandler(this);
        connector.setSocketFactory(this.getSocketFactory());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void dispatchEvents(ObjectWriter objectWriter) throws InterruptedException, IOException {
        while (true) {
            E event = this.deque.takeFirst();
            this.postProcessEvent(event);
            Serializable serializableEvent = this.getPST().transform(event);
            try {
                void var3_4;
                objectWriter.write(var3_4);
            }
            catch (IOException e) {
                void var1_2;
                void var2_3;
                this.tryReAddingEventToFrontOfQueue(var2_3);
                throw var1_2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryReAddingEventToFrontOfQueue(E event) {
        void var1_1;
        boolean bl = this.deque.offerFirst(var1_1);
        if (!bl) {
            this.addInfo("Dropping event due to socket connection error and maxed out deque capacity");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void connectionFailed(SocketConnector connector, Exception ex) {
        void var2_2;
        if (ex instanceof InterruptedException) {
            this.addInfo("connector interrupted");
            return;
        }
        if (ex instanceof ConnectException) {
            AbstractSocketAppender abstractSocketAppender = this;
            abstractSocketAppender.addInfo(abstractSocketAppender.peerId + "connection refused");
            return;
        }
        AbstractSocketAppender abstractSocketAppender = this;
        abstractSocketAppender.addInfo(abstractSocketAppender.peerId + String.valueOf(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    protected SocketConnector newConnector(InetAddress address, int port, long initialDelay, long retryDelay) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultSocketConnector((InetAddress)var1_1, (int)var2_2, (long)var3_3, retryDelay);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    protected abstract void postProcessEvent(E var1);

    protected abstract PreSerializationTransformer<E> getPST();

    /*
     * WARNING - void declaration
     */
    public void setRemoteHost(String host) {
        void var1_1;
        this.remoteHost = var1_1;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    /*
     * WARNING - void declaration
     */
    public void setPort(int port) {
        void var1_1;
        this.port = var1_1;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public void setReconnectionDelay(Duration delay) {
        void var1_1;
        this.reconnectionDelay = var1_1;
    }

    public Duration getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    /*
     * WARNING - void declaration
     */
    public void setQueueSize(int queueSize) {
        void var1_1;
        this.queueSize = var1_1;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setEventDelayLimit(Duration eventDelayLimit) {
        void var1_1;
        this.eventDelayLimit = var1_1;
    }

    public Duration getEventDelayLimit() {
        return this.eventDelayLimit;
    }

    /*
     * WARNING - void declaration
     */
    void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        void var1_1;
        this.acceptConnectionTimeout = var1_1;
    }
}

