/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.TimestampModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.CachingDateFormatter;
import ch.qos.logback.core.util.OptionHelper;

public class TimestampModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    /*
     * WARNING - void declaration
     */
    public TimestampModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new TimestampModelHandler(context2);
    }

    protected Class<TimestampModel> getSupportedModelClass() {
        return TimestampModel.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext interpretationContext, Model model) {
        void var2_2;
        void var3_3;
        void var1_1;
        long timeReference;
        String timeReferenceStr;
        Object datePatternStr;
        Object timestampModel = (TimestampModel)model;
        String keyStr = ((TimestampModel)timestampModel).getKey();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(keyStr)) {
            this.addError("Attribute named [key] cannot be empty");
            this.inError = true;
        }
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)(datePatternStr = ((TimestampModel)timestampModel).getDatePattern()))) {
            this.addError("Attribute named [datePattern] cannot be empty");
            this.inError = true;
        }
        if ("contextBirth".equalsIgnoreCase(timeReferenceStr = ((TimestampModel)timestampModel).getTimeReference())) {
            this.addInfo("Using context birth as time reference.");
            timeReference = this.context.getBirthTime();
        } else {
            timeReference = System.currentTimeMillis();
            this.addInfo("Using current interpretation time, i.e. now, as time reference.");
        }
        if (this.inError) {
            return;
        }
        timestampModel = ((TimestampModel)timestampModel).getScopeStr();
        ActionUtil.Scope scope = ActionUtil.stringToScope((String)timestampModel);
        datePatternStr = new CachingDateFormatter((String)datePatternStr);
        String val = ((CachingDateFormatter)datePatternStr).format(timeReference);
        this.addInfo("Adding property to the context with key=\"" + keyStr + "\" and value=\"" + val + "\" to the " + String.valueOf((Object)scope) + " scope");
        ActionUtil.setProperty((ContextAwarePropertyContainer)var1_1, (String)var3_3, val, (ActionUtil.Scope)var2_2);
    }
}

