/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.StatusListenerModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    Boolean effectivelyAdded = null;
    StatusListener statusListener = null;

    /*
     * WARNING - void declaration
     */
    public StatusListenerModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new StatusListenerModelHandler(context2);
    }

    protected Class<StatusListenerModel> getSupportedModelClass() {
        return StatusListenerModel.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext ic, Model model) throws ModelHandlerException {
        StatusListenerModel slModel = (StatusListenerModel)model;
        String className = slModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(className)) {
            this.addError("Empty class name for StatusListener");
            this.inError = true;
            return;
        }
        className = ic.getImport(className);
        try {
            void var3_4;
            this.statusListener = (StatusListener)OptionHelper.instantiateByClassName((String)var3_4, StatusListener.class, this.context);
            this.effectivelyAdded = ic.getContext().getStatusManager().add(this.statusListener);
            if (this.statusListener instanceof ContextAware) {
                ((ContextAware)((Object)this.statusListener)).setContext(this.context);
            }
            this.addInfo("Added status listener of type [" + slModel.getClassName() + "]");
            ic.pushObject(this.statusListener);
            return;
        }
        catch (Exception e) {
            void var1_2;
            void var2_3;
            this.inError = true;
            this.addError("Could not create an StatusListener of type [" + var2_3.getClassName() + "].", e);
            throw new ModelHandlerException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postHandle(ModelInterpretationContext mic, Model m) {
        void var1_1;
        Object object;
        if (this.inError) {
            return;
        }
        if (this.isEffectivelyAdded() && this.statusListener instanceof LifeCycle) {
            ((LifeCycle)((Object)this.statusListener)).start();
        }
        if ((object = mic.peekObject()) != this.statusListener) {
            this.addWarn("The object at the of the stack is not the statusListener pushed earlier.");
            return;
        }
        var1_1.popObject();
    }

    private boolean isEffectivelyAdded() {
        if (this.effectivelyAdded == null) {
            return false;
        }
        return this.effectivelyAdded;
    }
}

