/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ImcplicitActionDataForBasicProperty;
import ch.qos.logback.core.joran.action.ImplicitModelData;
import ch.qos.logback.core.joran.action.ImplicitModelDataForComplexProperty;
import ch.qos.logback.core.joran.spi.NoAutoStartUtil;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;

public class ImplicitModelHandler
extends ModelHandlerBase {
    private final BeanDescriptionCache beanDescriptionCache;
    private ImplicitModelData implicitModelData;
    public static final String IGNORING_UNKNOWN_PROP = "Ignoring unknown property";
    boolean inError = false;

    /*
     * WARNING - void declaration
     */
    public ImplicitModelHandler(Context context, BeanDescriptionCache beanDescriptionCache) {
        super((Context)var1_1);
        void var2_2;
        void var1_1;
        this.beanDescriptionCache = var2_2;
    }

    protected Class<? extends ImplicitModel> getSupportedModelClass() {
        return ImplicitModel.class;
    }

    /*
     * WARNING - void declaration
     */
    public static ImplicitModelHandler makeInstance(Context context, ModelInterpretationContext mic) {
        void var1_1;
        Context context2;
        BeanDescriptionCache beanDescriptionCache = mic.getBeanDescriptionCache();
        return new ImplicitModelHandler(context2, (BeanDescriptionCache)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext mic, Model model) {
        ImplicitModel implicitModel = (ImplicitModel)model;
        if (mic.isObjectStackEmpty()) {
            this.inError = true;
            return;
        }
        String nestedElementTagName = implicitModel.getTag();
        Object o = mic.peekObject();
        PropertySetter parentBean = new PropertySetter(this.beanDescriptionCache, o);
        ((ContextAwareBase)parentBean).setContext(this.context);
        AggregationType aggregationType = parentBean.computeAggregationType(nestedElementTagName);
        switch (aggregationType) {
            case NOT_FOUND: {
                this.addWarn("Ignoring unknown property [" + nestedElementTagName + "] in [" + o.getClass().getName() + "]");
                this.inError = true;
                implicitModel.markAsSkipped();
                return;
            }
            case AS_BASIC_PROPERTY: 
            case AS_BASIC_PROPERTY_COLLECTION: {
                void var3_3;
                ImcplicitActionDataForBasicProperty adBasicProperty = new ImcplicitActionDataForBasicProperty(parentBean, aggregationType, nestedElementTagName);
                this.implicitModelData = adBasicProperty;
                this.doBasicProperty(mic, model, (ImcplicitActionDataForBasicProperty)var3_3);
                return;
            }
            case AS_COMPLEX_PROPERTY_COLLECTION: 
            case AS_COMPLEX_PROPERTY: {
                void var2_2;
                void var1_1;
                void var3_3;
                ImplicitModelDataForComplexProperty adComplex = new ImplicitModelDataForComplexProperty(parentBean, aggregationType, nestedElementTagName);
                this.implicitModelData = adComplex;
                this.doComplex((ModelInterpretationContext)var1_1, (ComponentModel)var3_3, (ImplicitModelDataForComplexProperty)var2_2);
                return;
            }
        }
        this.addError("PropertySetter.computeAggregationType returned " + String.valueOf((Object)aggregationType));
    }

    /*
     * WARNING - void declaration
     */
    void doBasicProperty(ModelInterpretationContext interpretationContext, Model model, ImcplicitActionDataForBasicProperty actionData) {
        void var3_3;
        void var2_2;
        String finalBody = interpretationContext.subst(var2_2.getBodyText());
        switch (actionData.aggregationType) {
            case AS_BASIC_PROPERTY: {
                actionData.parentBean.setProperty(actionData.propertyName, finalBody);
                return;
            }
            case AS_BASIC_PROPERTY_COLLECTION: {
                void var1_1;
                actionData.parentBean.addBasicProperty(actionData.propertyName, (String)var1_1);
                return;
            }
        }
        this.addError("Unexpected aggregationType " + String.valueOf((Object)var3_3.aggregationType));
    }

    /*
     * WARNING - void declaration
     */
    public void doComplex(ModelInterpretationContext interpretationContext, ComponentModel componentModel, ImplicitModelDataForComplexProperty actionData) {
        String className = componentModel.getClassName();
        String substClassName = interpretationContext.subst(className);
        String fqcn = interpretationContext.getImport(substClassName);
        try {
            String errMsg;
            Class<?> componentClass;
            if (!OptionHelper.isNullOrEmptyOrAllSpaces(fqcn)) {
                componentClass = Loader.loadClass(fqcn, this.context);
            } else {
                componentClass = actionData.parentBean;
                componentClass = ((PropertySetter)((Object)componentClass)).getClassNameViaImplicitRules(actionData.propertyName, actionData.getAggregationType(), interpretationContext.getDefaultNestedComponentRegistry());
            }
            if (componentClass == null) {
                actionData.inError = true;
                errMsg = "Could not find an appropriate class for property [" + componentModel.getTag() + "]";
                this.addError(errMsg);
                return;
            }
            if (OptionHelper.isNullOrEmptyOrAllSpaces(fqcn)) {
                this.addInfo("Assuming default type [" + ((Class)((Object)errMsg)).getName() + "] for [" + componentModel.getTag() + "] property");
            }
            actionData.setNestedComplexProperty(((Class)((Object)errMsg)).getConstructor(new Class[0]).newInstance(new Object[0]));
            if (actionData.getNestedComplexProperty() instanceof ContextAware) {
                ((ContextAware)actionData.getNestedComplexProperty()).setContext(this.context);
            }
            interpretationContext.pushObject(actionData.getNestedComplexProperty());
            return;
        }
        catch (Exception oops) {
            void var1_1;
            void var2_2;
            var3_3.inError = true;
            String msg = "Could not create component [" + var2_2.getTag() + "] of type [" + fqcn + "]";
            this.addError((String)var1_1, oops);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postHandle(ModelInterpretationContext intercon, Model model) {
        if (this.inError) {
            return;
        }
        if (this.implicitModelData == null) {
            return;
        }
        if (this.implicitModelData.inError) {
            return;
        }
        if (this.implicitModelData instanceof ImplicitModelDataForComplexProperty) {
            void var2_2;
            void var1_1;
            this.postHandleComplex((ModelInterpretationContext)var1_1, (Model)var2_2, (ImplicitModelDataForComplexProperty)this.implicitModelData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void postHandleComplex(ModelInterpretationContext mic, Model model, ImplicitModelDataForComplexProperty imdComplex) {
        void var3_3;
        void var1_1;
        Object object;
        Object nestedComplexProperty;
        PropertySetter nestedBean = new PropertySetter(this.beanDescriptionCache, imdComplex.getNestedComplexProperty());
        ((ContextAwareBase)nestedBean).setContext(this.context);
        if (nestedBean.computeAggregationType("parent") == AggregationType.AS_COMPLEX_PROPERTY) {
            nestedBean.setComplexProperty("parent", imdComplex.parentBean.getObj());
        }
        if (NoAutoStartUtil.shouldBeStarted(nestedComplexProperty = imdComplex.getNestedComplexProperty())) {
            ((LifeCycle)nestedComplexProperty).start();
        }
        if ((object = mic.peekObject()) != imdComplex.getNestedComplexProperty()) {
            this.addError("The object on the top the of the stack is not the component pushed earlier.");
            return;
        }
        var1_1.popObject();
        switch (imdComplex.aggregationType) {
            case AS_COMPLEX_PROPERTY: {
                imdComplex.parentBean.setComplexProperty(model.getTag(), imdComplex.getNestedComplexProperty());
                return;
            }
            case AS_COMPLEX_PROPERTY_COLLECTION: {
                void var2_2;
                imdComplex.parentBean.addComplexProperty(var2_2.getTag(), imdComplex.getNestedComplexProperty());
                return;
            }
        }
        this.addError("Unexpected aggregationType " + String.valueOf((Object)var3_3.aggregationType));
    }
}

