/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ConversionRuleModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;

public class ConversionRuleModelHandler
extends ModelHandlerBase {
    private boolean inError;

    /*
     * WARNING - void declaration
     */
    public ConversionRuleModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ConversionRuleModelHandler makeInstance(Context context, ModelInterpretationContext mic) {
        Context context2;
        return new ConversionRuleModelHandler(context2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        ConversionRuleModel conversionRuleModel = (ConversionRuleModel)model;
        String converterClass = conversionRuleModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(converterClass)) {
            this.addWarn("Missing className. This should have been caught earlier.");
            this.inError = true;
            return;
        }
        converterClass = mic.getImport(converterClass);
        String conversionWord = conversionRuleModel.getConversionWord();
        try {
            void var3_3;
            void var2_2;
            HashMap ruleRegistry = (HashMap)this.context.getObject("PATTERN_RULE_REGISTRY");
            if (ruleRegistry == null) {
                ruleRegistry = new HashMap();
                this.context.putObject("PATTERN_RULE_REGISTRY", ruleRegistry);
            }
            this.addInfo("registering conversion word " + conversionWord + " with class [" + converterClass + "]");
            var2_2.put(conversionWord, var3_3);
            return;
        }
        catch (Exception exception) {
            void var1_1;
            this.inError = true;
            String errorMsg = "Could not add conversion rule to PatternLayout.";
            this.addError((String)var1_1);
            return;
        }
    }
}

